@extends('layout.master')

@section('title')
    @if ($job_master->operation_id == 1)
        Add-SE B/L-YARAN
    @elseif($job_master->operation_id == 2)
        Add-SI B/L-YARAN
    @elseif($job_master->operation_id == 3)
        Add-AE B/L-YARAN
    @elseif($job_master->operation_id == 4)
        Add-AI B/L-YARAN
    @endif
@endsection

@section('topbar')
    @if ($job_master->operation_id == 1)
        <a href="/se_bl" class="breadcrumb-item">SE B/L</a>
    @elseif($job_master->operation_id == 2)
        <a href="/si_bl" class="breadcrumb-item">SI B/L</a>
    @elseif($job_master->operation_id == 3)
        <a href="/ae_bl" class="breadcrumb-item">AE B/L</a>
    @elseif($job_master->operation_id == 4)
        <a href="/ai_bl" class="breadcrumb-item">AI B/L</a>
    @endif
    <i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" action="{{ url('se_bl/add/' . $job_master->id) }}" enctype="multipart/form-data"
                class="row g-3" id="formId">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            @if ($job_master->operation_id == 1)
                                Add SE B/L
                            @elseif($job_master->operation_id == 2)
                                Add SI B/L
                            @elseif($job_master->operation_id == 3)
                                Add AE B/L
                            @elseif($job_master->operation_id == 4)
                                Add AI B/L
                            @endif
                        </h2>
                        <button type="submit" class="btn btn-primary submitBtn me-2" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">

                            {{-- @if (Request::is('se_job/add/' . @$job_master->id))
                                <input type="hidden" name="operation_id" value="1">
                            @elseif(Request::is('si_job/add/' . @$job_master->id))
                                <input type="hidden" name="operation_id" value="2">
                            @elseif(Request::is('ae_job/add/' . @$job_master->id))
                                <input type="hidden" name="operation_id" value="3">
                            @elseif(Request::is('ai_job/add/' . @$job_master->id))
                                <input type="hidden" name="operation_id" value="4">
                            @endif --}}
                            <div class="row mb-5">
                                <div class="">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="bl_info_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#bl_info" type="button"
                                                            role="tab" aria-controls="bl_info_tab"
                                                            aria-selected="true">BL Info</button>
                                                    </li>
                                                    @if ($job_master->operation_id == 1 || $job_master->operation_id == 2)
                                                        <li id="container_info_tab" class="nav-item flex-1"
                                                            role="presentation">
                                                            <button class="nav-link w-full pt-2 pb-2.5"
                                                                data-bs-toggle="pill" data-bs-target="#container_info"
                                                                type="button" role="tab"
                                                                aria-controls="container_info_tab"
                                                                aria-selected="false">Container Info</button>
                                                        </li>
                                                    @endif
                                                    <li id="bl_details_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#bl_details" type="button" role="tab"
                                                            aria-controls="bl_details_tab" aria-selected="false">BL
                                                            Details</button>
                                                    </li>
                                                    <li id="ref_no_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#ref_no" type="button" role="tab"
                                                            aria-controls="ref_no_tab" aria-selected="false">Ref
                                                            No's/Stamps</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="bl_info" role="tabpanel"
                                                aria-labelledby="bl_info_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Job #<span
                                                                style="color: red;">*</span></label>
                                                        {{-- <input required id="job_no" type="text" class="form-control"
                                                            readonly placeholder="Enter Job #"
                                                            value="{{ @$job_master->id }}" name="job_no"> --}}
                                                        <input type="hidden" value="{{ $job_master->id }}" name="job_no">
                                                        <input readonly id="job_no" type="text" class="form-control"
                                                            placeholder="Enter Job #" value="{{ @$job_master->job_no }}"
                                                            name="sej_job_no">
                                                        <div class="invalid-feedback">This field is required.</div>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Status</label>
                                                        <select data-placeholder="Select Status" id="regular-form-1"
                                                            name="bl_status" class="tom-select w-full mt-2">
                                                            <option value="Draft">Draft</option>
                                                            <option value="Final">Final</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Source</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Source" name="source">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>BL Template</label>
                                                        <select data-placeholder="Select Status" id="regular-form-1"
                                                            name="bl_template" class="tom-select w-full mt-2">
                                                            <option value="Freight Care">Freight Care</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">HBL #<span
                                                                style="color: red;">*</span></label>
                                                        <input required id="hbl_no" type="text"
                                                            class="form-control" placeholder="Enter HBL #"
                                                            name="hbl_no">
                                                        <div class="invalid-feedback">This field is required.</div>

                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">HBL Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="hbl_date" value="{{ $currentDate }}">
                                                    </div>
                                                    <div class="col-md-2 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="hbl_issue" value="1">
                                                        <label class="form-label" for="hbl_issue">
                                                            HBL Issue
                                                        </label>
                                                    </div>

                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">MBL #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter MBL #" name="mbl_no">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">MBL Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="mbl_date" value="{{ $currentDate }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Shipper<span
                                                                style="color: red;">*</span></label>
                                                        <select required class="tom-select" name="shipper_id"
                                                            id="shipper_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($shippers as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->shipper_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="invalid-feedback">This field is required.</div>

                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Consignee<span
                                                                style="color: red;">*</span></label>
                                                        <select required class="tom-select" name="consignee_id"
                                                            id="consignee_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($consignees as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->consignee_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="invalid-feedback">This field is required.</div>

                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="notify_party_one" class="form-label">Notify Party
                                                            1</label>
                                                        <select class="tom-select" name="notify_party_one"
                                                            id="notify_party_one">
                                                            <option value="">Please Select</option>
                                                            @foreach ($notify_parties as $item)
                                                                <option value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        {{-- <input required id="regular-form-1" type="text"
                                                            class="form-control" placeholder="Enter Notify Party 1"
                                                            name="notify_party_one"> --}}
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="notify_party_two" class="form-label">Notify Party
                                                            2</label>
                                                        <select class="tom-select" name="notify_party_two"
                                                            id="notify_party_two">
                                                            <option value="">Please Select</option>
                                                            @foreach ($notify_parties as $item)
                                                                <option value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        {{-- <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Notify Party 2" name="notify_party_two"> --}}
                                                    </div>
                                                    @if ($job_master->operation_id == 1 || $job_master->operation_id == 2)
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Vessel</label>
                                                            <select class="tom-select" name="vessel_id" id="vessel_id">
                                                                <option value="">Please Select</option>
                                                                @foreach ($vessels as $item)
                                                                    <option
                                                                        {{ @$job_master->job_vessel->vessel_id == $item->id ? 'selected' : '' }}
                                                                        value="{{ $item->id }}">{{ $item->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Voyage</label>
                                                            <select class="tom-select" name="voyage_id" id="voyage_id">
                                                                <option value="">Please Select</option>
                                                                @foreach ($voyages as $item)
                                                                    <option
                                                                        {{ @$job_master->job_vessel->voyage_id == $item->id ? 'selected' : '' }}
                                                                        value="{{ $item->id }}">
                                                                        {{ $item->voyage_no }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    @elseif($job_master->operation_id == 3 || $job_master->operation_id == 4)
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Airline</label>
                                                            <select class="tom-select" name="airline_id" id="airline_id">
                                                                <option value="">Please Select</option>
                                                                @foreach ($airline as $item)
                                                                    <option
                                                                        {{ @$job_master->job_vessel->airline_id == $item->id ? 'selected' : '' }}
                                                                        value="{{ $item->id }}">
                                                                        {{ $item->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    @endif
                                                    @if ($job_master->operation_id == 1 || $job_master->operation_id == 3)
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Sailing
                                                                Date</label>
                                                            <input id="regular-form-1" type="date"
                                                                class="form-control" name="sailing_date"
                                                                value="{{ $currentDate }}">
                                                        </div>
                                                    @elseif ($job_master->operation_id == 2 || $job_master->operation_id == 4)
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Arrival
                                                                Date</label>
                                                            <input id="regular-form-1" type="date"
                                                                class="form-control" name="arrival_date"
                                                                value="{{ $currentDate }}">
                                                        </div>
                                                    @endif
                                                    <h2 class="fw-medium fs-base me-auto text-center mt-2">
                                                        Booking Info
                                                    </h2>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">POL</label>
                                                        <select class="tom-select" name="port_of_loading_id"
                                                            id="port_of_loading_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->port_of_loading_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">POFD</label>
                                                        <select class="tom-select" name="port_of_discharge_id"
                                                            id="port_of_discharge_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->port_of_discharge_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">POT</label>
                                                        <select class="tom-select" name="transportation_id"
                                                            id="transportation_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->transportation_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Final Dest</label>
                                                        <select class="tom-select" name="final_destination_id"
                                                            id="final_destination_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->final_destination_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Commodity</label>
                                                        <select class="tom-select" name="commodity_id" id="commodity_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($commodities as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->commodity_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Reference #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Reference #" name="reference_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Overseas
                                                            Agent</label>
                                                        <select class="tom-select" name="overseas_agent_id"
                                                            id="overseas_agent_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($overseas_agent as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->overseas_agent_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1"
                                                            class="form-label">SLine/Carrier</label>
                                                        <select class="tom-select" name="shipping_line_id"
                                                            id="shipping_line_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($shipping_line as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->shipping_line_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Total
                                                            Container</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Total Container" name="total_container">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Delivery</label>
                                                        <select data-placeholder="Select Delivery" id="regular-form-1"
                                                            name="delivery" class="tom-select w-full">
                                                            <option
                                                                {{ @$job_master->delivery == 'Airport/DO' ? 'selected' : '' }}
                                                                value="Airport/DO">Airport/DO</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'CFS/CFS' ? 'selected' : '' }}
                                                                value="CFS/CFS">CFS/CFS</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'CFS/CY' ? 'selected' : '' }}
                                                                value="CFS/CY">CFS/CY</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'CFS/DR' ? 'selected' : '' }}
                                                                value="CFS/DR">CFS/DR</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'CY/CY' ? 'selected' : '' }}
                                                                value="CY/CY">CY/CY</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'CY/DR' ? 'selected' : '' }}
                                                                value="CY/DR">CY/DR</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'CY/SD' ? 'selected' : '' }}
                                                                value="CY/SD">CY/SD</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'DOOR/DOOR' ? 'selected' : '' }}
                                                                value="DOOR/DOOR">DOOR/DOOR</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'DOOR/FCL' ? 'selected' : '' }}
                                                                value="DOOR/FCL">DOOR/FCL</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'DOOR/LCL' ? 'selected' : '' }}
                                                                value="DOOR/LCL">DOOR/LCL</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'DR/CFS' ? 'selected' : '' }}
                                                                value="DR/CFS">DR/CFS</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'DR/CY' ? 'selected' : '' }}
                                                                value="DR/CY">DR/CY</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'DR/DR' ? 'selected' : '' }}
                                                                value="DR/DR">DR/DR</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'FCL/DOOR' ? 'selected' : '' }}
                                                                value="FCL/DOOR">FCL/DOOR</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'FCL/FCL' ? 'selected' : '' }}
                                                                value="FCL/FCL">FCL/FCL</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'FCL/LCL' ? 'selected' : '' }}
                                                                value="FCL/LCL">FCL/LCL</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'LCL/DOOR' ? 'selected' : '' }}
                                                                value="LCL/DOOR">LCL/DOOR</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'LCL/FCL' ? 'selected' : '' }}
                                                                value="LCL/FCL">LCL/FCL</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'LCL/LCL' ? 'selected' : '' }}
                                                                value="LCL/LCL">LCL/LCL</option>
                                                            <option
                                                                {{ @$job_master->delivery == 'PIER/PIER' ? 'selected' : '' }}
                                                                value="PIER/PIER">PIER/PIER</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="container_info" role="tabpanel"
                                                aria-labelledby="container_info_tab">
                                                <div class="text-end me-5">
                                                    <button id="addRowContainerInfo" type="button"
                                                        class="btn btn-primary">Add Row</button>
                                                </div>
                                                <div class="row px-5">
                                                    <div class="intro-y g-col-12 overflow-auto">
                                                        <table id="containerInfoTable" class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-nowrap" colspan="15"></th>
                                                                    <th class="text-nowrap">Principal Information</th>
                                                                    <th class="text-nowrap" colspan="3">Free Days</th>
                                                                    <th class="text-nowrap" colspan="3"></th>
                                                                    <th class="text-nowrap" colspan="2">Form E</th>
                                                                    <th class="text-nowrap" colspan="7"></th>
                                                                </tr>
                                                                <tr>
                                                                    <th class="text-nowrap"></th>
                                                                    <th class="text-nowrap">S#</th>
                                                                    <th class="text-nowrap">Container #</th>
                                                                    <th class="text-nowrap">Seal #</th>
                                                                    <th class="text-nowrap">Size Type</th>
                                                                    <th class="text-nowrap">Rate Group</th>
                                                                    <th class="text-nowrap">Gross WT</th>
                                                                    <th class="text-nowrap">Net WT</th>
                                                                    <th class="text-nowrap">Tare WT</th>
                                                                    <th class="text-nowrap">WT Unit</th>
                                                                    <th class="text-nowrap">CBM</th>
                                                                    <th class="text-nowrap">Package</th>
                                                                    <th class="text-nowrap">Unit</th>
                                                                    <th class="text-nowrap">Temperature</th>
                                                                    <th class="text-nowrap">Load Type</th>
                                                                    <th class="text-nowrap">Remarks</th>
                                                                    <th class="text-nowrap">Detention</th>
                                                                    <th class="text-nowrap">Demurrage</th>
                                                                    <th class="text-nowrap">Plugin</th>
                                                                    <th class="text-nowrap">Line Code</th>
                                                                    <th class="text-nowrap">PartFCL</th>
                                                                    <th class="text-nowrap">SOC</th>
                                                                    <th class="text-nowrap">DG/Non-DG</th>
                                                                    <th class="text-nowrap">Form Number</th>
                                                                    <th class="text-nowrap">Form Date</th>
                                                                    <th class="text-nowrap">OOG</th>
                                                                    <th class="text-nowrap">Top</th>
                                                                    <th class="text-nowrap">Right</th>
                                                                    <th class="text-nowrap">Left</th>
                                                                    <th class="text-nowrap">Front</th>
                                                                    <th class="text-nowrap">Back</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="bl_details" role="tabpanel"
                                                aria-labelledby="bl_details_tab">
                                                <div class="row">
                                                    <div class="col-md-6 mt-2">
                                                        <label for="regular-form-1" class="form-label">Shipper</label>
                                                        <textarea name="shipper" id="regular-form-1" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Shipper">{{ @$job_master->job_detail->shipper->name . "\n" . @$job_master->job_detail->shipper->address }}</textarea>
                                                    </div>
                                                    <div class="col-md-6 mt-2">
                                                        {{-- <label for="regular-form-1" class="form-label">Consignee</label> --}}
                                                        <a href="javascript:;"
                                                            class="consignee-modal text-decoration-underline fw-medium"
                                                            data-bs-toggle="modal" data-bs-target="#consigneeModal"
                                                            data-id="consignee_id">Consignee</a>
                                                        <textarea name="consignee" id="consignee" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Consignee">{{ @$job_master->job_detail->consignee->name . "\n" . @$job_master->job_detail->consignee->address }}</textarea>
                                                    </div>
                                                    <div class="col-md-6 mt-2">
                                                        {{-- <label for="regular-form-1" class="form-label">Notify Party
                                                            1</label> --}}
                                                        <a href="javascript:;"
                                                            class="notify_party_1-modal text-decoration-underline fw-medium"
                                                            data-bs-toggle="modal" data-bs-target="#notifyParty1Modal"
                                                            data-id="notify_party_1_id">Notify Party 1</a>
                                                        <textarea name="detail_notify_party_one" id="detail_notify_party_one" cols="30" rows="3"
                                                            class="form-control" placeholder="Enter Notify Party 1"></textarea>
                                                    </div>
                                                    <div class="col-md-6 mt-2">
                                                        {{-- <label for="detail_notify_party_two" class="form-label">Notify
                                                            Party
                                                            2</label> --}}
                                                        <a href="javascript:;"
                                                            class="notify_party_2-modal text-decoration-underline fw-medium"
                                                            data-bs-toggle="modal" data-bs-target="#notifyParty2Modal"
                                                            data-id="notify_party_2_id">Notify Party 2</a>
                                                        <textarea name="detail_notify_party_two" id="detail_notify_party_two" cols="30" rows="3"
                                                            class="form-control" placeholder="Enter Notify Party 2"></textarea>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Port of
                                                            Loading</label>
                                                        <select class="tom-select" name="detail_port_of_loading_id"
                                                            id="port_of_loading_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->port_of_loading_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Port Of
                                                            Discharge</label>
                                                        <select class="tom-select" name="detail_port_of_discharge_id"
                                                            id="port_of_discharge_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->port_of_discharge_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Place of
                                                            Delivery</label>
                                                        <select class="tom-select" name="place_of_delivery_id"
                                                            id="place_of_delivery_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->final_destination_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Agent Stamp</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Agent Stamp" name="agent_stamp">
                                                    </div>
                                                    <div class="col-md-12 mt-2">
                                                        <label for="delivery_agent" class="form-label">Delivery
                                                            Agent</label>
                                                        <textarea name="delivery_agent" id="delivery_agent" cols="30" rows="2" class="form-control"
                                                            placeholder="Enter Delivery Agent"></textarea>
                                                    </div>
                                                    <div class="col-md-4 mt-2">
                                                        <label>Freight Type</label>
                                                        <select data-placeholder="Select Freight Type" id="regular-form-1"
                                                            name="freight_type" class="tom-select w-full mt-2">
                                                            <option
                                                                {{ @$job_master->freight_type == 'Prepaid' ? 'selected' : '' }}
                                                                value="Prepaid">Prepaid</option>
                                                            <option
                                                                {{ @$job_master->freight_type == 'Collect' ? 'selected' : '' }}
                                                                value="Collect">Collect</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4 mt-2">
                                                        <div class="d-flex align-items-end">
                                                            <div class="">
                                                                <label>Unit</label>
                                                                <select data-placeholder="Select Unit" id="regular-form-1"
                                                                    name="unit" class="form-select w-32 mt-2">
                                                                    <option value="LBS">LBS</option>
                                                                    <option value="KG">KG</option>
                                                                    <option value="MTON">MTON</option>
                                                                </select>
                                                            </div>
                                                            <div class="ms-3">
                                                                <input id="regular-form-1" type="checkbox"
                                                                    class="form-check-input" name="manual"
                                                                    value="1">
                                                                <label class="form-label" for="manual">
                                                                    Manual
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 mt-2">
                                                        <label for="regular-form-1" class="form-label">No. Of Original
                                                            B/L's</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter No. Of Original B/L's"
                                                            name="no_of_original_bl">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="gross-wt" class="form-label">Gross WT</label>
                                                        <input id="gross-wt" type="text" class="form-control"
                                                            placeholder="Enter Gross WT"
                                                            value="{{ @$job_master->job_weight->weight }}"
                                                            name="gross_wt">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="net-wt" class="form-label">Net WT</label>
                                                        <input id="net-wt" type="text" class="form-control"
                                                            placeholder="Enter Net WT"
                                                            value="{{ @$job_master->job_weight->weight }}"
                                                            name="net_wt">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">Tare WT</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Tare WT" name="tare_wt">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">CBM</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter CBM" name="cbm">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">Pkgs</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Pkgs" name="pkgs">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">Unit</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Unit" name="pkg_unit">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="hs_code_id" class="form-label">HS Code</label>
                                                        {{-- <select class="tom-select" name="hs_code_id" id="hs_code_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($hsCodes as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->commodity->hs_code_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select> --}}
                                                        <input name="hs_code_id" id="hs_code_id" type="text"
                                                            class="form-control" placeholder="Enter HS Code"
                                                            value="{{ @$job_master->job_detail->commodity->hs_code_id }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Packing Group</label>
                                                        <select data-placeholder="Select Packing Group"
                                                            id="regular-form-1" name="packing_group"
                                                            class="tom-select w-full mt-2">
                                                            <option value="none">None</option>
                                                            <option value="I-high_danger">I (High Danger)</option>
                                                            <option value="II-med_danger">II (Med. Danger)</option>
                                                            <option value="III-low_danger">III (Low Danger)</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Hazmat Class</label>
                                                        <select data-placeholder="Select Hazmat Class" id="regular-form-1"
                                                            name="hazmat_class" class="tom-select w-full mt-2">
                                                            <option value="Class not Specified">Class not Specified
                                                            </option>
                                                            <option value="Class 1 Explosive">Class 1 Explosive</option>
                                                            <option value="Class 1.1 Explosive">Class 1.1 Explosive
                                                            </option>
                                                            <option value="Class 1.2 Explosive">Class 1.2 Explosive
                                                            </option>
                                                            <option value="Class 1.3 Explosive">Class 1.3 Explosive
                                                            </option>
                                                            <option value="Class 1.4 Explosive">Class 1.4 Explosive
                                                            </option>
                                                            <option value="Class 1.5 Explosive">Class 1.5 Explosive
                                                            </option>
                                                            <option value="Class 1.6 Explosive">Class 1.6 Explosive
                                                            </option>
                                                            <option value="Class 2 Gas">Class 2 Gas</option>
                                                            <option value="Class 2.1 Gas">Class 2.1 Gas</option>
                                                            <option value="Class 2.2 Gas">Class 2.2 Gas</option>
                                                            <option value="Class 2.3 Gas">Class 2.3 Gas</option>
                                                            <option value="Class 3 Flammable">Class 3 Flammable Liq
                                                            </option>
                                                            <option value="Class 4 Solid:division">Class 4 Solid:division
                                                            </option>
                                                            <option value="Class 4.1 Flammable">Class 4.1 Flammable
                                                            </option>
                                                            <option value="Class 4.2 Spontaneous">Class 4.2 Spontaneous
                                                            </option>
                                                            <option value="Class 4.3 Dangerous">Class 4.3 Dangerous
                                                            </option>
                                                            <option value="Class 5 Oxidizer">Class 5 Oxidizer</option>
                                                            <option value="Class 5.1 Oxidizer">Class 5.1 Oxidizer</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">UNO Code</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter UNO Code" name="uno_code">
                                                    </div>
                                                    <div class="col-md-2 mt-1">
                                                        <label for="regular-form-1" class="form-label">Marks & No. Of
                                                            Container No's</label>
                                                        <textarea name="marks_and_container_no" id="regular-form-1" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Marks & No. Of Container No's"></textarea>
                                                    </div>
                                                    <div class="col-md-2 mt-1">
                                                        <label for="regular-form-1" class="form-label">No. Of Pkgs Or
                                                            Shipping Units</label>
                                                        <textarea name="no_of_pkgs" id="regular-form-1" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter No. Of Pkgs Or Shipping Units"></textarea>
                                                    </div>
                                                    <div class="col-md-4 mt-6">
                                                        <label for="regular-form-1" class="form-label">Description Of
                                                            Goods & Pkgs</label>
                                                        <textarea name="description_of_goods_and_pkgs" id="regular-form-1" cols="30" rows="3"
                                                            class="form-control" placeholder="Enter Description Of Goods & Pkgs"></textarea>
                                                    </div>
                                                    <div class="col-md-2 mt-6">
                                                        <label for="weight-textarea" class="form-label">Gross
                                                            Weight</label>
                                                        <textarea name="gross_weight" id="weight-textarea" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Gross Weight"></textarea>
                                                    </div>
                                                    <div class="col-md-2 mt-6">
                                                        <label for="regular-form-1" class="form-label">Measurement</label>
                                                        <textarea name="measurement" id="regular-form-1" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Measurement"></textarea>
                                                    </div>
                                                    <div class="col-md-4 mt-2">
                                                        <label for="regular-form-1" class="form-label">On Board
                                                            Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="on_board_date" value="{{ $currentDate }}">
                                                    </div>
                                                    <div class="col-md-4 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date Of
                                                            Issue</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="date_of_issue" value="{{ $currentDate }}">
                                                    </div>
                                                    <div class="col-md-4 mt-2">
                                                        <label for="regular-form-1" class="form-label">Place</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Place" name="place">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">F.I No/Form E
                                                            #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter F.I No/Form E #" name="fi_form_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="form_date" value="{{ $currentDate }}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="ref_no" role="tabpanel"
                                                aria-labelledby="ref_no_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Invoice #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Invoice #" name="invoice_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="invoice_date" value="{{ $currentDate }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Export #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Export #" name="export_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="export_date" value="{{ $currentDate }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Contract #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Contract #" name="contract_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="contract_date" value="{{ $currentDate }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">L/C #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter L/C #" name="lc_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="lc_date" value="{{ $currentDate }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Client Ref
                                                            #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Client Ref #" name="client_ref_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Shipping Ref
                                                            #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Shipping Ref #" name="shipping_ref_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">S Bill #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter S Bill #" name="s_bill_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="s_bill_date" value="{{ $currentDate }}">
                                                    </div>
                                                    {{-- <h2 class="fw-medium fs-base me-auto text-center mt-2">
                                                        STAMPS
                                                    </h2>
                                                    <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
                                                        <table class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th>S#</th>
                                                                    <th>Code</th>
                                                                    <th>Stamps</th>
                                                                    <th>Stamp Group</th> wire:
                                                                    <th>Stamp Date</th>
                                                                    <th>Remarks</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div> --}}
                                                </div>
                                                {{-- <div class="mt-3">
                                                    <a href="{{ url('/se_job') }}" type="back"
                                                        class="btn btn-secondary waves-effect">
                                                        Back
                                                    </a>
                                                    <button type="submit" class="btn btn-primary submitBtn" style="float: right"
                                                        id="submitBtn">Save</button>
                                                </div> --}}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
    @include('sea_export.se_bl.modals.consignee')
    @include('sea_export.se_bl.modals.notifyParty1Modal')
    @include('sea_export.se_bl.modals.notifyParty2Modal')

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('textarea').forEach(function(textarea) {
                textarea.addEventListener('keydown', function(e) {
                    // Prevent parent form or listeners from hijacking Enter key
                    e.stopPropagation();
                });
            });
        });
    </script>
    <script>
        $(document).ready(function() {

            $(window).keydown(function(event) {
                if (event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });

            $('.add-consignee-details').on('click', function(e) {
                e.preventDefault();
                var consigneeId = $(this).data('id');


                if (consigneeId) {
                    $.ajax({
                        url: '/api/get-consignee-details/' + consigneeId,
                        type: 'GET',
                        success: function(data) {
                            console.log('response', data)
                            var detail = data.name + '\n' + data
                                .address;
                            $('#consignee').val(
                                detail);
                        },
                        error: function() {
                            $('#consignee').val(
                                'Error retrieving details.');
                        }
                    });
                } else {
                    $('#consignee').val('');
                }
            });


            function loadNotifyPartyDetails(notifyPartyId) {
                if (notifyPartyId) {
                    $.ajax({
                        url: '/api/get-party-details/' + notifyPartyId,
                        type: 'GET',
                        success: function(data) {
                            console.log('response', data);
                            var detail = data.name + '\n' + data.address;
                            $('#detail_notify_party_one').val(
                                detail); // Set the value in the notify party detail field
                        },
                        error: function() {
                            $('#detail_notify_party_one').val(
                                'Error retrieving details.'); // Set error message
                        }
                    });
                } else {
                    $('#detail_notify_party_one').val(''); // Clear the field if no notify party is selected
                }
            }

            // Call the function on change event
            $('#notify_party_one').change(function() {
                var notifyPartyId = $(this).val();
                loadNotifyPartyDetails(notifyPartyId); // Call the function on change
            });

            $('.add-notify-party-1-details').on('click', function(e) {
                var notifyPartyId = $(this).data('id');
                console.log(notifyPartyId)
                loadNotifyPartyDetails(notifyPartyId); // Call the function on change
            });


            function loadNotifyPartyTwoDetails(notifyPartyId) {
                if (notifyPartyId) {
                    $.ajax({
                        url: '/api/get-party-details/' + notifyPartyId,
                        type: 'GET',
                        success: function(data) {
                            console.log('response', data);
                            var detail = data.name + '\n' + data.address;
                            $('#detail_notify_party_two').val(
                                detail); // Set the value in the notify party detail field
                        },
                        error: function() {
                            $('#detail_notify_party_two').val(
                                'Error retrieving details.'); // Set error message
                        }
                    });
                } else {
                    $('#detail_notify_party_two').val(''); // Clear the field if no notify party is selected
                }
            }

            // Call the function on change event
            $('#notify_party_two').change(function() {
                var notifyPartyId = $(this).val();
                loadNotifyPartyTwoDetails(notifyPartyId); // Call the function on change
            });
            $('.add-notify-party-2-details').on('click', function(e) {
                var notifyPartyId = $(this).data('id');
                console.log(notifyPartyId)
                loadNotifyPartyTwoDetails(notifyPartyId); // Call the function on change
            });

            var overseasAgentId = $('#overseas_agent_id').val();
            loadOverseasAgentDetails(overseasAgentId);

            function loadOverseasAgentDetails(overseasAgentId) {
                if (overseasAgentId) {
                    $.ajax({
                        url: '/api/get-party-details/' + overseasAgentId,
                        type: 'GET',
                        success: function(data) {
                            console.log('response', data);
                            var detail = data.name + '\n' + data.address;
                            $('#delivery_agent').val(detail); // Set the value of delivery agent
                        },
                        error: function() {
                            $('#delivery_agent').val('Error retrieving details.'); // Set error message
                        }
                    });
                } else {
                    $('#delivery_agent').val(''); // Clear the input if no overseas agent is selected
                }
            }

            // Call the function on change event
            $('#overseas_agent_id').change(function() {
                var overseasAgentId = $(this).val();
                loadOverseasAgentDetails(overseasAgentId); // Call the function on change
            });


            $('#container_info').on('keydown', 'input[name="container_no[]"]',
                function(e) {
                    // Check if the Tab key is pressed
                    if (e.which == 9) {
                        e.preventDefault(); // Prevent default tab behavior
                        addRowContainer(); // Add a new row
                        // Focus on the container_no input field of the new row
                        setTimeout(function() {
                            $('#containerInfoTable tbody tr:last-child')
                                .find(
                                    'input[name="container_no[]"]')
                                .focus();
                        }, 0);
                    }
                });

            const dropdownOptions = {
                loadType: ["Full", "Empty"],
                Unit: ["BAGS", "BALES", "BARREL", "BLOCKS", "BOATS", "BOBBIN",
                    "BOTTLES", "BOXES", "BRIQUETTES", "BUNDLES", "CABLE DRUM", "CANS", "CARBOY", "CARTONS",
                    "CASE", "CASKS", "COILS", "COLLI", "CRATES", "CYLINDERS", "DOZENS", "DRUMS",
                    "FIBRE DRUMS", "ITEMS", "KEGS", "LOOSE", "METAL DRUMS", "METERS", "MODULES", "PACKAGES",
                    "PACKETS", "PAILS", "PALLETS", "PARCELS", "PIECES", "PLASTIC DRUMS", "REELS", "ROLLS",
                    "SACKS", "SETS", "SHEETS", "SKIDS", "SLABS", "STEEL PACK", "STEEL PLATES",
                    "STEEL TRUNKS", "TEA CHESTS", "TONS", "UNIT"
                ],
                wtUnit: ["LBS", "KG", "MTON"],
                sizeType: ["Please Select", "20BK", "20FR", "20OT", "20RE",
                    "20SD", "20TK", "40FR", "40BK",
                    "40HC", "40HCRF",
                    "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK",
                    "45VH", "M3"
                ],
                dgNonDg: ["Non-DG", "DG", "All"],
            };

            // function createDropdown(name, options) {
            //     let dropdown = '<select name="' + name + '" class="form-control w-24">';
            //     options.forEach(option => {
            //         dropdown += '<option value="' + option + '">' + option + '</option>';
            //     });
            //     dropdown += '</select>';
            //     return dropdown;
            // }

            // function createDynamicDropdown(name, options) {
            //     let dropdown = '<select name="' + name + '" class="form-control w-24">';
            //     options.forEach(option => {
            //         dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            //     });
            //     dropdown += '</select>';
            //     return dropdown;
            // }

            // function createInput(type, name, placeholder, required = false) {
            //     if (type == "checkbox") {
            //         return '<input type="' + type + '" name="' + name + '"value="1" class="form-check-input" placeholder="' +
            //             placeholder + '">';
            //     } else {
            //         return '<input type="' + type + '" name="' + name +
            //             '" class="form-control w-24" placeholder="' +
            //             placeholder + '"' + (required ? ' required' : '') + '>';
            //     }
            // }

            // function createInput(type, name, placeholder, required = false) {
            //     let input = '';
            //     if (type === "checkbox") {
            //         input = '<input type="' + type + '" name="' + name +
            //             '" value="1" class="form-check-input" placeholder="' + placeholder + '">';
            //     } else {
            //         input = '<div class="form-group">' +
            //             '<input type="' + type + '" name="' + name + '" class="form-control w-24' + (required ?
            //                 ' required' : '') + '" placeholder="' + placeholder + '">' +
            //             (required ? '<div class="invalid-feedback">Container Seal No is required.</div>' : '') +
            //             '</div>';
            //     }
            //     return input;
            // }

            let containerInfoRows = 1;

            // function addRowContainer(tabKeyPressed) {
            //     let row = '<tr>' +
            //         '<td class="text-nowrap">' + containerInfoRows +
            //         '<input type="hidden" name="container_info_rows" value=' + containerInfoRows + '>' + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_no[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_seal_no[]', '', tabKeyPressed) +
            //         '</td>' +
            //         '<td class="text-nowrap">' + createDropdown('container_size_type[]', dropdownOptions.sizeType) +
            //         '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_rate_group[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_gross_wt[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_net_wt[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_tare_wt[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createDropdown('container_wt_unit[]', dropdownOptions.wtUnit) +
            //         '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_cbm[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_packages[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createDropdown('container_unit[]', dropdownOptions.Unit) +
            //         '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_temperature[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createDropdown('container_load_type[]', dropdownOptions.loadType) +
            //         '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_remarks[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_detention[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_demurrage[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_plugin[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_line_code[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('checkbox', 'container_part_fcl[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('checkbox', 'container_soc[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createDropdown('container_dg_non_dg[]', dropdownOptions.dgNonDg) +
            //         '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_form_number[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('date', 'container_form_date[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('checkbox', 'container_oog[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_top[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_right[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_left[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_front[]', '') + '</td>' +
            //         '<td class="text-nowrap">' + createInput('text', 'container_back[]', '') + '</td>' +
            //         '</tr>';
            //     $('#containerInfoTable tbody').append(row);
            //     containerInfoRows++;
            // }

            function createDropdown(name, options, additionalClass = '') {
                let dropdown = '<select name="' + name +
                    '" class="form-control w-24 ' + additionalClass + '">';
                options.forEach(option => {
                    dropdown += '<option value="' + option + '">' + option +
                        '</option>';
                });
                dropdown += '</select>';
                return dropdown;
            }

            function createDynamicDropdown(name, options, additionalClass = '') {
                let dropdown = '<select name="' + name +
                    '" class="form-control w-24 ' + additionalClass + '">';
                options.forEach(option => {
                    dropdown += '<option value="' + option.id + '">' +
                        option.name + '</option>';
                });
                dropdown += '</select>';
                return dropdown;
            }

            function createInput(type, name, placeholder, required = false,
                additionalClass = '', value = '') {
                let input = '';
                const inputId = name.replace(/\[\]/g, '') + '_' + Math.random()
                    .toString(36).substring(
                        7); // Unique ID for each input

                if (type === "checkbox") {
                    input = '<input type="' + type + '" name="' + name +
                        '" value="1" class="form-check-input ' + additionalClass +
                        '" placeholder="' + placeholder +
                        '">';
                } else {
                    input = '<div class="form-group">' +
                        '<input type="' + type + '" id="' + inputId + '" name="' +
                        name + '" value="' + value +
                        '" class="form-control w-24 ' + (required ? 'required ' : '') + additionalClass +
                        '" placeholder="' + placeholder + '">' +
                        (required ?
                            '<div class="invalid-feedback" id="' + inputId +
                            '-feedback">Seal No is required</div>' :
                            ''
                        ) + // Ensure no undefined value is added when `required` is false
                        '</div>';
                }
                // else {
                //     input = '<div class="form-group">' +
                //         '<input type="' + type + '" id="' + inputId + '" name="' +
                //         name + '" value="' + value +
                //         '" class="form-control w-24 ' + (required ? 'required ' :
                //             '') + additionalClass +
                //         '" placeholder="' + placeholder + '">' +
                //         (required ?
                //         '<div class="" id="' + inputId +
                //         '-feedback">Seal No is required</div>'
                //         )
                //         +
                //         '</div>';
                // }


                return input;
            }

            // Validation function
            function validateContainerNo(inputElement) {
                const value = inputElement.val();
                const hasFourAlphabets = (value.match(/[A-Za-z]/g) || []).length ===
                    4;
                const hasSevenDigits = (value.match(/[0-9]/g) || []).length === 7;
                const feedbackElement = inputElement.siblings('.invalid-feedback');

                if (!hasFourAlphabets || !hasSevenDigits) {
                    feedbackElement.text('Container No is invalid');
                    feedbackElement.show();
                    inputElement.addClass('is-invalid');
                } else {
                    feedbackElement.hide();
                    inputElement.removeClass('is-invalid');
                }
            }

            // Function to calculate tare weight
            function calculateTareWeight(row) {
                const grossWeight = parseFloat(row.find(
                    'input[name^="container_gross_wt"]').val()) || 0;
                const netWeight = parseFloat(row.find(
                    'input[name^="container_net_wt"]').val()) || 0;
                const tareWeight = grossWeight - netWeight;
                row.find('input[name^="container_tare_wt"]').val(tareWeight);
                updateTotals();
            }

            function updateTotals() {
                let totalGrossWt = 0;
                let totalNetWt = 0;
                let totalTareWt = 0;
                let totalPackages = 0;

                $('input[name^="container_gross_wt"]').each(function() {
                    totalGrossWt += parseFloat($(this).val()) || 0;
                });

                $('input[name^="container_net_wt"]').each(function() {
                    totalNetWt += parseFloat($(this).val()) || 0;
                });

                $('input[name^="container_tare_wt"]').each(function() {
                    totalTareWt += parseFloat($(this).val()) || 0;
                });

                $('input[name^="container_packages"]').each(function() {
                    totalPackages += parseInt($(this).val()) || 0;
                });

                totalContainers = $('input[name^="container_no"]').length;

                $('input[name="gross_wt"]').val(totalGrossWt);
                $('input[name="net_wt"]').val(totalNetWt);
                $('input[name="tare_wt"]').val(totalTareWt);
                $('input[name="pkgs"]').val(totalPackages);

                // Update hidden input fields with calculated totals
                $('#totalGrosswt').val(totalGrossWt);
                $('#totalpackages').val(totalPackages);
                $('#totalcontainers').val(totalContainers);
                updateWeightTextarea();
            }

            function updateWeightTextarea() {
                // Get values from input fields
                var grossWt = document.getElementById('gross-wt').value;
                var netWt = document.getElementById('net-wt').value;

                // Set value of the textarea
                var textarea = document.getElementById('weight-textarea');
                textarea.value = 'Net Weight: ' + netWt + '\nGross Weight: ' +
                    grossWt;
            }

            // Add event listeners to input fields
            document.getElementById('gross-wt').addEventListener('input',
                updateWeightTextarea);
            document.getElementById('net-wt').addEventListener('input',
                updateWeightTextarea);

            function addRowContainer(tabKeyPressed) {
                let row = '<tr>' +
                    '<td class="text-nowrap">' +
                    '<button type="button" class="btn btn-danger btn-sm delete-row">Delete</button>' +
                    '</td>' +
                    '<td class="text-nowrap">' + containerInfoRows +
                    '<input type="hidden" name="container_info_rows" value=' +
                    containerInfoRows + '>' + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_no[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_seal_no[]', '', tabKeyPressed) +
                    '</td>' +
                    '<td class="text-nowrap">' + createDropdown(
                        'container_size_type[]', dropdownOptions.sizeType,
                        'container-size-type') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_rate_group[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_gross_wt[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_net_wt[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_tare_wt[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createDropdown(
                        'container_wt_unit[]', dropdownOptions.wtUnit) +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_cbm[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_packages[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createDropdown('container_unit[]',
                        dropdownOptions.Unit) +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_temperature[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createDropdown(
                        'container_load_type[]', dropdownOptions.loadType) +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_remarks[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_detention[]', '', false, '', '14') +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_demurrage[]', '', false, '', '14') +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_plugin[]', '', false,
                        'container-plugin') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_line_code[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('checkbox',
                        'container_part_fcl[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('checkbox',
                        'container_soc[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createDropdown(
                        'container_dg_non_dg[]', dropdownOptions.dgNonDg) +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_form_number[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('date',
                        'container_form_date[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('checkbox',
                        'container_oog[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_top[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_right[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_left[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_front[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text',
                        'container_back[]', '') + '</td>' +
                    '</tr>';
                $('#containerInfoTable tbody').append(row);
                containerInfoRows++;
                updateTotals();

                // Attach change event to newly added dropdowns
                $('#containerInfoTable tbody tr:last-child .container-size-type')
                    .change(function() {
                        let selectedValue = $(this).val();
                        let containerPluginInput = $(this).closest('tr').find(
                            '.container-plugin');
                        if (selectedValue.startsWith('40') || selectedValue
                            .startsWith('45')) {
                            containerPluginInput.val(2);
                        } else {
                            containerPluginInput.val(1);
                        }
                    });

                $('#containerInfoTable tbody tr:last-child input[name^="container_no"]')
                    .on('input', function() {
                        validateContainerNo($(this));
                    });

                // Attach input event listeners for gross weight and net weight to calculate tare weight
                $('#containerInfoTable tbody tr:last-child input[name^="container_gross_wt"], #containerInfoTable tbody tr:last-child input[name^="container_net_wt"]')
                    .on('input', function() {
                        calculateTareWeight($(this).closest('tr'));
                    });

                // Attach change event listener for the unit dropdown to update the target div
                $('#containerInfoTable tbody tr:first-child select[name^="container_wt_unit"]')
                    .on('change',
                        function() {
                            updateUnitDiv($(this));
                        });

                // Attach input event listener for the container_packages[] input to update the sum
                $('#containerInfoTable tbody tr:last-child input[name^="container_packages"]')
                    .on('input',
                        function() {
                            updatePackagesSum();
                        });

                $('#containerInfoTable tbody tr:last-child .delete-row').click(function() {
                    $(this).closest('tr').remove();
                    updateTotals();
                });

            }

            // Function to update the select element inside the div with the value from the first row
            function updateUnitDiv(selectedUnitElement) {
                const selectedValue = selectedUnitElement.val();
                // console.log(selectedValue);
                $('select[name="unit"]').val(selectedValue);
            }

            // Function to update the sum of all container_packages[] inputs
            function updatePackagesSum() {
                let totalPackages = 0;
                $('input[name^="container_packages"]').each(function() {
                    totalPackages += parseFloat($(this).val()) || 0;
                });
                $('input[name="pkgs"]').val(totalPackages);
            }

            // Assuming you have a form with id="yourFormId"
            $('#formId').on('submit', function(e) {
                var formIsValid = true;

                // Check each input field for validation errors
                // $('input[name="container_seal_no[]"]').each(function() {
                //     if ($(this).val().trim() === '') {
                //         $(this).addClass(
                //             'is-invalid'); // Mark input as invalid
                //         $(this).next('.invalid-feedback')
                //             .show(); // Show error message
                //         formIsValid = false;
                //     } else {
                //         $(this).removeClass(
                //             'is-invalid'); // Remove invalid state if input is valid
                //         $(this).next('.invalid-feedback')
                //             .hide(); // Hide error message
                //     }
                // });

                // If form is not valid, prevent submission and focus on the first input field with validation error
                if (!formIsValid) {
                    e.preventDefault();
                    var tabPaneId = $('input.is-invalid').first().closest(
                        '.tab-pane').attr('id');
                    var tabButtonSelector = 'button[data-bs-target="#' +
                        tabPaneId + '"]';
                    var tabButton = $(tabButtonSelector);
                    console.log("Tab Button:", tabButton);
                    if (tabButton.length > 0) {
                        tabButton.tab(
                            'show'
                        ); // Show the tab containing the first input with validation error
                        console.log("Tab Button Clicked");
                    }
                    $('input.is-invalid').first()
                        .focus(); // Focus on the first input with validation error
                    console.log("Focused on Input Field");
                }
            });

            $(document).on('keyup',
                'input[name^="container_gross_wt"], input[name^="container_net_wt"], input[name^="container_tare_wt"], input[name^="container_packages"]',
                function() {
                    updateTotals();
                });


            $('#addRowContainerInfo').click(addRowContainer);
            // addRowContainer();
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#submitBtn').on('click', function(e) {
                // Validate form and check if it's valid
                var isValid = validateFormAndSubmit();

                // If form is valid, allow submission (or continue with your submission logic)
                if (isValid) {
                    // You can proceed with form submission or any other action
                    console.log(
                        'Form is valid. Proceeding with submission...');
                } else {
                    // Prevent default form submission if there are errors
                    e.preventDefault();
                    console.log(
                        'Form submission prevented due to validation errors.'
                    );
                }
            });

            function validateFormAndSubmit() {
                var formIsValid = true;

                // Reset validation states and hide all error messages
                $('.is-invalid').removeClass('is-invalid');
                $('.invalid-feedback').hide();

                if ($('#shipper_id').val() === '') {
                    $('#shipper_id').addClass('is-invalid');
                    $('#shipper_id').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
                if ($('#consignee_id').val() === '') {
                    $('#consignee_id').addClass('is-invalid');
                    $('#consignee_id').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
                if ($('#hbl_no').val() === '') {
                    $('#hbl_no').addClass('is-invalid');
                    $('#hbl_no').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
                if ($('#job_no').val() === '') {
                    $('#job_no').addClass('is-invalid');
                    $('#job_no').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }

                // If form is not valid, prevent submission and show Swal alert
                if (!formIsValid) {
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'error',
                        title: "Please fill all required fields",
                        showConfirmButton: false,
                        timer: 2500
                    });
                }

                return formIsValid; // Return form validity status
            }
        });
    </script>
@endsection
