@extends('layout.master')

@section('title')
    @if ($bl_master->operation_id == 1)
        Edit-SE B/L-YARAN
    @elseif($bl_master->operation_id == 2)
        Edit-SI B/L-YARAN
    @elseif($bl_master->operation_id == 3)
        Edit-AE B/L-YARAN
    @elseif($bl_master->operation_id == 4)
        Edit-AI B/L-YARAN
    @endif
@endsection

@section('topbar')
    @if ($bl_master->operation_id == 1)
        <a href="/se_bl" class="breadcrumb-item">SE B/L</a>
    @elseif($bl_master->operation_id == 2)
        <a href="/si_bl" class="breadcrumb-item">SI B/L</a>
    @elseif($bl_master->operation_id == 3)
        <a href="/ae_bl" class="breadcrumb-item">AE B/L</a>
    @elseif($bl_master->operation_id == 4)
        <a href="/ai_bl" class="breadcrumb-item">AI B/L</a>
    @endif
    <i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">

                        @if ($bl_master->operation_id == 1)
                            Edit SE B/L
                        @elseif($bl_master->operation_id == 2)
                            Edit SI B/L
                        @elseif($bl_master->operation_id == 3)
                            Edit AE B/L
                        @elseif($bl_master->operation_id == 4)
                            Edit AI B/L
                        @endif
                    </h2>
                    <div class="d-flex align-items-center">
                        <button id="showPrintBtn{{ $bl_master->id }}" class="btn btn-success me-2 p-2 showPrintBtn"
                            data-bs-toggle="modal" data-bs-target="#printModal" data-item-id="{{ $bl_master->id }}"><i
                                data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                    </div>
                    @if ($bl_master->job_master_id)
                        @if ($bl_master->operation_id == 1)
                            <a title="SE JOB" class="tooltip btn btn-primary me-2 p-2"
                                href="{{ url('/se_job/edit/' . $bl_master->job_master_id) }}"><i data-feather="file-text"
                                    class="w-4 h-4 me-1"></i>
                                JOB </a>
                        @elseif ($bl_master->operation_id == 2)
                            <a title="SI JOB" class="tooltip btn btn-primary me-2 p-2"
                                href="{{ url('/si_job/edit/' . $bl_master->job_master_id) }}"><i data-feather="file-text"
                                    class="w-4 h-4 me-1"></i>
                                JOB </a>
                        @elseif ($bl_master->operation_id == 3)
                            <a title="AE JOB" class="tooltip btn btn-primary me-2 p-2"
                                href="{{ url('/ae_job/edit/' . $bl_master->job_master_id) }}"><i data-feather="file-text"
                                    class="w-4 h-4 me-1"></i>
                                JOB </a>
                        @elseif ($bl_master->operation_id == 4)
                            <a title="AI JOB" class="tooltip btn btn-primary me-2 p-2"
                                href="{{ url('/ai_job/edit/' . $bl_master->job_master_id) }}"><i data-feather="file-text"
                                    class="w-4 h-4 me-1"></i>
                                JOB </a>
                        @endif
                    @endif
                    {{-- <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a> --}}
                </div>
                <form method="POST" action="{{ url('se_bl/edit/' . $bl_master->id) }}" enctype="multipart/form-data"
                    class="row g-3" id="formId">
                    @csrf
                    <div class="g-col-12 text-end py-0 px-5">
                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>
                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="bl_info_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#bl_info" type="button"
                                                            role="tab" aria-controls="bl_info_tab"
                                                            aria-selected="true">BL Info</button>
                                                    </li>
                                                    <li id="container_info_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#container_info" type="button" role="tab"
                                                            aria-controls="container_info_tab"
                                                            aria-selected="false">Container Info</button>
                                                    </li>
                                                    <li id="bl_details_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#bl_details" type="button" role="tab"
                                                            aria-controls="bl_details_tab" aria-selected="false">BL
                                                            Details</button>
                                                    </li>
                                                    <li id="ref_no_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#ref_no" type="button" role="tab"
                                                            aria-controls="ref_no_tab" aria-selected="false">Ref
                                                            No's/Stamps</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="bl_info" role="tabpanel"
                                                aria-labelledby="bl_info_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Job #<span
                                                                style="color: red;">*</span></label>
                                                        <input id="job_no" type="hidden"
                                                            value="{{ @$bl_master->job_master_id }}" name="job_no">
                                                        <input type="text" class="form-control" readonly
                                                            placeholder="Enter Job #"
                                                            value="{{ @$bl_master->job_master->job_no }}"
                                                            name="sej_job_no">
                                                        <div class="invalid-feedback">This field is required.</div>

                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Status</label>
                                                        <select data-placeholder="Select Status" id="regular-form-1"
                                                            name="bl_status" class="tom-select w-full mt-2">
                                                            <option {{ $bl_master->bl_status == 'Draft' ? 'selected' : '' }}
                                                                value="Draft">Draft</option>
                                                            <option
                                                                {{ $bl_master->bl_status == 'Final' ? 'selected' : '' }}
                                                                value="Final">Final</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Source</label>
                                                        <input id="regular-form-1" value="{{ $bl_master->source }}"
                                                            type="text" class="form-control"
                                                            placeholder="Enter Source" name="source">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>BL Template</label>
                                                        <select data-placeholder="Select Status" id="regular-form-1"
                                                            name="bl_template" class="tom-select w-full mt-2">
                                                            <option
                                                                {{ $bl_master->bl_template == 'Freight Care' ? 'selected' : '' }}
                                                                value="Freight Care">Freight Care</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">HBL #<span
                                                                style="color: red;">*</span></label>
                                                        <input required id="hbl_no" value="{{ $bl_master->hbl_no }}"
                                                            type="text" class="form-control" placeholder="Enter HBL #"
                                                            name="hbl_no">
                                                        <div class="invalid-feedback">This field is required.</div>
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">HBL Date</label>
                                                        <input id="regular-form-1" value="{{ $bl_master->hbl_date }}"
                                                            type="date" class="form-control" name="hbl_date">
                                                    </div>
                                                    <div class="col-md-2 mt-10">
                                                        <input id="regular-form-1"
                                                            {{ $bl_master->hbl_issue == '1' ? 'checked' : '' }}
                                                            type="checkbox" class="form-check-input" name="hbl_issue"
                                                            value="1">
                                                        <label class="form-label" for="hbl_issue">
                                                            HBL Issue
                                                        </label>
                                                    </div>

                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">MBL #</label>
                                                        <input id="regular-form-1" value="{{ $bl_master->mbl_no }}"
                                                            type="text" class="form-control" placeholder="Enter MBL #"
                                                            name="mbl_no">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">MBL Date</label>
                                                        <input id="regular-form-1" value="{{ $bl_master->mbl_date }}"
                                                            type="date" class="form-control" name="mbl_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Shipper<span
                                                                style="color: red;">*</span></label>
                                                        <select required class="tom-select" name="shipper_id"
                                                            id="shipper_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($shippers as $item)
                                                                <option
                                                                    {{ @$bl_master->shipper_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="invalid-feedback">This field is required.</div>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Consignee<span
                                                                style="color: red;">*</span></label>
                                                        <select required class="tom-select" name="consignee_id"
                                                            id="consignee_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($consignees as $item)
                                                                <option
                                                                    {{ @$bl_master->consignee_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="invalid-feedback">This field is required.</div>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="notify_party_one" class="form-label">Notify Party
                                                            1</label>
                                                        <select class="tom-select" name="notify_party_one"
                                                            id="notify_party_one">
                                                            <option value="">Please Select</option>
                                                            @foreach ($notify_parties as $item)
                                                                <option
                                                                    {{ @$bl_master->notify_party_one == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        {{-- <input required id="regular-form-1" type="text"
                                                            class="form-control" placeholder="Enter Notify Party 1"
                                                            value="{{ $bl_master->notify_party_one }}"
                                                            name="notify_party_one"> --}}
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="notify_party_two" class="form-label">Notify Party
                                                            2</label>
                                                        <select class="tom-select" name="notify_party_two"
                                                            id="notify_party_two">
                                                            <option value="">Please Select</option>
                                                            @foreach ($notify_parties as $item)
                                                                <option
                                                                    {{ @$bl_master->notify_party_two == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        {{-- <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Notify Party 2"
                                                            value="{{ $bl_master->notify_party_two }}"
                                                            name="notify_party_two"> --}}
                                                    </div>
                                                    @if ($bl_master->operation_id == 1 || $bl_master->operation_id == 2)
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Vessel</label>
                                                            <select class="tom-select" name="vessel_id" id="vessel_id">
                                                                <option value="">Please Select</option>
                                                                @foreach ($vessels as $item)
                                                                    <option
                                                                        {{ @$bl_master->vessel_id == $item->id ? 'selected' : '' }}
                                                                        value="{{ $item->id }}">{{ $item->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Voyage</label>
                                                            <select class="tom-select" name="voyage_id" id="voyage_id">
                                                                <option value="">Please Select</option>
                                                                @foreach ($voyages as $item)
                                                                    <option
                                                                        {{ @$bl_master->voyage_id == $item->id ? 'selected' : '' }}
                                                                        value="{{ $item->id }}">
                                                                        {{ $item->voyage_no }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    @elseif($bl_master->operation_id == 3 || $bl_master->operation_id == 4)
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Airline</label>
                                                            <select class="tom-select" name="airline_id" id="airline_id">
                                                                <option value="">Please Select</option>
                                                                @foreach ($airline as $item)
                                                                    <option
                                                                        {{ @$bl_master->airline_id == $item->id ? 'selected' : '' }}
                                                                        value="{{ $item->id }}">
                                                                        {{ $item->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    @endif
                                                    @if ($bl_master->operation_id == 1 || $bl_master->operation_id == 3)
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Sailing
                                                                Date</label>
                                                            <input id="regular-form-1" type="date"
                                                                class="form-control" name="sailing_date"
                                                                value="{{ $bl_master->sailing_date }}">
                                                        </div>
                                                    @elseif ($bl_master->operation_id == 2 || $bl_master->operation_id == 4)
                                                        <div class="col-md-3 mt-2">
                                                            <label for="regular-form-1" class="form-label">Arrival
                                                                Date</label>
                                                            <input id="regular-form-1" type="date"
                                                                class="form-control" name="arrival_date"
                                                                value="{{ $bl_master->arrival_date }}">
                                                        </div>
                                                    @endif
                                                    <h2 class="fw-medium fs-base me-auto text-center mt-2">
                                                        Booking Info
                                                    </h2>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">POL</label>
                                                        <select class="tom-select" name="port_of_loading_id"
                                                            id="port_of_loading_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$bl_master->bl_booking_info->port_of_loading_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">POFD</label>
                                                        <select class="tom-select" name="port_of_discharge_id"
                                                            id="port_of_discharge_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$bl_master->bl_booking_info->port_of_discharge_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">POT</label>
                                                        <select class="tom-select" name="transportation_id"
                                                            id="transportation_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$bl_master->bl_booking_info->transportation_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Final Dest</label>
                                                        <select class="tom-select" name="final_destination_id"
                                                            id="final_destination_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$bl_master->bl_booking_info->final_destination_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Commodity</label>
                                                        <select class="tom-select" name="commodity_id" id="commodity_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($commodities as $item)
                                                                <option
                                                                    {{ @$bl_master->bl_booking_info->commodity_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Reference #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Reference #"
                                                            value="{{ $bl_master->bl_booking_info->reference_no }}"
                                                            name="reference_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Overseas
                                                            Agent</label>
                                                        <select class="tom-select" name="overseas_agent_id"
                                                            id="overseas_agent_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($overseas_agent as $item)
                                                                <option
                                                                    {{ @$bl_master->bl_booking_info->overseas_agent_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1"
                                                            class="form-label">SLine/Carrier</label>
                                                        <select class="tom-select" name="shipping_line_id"
                                                            id="shipping_line_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($shipping_line as $item)
                                                                <option
                                                                    {{ @$bl_master->bl_booking_info->shipping_line_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Total
                                                            Container</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Total Container"
                                                            value="{{ $bl_master->bl_booking_info->total_container }}"
                                                            name="total_container">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Delivery</label>
                                                        <select data-placeholder="Select Delivery" id="regular-form-1"
                                                            name="delivery" class="tom-select w-full">
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'Airport/DO' ? 'selected' : '' }}
                                                                value="Airport/DO">Airport/DO</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'CFS/CFS' ? 'selected' : '' }}
                                                                value="CFS/CFS">CFS/CFS</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'CFS/CY' ? 'selected' : '' }}
                                                                value="CFS/CY">CFS/CY</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'CFS/DR' ? 'selected' : '' }}
                                                                value="CFS/DR">CFS/DR</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'CY/CY' ? 'selected' : '' }}
                                                                value="CY/CY">CY/CY</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'CY/DR' ? 'selected' : '' }}
                                                                value="CY/DR">CY/DR</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'CY/SD' ? 'selected' : '' }}
                                                                value="CY/SD">CY/SD</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'DOOR/DOOR' ? 'selected' : '' }}
                                                                value="DOOR/DOOR">DOOR/DOOR</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'DOOR/FCL' ? 'selected' : '' }}
                                                                value="DOOR/FCL">DOOR/FCL</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'DOOR/LCL' ? 'selected' : '' }}
                                                                value="DOOR/LCL">DOOR/LCL</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'DR/CFS' ? 'selected' : '' }}
                                                                value="DR/CFS">DR/CFS</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'DR/CY' ? 'selected' : '' }}
                                                                value="DR/CY">DR/CY</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'DR/DR' ? 'selected' : '' }}
                                                                value="DR/DR">DR/DR</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'FCL/DOOR' ? 'selected' : '' }}
                                                                value="FCL/DOOR">FCL/DOOR</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'FCL/FCL' ? 'selected' : '' }}
                                                                value="FCL/FCL">FCL/FCL</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'FCL/LCL' ? 'selected' : '' }}
                                                                value="FCL/LCL">FCL/LCL</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'LCL/DOOR' ? 'selected' : '' }}
                                                                value="LCL/DOOR">LCL/DOOR</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'LCL/FCL' ? 'selected' : '' }}
                                                                value="LCL/FCL">LCL/FCL</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'LCL/LCL' ? 'selected' : '' }}
                                                                value="LCL/LCL">LCL/LCL</option>
                                                            <option
                                                                {{ @$bl_master->bl_booking_info->delivery == 'PIER/PIER' ? 'selected' : '' }}
                                                                value="PIER/PIER">PIER/PIER</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="container_info" role="tabpanel"
                                                aria-labelledby="container_info_tab">
                                                <div class="text-end me-5">
                                                    <button id="addRowContainerInfo" type="button"
                                                        class="btn btn-primary">Add Row</button>
                                                </div>
                                                <div class="row px-5">
                                                    <div class="intro-y g-col-12 overflow-auto">
                                                        <table id="containerInfoTable" class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-nowrap" colspan="14"></th>
                                                                    <th class="text-nowrap">Principal Information</th>
                                                                    <th class="text-nowrap" colspan="3">Free Days</th>
                                                                    <th class="text-nowrap" colspan="3"></th>
                                                                    <th class="text-nowrap" colspan="2">Form E</th>
                                                                    <th class="text-nowrap" colspan="7"></th>
                                                                </tr>
                                                                <tr>
                                                                    <th class="text-nowrap"></th>
                                                                    <th class="text-nowrap">S#</th>
                                                                    <th class="text-nowrap">Container #</th>
                                                                    <th class="text-nowrap">Seal #</th>
                                                                    <th class="text-nowrap">Size Type</th>
                                                                    <th class="text-nowrap">Rate Group</th>
                                                                    <th class="text-nowrap">Gross WT</th>
                                                                    <th class="text-nowrap">Net WT</th>
                                                                    <th class="text-nowrap">Tare WT</th>
                                                                    <th class="text-nowrap">WT Unit</th>
                                                                    <th class="text-nowrap">CBM</th>
                                                                    <th class="text-nowrap">Package</th>
                                                                    <th class="text-nowrap">Unit</th>
                                                                    <th class="text-nowrap">Temperature</th>
                                                                    <th class="text-nowrap">Load Type</th>
                                                                    <th class="text-nowrap">Remarks</th>
                                                                    <th class="text-nowrap">Detention</th>
                                                                    <th class="text-nowrap">Demurrage</th>
                                                                    <th class="text-nowrap">Plugin</th>
                                                                    <th class="text-nowrap">Line Code</th>
                                                                    <th class="text-nowrap">PartFCL</th>w
                                                                    <th class="text-nowrap">SOC</th>
                                                                    <th class="text-nowrap">DG/Non-DG</th>
                                                                    <th class="text-nowrap">Form Number</th>
                                                                    <th class="text-nowrap">Form Date</th>
                                                                    <th class="text-nowrap">OOG</th>
                                                                    <th class="text-nowrap">Top</th>
                                                                    <th class="text-nowrap">Right</th>
                                                                    <th class="text-nowrap">Left</th>
                                                                    <th class="text-nowrap">Front</th>
                                                                    <th class="text-nowrap">Back</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @php
                                                                    // Initialize rowPayableCounter with 1
                                                                    $lastRowContainerInfoCounter = 1;
                                                                @endphp
                                                                @foreach (@$bl_master->bl_container_info as $index => $item)
                                                                    <tr>
                                                                        <td><button type="button"
                                                                                class="btn btn-danger btn-sm delete-row">Delete</button>
                                                                        </td>
                                                                        <td>{{ $index + 1 }}</td>
                                                                        <td><input type="text" name="container_no[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_no }}"></td>
                                                                        <td><input type="text"
                                                                                name="container_seal_no[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_seal_no }}">
                                                                        </td>
                                                                        <td>
                                                                            <select name="container_size_type[]"
                                                                                class="form-control w-24 container-size-type">
                                                                                @foreach (['Please Select', '20BK', '20FR', '20OT', '20RE', '20SD', '20TK', '40FR', '40BK', '40HC', '40HCRF', '40OT', '40SD', '40VH', '45BK', '45HC', '45OT', '45TK', '45VH', 'M3'] as $option)
                                                                                    <option value="{{ $option }}"
                                                                                        {{ $option == $item->container_size_type ? 'selected' : '' }}>
                                                                                        {{ $option }}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_rate_group[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_rate_group }}">
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_gross_wt[]"
                                                                                class="form-control w-24" onchange=""
                                                                                value="{{ $item->container_gross_wt }}">
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_net_wt[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_net_wt }}">
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_tare_wt[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_tare_wt }}">
                                                                        </td>
                                                                        <td>
                                                                            <select name="container_wt_unit[]"
                                                                                class="form-control w-24">
                                                                                @foreach (['LBS', 'KG', 'MTON'] as $option)
                                                                                    <option value="{{ $option }}"
                                                                                        {{ $option == $item->container_wt_unit ? 'selected' : '' }}>
                                                                                        {{ $option }}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                        <td><input type="text" name="container_cbm[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_cbm }}"></td>
                                                                        <td><input type="text"
                                                                                name="container_packages[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_packages }}">
                                                                        </td>
                                                                        <td>
                                                                            <select name="container_unit[]"
                                                                                class="form-control w-24">
                                                                                @php
                                                                                    $containerUnits = [
                                                                                        'BAGS',
                                                                                        'BALES',
                                                                                        'BARREL',
                                                                                        'BLOCKS',
                                                                                        'BOATS',
                                                                                        'BOBBIN',
                                                                                        'BOTTLES',
                                                                                        'BOXES',
                                                                                        'BRIQUETTES',
                                                                                        'BUNDLES',
                                                                                        'CABLE DRUM',
                                                                                        'CANS',
                                                                                        'CARBOY',
                                                                                        'CARTONS',
                                                                                        'CASE',
                                                                                        'CASKS',
                                                                                        'COILS',
                                                                                        'COLLI',
                                                                                        'CRATES',
                                                                                        'CYLINDERS',
                                                                                        'DOZENS',
                                                                                        'DRUMS',
                                                                                        'FIBRE DRUMS',
                                                                                        'ITEMS',
                                                                                        'KEGS',
                                                                                        'LOOSE',
                                                                                        'METAL DRUMS',
                                                                                        'METERS',
                                                                                        'MODULES',
                                                                                        'PACKAGES',
                                                                                        'PACKETS',
                                                                                        'PAILS',
                                                                                        'PALLETS',
                                                                                        'PARCELS',
                                                                                        'PIECES',
                                                                                        'PLASTIC DRUMS',
                                                                                        'REELS',
                                                                                        'ROLLS',
                                                                                        'SACKS',
                                                                                        'SETS',
                                                                                        'SHEETS',
                                                                                        'SKIDS',
                                                                                        'SLABS',
                                                                                        'STEEL PACK',
                                                                                        'STEEL PLATES',
                                                                                        'STEEL TRUNKS',
                                                                                        'TEA CHESTS',
                                                                                        'TONS',
                                                                                        'UNIT',
                                                                                    ];
                                                                                @endphp

                                                                                @foreach ($containerUnits as $option)
                                                                                    <option value="{{ $option }}"
                                                                                        {{ $option == $item->container_unit ? 'selected' : '' }}>
                                                                                        {{ $option }}
                                                                                    </option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_temperature[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_temperature }}">
                                                                        </td>
                                                                        <td>
                                                                            <select name="container_load_type[]"
                                                                                class="form-control w-24">
                                                                                @foreach (['Full', 'Empty'] as $option)
                                                                                    <option value="{{ $option }}"
                                                                                        {{ $option == $item->container_load_type ? 'selected' : '' }}>
                                                                                        {{ $option }}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_remarks[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_remarks }}">
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_detention[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_detention }}">
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_demurrage[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_demurrage }}">
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_plugin[]"
                                                                                class="form-control w-24 container-plugin"
                                                                                value="{{ $item->container_plugin }}">
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_line_code[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_line_code }}">
                                                                        </td>
                                                                        <td><input type="checkbox"
                                                                                name="container_part_fcl[]"
                                                                                class="form-check-input" value="1"
                                                                                {{ $item->container_part_fcl ? 'checked' : '' }}>
                                                                        </td>
                                                                        <td><input type="checkbox" name="container_soc[]"
                                                                                class="form-check-input" value="1"
                                                                                {{ $item->container_soc ? 'checked' : '' }}>
                                                                        </td>
                                                                        <td>
                                                                            <select name="container_dg_non_dg[]"
                                                                                class="form-control w-24">
                                                                                @foreach (['DG', 'Non-DG', 'All'] as $option)
                                                                                    <option value="{{ $option }}"
                                                                                        {{ $option == $item->container_dg_non_dg ? 'selected' : '' }}>
                                                                                        {{ $option }}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                        <td><input type="text"
                                                                                name="container_form_number[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_form_number }}">
                                                                        </td>
                                                                        <td><input type="date"
                                                                                name="container_form_date[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_form_date }}">
                                                                        </td>
                                                                        <td><input type="checkbox" name="container_oog[]"
                                                                                class="form-check-input" value="1"
                                                                                {{ $item->container_oog ? 'checked' : '' }}>
                                                                        </td>
                                                                        <td><input type="text" name="container_top[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_top }}"></td>
                                                                        <td><input type="text" name="container_right[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_right }}">
                                                                        </td>
                                                                        <td><input type="text" name="container_left[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_left }}"></td>
                                                                        <td><input type="text" name="container_front[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_front }}">
                                                                        </td>
                                                                        <td><input type="text" name="container_back[]"
                                                                                class="form-control w-24"
                                                                                value="{{ $item->container_back }}"></td>
                                                                    </tr>
                                                                    @php
                                                                        // Update lastRowReceivableCounter to the next value
                                                                        $lastRowContainerInfoCounter = $index + 2; // Increment by 1 from the last index
                                                                    @endphp
                                                                @endforeach
                                                                <input type="hidden" id="lastRowContainerInfoCounter"
                                                                    value="{{ $lastRowContainerInfoCounter }}"
                                                                    name="last_row_container_info_counter">
                                                                {{-- @endforeach --}}
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="bl_details" role="tabpanel"
                                                aria-labelledby="bl_details_tab">
                                                <div class="row">
                                                    <div class="col-md-6 mt-2">
                                                        <label for="regular-form-1" class="form-label">Shipper</label>
                                                        <textarea name="shipper" id="regular-form-1" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Shipper">{{ @$job_master->job_detail->shipper->name . "\n" . @$job_master->job_detail->shipper->address }}</textarea>
                                                    </div>
                                                    <div class="col-md-6 mt-2">
                                                        {{-- <label for="regular-form-1" class="form-label">Consignee</label> --}}
                                                        <a href="javascript:;"
                                                            class="consignee-modal text-decoration-underline fw-medium"
                                                            data-bs-toggle="modal" data-bs-target="#consigneeModal"
                                                            data-id="consignee_id">Consignee</a>
                                                        <textarea name="consignee" id="consignee" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Consignee">
@if (@$bl_master->bl_detail->consignee != null)
{{ @$bl_master->bl_detail->consignee }}@else{{ @$job_master->job_detail->consignee->name . "\n" . @$job_master->job_detail->consignee->address }}
@endif
</textarea>
                                                    </div>
                                                    <div class="col-md-6 mt-2">
                                                        <label for="regular-form-1" class="form-label">Notify Party
                                                            1</label>
                                                        <textarea name="detail_notify_party_one" id="detail_notify_party_one" cols="30" rows="3"
                                                            class="form-control" placeholder="Enter Notify Party 1">{{ $bl_master->bl_detail?->notify_party_one }}</textarea>
                                                    </div>
                                                    <div class="col-md-6 mt-2">
                                                        <label for="regular-form-1" class="form-label">Notify Party
                                                            2</label>
                                                        <textarea name="detail_notify_party_two" id="detail_notify_party_two" cols="30" rows="3"
                                                            class="form-control" placeholder="Enter Notify Party 2">{{ $bl_master->bl_detail?->notify_party_two }}</textarea>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Port of
                                                            Loading</label>
                                                        <select class="tom-select" name="detail_port_of_loading_id"
                                                            id="port_of_loading_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->port_of_loading_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Port Of
                                                            Discharge</label>
                                                        <select class="tom-select" name="detail_port_of_discharge_id"
                                                            id="port_of_discharge_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->port_of_discharge_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Place of
                                                            Delivery</label>
                                                        <select class="tom-select" name="place_of_delivery_id"
                                                            id="place_of_delivery_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->final_destination_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Agent Stamp</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Agent Stamp"
                                                            value="{{ $bl_master->bl_detail?->agent_stamp }}"
                                                            name="agent_stamp">
                                                    </div>
                                                    <div class="col-md-12 mt-2">
                                                        <label for="delivery_agent" class="form-label">Delivery
                                                            Agent</label>
                                                        <textarea name="delivery_agent" id="delivery_agent" cols="30" rows="2" class="form-control"
                                                            placeholder="Enter Delivery Agent">{{ $bl_master->bl_detail?->delivery_agent }}</textarea>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Freight Type</label>
                                                        <select data-placeholder="Select Freight Type" id="regular-form-1"
                                                            name="freight_type" class="tom-select w-full mt-2">
                                                            <option
                                                                {{ @$bl_master->bl_detail?->freight_type == 'Prepaid' ? 'selected' : '' }}
                                                                value="Prepaid">Prepaid</option>
                                                            <option
                                                                {{ @$bl_master->bl_detail?->freight_type == 'Collect' ? 'selected' : '' }}
                                                                value="Collect">Collect</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Unit</label>
                                                        <select data-placeholder="Select Unit" id="regular-form-1"
                                                            name="unit" class="tom-select w-full mt-2">
                                                            <option
                                                                {{ @$bl_master->bl_detail?->unit == 'LBS' ? 'selected' : '' }}
                                                                value="LBS">LBS</option>
                                                            <option
                                                                {{ @$bl_master->bl_detail?->unit == 'KG' ? 'selected' : '' }}
                                                                value="KG">KG</option>
                                                            <option
                                                                {{ @$bl_master->bl_detail?->unit == 'MTON' ? 'selected' : '' }}
                                                                value="MTON">MTON</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="manual"
                                                            {{ @$bl_master->bl_detail?->manual == '1' ? 'checked' : '' }}
                                                            value="1">
                                                        <label class="form-label" for="manual">
                                                            Manual
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">No. Of Original
                                                            B/L's</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter No. Of Original B/L's"
                                                            value="{{ $bl_master->bl_detail?->no_of_original_bl }}"
                                                            name="no_of_original_bl">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="gross-wt" class="form-label">Gross WT</label>
                                                        <input id="gross-wt" type="text" class="form-control"
                                                            placeholder="Enter Gross WT"
                                                            value="{{ $bl_master->bl_detail?->gross_wt }}"
                                                            name="gross_wt">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="net-wt" class="form-label">Net WT</label>
                                                        <input id="net-wt" type="text" class="form-control"
                                                            placeholder="Enter Net WT"
                                                            value="{{ $bl_master->bl_detail?->net_wt }}" name="net_wt">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">Tare WT</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Tare WT"
                                                            value="{{ $bl_master->bl_detail?->tare_wt }}" name="tare_wt">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">CBM</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter CBM"
                                                            value="{{ $bl_master->bl_detail?->cbm }}" name="cbm">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">Pkgs</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Pkgs"
                                                            value="{{ $bl_master->bl_detail?->pkgs }}" name="pkgs">
                                                    </div>
                                                    <div class="col-md-2 mt-2">
                                                        <label for="regular-form-1" class="form-label">Unit</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Unit"
                                                            value="{{ $bl_master->bl_detail?->pkg_unit }}"
                                                            name="pkg_unit">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">HS Code</label>
                                                        {{-- <select class="tom-select" name="hs_code_id" id="hs_code_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($hsCodes as $item)
                                                                <option
                                                                    {{ @$job_master->job_detail->commodity->hs_code_id == $item->id ? 'selected' : '' }}
                                                                    {{ @$bl_master->bl_detail->hs_code_id == $item->id ? 'selected' : '' }} value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select> --}}
                                                        <input name="hs_code_id" id="hs_code_id" type="text"
                                                            class="form-control" placeholder="Enter HS Code"
                                                            value="{{ @$job_master->job_detail?->commodity?->hs_code_id }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Packing Group</label>
                                                        <select data-placeholder="Select Packing Group"
                                                            id="regular-form-1" name="packing_group"
                                                            class="tom-select w-full mt-2">
                                                            <option
                                                                {{ $bl_master->bl_detail?->packing_group == 'none' ? 'selected' : '' }}
                                                                value="none">None
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->packing_group == 'I-high_danger' ? 'selected' : '' }}
                                                                value="I-high_danger">I (High Danger)</option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->packing_group == 'II-med_danger' ? 'selected' : '' }}
                                                                value="II-med_danger">II (Med. Danger)</option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->packing_group == 'III-low_danger' ? 'selected' : '' }}
                                                                value="III-low_danger">III (Low Danger)</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Hazmat Class</label>
                                                        <select data-placeholder="Select Hazmat Class" id="regular-form-1"
                                                            name="hazmat_class" class="tom-select w-full mt-2">
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class not Specified' ? 'selected' : '' }}
                                                                value="Class not Specified">Class not Specified
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 1 Explosive' ? 'selected' : '' }}
                                                                value="Class 1 Explosive">Class 1 Explosive</option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 1.1 Explosive' ? 'selected' : '' }}
                                                                value="Class 1.1 Explosive">Class 1.1 Explosive
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 1.2 Explosive' ? 'selected' : '' }}
                                                                value="Class 1.2 Explosive">Class 1.2 Explosive
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 1.3 Explosive' ? 'selected' : '' }}
                                                                value="Class 1.3 Explosive">Class 1.3 Explosive
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 1.4 Explosive' ? 'selected' : '' }}
                                                                value="Class 1.4 Explosive">Class 1.4 Explosive
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 1.5 Explosive' ? 'selected' : '' }}
                                                                value="Class 1.5 Explosive">Class 1.5 Explosive
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 1.6 Explosive' ? 'selected' : '' }}
                                                                value="Class 1.6 Explosive">Class 1.6 Explosive
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 2 Gas' ? 'selected' : '' }}
                                                                value="Class 2 Gas">Class 2 Gas</option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 2.1 Gas' ? 'selected' : '' }}
                                                                value="Class 2.1 Gas">Class 2.1 Gas</option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 2.2 Gas' ? 'selected' : '' }}
                                                                value="Class 2.2 Gas">Class 2.2 Gas</option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 2.3 Gas' ? 'selected' : '' }}
                                                                value="Class 2.3 Gas">Class 2.3 Gas</option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 3 Flammable' ? 'selected' : '' }}
                                                                value="Class 3 Flammable">Class 3 Flammable Liq
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 4 Solid' ? 'selected' : '' }}
                                                                value="Class 4 Solid:division">Class 4 Solid:division
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 4.1 Flammable' ? 'selected' : '' }}
                                                                value="Class 4.1 Flammable">Class 4.1 Flammable
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 4.2 Spontaneous' ? 'selected' : '' }}
                                                                value="Class 4.2 Spontaneous">Class 4.2 Spontaneous
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 4.3 Dangerous' ? 'selected' : '' }}
                                                                value="Class 4.3 Dangerous">Class 4.3 Dangerous
                                                            </option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 5 Oxidizer' ? 'selected' : '' }}
                                                                value="Class 5 Oxidizer">Class 5 Oxidizer</option>
                                                            <option
                                                                {{ $bl_master->bl_detail?->hazmat_class == 'Class 5.1 Oxidizer' ? 'selected' : '' }}
                                                                value="Class 5.1 Oxidizer">Class 5.1 Oxidizer</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">UNO Code</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter UNO Code"
                                                            value="{{ $bl_master->bl_detail?->uno_code }}"
                                                            name="uno_code">
                                                    </div>
                                                    <div class="col-md-2 mt-1">
                                                        <label for="regular-form-1" class="form-label">Marks & No. Of
                                                            Container No's</label>
                                                        <textarea name="marks_and_container_no" id="regular-form-1" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Marks & No. Of Container No's">{{ $bl_master->bl_detail?->marks_and_container_no }}</textarea>
                                                    </div>
                                                    <div class="col-md-2 mt-1">
                                                        <label for="regular-form-1" class="form-label">No. Of Pkgs Or
                                                            Shipping Units</label>
                                                        <textarea name="no_of_pkgs" id="regular-form-1" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter No. Of Pkgs Or Shipping Units">{{ $bl_master->bl_detail?->no_of_pkgs }}</textarea>
                                                    </div>
                                                    <div class="col-md-4 mt-6">
                                                        <label for="regular-form-1" class="form-label">Description Of
                                                            Goods & Pkgs</label>
                                                        <textarea name="description_of_goods_and_pkgs" id="regular-form-1" cols="30" rows="3"
                                                            class="form-control" placeholder="Enter Description Of Goods & Pkgs">{{ $bl_master->bl_detail?->description_of_goods_and_pkgs }}</textarea>
                                                    </div>
                                                    <div class="col-md-2 mt-6">
                                                        <label for="weight-textarea" class="form-label">Gross
                                                            Weight</label>
                                                        <textarea name="gross_weight" id="weight-textarea" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Gross Weight">{{ $bl_master->bl_detail?->gross_weight }}</textarea>
                                                    </div>
                                                    <div class="col-md-2 mt-6">
                                                        <label for="regular-form-1" class="form-label">Measurement</label>
                                                        <textarea name="measurement" id="regular-form-1" cols="30" rows="3" class="form-control"
                                                            placeholder="Enter Measurement">{{ $bl_master->bl_detail?->measurement }}</textarea>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">On Board
                                                            Date</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_detail?->on_board_date }}"
                                                            type="date" class="form-control" name="on_board_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Place</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_detail?->place }}" type="text"
                                                            class="form-control" placeholder="Enter Place"
                                                            name="place">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date Of
                                                            Issue</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_detail?->date_of_issue }}"
                                                            type="date" class="form-control" name="date_of_issue">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">F.I No/Form E
                                                            #</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_detail?->fi_form_no }}"
                                                            type="text" class="form-control"
                                                            placeholder="Enter F.I No/Form E #" name="fi_form_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_detail?->form_date }}"
                                                            type="date" class="form-control" name="form_date">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="ref_no" role="tabpanel"
                                                aria-labelledby="ref_no_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Invoice #</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->invoice_no }}"
                                                            type="text" class="form-control"
                                                            placeholder="Enter Invoice #" name="invoice_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->invoice_date }}"
                                                            type="date" class="form-control" name="invoice_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Export #</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->export_no }}"
                                                            type="text" class="form-control"
                                                            placeholder="Enter Export #" name="export_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->export_date }}"
                                                            type="date" class="form-control" name="export_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Contract #</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->contract_no }}"
                                                            type="text" class="form-control"
                                                            placeholder="Enter Contract #" name="contract_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->contract_date }}"
                                                            type="date" class="form-control" name="contract_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">L/C #</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->lc_no }}" type="text"
                                                            class="form-control" placeholder="Enter L/C #"
                                                            name="lc_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->lc_date }}" type="date"
                                                            class="form-control" name="lc_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Client Ref
                                                            #</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->client_ref_no }}"
                                                            type="text" class="form-control"
                                                            placeholder="Enter Client Ref #" name="client_ref_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Shipping Ref
                                                            #</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->shipping_ref_no }}"
                                                            type="text" class="form-control"
                                                            placeholder="Enter Shipping Ref #" name="shipping_ref_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">S Bill #</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->s_bill_no }}"
                                                            type="text" class="form-control"
                                                            placeholder="Enter S Bill #" name="s_bill_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1"
                                                            value="{{ $bl_master->bl_ref_no?->s_bill_date }}"
                                                            type="date" class="form-control" name="s_bill_date">
                                                    </div>
                                                    {{-- <h2 class="fw-medium fs-base me-auto text-center mt-2">
                                                        STAMPS
                                                    </h2>
                                                    <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
                                                        <table class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th>S#</th>
                                                                    <th>Code</th>
                                                                    <th>Stamps</th>
                                                                    <th>Stamp Group</th> wire:
                                                                    <th>Stamp Date</th>
                                                                    <th>Remarks</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div> --}}
                                                    <!-- Hidden input fields for calculated totals -->
                                                    <input type="hidden" name="totalGrosswt" id="totalGrosswt"
                                                        value="">
                                                    <input type="hidden" name="totalpackages" id="totalpackages"
                                                        value="">
                                                    <input type="hidden" name="totalcontainers" id="totalcontainers"
                                                        value="">
                                                </div>
                                                {{-- <div class="mt-3">
                                                    <a href="{{ url('/se_job') }}" type="back"
                                                        class="btn btn-secondary waves-effect">
                                                        Back
                                                    </a>
                                                    <button type="submit" class="btn btn-primary submitBtn" style="float: right"
                                                        id="submitBtn">Save</button>
                                                </div> --}}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                </form>
            </div>
        </div>
    </div>
    </div>
    </div>
    @include('sea_export.se_bl.modals.print')
    @include('sea_export.se_bl.modals.consignee')


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('textarea').forEach(function(textarea) {
                textarea.addEventListener('keydown', function(e) {
                    // Prevent parent form or listeners from hijacking Enter key
                    e.stopPropagation();
                });
            });
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add event listener to all buttons with the class 'showPrintBtn'
            document.querySelectorAll('.showPrintBtn').forEach(button => {
                button.addEventListener('click', function() {
                    // Get the bl_id from the button's data-item-id attribute
                    const blId = this.getAttribute('data-item-id');

                    // Set the value of the hidden input field
                    // document.getElementById('selectedBLId').value = blId;
                    const form = document.getElementById(
                        'printForm');
                    form.setAttribute('action', `/bl_print/${blId}`);
                });
            });
        });

        // function updatePrintLink() {
        //     // Get the selected blank or pre-printed page option
        //     const selectedValue = document.querySelector('input[name="blank_preprinted_page"]:checked').value;

        //     // Get the bl_id value from the hidden input
        //     const blId = document.getElementById('selectedBLId').value;
        //     const noOfOriginal = document.getElementById('no_of_original').value;

        //     // Get the printLink element
        //     const printLink = document.getElementById('printLink');

        //     // Set the href attribute with the updated URL
        //     printLink.href =
        //         `{{ url('bl_print') }}?page_type=${encodeURIComponent(selectedValue)}&bl_id=${encodeURIComponent(blId)}&no_of_original=${encodeURIComponent(noOfOriginal)}`;
        // }

        // function updatePrintLink() {
        //     const selectedValue = document.querySelector('input[name="blank_preprinted_page"]:checked').value;
        //     const blId = document.getElementById('selectedBLId').value;
        //     const printLink = document.getElementById('printLink');
        //     printLink.href =
        //         `{{ url('se_bl_print') }}?page_type=${encodeURIComponent(selectedValue)}&bl_id=${encodeURIComponent(blId)}`;
        // }
        document.addEventListener('DOMContentLoaded', function() {

            function toggleDivFormat() {
                if ($('#option1').is(':checked')) {
                    $('#divFormat').addClass('d-none');
                } else {
                    $('#divFormat').removeClass('d-none');
                }
            }

            function toggleDivFormatTwo() {
                if ($('#pdf').is(':checked')) {
                    $('#divDownloadAndPreview').removeClass('d-none');
                } else {
                    $('#divDownloadAndPreview').addClass('d-none');
                }
            }

            // Event listener for radio button changes
            $('input[name="option"]').change(function() {
                toggleDivFormat();
            });

            $('input[name="output"]').change(function() {
                toggleDivFormatTwo();
            });
            // Get all radio buttons
            const radioButtons = document.querySelectorAll('input[name="reportOptions"]');
            // Add event listener to each radio button
            radioButtons.forEach(function(radio) {
                radio.addEventListener('change', function() {
                    // Hide all divs
                    $('#divDefAndTemp').addClass('d-none');
                    $('#divFormat').addClass('d-none');
                    $('#divRiderSheet').addClass('d-none');
                    $('#divPrintWhatAndHide').addClass('d-none');

                    // Show the selected div
                    if (this.id === 'report1') {
                        $('#divDefAndTemp').removeClass('d-none');
                        $('#divPrintWhatAndHide').removeClass('d-none');
                        $('input[name="option"]').change(function() {
                            if ($('#option1').is(':checked')) {
                                $('#divFormat').addClass('d-none');
                            } else {
                                $('#divFormat').removeClass('d-none');
                            }
                        });
                        toggleDivFormat();
                        toggleDivFormatTwo();
                    } else if (this.id === 'report2') {
                        $('#divFormat').addClass('d-none');
                        $('#divDefAndTemp').addClass('d-none');
                        $('#divRiderSheet').removeClass('d-none');
                        $('#divPrintWhatAndHide').removeClass('d-none');
                    }
                });
            });
        });
    </script>
    <script>
        $(document).ready(function() {

            $(window).keydown(function(event) {
                if (event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });

            $('.add-consignee-details').on('click', function(e) {
                e.preventDefault();
                var consigneeId = $(this).data('id');


                if (consigneeId) {
                    $.ajax({
                        url: '/api/get-consignee-details/' + consigneeId,
                        type: 'GET',
                        success: function(data) {
                            console.log('response', data)
                            var detail = data.name + '\n' + data
                                .address;
                            $('#consignee').val(
                                detail);
                        },
                        error: function() {
                            $('#consignee').val(
                                'Error retrieving details.');
                        }
                    });
                } else {
                    $('#consignee').val('');
                }
            });

            function loadNotifyPartyDetails(notifyPartyId) {
                if (notifyPartyId) {
                    $.ajax({
                        url: '/api/get-party-details/' + notifyPartyId,
                        type: 'GET',
                        success: function(data) {
                            console.log('response', data);
                            var detail = data.name + '\n' + data.address;
                            $('#detail_notify_party_one').val(
                                detail); // Set the value in the notify party detail field
                        },
                        error: function() {
                            $('#detail_notify_party_one').val(
                                'Error retrieving details.'); // Set error message
                        }
                    });
                } else {
                    $('#detail_notify_party_one').val(''); // Clear the field if no notify party is selected
                }
            }

            // Call the function on change event
            $('#notify_party_one').change(function() {
                var notifyPartyId = $(this).val();
                loadNotifyPartyDetails(notifyPartyId); // Call the function on change
            });

            $('.add-notify-party-1-details').on('click', function(e) {
                var notifyPartyId = $(this).data('id');
                console.log(notifyPartyId)
                loadNotifyPartyDetails(notifyPartyId); // Call the function on change
            });


            function loadNotifyPartyTwoDetails(notifyPartyId) {
                if (notifyPartyId) {
                    $.ajax({
                        url: '/api/get-party-details/' + notifyPartyId,
                        type: 'GET',
                        success: function(data) {
                            console.log('response', data);
                            var detail = data.name + '\n' + data.address;
                            $('#detail_notify_party_two').val(
                                detail); // Set the value in the notify party detail field
                        },
                        error: function() {
                            $('#detail_notify_party_two').val(
                                'Error retrieving details.'); // Set error message
                        }
                    });
                } else {
                    $('#detail_notify_party_two').val(''); // Clear the field if no notify party is selected
                }
            }

            // Call the function on change event
            $('#notify_party_two').change(function() {
                var notifyPartyId = $(this).val();
                loadNotifyPartyTwoDetails(notifyPartyId); // Call the function on change
            });
            $('.add-notify-party-2-details').on('click', function(e) {
                var notifyPartyId = $(this).data('id');
                console.log(notifyPartyId)
                loadNotifyPartyTwoDetails(notifyPartyId); // Call the function on change
            });

            var overseasAgentId = $('#overseas_agent_id').val();
            loadOverseasAgentDetails(overseasAgentId);

            function loadOverseasAgentDetails(overseasAgentId) {
                if (overseasAgentId) {
                    $.ajax({
                        url: '/api/get-party-details/' + overseasAgentId,
                        type: 'GET',
                        success: function(data) {
                            console.log('response', data);
                            var detail = data.name + '\n' + data.address;
                            $('#delivery_agent').val(detail); // Set the value of delivery agent
                        },
                        error: function() {
                            $('#delivery_agent').val('Error retrieving details.'); // Set error message
                        }
                    });
                } else {
                    $('#delivery_agent').val(''); // Clear the input if no overseas agent is selected
                }
            }

            // Call the function on change event
            $('#overseas_agent_id').change(function() {
                var overseasAgentId = $(this).val();
                loadOverseasAgentDetails(overseasAgentId); // Call the function on change
            });



            $('#container_info').on('keydown', 'input[name="container_no[]"]', function(e) {
                // Check if the Tab key is pressed
                if (e.which == 9) {
                    e.preventDefault(); // Prevent default tab behavior
                    addRowContainer(); // Add a new row
                    // Focus on the container_no input field of the new row
                    setTimeout(function() {
                        $('#containerInfoTable tbody tr:last-child').find(
                            'input[name="container_no[]"]').focus();
                    }, 0);
                }
            });

            const dropdownOptions = {
                loadType: ["Full", "Empty"],
                Unit: ["BAGS", "BALES", "BARREL", "BLOCKS", "BOATS", "BOBBIN",
                    "BOTTLES", "BOXES", "BRIQUETTES", "BUNDLES", "CABLE DRUM", "CANS", "CARBOY", "CARTONS",
                    "CASE", "CASKS", "COILS", "COLLI", "CRATES", "CYLINDERS", "DOZENS", "DRUMS",
                    "FIBRE DRUMS", "ITEMS", "KEGS", "LOOSE", "METAL DRUMS", "METERS", "MODULES", "PACKAGES",
                    "PACKETS", "PAILS", "PALLETS", "PARCELS", "PIECES", "PLASTIC DRUMS", "REELS", "ROLLS",
                    "SACKS", "SETS", "SHEETS", "SKIDS", "SLABS", "STEEL PACK", "STEEL PLATES",
                    "STEEL TRUNKS", "TEA CHESTS", "TONS", "UNIT"
                ],
                wtUnit: ["LBS", "KG", "MTON"],
                sizeType: ["Please Select", "20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK",
                    "40HC", "40HCRF",
                    "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
                ],
                dgNonDg: ["Non-DG", "DG", "All"],
            };

            // function createDropdown(name, options) {
            //     let dropdown = '<select name="' + name + '" class="form-control w-24">';
            //     options.forEach(option => {
            //         dropdown += '<option value="' + option + '">' + option + '</option>';
            //     });
            //     dropdown += '</select>';
            //     return dropdown;
            // }

            // function createDynamicDropdown(name, options) {
            //     let dropdown = '<select name="' + name + '" class="form-control w-24">';
            //     options.forEach(option => {
            //         dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            //     });
            //     dropdown += '</select>';
            //     return dropdown;
            // }

            function createDropdown(name, options, additionalClass = '') {
                let dropdown = '<select name="' + name + '" class="form-control w-24 ' + additionalClass + '">';
                options.forEach(option => {
                    dropdown += '<option value="' + option + '">' + option + '</option>';
                });
                dropdown += '</select>';
                return dropdown;
            }

            function createDynamicDropdown(name, options, additionalClass = '') {
                let dropdown = '<select name="' + name + '" class="form-control w-24 ' + additionalClass + '">';
                options.forEach(option => {
                    dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
                });
                dropdown += '</select>';
                return dropdown;
            }

            // function createInput(type, name, placeholder) {
            //     if (type == "checkbox") {
            //         return '<input type="' + type + '" name="' + name +
            //             '"value="1" class="form-check-input" placeholder="' +
            //             placeholder + '">';
            //     } else {
            //         return '<input type="' + type + '" name="' + name +
            //             '" class="form-control w-24" placeholder="' +
            //             placeholder + '">';
            //     }
            // }

            function createInputWithClass(name, placeholder, additionalClass = '') {
                return '<input type="text" name="' + name +
                    '" class="form-control w-24 ' + additionalClass + '" placeholder="' +
                    placeholder + '">';
            }

            function createInput(type, name, placeholder, required = false, additionalClass = '', value = '') {
                let input = '';
                const inputId = name.replace(/\[\]/g, '') + '_' + Math.random().toString(36).substring(
                    7); // Unique ID for each input

                if (type === "checkbox") {
                    input = '<input type="' + type + '" name="' + name +
                        '" value="1" class="form-check-input ' + additionalClass + '" placeholder="' + placeholder +
                        '">';
                } else {
                    input = '<div class="form-group">' +
                        '<input type="' + type + '" id="' + inputId + '" name="' + name + '" value="' + value +
                        '" class="form-control w-24 ' + (required ? 'required ' : '') + additionalClass +
                        '" placeholder="' + placeholder + '">' +
                        // (required ?
                        '<div class="invalid-feedback" id="' + inputId + '-feedback">Seal No is required</div>'
                        // )
                        +
                        '</div>';
                }

                return input;
            }

            // Validation function
            function validateContainerNo(inputElement) {
                const value = inputElement.val();
                const hasFourAlphabets = (value.match(/[A-Za-z]/g) || []).length === 4;
                const hasSevenDigits = (value.match(/[0-9]/g) || []).length === 7;
                const feedbackElement = inputElement.siblings('.invalid-feedback');

                if (!hasFourAlphabets || !hasSevenDigits) {
                    feedbackElement.text('Container No is invalid');
                    feedbackElement.show();
                    inputElement.addClass('is-invalid');
                } else {
                    feedbackElement.hide();
                    inputElement.removeClass('is-invalid');
                }
            }

            // Function to calculate tare weight
            function calculateTareWeight(row) {
                const grossWeight = parseFloat(row.find('input[name^="container_gross_wt"]').val()) || 0;
                const netWeight = parseFloat(row.find('input[name^="container_net_wt"]').val()) || 0;
                const tareWeight = grossWeight - netWeight;
                row.find('input[name^="container_tare_wt"]').val(tareWeight);
                updateTotals();
            }

            // let containerInfoRows = 1;
            let lastRowContainerInfoCounter = parseInt(document.getElementById('lastRowContainerInfoCounter')
                .value);
            let containerInfoRows = isNaN(lastRowContainerInfoCounter) ? 1 : lastRowContainerInfoCounter;

            function updateTotals() {
                let totalGrossWt = 0;
                let totalNetWt = 0;
                let totalTareWt = 0;
                let totalPackages = 0;

                $('input[name^="container_gross_wt"]').each(function() {
                    totalGrossWt += parseFloat($(this).val()) || 0;
                });

                $('input[name^="container_net_wt"]').each(function() {
                    totalNetWt += parseFloat($(this).val()) || 0;
                });

                $('input[name^="container_tare_wt"]').each(function() {
                    totalTareWt += parseFloat($(this).val()) || 0;
                });

                $('input[name^="container_packages"]').each(function() {
                    totalPackages += parseInt($(this).val()) || 0;
                });

                totalContainers = $('input[name^="container_no"]').length;

                $('input[name="gross_wt"]').val(totalGrossWt);
                $('input[name="net_wt"]').val(totalNetWt);
                $('input[name="tare_wt"]').val(totalTareWt);
                $('input[name="pkgs"]').val(totalPackages);

                // Update hidden input fields with calculated totals
                $('#totalGrosswt').val(totalGrossWt);
                $('#totalpackages').val(totalPackages);
                $('#totalcontainers').val(totalContainers);
                updateWeightTextarea();
            }

            function updateWeightTextarea() {
                // Get values from input fields
                var grossWt = document.getElementById('gross-wt').value;
                var netWt = document.getElementById('net-wt').value;

                // Set value of the textarea
                var textarea = document.getElementById('weight-textarea');
                textarea.value = 'Net Weight: ' + netWt + '\nGross Weight: ' + grossWt;
            }

            // Add event listeners to input fields
            document.getElementById('gross-wt').addEventListener('input', updateWeightTextarea);
            document.getElementById('net-wt').addEventListener('input', updateWeightTextarea);

            function addRowContainer(tabKeyPressed) {
                let row = '<tr>' +
                    '<td class="text-nowrap"><button type="button" class="btn btn-danger btn-sm delete-row">Delete</button></td>' +
                    '<td class="text-nowrap">' + containerInfoRows +
                    '<input type="hidden" name="container_info_rows" value=' + containerInfoRows + '>' + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_no[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_seal_no[]', '', tabKeyPressed) +
                    '</td>' +
                    '<td class="text-nowrap">' + createDropdown('container_size_type[]', dropdownOptions.sizeType,
                        'container-size-type') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_rate_group[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_gross_wt[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_net_wt[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_tare_wt[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createDropdown('container_wt_unit[]', dropdownOptions.wtUnit) +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_cbm[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_packages[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createDropdown('container_unit[]', dropdownOptions.Unit) +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_temperature[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createDropdown('container_load_type[]', dropdownOptions.loadType) +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_remarks[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_detention[]', '', false, '', '14') +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_demurrage[]', '', false, '', '14') +
                    '</td>' +
                    '<td class="text-nowrap">' + createInputWithClass('container_plugin[]', '',
                        'container-plugin') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_line_code[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('checkbox', 'container_part_fcl[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('checkbox', 'container_soc[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createDropdown('container_dg_non_dg[]', dropdownOptions.dgNonDg) +
                    '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_form_number[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('date', 'container_form_date[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('checkbox', 'container_oog[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_top[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_right[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_left[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_front[]', '') + '</td>' +
                    '<td class="text-nowrap">' + createInput('text', 'container_back[]', '') + '</td>' +
                    '</tr>';
                $('#containerInfoTable tbody').append(row);
                containerInfoRows++;
                updateTotals();

                // Attach change event to newly added dropdowns

                // Attach change event listener for the unit dropdown to update the target div
                $('#containerInfoTable tbody tr:first-child select[name^="container_wt_unit"]').on('change',
                    function() {
                        updateUnitDiv($(this));
                    });

                $('#containerInfoTable tbody tr:last-child input[name^="container_packages"]').on('input',
                    function() {
                        updatePackagesSum();
                    });

                $('#containerInfoTable tbody tr:last-child .container-size-type').change(function() {
                    let selectedValue = $(this).val();
                    let containerPluginInput = $(this).closest('tr').find('.container-plugin');
                    if (selectedValue.startsWith('40') || selectedValue.startsWith('45')) {
                        containerPluginInput.val(2);
                    } else {
                        containerPluginInput.val(1);
                    }
                });

                $('#containerInfoTable tbody tr:last-child input[name^="container_no"]').on('input', function() {
                    validateContainerNo($(this));
                });

                // Attach input event listeners for gross weight and net weight to calculate tare weight
                $('#containerInfoTable tbody tr:last-child input[name^="container_gross_wt"], #containerInfoTable tbody tr:last-child input[name^="container_net_wt"]')
                    .on('input', function() {
                        calculateTareWeight($(this).closest('tr'));
                    });
                $('#addRowContainerInfo').click(addRowContainer);

                $('#containerInfoTable tbody tr:last-child .delete-row').on('click', function() {
                    $(this).closest('tr').remove();
                    updateTotals(); // Update totals after removing a row
                });

                $('#addRowContainerInfo').click(addRowContainer);
            }
            $('#containerInfoTable tbody .delete-row').on('click', function() {
                $(this).closest('tr').remove();
                updateTotals(); // Update totals after removing a row
            });
            // Attach input event listener for the container_packages[] input to update the sum
            $('input[name^="container_packages"]').on('input', function() {
                updatePackagesSum();
            });

            $('.container-size-type').change(function() {
                let selectedValue = $(this).val();
                let containerPluginInput = $(this).closest('tr').find('.container-plugin');
                if (selectedValue.startsWith('40') || selectedValue.startsWith('45')) {
                    containerPluginInput.val(2);
                } else {
                    containerPluginInput.val(1);
                }
            });

            $('input[name^="container_no"]').on('input', function() {
                validateContainerNo($(this));
            });

            // Attach input event listeners for gross weight and net weight to calculate tare weight
            $('input[name^="container_gross_wt"], input[name^="container_net_wt"]').on('input', function() {
                calculateTareWeight($(this).closest('tr'));
            });
            $('#addRowContainerInfo').click(addRowContainer);

            // Function to update the select element inside the div with the value from the first row
            function updateUnitDiv(selectedUnitElement) {
                const selectedValue = selectedUnitElement.val();
                console.log(selectedValue);
                $('select[name="unit"]').val(selectedValue);
            }

            // Function to update the sum of all container_packages[] inputs
            function updatePackagesSum() {
                let totalPackages = 0;
                $('input[name^="container_packages"]').each(function() {
                    totalPackages += parseFloat($(this).val()) || 0;
                });
                $('input[name="pkgs"]').val(totalPackages);
            }

            // Assuming you have a form with id="yourFormId"
            $('#formId').on('submit', function(e) {
                var formIsValid = true;

                // Check each input field for validation errors
                $('input[name="container_seal_no[]"]').each(function() {
                    if ($(this).val().trim() === '') {
                        $(this).addClass('is-invalid'); // Mark input as invalid
                        $(this).next('.invalid-feedback').show(); // Show error message
                        formIsValid = false;
                    } else {
                        $(this).removeClass('is-invalid'); // Remove invalid state if input is valid
                        $(this).next('.invalid-feedback').hide(); // Hide error message
                    }
                });

                // If form is not valid, prevent submission and focus on the first input field with validation error
                if (!formIsValid) {
                    e.preventDefault();
                    var tabPaneId = $('input.is-invalid').first().closest('.tab-pane').attr('id');
                    var tabButtonSelector = 'button[data-bs-target="#' + tabPaneId + '"]';
                    var tabButton = $(tabButtonSelector);
                    console.log("Tab Button:", tabButton);
                    if (tabButton.length > 0) {
                        tabButton.tab(
                            'show'); // Show the tab containing the first input with validation error
                        console.log("Tab Button Clicked");
                    }
                    $('input.is-invalid').first().focus(); // Focus on the first input with validation error
                    console.log("Focused on Input Field");
                }
            });

            $(document).on('keyup',
                'input[name^="container_gross_wt"], input[name^="container_net_wt"], input[name^="container_tare_wt"], input[name^="container_packages"]',
                function() {
                    updateTotals();
                });

            // // Function to check form validity and show Swal alert if invalid
            // function validateFormAndSubmit() {
            //     var formIsValid = true;

            //     // Reset validation states and hide all error messages
            //     $('.is-invalid').removeClass('is-invalid');
            //     $('.invalid-feedback').hide();

            //     // Check each input field for validation errors
            //     $('input[required]').each(function() {
            //         if ($(this).val().trim() === '') {
            //             $(this).addClass('is-invalid'); // Mark input as invalid
            //             $(this).next('.invalid-feedback').show(); // Show error message
            //             formIsValid = false;
            //         }
            //     });

            //     // Check each select field for validation errors
            //     $('select[required]').each(function() {
            //         if ($(this).val() === '') {
            //             $(this).addClass('is-invalid'); // Mark select as invalid
            //             $(this).nextAll('.invalid-feedback').first().show(); // Show error message
            //             formIsValid = false;
            //         }
            //     });

            //     // If form is not valid, prevent submission and show Swal alert
            //     if (!formIsValid) {
            //         Swal.fire({
            //             toast: true,
            //             position: 'top-end',
            //             icon: 'error',
            //             title: "Please fill all required fields",
            //             showConfirmButton: false,
            //             timer: 2500
            //         });
            //     }

            //     return formIsValid; // Return form validity status
            // }

            // // Handle form submission
            // $('#submitBtn').on('click', function(e) {
            //     // Validate form and check if it's valid
            //     var isValid = validateFormAndSubmit();

            //     // If form is valid, allow submission (or continue with your submission logic)
            //     if (isValid) {
            //         // You can proceed with form submission or any other action
            //         console.log('Form is valid. Proceeding with submission...');
            //     } else {
            //         // Prevent default form submission if there are errors
            //         e.preventDefault();
            //         console.log('Form submission prevented due to validation errors.');
            //     }
            // });

        });
    </script>
    <script>
        $(document).ready(function() {
            $('#submitBtn').on('click', function(e) {
                // Validate form and check if it's valid
                var isValid = validateFormAndSubmit();

                // If form is valid, allow submission (or continue with your submission logic)
                if (isValid) {
                    // You can proceed with form submission or any other action
                    console.log(
                        'Form is valid. Proceeding with submission...');
                } else {
                    // Prevent default form submission if there are errors
                    e.preventDefault();
                    console.log(
                        'Form submission prevented due to validation errors.'
                    );
                }
            });

            function validateFormAndSubmit() {
                var formIsValid = true;

                // Reset validation states and hide all error messages
                $('.is-invalid').removeClass('is-invalid');
                $('.invalid-feedback').hide();

                if ($('#shipper_id').val() === '') {
                    $('#shipper_id').addClass('is-invalid');
                    $('#shipper_id').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
                if ($('#consignee_id').val() === '') {
                    $('#consignee_id').addClass('is-invalid');
                    $('#consignee_id').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
                if ($('#hbl_no').val() === '') {
                    $('#hbl_no').addClass('is-invalid');
                    $('#hbl_no').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
                if ($('#job_no').val() === '') {
                    $('#job_no').addClass('is-invalid');
                    $('#job_no').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }

                // If form is not valid, prevent submission and show Swal alert
                if (!formIsValid) {
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'error',
                        title: "Please fill all required fields",
                        showConfirmButton: false,
                        timer: 2500
                    });
                }

                return formIsValid; // Return form validity status
            }
        });
    </script>
@endsection
