@extends('layout.master')

@section('title')
    @if (Request::is('se_bl'))
        SE B/L-YARAN
    @elseif(Request::is('si_bl'))
        SI B/L-YARAN
    @elseif(Request::is('ae_bl'))
        AE B/L-YARAN
    @elseif(Request::is('ai_bl'))
        AI B/L-YARAN
    @endif
@endsection

@section('topbar')
    @if (Request::is('se_bl'))
        <a href="/se_bl" class="breadcrumb--active">SE B/L</a>
    @elseif(Request::is('si_bl'))
        <a href="/si_bl" class="breadcrumb--active">SI B/L</a>
    @elseif(Request::is('ae_bl'))
        <a href="/ae_bl" class="breadcrumb--active">AE B/L</a>
    @elseif(Request::is('ai_bl'))
        <a href="/se_bl" class="breadcrumb--active">AI B/L</a>
    @endif
@endsection
@section('content')
    {{-- <h2 class="intro-y fs-lg fw-medium mt-10">
        @if (Request::is('se_bl'))
            SE B/L
        @elseif(Request::is('si_bl'))
            SI B/L
        @elseif(Request::is('ae_bl'))
        @endif
    </h2> --}}
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-6">
                @if (Request::is('se_bl'))
                    SE B/L
                @elseif(Request::is('si_bl'))
                    SI B/L
                @elseif(Request::is('ae_bl'))
                    AE B/L
                @elseif(Request::is('ai_bl'))
                    AI B/L
                @endif
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button" data-bs-toggle="collapse"
                data-bs-target="#faq-accordion-collapse-1" aria-expanded="true" aria-controls="faq-accordion-collapse-1"> <i
                    data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    <div id="faq-accordion-collapse-1" class="accordion-collapse collapse show mt-5" aria-labelledby="faq-accordion-content-1"
        data-bs-parent="#faq-accordion-1">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <form method="GET" id="myForm" action="{{ url('/se_bl') }}">
                        <div class="row">
                            <div class="col-md-3">
                                <div>
                                    <label for="filterBy" class="form-label">Select</label>
                                    <select name="filterBy" id="filterBy" class="form-control">
                                        <option value="" {{ request('filterBy') == '' ? 'selected' : '' }}>Select
                                        </option>
                                        <option value="job_master_id"
                                            {{ request('filterBy') == 'job_master_id' ? 'selected' : '' }}>Job Number
                                        </option>
                                        <option value="hbl_no" {{ request('filterBy') == 'hbl_no' ? 'selected' : '' }}>HBL #
                                        </option>
                                        <option value="mbl_no" {{ request('filterBy') == 'mbl_no' ? 'selected' : '' }}>MBL #
                                        </option>
                                        <option value="shipper_id"
                                            {{ request('filterBy') == 'shipper_id' ? 'selected' : '' }}>Shipper ID</option>
                                        <option value="consignee_id"
                                            {{ request('filterBy') == 'consignee_id' ? 'selected' : '' }}>Consignee ID
                                        </option>
                                        <option value="vessel_id"
                                            {{ request('filterBy') == 'vessel_id' ? 'selected' : '' }}>Vessel ID</option>
                                        <option value="voyage_id"
                                            {{ request('filterBy') == 'voyage_id' ? 'selected' : '' }}>Voyage</option>
                                        <option value="description_of_goods_and_pkgs"
                                            {{ request('filterBy') == 'description_of_goods_and_pkgs' ? 'selected' : '' }}>
                                            Description of Goods and Pkgs</option>
                                        <option value="notify_party_one"
                                            {{ request('filterBy') == 'notify_party_one' ? 'selected' : '' }}>Notify Party
                                            One</option>
                                        <option value="notify_party_two"
                                            {{ request('filterBy') == 'notify_party_two' ? 'selected' : '' }}>Notify Party
                                            Two</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3" id="filterInput">
                                <label for="filterValue" class="form-label">Name</label>
                                <input type="text" name="filterValue" class="form-control"
                                    value="{{ request('filterValue') }}" placeholder="Enter Name or ID" name="name"
                                    aria-label="Enter Name">
                            </div>
                            <div class="col-md-3 d-none" id="shipperId">
                                <label>Shipper</label>
                                <select class="tom-select w-full mt-2" name="shipper_id" id="shipper_id"
                                    data-placeholder="Select Shipper">
                                    <option value="">Please Select</option>
                                    @foreach ($shippers as $item)
                                        <option {{ request('shipper_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="consigneeId">
                                <label>Consignee</label>
                                <select class="tom-select w-full mt-2" name="consignee_id" id="consignee_id"
                                    data-placeholder="Select Consignee">
                                    <option value="">Please Select</option>
                                    @foreach ($consignees as $item)
                                        <option {{ request('consignee_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="vessel">
                                <label>Vessel</label>
                                <select class="tom-select w-full mt-2" name="vessel_id" id="vessel_id"
                                    data-placeholder="Select Vessel">
                                    <option value="">Please Select</option>
                                    @foreach ($vessels as $item)
                                        <option {{ request('vessel_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="voyage">
                                <label>Voyage</label>
                                <select class="tom-select w-full mt-2" name="voyage_id" id="voyage_id"
                                    data-placeholder="Select Voyage">
                                    <option value="">Please Select</option>
                                    @foreach ($voyages as $item)
                                        <option {{ request('voyage_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->voyage_no }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="notifyPartyOne">
                                <label>Notify Party One</label>
                                <select class="tom-select w-full mt-2" name="notify_party_one" id="notify_party_one"
                                    data-placeholder="Select Notify Party One">
                                    <option value="">Please Select</option>
                                    @foreach ($notify_parties as $item)
                                        <option {{ request('notify_party_one') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->voyage_no }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="notifyPartyTwo">
                                <label>Notify Party Two</label>
                                <select class="tom-select w-full mt-2" name="notify_party_two" id="notify_party_two"
                                    data-placeholder="Select Notify Party Two">
                                    <option value="">Please Select</option>
                                    @foreach ($notify_parties as $item)
                                        <option {{ request('notify_party_two') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->voyage_no }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>Status</label>
                                <select data-placeholder="Select Status" id="bl_status" name="bl_status"
                                    class="tom-select w-full mt-2">
                                    <option value="" {{ request('bl_status') == '' ? 'selected' : '' }}>Select
                                    </option>
                                    <option {{ request('bl_status') == 'Draft' ? 'selected' : '' }} value="Draft">Draft
                                    </option>
                                    <option {{ request('bl_status') == 'Final' ? 'selected' : '' }} value="Final">Final
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="date_filter" class="form-label">Date Filter</label>
                                <select name="date_filter" id="date_filter" class="form-control">
                                    <option value="" {{ request('date_filter') == '' ? 'selected' : '' }}>Select
                                    </option>
                                    <option value="today" {{ request('date_filter') == 'today' ? 'selected' : '' }}>Today
                                    </option>
                                    <option value="this_week"
                                        {{ request('date_filter') == 'this_week' ? 'selected' : '' }}>This Week</option>
                                    <option value="this_month"
                                        {{ request('date_filter') == 'this_month' ? 'selected' : '' }}>This Month</option>
                                    <option value="custom" {{ request('date_filter') == 'custom' ? 'selected' : '' }}>
                                        Custom</option>
                                </select>
                            </div>
                            <div class="col-md-3" id="customDateRange"
                                style="display: {{ request('date_filter') == 'custom' ? 'block' : 'none' }};">
                                <label for="date_from" class="form-label">From</label>
                                <input type="date" name="date_from" class="form-control"
                                    value="{{ request('date_from') }}">
                            </div>
                            <div class="col-md-3" id="customDateRangeTwo"
                                style="display: {{ request('date_filter') == 'custom' ? 'block' : 'none' }};">
                                <label for="date_to" class="form-label">To</label>
                                <input type="date" name="date_to" class="form-control"
                                    value="{{ request('date_to') }}">
                            </div>
                            <div class="col-md-3 mt-8">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <circle cx="11" cy="11" r="8" />
                                        <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                    </svg>
                                    Search</button>
                                <a href="{{ url('/se_bl') }}" type="button"
                                    class="btn btn-sm btn-elevated-danger w-24">
                                    {{-- <i data-feather="x"></i> --}}
                                    <!-- https://feathericons.dev/?search=x&iconset=feather -->
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <line x1="18" x2="6" y1="6" y2="18" />
                                        <line x1="6" x2="18" y1="6" y2="18" />
                                    </svg>
                                    Clear</a>
                            </div>
                    </form>
                </div>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
    </div>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            {{-- @if (Request::is('se_bl'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/se_bl/add') }}">Add New</a>
            @elseif(Request::is('si_bl'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/si_bl/add') }}">Add New</a>
            @elseif(Request::is('ae_bl'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ae_bl/add') }}">Add New</a>
            @elseif(Request::is('ai_bl'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ai_bl/add') }}">Add New</a>
            @endif --}}
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $se_bls->firstItem() }} to
                {{ $se_bls->lastItem() }} of {{ $se_bls->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>JOB #</th>
                        <th>Status</th>
                        <th>HBL #</th>
                        <th>HBL Date</th>
                        <th>MBL #</th>
                        <th>MBL Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($se_bls as $item)
                        <tr>
                            <td>{{ @$item->job_master->job_no }}</td>
                            <td>{{ $item->bl_status }}</td>
                            <td>{{ $item->hbl_no }}</td>
                            <td>{{ $item->hbl_date }}</td>
                            <td>{{ $item->mbl_no }}</td>
                            <td>{{ $item->mbl_date }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <a class="btn btn-primary me-2 p-2" href="{{ url('/se_bl/edit/' . $item->id) }}"><i
                                            data-feather="edit" class="w-4 h-4"></i> </a>
                                    <button id="showPrintBtn{{ $item->id }}"
                                        class="btn btn-success me-2 p-2 showPrintBtn" data-bs-toggle="modal"
                                        data-bs-target="#printModal" data-item-id="{{ $item->id }}"><i
                                            data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                                    @if ($item->job_master_id)
                                        @if ($item->operation_id == 1)
                                            <a title="SE JOB" class="tooltip btn btn-primary me-2 p-2"
                                                href="{{ url('/se_job/edit/' . $item->job_master_id) }}"><i
                                                    data-feather="file-text" class="w-4 h-4 me-1"></i>
                                                JOB </a>
                                        @elseif ($item->operation_id == 2)
                                            <a title="SI JOB" class="tooltip btn btn-primary me-2 p-2"
                                                href="{{ url('/si_job/edit/' . $item->job_master_id) }}"><i
                                                    data-feather="file-text" class="w-4 h-4 me-1"></i>
                                                JOB </a>
                                        @elseif ($item->operation_id == 3)
                                            <a title="AE JOB" class="tooltip btn btn-primary me-2 p-2"
                                                href="{{ url('/ae_job/edit/' . $item->job_master_id) }}"><i
                                                    data-feather="file-text" class="w-4 h-4 me-1"></i>
                                                JOB </a>
                                        @elseif ($item->operation_id == 4)
                                            <a title="AI JOB" class="tooltip btn btn-primary me-2 p-2"
                                                href="{{ url('/ai_job/edit/' . $item->job_master_id) }}"><i
                                                    data-feather="file-text" class="w-4 h-4 me-1"></i>
                                                JOB </a>
                                        @endif
                                    @endif
                                    {{-- <a title="SE JOB" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/se_bl/add/' . $item->id) }}"><i data-feather="file-text"
                                                class="w-4 h-4 me-1"></i>
                                            JOB </a> --}}
                                    {{-- <a class="btn btn-success me-2 p-2" href="{{ url('/se_bl/add/' . $item->id) }}"><i
                                                data-feather="activity" class="w-4 h-4"></i> </a> --}}
                                    {{-- <div class="g-col-6 g-col-sm-3 g-col-lg-2 g-col-xl-1">
                                        <i data-feather="trash-2" class="d-block mx-auto"></i>
                                        <div class="text-center fs-xs mt-2">trash-2</div>
                                    </div> --}}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="g-col-12">
            <div class="d-flex justify-content-end align-items-end">
                <div class="me-3">
                    <label for="perPage" class="form-label">Show Items:</label>
                    <select id="perPage" name="perPage" class="form-select" onchange="changePerPage(this)">
                        <option value="100" @if ($perPage == 100) selected @endif>100</option>
                        <option value="200" @if ($perPage == 200) selected @endif>200</option>
                        <option value="250" @if ($perPage == 250) selected @endif>250</option>
                    </select>
                </div>
                <div class="ms-3">
                    <?php echo $se_bls->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                </div>
            </div>
        </div>
    </div>
    @include('sea_export.se_bl.modals.print')

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add event listener to all buttons with the class 'showPrintBtn'
            document.querySelectorAll('.showPrintBtn').forEach(button => {
                button.addEventListener('click', function() {
                    // Get the bl_id from the button's data-item-id attribute
                    const blId = this.getAttribute('data-item-id');

                    // Set the value of the hidden input field
                    // document.getElementById('selectedBLId').value = blId;
                    const form = document.getElementById(
                    'printForm'); 
                    form.setAttribute('action', `/bl_print/${blId}`);
                });
            });
        });

        // function updatePrintLink() {
        //     // Get the selected blank or pre-printed page option
        //     const selectedValue = document.querySelector('input[name="blank_preprinted_page"]:checked').value;

        //     // Get the bl_id value from the hidden input
        //     const blId = document.getElementById('selectedBLId').value;
        //     const noOfOriginal = document.getElementById('no_of_original').value;

        //     // Get the printLink element
        //     const printLink = document.getElementById('printLink');

        //     // Set the href attribute with the updated URL
        //     printLink.href =
        //         `{{ url('bl_print') }}?page_type=${encodeURIComponent(selectedValue)}&bl_id=${encodeURIComponent(blId)}&no_of_original=${encodeURIComponent(noOfOriginal)}`;
        // }

        // function updatePrintLink() {
        //     const selectedValue = document.querySelector('input[name="blank_preprinted_page"]:checked').value;
        //     const blId = document.getElementById('selectedBLId').value;
        //     const printLink = document.getElementById('printLink');
        //     printLink.href =
        //         `{{ url('se_bl_print') }}?page_type=${encodeURIComponent(selectedValue)}&bl_id=${encodeURIComponent(blId)}`;
        // }
        document.addEventListener('DOMContentLoaded', function() {

            function toggleDivFormat() {
                if ($('#option1').is(':checked')) {
                    $('#divFormat').addClass('d-none');
                } else {
                    $('#divFormat').removeClass('d-none');
                }
            }

            function toggleDivFormatTwo() {
                if ($('#pdf').is(':checked')) {
                    $('#divDownloadAndPreview').removeClass('d-none');
                } else {
                    $('#divDownloadAndPreview').addClass('d-none');
                }
            }

            // Event listener for radio button changes
            $('input[name="option"]').change(function() {
                toggleDivFormat();
            });

            $('input[name="output"]').change(function() {
                toggleDivFormatTwo();
            });
            // Get all radio buttons
            const radioButtons = document.querySelectorAll('input[name="reportOptions"]');
            // Add event listener to each radio button
            radioButtons.forEach(function(radio) {
                radio.addEventListener('change', function() {
                    // Hide all divs
                    $('#divDefAndTemp').addClass('d-none');
                    $('#divFormat').addClass('d-none');
                    $('#divRiderSheet').addClass('d-none');
                    $('#divPrintWhatAndHide').addClass('d-none');

                    // Show the selected div
                    if (this.id === 'report1') {
                        $('#divDefAndTemp').removeClass('d-none');
                        $('#divPrintWhatAndHide').removeClass('d-none');
                        $('input[name="option"]').change(function() {
                            if ($('#option1').is(':checked')) {
                                $('#divFormat').addClass('d-none');
                            } else {
                                $('#divFormat').removeClass('d-none');
                            }
                        });
                        toggleDivFormat();
                        toggleDivFormatTwo();
                    } else if (this.id === 'report2') {
                        $('#divFormat').addClass('d-none');
                        $('#divDefAndTemp').addClass('d-none');
                        $('#divRiderSheet').removeClass('d-none');
                        $('#divPrintWhatAndHide').removeClass('d-none');
                    }
                });
            });
        });
    </script>
    <script>
        $(document).ready(function() {

            document.getElementById('date_filter').addEventListener('change', function() {
                var customDateRange = document.getElementById('customDateRange');
                var customDateRangeTwo = document.getElementById('customDateRangeTwo');
                if (this.value === 'custom') {
                    customDateRange.style.display = 'block';
                    customDateRangeTwo.style.display = 'block';
                } else {
                    customDateRange.style.display = 'none';
                    customDateRangeTwo.style.display = 'none';
                }
            });

            $('#filterBy').change(function() {
                var selectedOption = $(this).val();

                // Clear all input fields
                $('#filterInput input').val('');
                $('#shipperId select').val('');
                $('#consigneeId select').val('');
                $('#vessel select').val('');
                $('#voyage select').val('');
                $('#notifyPartyOne select').val('');
                $('#notifyPartyTwo select').val('');

                // Hide all optional fields initially
                $('#filterInput').addClass('d-none');
                $('#shipperId').addClass('d-none');
                $('#consigneeId').addClass('d-none');
                $('#vessel').addClass('d-none');
                $('#voyage').addClass('d-none');
                $('#notifyPartyOne').addClass('d-none');
                $('#notifyPartyTwo').addClass('d-none');

                // Show the appropriate field based on the selected option
                switch (selectedOption) {
                    case 'shipper_id':
                        $('#shipperId').removeClass('d-none');
                        break;
                    case 'consignee_id':
                        $('#consigneeId').removeClass('d-none');
                        break;
                    case 'vessel_id':
                        $('#vessel').removeClass('d-none');
                        break;
                    case 'voyage_id':
                        $('#voyage').removeClass('d-none');
                        break;
                    case 'notify_party_one':
                        $('#notifyPartyOne').removeClass('d-none');
                        break;
                    case 'notify_party_two':
                        $('#notifyPartyTwo').removeClass('d-none');
                        break;
                    default:
                        $('#filterInput').removeClass('d-none');
                        break;
                }
            }).trigger('change'); // Trigger change event on page load to set the correct state
        });
    </script>
    <script>
        function changePerPage(select) {
            const perPage = select.value;
            const urlParams = new URLSearchParams(window.location.search);

            // Add or update your own parameters
            urlParams.set('perPage', perPage);

            // Construct the new URL
            const newUrl = `{{ url('/se_bl') }}?${urlParams.toString()}`;

            // Redirect to the new URL
            window.location.href = newUrl;

        }
    </script>
@endsection