@extends('layout.master')

@section('title')
    @if (Request::is('se_invoice/add'))
        Add-SE Invoice-YARAN
    @elseif(Request::is('si_invoice/add'))
        Add-SI Invoice-YARAN
    @elseif(Request::is('ae_invoice/add'))
        Add-AE Invoice-YARAN
    @elseif(Request::is('ai_invoice/add'))
        Add-AI Invoice-YARAN
    @endif
@endsection

@section('topbar')
    @if (Request::is('se_invoice/add'))
        <a href="/se_invoice" class="breadcrumb-item">SE Invoice</a>
    @elseif(Request::is('si_invoice/add'))
        <a href="/si_invoice" class="breadcrumb-item">SI Invoice</a>
    @elseif(Request::is('ae_invoice/add'))
        <a href="/ae_invoice" class="breadcrumb-item">AE Invoice</a>
    @elseif(Request::is('ai_invoice/add'))
        <a href="/ai_invoice" class="breadcrumb-item">AI Invoice</a>
    @endif

    <i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('se_invoice/add') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            @if (Request::is('se_invoice/add'))
                                Add SE Invoice
                            @elseif(Request::is('si_invoice/add'))
                                Add SI Invoice
                            @elseif(Request::is('ae_invoice/add'))
                                Add AE Invoice
                            @elseif(Request::is('ai_invoice/add'))
                                Add AI Invoice
                            @endif
                        </h2>
                        <button type="submit" class="btn btn-primary submitBtn" style="float: right"
                            id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="invoice_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#invoice" type="button"
                                                            role="tab" aria-controls="invoice_tab"
                                                            aria-selected="true">Invoice</button>
                                                    </li>
                                                    <li id="charges_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#charges" type="button" role="tab"
                                                            aria-controls="charges_tab"
                                                            aria-selected="false">Charges</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="invoice" role="tabpanel"
                                                aria-labelledby="invoice_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Tran #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Tran #" name="tran_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Inv Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="inv_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Reference</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Reference" name="reference">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Status</label>
                                                        <select data-placeholder="Select Status" id="regular-form-1"
                                                            name="bl_status" class="tom-select w-full mt-2">
                                                            <option value="1">Active</option>
                                                            <option value="2">Inactive</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Category</label>
                                                        <select id="regular-form-1" name="category"
                                                            class="tom-select w-full mt-2">
                                                            <option value="Regular">Regular</option>
                                                            <option value="Security Deposit">Security Deposit</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-12">
                                                        <input class="form-check-input" type="radio" name="settlement"
                                                            id="settled" value="settled">
                                                        <label class="form-label" for="settled">
                                                            Settled
                                                        </label>
                                                        <input class="form-check-input" type="radio" name="settlement"
                                                            id="un_settled" value="un_settled">
                                                        <label class="form-label" for="un_settled">
                                                            Un-Settled
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Client</label>
                                                        <select class="tom-select" name="client_id" id="client_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($clients as $item)
                                                                <option {{-- {{ $job_master->job_detail->client_id == $item->id ? 'selected' : '' }} --}} value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Sequence #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Sequence #" name="sequence_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Invoice Type</label>
                                                        <select id="regular-form-1" name="invoice_type"
                                                            class="tom-select w-full mt-2">
                                                            <option value="SI">SI</option>
                                                            <option value="CN">CN</option>
                                                            <option value="Zero">Zero</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Ref. Tran #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Ref. Tran #" name="ref_tran_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Operation</label>
                                                        <select id="regular-form-1" name="operation_id"
                                                            class="tom-select w-full mt-2">
                                                            @foreach ($operations as $item)
                                                                <option {{-- {{ $job_master->operation_id == $item->id ? 'selected' : '' }} --}} value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Job #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Job #" {{-- value="{{ $job_master->id }}" --}}
                                                            name="job_no">
                                                    </div>
                                                    {{-- <div class="col-md-3 mt-2">
                                                        <label>Currency</label>
                                                        <select id="regular-form-1" name="currency"
                                                            class="tom-select w-full mt-2">
                                                            <option value="PKR">PKR</option>
                                                            <option value="USD">USD</option>
                                                            <option value="AED">AED</option>
                                                            <option value="GPB">GPB</option>
                                                            <option value="EUR">EUR</option>
                                                            <option value="BDT">BDT</option>
                                                            <option value="OMR">OMR</option>
                                                        </select>
                                                    </div> --}}
                                                    <div class="col-md-3 mt-2">
                                                        <label>Cost Center</label>
                                                        <select data-placeholder="Select Cost Center" id="regular-form-1"
                                                            name="cost_center" class="tom-select w-full mt-2">
                                                            <option value="Head Office">Head Office</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Invoice To</label>
                                                        <select id="regular-form-1" name="invoice_to"
                                                            class="tom-select w-full mt-2">
                                                            <option value="clearing_agent">Clearing Agent</option>
                                                            <option value="importer">Importer</option>
                                                            <option value="coloador">Coloador</option>
                                                            <option value="client">Client</option>
                                                            <option value="client_importer">Client/Importer</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="manual" value="1">
                                                        <label class="form-label" for="manual">
                                                            Manual
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Due Days</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Due Days" name="due_days">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Invoice A/C</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Invoice A/C" name="invoice_ac">
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="auto_round_off"
                                                            value="1">
                                                        <label class="form-label" for="auto_round_off">
                                                            Auto Round Off
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="tax_charges" value="1">
                                                        <label class="form-label" for="tax_charges">
                                                            Tax Charges
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="charges" role="tabpanel"
                                                aria-labelledby="charges_tab">
                                                <div class="text-end mt-3 me-5">
                                                    <button id="addRowReceivableButton" type="button"
                                                        class="btn btn-primary">Add
                                                        Row</button>
                                                </div>
                                                <div class="row">
                                                    <div class="g-col-12 overflow-auto">
                                                        <table id="receiveableTable" class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-nowrap">S.No</th>
                                                                    <th class="text-nowrap">Charge Name</th>
                                                                    <th class="text-nowrap">Charge Descripton</th>
                                                                    <th class="text-nowrap">Size/Type</th>
                                                                    <th class="text-nowrap">Rate Group</th>
                                                                    <th class="text-nowrap">DG/Non-DG</th>
                                                                    <th class="text-nowrap">Container</th>
                                                                    <th class="text-nowrap">Qty</th>
                                                                    <th class="text-nowrap">Rate</th>
                                                                    <th class="text-nowrap">Currency</th>
                                                                    <th class="text-nowrap">Amount</th>
                                                                    <th class="text-nowrap">Discount</th>
                                                                    <th class="text-nowrap">Net Amount</th>
                                                                    <th class="text-nowrap">Margin</th>
                                                                    <th class="text-nowrap">Tax</th>
                                                                    <th class="text-nowrap">Tax Amount</th>
                                                                    <th class="text-nowrap">Net Amount Inc Tax</th>
                                                                    <th class="text-nowrap">Ex. Rate</th>
                                                                    <th class="text-nowrap">Local Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                {{-- @foreach ($job_master->job_charges_receivable as $index => $item)
                                                                    <tr>
                                                                        <td>{{ $index + 1 }}</td>
                                                                        <td><select class="form-control"
                                                                                name="charge_id[]" id="charge_id">
                                                                                @foreach ($charges as $charge)
                                                                                    <option
                                                                                        {{ $item->receivable_charge_id == $charge->id ? 'selected' : '' }}
                                                                                        value="{{ $charge->id }}">
                                                                                        {{ $charge->name }}</option>
                                                                                @endforeach
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="description[]"
                                                                                value="{{ $item->description }}">
                                                                        </td>
                                                                        <td><select class="form-control"
                                                                                name="size_type[]" id="size_type">
                                                                                <option
                                                                                    {{ $item->size_type == '20BK' ? 'selected' : '' }}
                                                                                    value="20BK">20BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20FR' ? 'selected' : '' }}
                                                                                    value="20FR">20FR</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20OT' ? 'selected' : '' }}
                                                                                    value="20OT">20OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20RE' ? 'selected' : '' }}
                                                                                    value="20RE">20RE</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20SD' ? 'selected' : '' }}
                                                                                    value="20SD">20SD</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20TK' ? 'selected' : '' }}
                                                                                    value="20TK">20TK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40FR' ? 'selected' : '' }}
                                                                                    value="40FR">40FR</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40BK' ? 'selected' : '' }}
                                                                                    value="40BK">40BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40HC' ? 'selected' : '' }}
                                                                                    value="40HC">40HC</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40HCRF' ? 'selected' : '' }}
                                                                                    value="40HCRF">40HCRF</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40OT' ? 'selected' : '' }}
                                                                                    value="40OT">40OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40SD' ? 'selected' : '' }}
                                                                                    value="40SD">40SD</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40VH' ? 'selected' : '' }}
                                                                                    value="40VH">40VH</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45BK' ? 'selected' : '' }}
                                                                                    value="45BK">45BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45HC' ? 'selected' : '' }}
                                                                                    value="45HC">45HC</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45OT' ? 'selected' : '' }}
                                                                                    value="45OT">45OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45TK' ? 'selected' : '' }}
                                                                                    value="45TK">45TK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45VH' ? 'selected' : '' }}
                                                                                    value="45VH">45VH</option>
                                                                                <option
                                                                                    {{ $item->size_type == 'M3' ? 'selected' : '' }}
                                                                                    value="M3">M3</option>
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="rate_group[]"
                                                                                value="{{ $item->rate_group }}">
                                                                        </td>
                                                                        <td><select class="form-control"
                                                                                name="dg_non_dg[]" id="dg_non_dg">
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'DG' ? 'selected' : '' }}
                                                                                    value="DG">
                                                                                    DG</option>
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'Non-DG' ? 'selected' : '' }}
                                                                                    value="Non-DG">
                                                                                    Non-DG</option>
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'All' ? 'selected' : '' }}
                                                                                    value="All">
                                                                                    All</option>
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="container[]"
                                                                                value="{{ $item->container }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control w-24"
                                                                                type="text" name="qty[]"
                                                                                value="{{ $item->qty }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="rate[]"
                                                                                value="{{ $item->rate }}">
                                                                        </td>
                                                                        <td><select name="currency[]" id="currency">
                                                                                <option
                                                                                    {{ $item->currency == 'USD' ? 'selected' : '' }}
                                                                                    value="USD">
                                                                                    USD</option>
                                                                                <option
                                                                                    {{ $item->currency == 'PKR' ? 'selected' : '' }}
                                                                                    value="PKR">
                                                                                    PKR</option>
                                                                                <option
                                                                                    {{ $item->currency == 'AED' ? 'selected' : '' }}
                                                                                    value="AED">
                                                                                    AED</option>
                                                                                <option
                                                                                    {{ $item->currency == 'BDT' ? 'selected' : '' }}
                                                                                    value="BDT">
                                                                                    BDT</option>
                                                                                <option
                                                                                    {{ $item->currency == 'OMR' ? 'selected' : '' }}
                                                                                    value="OMR">
                                                                                    OMR</option>
                                                                                <option
                                                                                    {{ $item->currency == 'EUR' ? 'selected' : '' }}
                                                                                    value="EUR">
                                                                                    EUR</option>
                                                                                <option
                                                                                    {{ $item->currency == 'GBP' ? 'selected' : '' }}
                                                                                    value="GBP">
                                                                                    GBP</option>
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="amount[]"
                                                                                value="{{ $item->amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="discount[]"
                                                                                value="{{ $item->discount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="net_amount[]"
                                                                                value="{{ $item->net_amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="margin[]"
                                                                                value="{{ $item->margin }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control w-30"
                                                                                type="text" name="tax[]"
                                                                                value="{{ $item->tax }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="tax_amount[]"
                                                                                value="{{ $item->tax_amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="net_amount_inc_tax[]"
                                                                                value="{{ $item->net_amount_inc_tax }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="ex_rate[]"
                                                                                value="{{ $item->ex_rate }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="local_amount[]"
                                                                                value="{{ $item->local_amount }}">
                                                                        </td>
                                                                    </tr>
                                                                @endforeach --}}
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Remarks</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Remarks" name="remarks">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Voucher #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Voucher #" name="voucher_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Bank
                                                            Details</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Bank Details" name="bank_details">
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="manual_remarks"
                                                            value="1">
                                                        <label class="form-label" for="manual_remarks">
                                                            Manual Remarks
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Total
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Total Amount" name="grand_total_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Net Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Net Amount" name="grand_net_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Discount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Discount" name="grand_discount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Tax Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Tax Amount" name="grand_tax_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Net Amount Inc
                                                            Tax</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Net Amount Inc Tax"
                                                            name="grand_net_amount_inc_tax">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Local
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Local Amount" name="grand_local_amount">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        const dropdownOptions = {
            customers: [""],
            vendors: [""],
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: ["PKR", "USD", "AED", "GBP", "EUR", "BDT", "OMR"],
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createCurrencyDropdown(name, currencies) {
            let dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please Select</option>';
            currencies.forEach((currency, index) => {
                dropdown += '<option value="' + (index + 1) + '">' + currency + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('charge_id[]', dropdownOptions
                    .charges) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('size_type[]', dropdownOptions
                    .sizeType) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate_group[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'container[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createCurrencyDropdown('currency[]', dropdownOptions.currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'discount[]', '') + '</td>' +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'margin[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount_inc_tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'ex_rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'local_amount[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>
