@extends('layout.master')

@section('title')
    @if ($job_master->operation_id == 1)
        Add-SE Invoice-YARAN
    @elseif($job_master->operation_id == 2)
        Add-SI Invoice-YARAN
    @elseif($job_master->operation_id == 3)
        Add-AE Invoice-YARAN
    @elseif($job_master->operation_id == 4)
        Add-AI Invoice-YARAN
    @endif
    {{-- Add-SE Invoice-YARAN --}}
@endsection

@section('topbar')
    {{-- <a href="/se_invoice" class="breadcrumb-item">SE Invoice</a> --}}

    @if ($job_master->operation_id == 1)
        <a href="/se_invoice" class="breadcrumb-item">SE Invoice</a>
    @elseif($job_master->operation_id == 2)
        <a href="/si_invoice" class="breadcrumb-item">SI Invoice</a>
    @elseif($job_master->operation_id == 3)
        <a href="/ae_invoice" class="breadcrumb-item">AE Invoice</a>
    @elseif($job_master->operation_id == 4)
        <a href="/ai_invoice" class="breadcrumb-item">AI Invoice</a>
    @endif
    <i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('se_invoice/add/' . $job_master->id) }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            @if ($job_master->operation_id == 1)
                                Add SE Invoice
                            @elseif($job_master->operation_id == 2)
                                Add SI Invoice
                            @elseif($job_master->operation_id == 3)
                                Add AE Invoice
                            @elseif($job_master->operation_id == 4)
                                Add AI Invoice
                            @endif
                        </h2>
                        <button type="submit" class="btn btn-primary submitBtn" style="float: right"
                            id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="row">
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Tran #</label>
                                                <input id="regular-form-1" type="text" class="form-control"
                                                    placeholder="Enter Tran #" name="tran_no"
                                                    value="{{ 'JI-' . (($latest_transaction?->id ?? 0) + 1) . '/' . date('y') }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Inv Date</label>
                                                <input id="regular-form-1" type="date" class="form-control"
                                                    name="inv_date" value="{{ $job_master->job_date }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Reference</label>
                                                <input id="regular-form-1" type="text" class="form-control"
                                                    placeholder="Enter Reference" name="reference"
                                                    value="{{ $job_master->file_no }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label>Status</label>
                                                <select data-placeholder="Select Status" id="regular-form-1"
                                                    name="bl_status" class="tom-select w-full mt-2">
                                                    <option value="1">Active</option>
                                                    <option value="2">Inactive</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label>Category</label>
                                                <select id="regular-form-1" name="category" class="tom-select w-full mt-2">
                                                    <option value="Regular">Regular</option>
                                                    <option value="Security Deposit">Security Deposit</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mt-12">
                                                <input class="form-check-input" type="radio" name="settlement"
                                                    id="settled" value="settled">
                                                <label class="form-label" for="settled">
                                                    Settled
                                                </label>
                                                <input class="form-check-input" type="radio" name="settlement"
                                                    id="un_settled" value="un_settled" checked>
                                                <label class="form-label" for="un_settled">
                                                    Un-Settled
                                                </label>
                                            </div>
                                            @php
                                                // Group charges by customer_id
                                                $chargesGroupedByCustomerId = $job_charges_recievable->groupBy(
                                                    'customer_id',
                                                );
                                            @endphp

                                            <div class="col-md-3 mt-2">
                                                <label for="client_id" class="form-label">Client</label>
                                                <input type="hidden" id="charges_ids" value="{{ $charges_ids }}">
                                                <select class="tom-select" name="client_id" id="client_id">
                                                    @if ($chargesGroupedByCustomerId->count() > 1)
                                                        <option value="">Please Select</option>
                                                        @foreach ($chargesGroupedByCustomerId as $customer_id => $charges)
                                                            <option value="{{ $customer_id }}">
                                                                {{ $charges->first()->customer->name ?? 'Unknown Client' }}
                                                            </option>
                                                        @endforeach
                                                    @elseif($chargesGroupedByCustomerId->count() === 1)
                                                        @php $singleCustomerId = $chargesGroupedByCustomerId->keys()->first(); @endphp
                                                        <option value="{{ $singleCustomerId }}" selected>
                                                            {{ $chargesGroupedByCustomerId[$singleCustomerId]->first()->customer->name ?? 'Unknown Client' }}
                                                        </option>
                                                    @else
                                                        <option value="">No Clients Available</option>
                                                    @endif
                                                </select>
                                            </div>
                                            {{-- <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Sequence #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Sequence #" name="sequence_no">
                                                    </div> --}}
                                            <div class="col-md-3 mt-2">
                                                {{-- <label for="regular-form-1" class="form-label">Ref. Tran #</label> --}}
                                                <button type="button" class="w-100" id="openInvoiceModalBtn">Ref.
                                                    Tran #</button>
                                                <input id="ref_tran_no" type="text" class="form-control"
                                                    placeholder="Enter Ref. Tran #" name="ref_tran_no" readonly>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label>Invoice Type</label>
                                                <select id="regular-form-1" name="invoice_type"
                                                    class="tom-select w-full mt-2">
                                                    <option value="SI" selected>SI</option>
                                                    <option value="CN">CN</option>
                                                    <option value="Zero">Zero</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label>Operation</label>
                                                <select id="regular-form-1" name="operation_id"
                                                    class="tom-select w-full mt-2">
                                                    @foreach ($operations as $item)
                                                        <option
                                                            {{ @$job_master->operation_id == $item->id ? 'selected' : '' }}
                                                            value="{{ $item->id }}">{{ $item->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Job #</label>
                                                <input type="hidden" value="{{ $job_master->id }}" name="job_no">
                                                <input readonly id="regular-form-1" type="text" class="form-control"
                                                    placeholder="Enter Job #" value="{{ @$job_master->job_no }}"
                                                    name="sej_job_no">
                                            </div>
                                            {{-- <div class="col-md-3 mt-2">
                                                        <label>Currency</label>
                                                        <select id="regular-form-1" name="currency"
                                                            class="tom-select w-full mt-2">
                                                            <option value="PKR">PKR</option>
                                                            <option value="USD">USD</option>
                                                            <option value="AED">AED</option>
                                                            <option value="GPB">GPB</option>
                                                            <option value="EUR">EUR</option>
                                                            <option value="BDT">BDT</option>
                                                            <option value="OMR">OMR</option>
                                                        </select>
                                                    </div> --}}
                                            <div class="col-md-3 mt-2">
                                                <label>Cost Center</label>
                                                <select data-placeholder="Select Cost Center" id="regular-form-1"
                                                    name="cost_center" class="tom-select w-full mt-2">
                                                    <option value="Head Office" selected>Head Office</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label>Invoice To</label>
                                                <select id="regular-form-1" name="invoice_to"
                                                    class="tom-select w-full mt-2">
                                                    <option value="clearing_agent">Clearing Agent</option>
                                                    <option value="importer">Importer</option>
                                                    <option value="coloador">Coloador</option>
                                                    <option value="client">Client</option>
                                                    <option value="client_importer">Client/Importer</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mt-10">
                                                <input id="regular-form-1" type="checkbox" class="form-check-input"
                                                    name="manual" value="1">
                                                <label class="form-label" for="manual">
                                                    Manual
                                                </label>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Due Days</label>
                                                <input id="regular-form-1" type="text" class="form-control"
                                                    placeholder="Enter Due Days" name="due_days">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Invoice A/C</label>
                                                <input id="regular-form-1" type="text" class="form-control"
                                                    placeholder="Enter Invoice A/C" name="invoice_ac">
                                            </div>
                                            <div class="col-md-3 mt-10">
                                                <input id="regular-form-1" type="checkbox" class="form-check-input"
                                                    name="auto_round_off" value="1">
                                                <label class="form-label" for="auto_round_off">
                                                    Auto Round Off
                                                </label>
                                            </div>
                                            <div class="col-md-3 mt-10">
                                                <input id="regular-form-1" type="checkbox" class="form-check-input"
                                                    name="tax_charges" value="1">
                                                <label class="form-label" for="tax_charges">
                                                    Tax Charges
                                                </label>
                                            </div>
                                            <div class="g-col-12 overflow-auto">
                                                <table id="receiveableTable" class="table table-bordered mt-n2">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-nowrap">S.No</th>
                                                            <th class="text-nowrap">Charge Name</th>
                                                            <th class="text-nowrap">Charge Descripton</th>
                                                            <th class="text-nowrap">Size/Type</th>
                                                            <th class="text-nowrap">Rate Group</th>
                                                            <th class="text-nowrap">DG/Non-DG</th>
                                                            <th class="text-nowrap">Container</th>
                                                            <th class="text-nowrap">Qty</th>
                                                            <th class="text-nowrap">Rate</th>
                                                            <th class="text-nowrap">Currency</th>
                                                            <th class="text-nowrap">Amount</th>
                                                            <th class="text-nowrap">Discount</th>
                                                            <th class="text-nowrap">Net Amount</th>
                                                            <th class="text-nowrap">Margin</th>
                                                            <th class="text-nowrap">Tax</th>
                                                            <th class="text-nowrap">Tax Amount</th>
                                                            <th class="text-nowrap">Net Amount Inc Tax</th>
                                                            <th class="text-nowrap">Ex. Rate</th>
                                                            <th class="text-nowrap">Local Amount</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @php
                                                            // Group charges by customer_id
                                                            $chargesGroupedByCustomerId = $job_charges_recievable->groupBy(
                                                                'customer_id',
                                                            );
                                                        @endphp
                                                        @if ($chargesGroupedByCustomerId->count() === 1)
                                                            {{-- @foreach ($job_master->job_charges_receivable as $index => $item) --}}
                                                            @foreach ($job_charges_recievable as $index => $item)
                                                                <tr>
                                                                    <input type="hidden"
                                                                        name="job_charge_recievable_id[]"
                                                                        value="{{ $item->id }}">
                                                                    <td>{{ $index + 1 }}</td>
                                                                    <td><select class="form-control" name="charge_id[]"
                                                                            id="charge_id">
                                                                            @foreach ($charges as $charge)
                                                                                <option
                                                                                    {{ $item->charge_id == $charge->id ? 'selected' : '' }}
                                                                                    value="{{ $charge->id }}">
                                                                                    {{ $charge->name }}</option>
                                                                            @endforeach
                                                                        </select></td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="description[]"
                                                                            value="{{ $item->description }}">
                                                                    </td>
                                                                    <td><select class="form-control" name="size_type[]"
                                                                            id="size_type">
                                                                            <option
                                                                                {{ $item->size_type == '20BK' ? 'selected' : '' }}
                                                                                value="20BK">20BK</option>
                                                                            <option
                                                                                {{ $item->size_type == '20FR' ? 'selected' : '' }}
                                                                                value="20FR">20FR</option>
                                                                            <option
                                                                                {{ $item->size_type == '20OT' ? 'selected' : '' }}
                                                                                value="20OT">20OT</option>
                                                                            <option
                                                                                {{ $item->size_type == '20RE' ? 'selected' : '' }}
                                                                                value="20RE">20RE</option>
                                                                            <option
                                                                                {{ $item->size_type == '20SD' ? 'selected' : '' }}
                                                                                value="20SD">20SD</option>
                                                                            <option
                                                                                {{ $item->size_type == '20TK' ? 'selected' : '' }}
                                                                                value="20TK">20TK</option>
                                                                            <option
                                                                                {{ $item->size_type == '40FR' ? 'selected' : '' }}
                                                                                value="40FR">40FR</option>
                                                                            <option
                                                                                {{ $item->size_type == '40BK' ? 'selected' : '' }}
                                                                                value="40BK">40BK</option>
                                                                            <option
                                                                                {{ $item->size_type == '40HC' ? 'selected' : '' }}
                                                                                value="40HC">40HC</option>
                                                                            <option
                                                                                {{ $item->size_type == '40HCRF' ? 'selected' : '' }}
                                                                                value="40HCRF">40HCRF</option>
                                                                            <option
                                                                                {{ $item->size_type == '40OT' ? 'selected' : '' }}
                                                                                value="40OT">40OT</option>
                                                                            <option
                                                                                {{ $item->size_type == '40SD' ? 'selected' : '' }}
                                                                                value="40SD">40SD</option>
                                                                            <option
                                                                                {{ $item->size_type == '40VH' ? 'selected' : '' }}
                                                                                value="40VH">40VH</option>
                                                                            <option
                                                                                {{ $item->size_type == '45BK' ? 'selected' : '' }}
                                                                                value="45BK">45BK</option>
                                                                            <option
                                                                                {{ $item->size_type == '45HC' ? 'selected' : '' }}
                                                                                value="45HC">45HC</option>
                                                                            <option
                                                                                {{ $item->size_type == '45OT' ? 'selected' : '' }}
                                                                                value="45OT">45OT</option>
                                                                            <option
                                                                                {{ $item->size_type == '45TK' ? 'selected' : '' }}
                                                                                value="45TK">45TK</option>
                                                                            <option
                                                                                {{ $item->size_type == '45VH' ? 'selected' : '' }}
                                                                                value="45VH">45VH</option>
                                                                            <option
                                                                                {{ $item->size_type == 'M3' ? 'selected' : '' }}
                                                                                value="M3">M3</option>
                                                                        </select></td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="rate_group[]"
                                                                            value="{{ $item->rate_group }}">
                                                                    </td>
                                                                    <td><select class="form-control" name="dg_non_dg[]"
                                                                            id="dg_non_dg">
                                                                            <option
                                                                                {{ $item->dg_non_dg == 'DG' ? 'selected' : '' }}
                                                                                value="DG">
                                                                                DG</option>
                                                                            <option
                                                                                {{ $item->dg_non_dg == 'Non-DG' ? 'selected' : '' }}
                                                                                value="Non-DG">
                                                                                Non-DG</option>
                                                                            <option
                                                                                {{ $item->dg_non_dg == 'All' ? 'selected' : '' }}
                                                                                value="All">
                                                                                All</option>
                                                                        </select></td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="container[]"
                                                                            value="{{ $item->container }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control w-24" type="text"
                                                                            name="qty[]" value="{{ $item->qty }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="rate[]" value="{{ $item->rate }}">
                                                                    </td>
                                                                    <td><select name="currency[]" id="currency">
                                                                            @foreach ($currencies as $currency)
                                                                                <option
                                                                                    {{ $item->currency == $currency->id ? 'selected' : '' }}
                                                                                    value="{{ $currency->id }}">
                                                                                    {{ $currency->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>

                                                                    {{-- <option
                                                                                    {{ $item->currency == 'PKR' ? 'selected' : '' }}
                                                                                    value="PKR">
                                                                                    PKR</option>
                                                                                <option
                                                                                    {{ $item->currency == 'AED' ? 'selected' : '' }}
                                                                                    value="AED">
                                                                                    AED</option>
                                                                                <option
                                                                                    {{ $item->currency == 'BDT' ? 'selected' : '' }}
                                                                                    value="BDT">
                                                                                    BDT</option>
                                                                                <option
                                                                                    {{ $item->currency == 'OMR' ? 'selected' : '' }}
                                                                                    value="OMR">
                                                                                    OMR</option>
                                                                                <option
                                                                                    {{ $item->currency == 'EUR' ? 'selected' : '' }}
                                                                                    value="EUR">
                                                                                    EUR</option>
                                                                                <option
                                                                                    {{ $item->currency == 'GBP' ? 'selected' : '' }}
                                                                                    value="GBP">
                                                                                    GBP</option> --}}
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="amount[]" value="{{ $item->amount }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="discount[]"
                                                                            value="{{ $item->discount }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="net_amount[]"
                                                                            value="{{ $item->net_amount }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="margin[]" value="{{ $item->margin }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control w-30" type="text"
                                                                            name="tax[]"
                                                                            value="{{ $item->tax_apply }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="tax_amount[]"
                                                                            value="{{ $item->tax_amount_lc }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="net_amount_inc_tax[]"
                                                                            value="{{ $item->net_amount }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="ex_rate[]"
                                                                            value="{{ $item->ex_rate }}">
                                                                    </td>
                                                                    <td>
                                                                        <input class="form-control" type="text"
                                                                            name="local_amount[]"
                                                                            value="{{ $item->local_amount }}">
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        @endif
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Remarks</label>
                                                <input id="regular-form-1" type="text" class="form-control"
                                                    placeholder="Enter Remarks" name="remarks"
                                                    value="{{ @$job_master->remarks }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Voucher #</label>
                                                <input id="regular-form-1" type="text" class="form-control"
                                                    placeholder="Enter Voucher #" name="voucher_no"
                                                    value="{{ @$voucher_no }}" readonly>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="regular-form-1" class="form-label">Bank
                                                    Details</label>
                                                <input id="regular-form-1" type="text" class="form-control"
                                                    placeholder="Enter Bank Details" name="bank_details">
                                            </div>
                                            <div class="col-md-3 mt-10">
                                                <input id="regular-form-1" type="checkbox" class="form-check-input"
                                                    name="manual_remarks" value="1">
                                                <label class="form-label" for="manual_remarks">
                                                    Manual Remarks
                                                </label>
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="grand_total_amount" class="form-label">Total
                                                    Amount</label>
                                                <input id="grand_total_amount" type="text" class="form-control"
                                                    placeholder="Enter Total Amount" name="grand_total_amount"
                                                    value="{{ $grand_total_amount }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="grand_net_amount" class="form-label">Net
                                                    Amount</label>
                                                <input id="grand_net_amount" type="text" class="form-control"
                                                    placeholder="Enter Net Amount" name="grand_net_amount"
                                                    value="{{ $grand_net_amount }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="grand_discount" class="form-label">Discount</label>
                                                <input id="grand_discount" type="text" class="form-control"
                                                    placeholder="Enter Discount" name="grand_discount"
                                                    value="{{ $grand_discount }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="grand_tax_amount" class="form-label">Tax
                                                    Amount</label>
                                                <input id="grand_tax_amount" type="text" class="form-control"
                                                    placeholder="Enter Tax Amount" name="grand_tax_amount"
                                                    value="{{ $grand_tax_amount }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="grand_net_amount_inc_tax" class="form-label">Net
                                                    Amount Inc
                                                    Tax</label>
                                                <input id="grand_net_amount_inc_tax" type="text" class="form-control"
                                                    placeholder="Enter Net Amount Inc Tax" name="grand_net_amount_inc_tax"
                                                    value="{{ $grand_net_amount_inc_tax }}">
                                            </div>
                                            <div class="col-md-3 mt-2">
                                                <label for="grand_local_amount" class="form-label">Local
                                                    Amount</label>
                                                <input id="grand_local_amount" type="text" class="form-control"
                                                    placeholder="Enter Local Amount" name="grand_local_amount"
                                                    value="{{ $grand_local_amount }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
<div class="modal fade" id="invoiceModal" tabindex="-1" aria-labelledby="invoiceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Job Invoices</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="invoiceModalBody">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Invoice #</th>
                                <th>Invoice Date</th>
                                <th>Reference #</th>
                                <th>Client Name</th>
                                <th>Amount</th>
                                <th>Balance</th>
                            </tr>
                        </thead>
                        <tbody id="invoiceTableBody">
                            <!-- Rows inserted via JS -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Selecting Charges -->
<div class="modal fade" id="chargesModal" tabindex="-1" aria-labelledby="chargesModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="chargesModalLabel">Select
                    Charges</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="form-check mb-2">
                    <input class="form-check-input" type="checkbox" id="selectAllCharges">
                    <label class="form-check-label" for="selectAllCharges"><strong>Select
                            All</strong></label>
                    <hr>
                </div>
                <div id="chargesCheckboxContainer"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="addChargesButton">Add Selected Charges</button>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {

        document.getElementById('openInvoiceModalBtn').addEventListener('click', function() {
            const clientId = document.getElementById('client_id').value;

            if (!clientId) {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Select Client First",
                    showConfirmButton: false,
                    timer: 2500
                });
                return;
            }

            fetch(`/get-invoices/${clientId}`)
                .then(response => response.json())
                .then(data => {
                    const tableBody = document.getElementById('invoiceTableBody');
                    tableBody.innerHTML = ''; // Clear previous rows

                    if (data.invoices && data.invoices.length > 0) {
                        data.invoices.forEach(invoice => {
                            const row = document.createElement('tr');
                            row.innerHTML = `
                        <td><a href="#" class="invoice-link" data-invoiceno="${invoice.invoice_no}">${invoice.invoice_no}</a></td>
                        <td>${invoice.invoice_date}</td>
                        <td>${invoice.reference_no}</td>
                        <td>${invoice.client_name}</td>
                        <td>${invoice.amount}</td>
                        <td>${invoice.balance}</td>
                    `;
                            tableBody.appendChild(row);
                        });

                        document.querySelectorAll('.invoice-link').forEach(link => {
                            link.addEventListener('click', function(e) {
                                e.preventDefault();
                                const invoiceNo = this.getAttribute(
                                    'data-invoiceno');
                                document.querySelector('input[name="ref_tran_no"]')
                                    .value = invoiceNo;

                                // Close the modal
                                const modalEl = document.getElementById(
                                    'invoiceModal');
                                const modalInstance = bootstrap.Modal.getInstance(
                                    modalEl);
                                modalInstance.hide();
                            });
                        });
                    } else {
                        tableBody.innerHTML =
                            `<tr><td colspan="6" class="text-center">No invoices found for this client.</td></tr>`;
                    }

                    const invoiceModal = new bootstrap.Modal(document.getElementById(
                        'invoiceModal'));
                    invoiceModal.show();
                })
                .catch(error => {
                    console.error('Error fetching invoices:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed to fetch invoices',
                        text: 'Please try again later.',
                    });
                });
        });

        document.getElementById('client_id').addEventListener('change', function() {
            const customerId = this.value;
            const charges_ids = document.getElementById('charges_ids').value;
            const jobId = <?php echo json_encode($job_master->id); ?>;
            const url = `/getRecCharges/${jobId}/${customerId}?charges_ids=${encodeURIComponent(charges_ids)}`;


            if (customerId) {
                // fetch(`/getRecCharges/${jobId}/${customerId}`)
                fetch(url)
                    .then(response => response.json())
                    .then(data => {
                        const chargesContainer = document.getElementById(
                            'chargesCheckboxContainer');
                        chargesContainer.innerHTML = ''; // Clear previous charges
                        const selectAllCheckbox = document.getElementById('selectAllCharges');
                        selectAllCheckbox.checked = false;

                        data.job_receivables.forEach(job_receivable => {
                            const checkbox = document.createElement('div');
                            checkbox.classList.add('form-check');
                            checkbox.innerHTML = `
                        <input class="form-check-input charge-checkbox" type="checkbox" value="${job_receivable.charge.id}" id="charge_${job_receivable.charge.id}">
                        <label class="form-check-label" for="charge_${job_receivable.charge.id}">${job_receivable.charge.name}</label>
                    `;
                            chargesContainer.appendChild(checkbox);
                        });

                        document.getElementById('selectAllCharges').addEventListener('change',
                            function() {
                                const allCheckboxes = chargesContainer.querySelectorAll(
                                    '.charge-checkbox');
                                allCheckboxes.forEach(cb => cb.checked = this.checked);
                            });

                        // Show the modal
                        const chargesModal = new bootstrap.Modal(document.getElementById(
                            'chargesModal'));
                        chargesModal.show();
                    });
            }
        });

        // Handle adding selected charges to the table
        document.getElementById('addChargesButton').addEventListener('click', function() {
            // const customerId = this.value;
            const tableBody = document.querySelector('#receiveableTable tbody');
            tableBody.innerHTML = '';
            var customerId = document.getElementById('client_id').value;
            const selectedCharges = [];
            const checkboxes = document.querySelectorAll(
                '#chargesCheckboxContainer input[type="checkbox"]:checked');

            checkboxes.forEach(checkbox => {
                selectedCharges.push(checkbox.value);
            });

            if (selectedCharges.length > 0) {
                // Make an AJAX call or process selected charges here
                // Add selected charges to your table

                // Example: Loop through selected charges and create rows in the table
                selectedCharges.forEach(chargeId => {
                    // Assuming you have a function to add a row to the table
                    addChargeToTable(customerId,
                        chargeId); // You will need to implement this function
                });
            }
            calculateTotals();

            // Close the modal after processing the selected charges
            const chargesModal = bootstrap.Modal.getInstance(document.getElementById('chargesModal'));
            if (chargesModal) {
                chargesModal.hide(); // Hide the modal
            }
        });

        function addChargeToTable(customerId, chargeId) {
            const jobId = <?php echo json_encode($job_master->id); ?>;

            fetch(`/getRecChargeDetail/${jobId}/${customerId}/${chargeId}`) // Define this route
                .then(response => response.json())
                .then(data => {
                    const job_receivables = data.job_receivables; // Access the array of job_receivables
                    const tableBody = document.querySelector('#receiveableTable tbody');

                    job_receivables.forEach(job_receivable => {
                        const newRow = `
                    <tr>
                        <td><input type="hidden" name="job_charge_recievable_id[]" value="${job_receivable.id}"></td> <!-- S.No will be handled on the server side or by JS -->
                        <td>
                            <select class="form-control" name="charge_id[]">
                                <option value="${job_receivable.charge?.id || ''}">${job_receivable.charge?.name || 'N/A'}</option>
                            </select>
                        </td>
                        <td><input type="text" class="form-control" name="description[]" value="${job_receivable.description || ''}"></td>
                        <td>
                            <select class="form-control" name="size_type[]">
                                <option value="${job_receivable.size_type || ''}">${job_receivable.size_type || 'N/A'}</option>
                            </select>
                        </td>
                        <td><input type="text" class="form-control" name="rate_group[]" value="${job_receivable.rate_group || ''}"></td>
                        <td>
                            <select class="form-control" name="dg_non_dg[]">
                                <option value="${job_receivable.dg_non_dg || ''}">${job_receivable.dg_non_dg || 'N/A'}</option>
                            </select>
                        </td>
                        <td><input type="text" class="form-control" name="container[]"></td>
                        <td><input type="text" class="form-control w-24" name="qty[]" value="${job_receivable.qty || 1}"></td>
                        <td><input type="text" class="form-control" name="rate[]" value="${job_receivable.rate || 0}"></td>
                        <td>
                            <select class="form-control" name="currency[]">
                                <option value="${job_receivable.currency_name?.id || ''}">${job_receivable.currency_name?.name || 'N/A'}</option>
                            </select>
                        </td>
                        <td><input type="text" class="form-control" name="amount[]" value="${job_receivable.amount || 0}"></td>
                        <td><input type="text" class="form-control" name="discount[]" value="${job_receivable.discount || 0}"></td>
                        <td><input type="text" class="form-control" name="net_amount[]" value="${job_receivable.net_amount || 0}"></td>
                        <td><input type="text" class="form-control" name="margin[]" value="${job_receivable.margin || ''}"></td>
                        <td><input type="text" class="form-control w-30" name="tax[]" value="${job_receivable.tax_amount_lc || 0}"></td>
                        <td><input type="text" class="form-control" name="tax_amount[]" value="${job_receivable.tax_amount_lc || 0}"></td>
                        <td><input type="text" class="form-control" name="net_amount_inc_tax[]" value="${job_receivable.net_amount || 0}"></td>
                        <td><input type="text" class="form-control" name="ex_rate[]" value="${job_receivable.ex_rate || 0}"></td>
                        <td><input type="text" class="form-control" name="local_amount[]" value="${job_receivable.local_amount || 0}"></td>
                    </tr>
                `;
                        tableBody.insertAdjacentHTML('beforeend', newRow);
                    });
                    calculateTotals();
                })
                .catch(error => {
                    console.error('Error fetching job receivables:', error);
                });
        }


        const dropdownOptions = {
            customers: [""],
            vendors: [""],
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: ["PKR", "USD", "AED", "GBP", "EUR", "BDT", "OMR"],
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        function createCurrencyDropdown(name, currencies) {
            let dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please Select</option>';
            currencies.forEach((currency, index) => {
                dropdown += '<option value="' + (index + 1) + '">' + currency + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' +
                '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('charge_id[]', dropdownOptions
                    .charges) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('size_type[]', dropdownOptions
                    .sizeType) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate_group[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'container[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createCurrencyDropdown('currency[]', dropdownOptions
                    .currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'discount[]', '') + '</td>' +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'margin[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount_inc_tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'ex_rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'local_amount[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);

        // Function to calculate and update the grand totals
        function calculateTotals() {
            let totalAmount = 0;
            let netAmount = 0;
            let discount = 0;
            let taxAmount = 0;
            let netAmountIncTax = 0;
            let localAmount = 0;

            $('#receiveableTable tbody tr').each(function() {
                let row = $(this);
                let qty = parseFloat(row.find('input[name^="qty"]').val()) || 1;
                let rate = parseFloat(row.find('input[name^="rate"]').val()) || 0;
                let amount = parseFloat(row.find('input[name^="amount"]').val()) || 0;
                let discountValue = parseFloat(row.find('input[name^="discount"]').val()) || 0;
                let netAmountValue = parseFloat(row.find('input[name^="net_amount"]').val()) || 0;
                let taxValue = parseFloat(row.find('input[name^="tax"]').val()) || 0;
                let taxAmountValue = parseFloat(row.find('input[name^="tax_amount"]').val()) || 0;
                let netAmountIncTaxValue = parseFloat(row.find('input[name^="net_amount_inc_tax"]')
                    .val()) || 0;
                let localAmountValue = parseFloat(row.find('input[name^="local_amount"]').val()) || 0;

                totalAmount += amount;
                netAmount += netAmountValue;
                discount += discountValue;
                taxAmount += taxAmountValue;
                netAmountIncTax += netAmountIncTaxValue;
                localAmount += localAmountValue;
            });

            // Update the grand total fields
            $('#grand_total_amount').val(totalAmount.toFixed(2));
            $('#grand_net_amount').val(netAmount.toFixed(2));
            $('#grand_discount').val(discount.toFixed(2));
            $('#grand_tax_amount').val(taxAmount.toFixed(2));
            $('#grand_net_amount_inc_tax').val(netAmountIncTax.toFixed(2));
            $('#grand_local_amount').val(localAmount.toFixed(2));
        }

        // Attach event listeners to input fields for calculating totals
        $('input[name^="qty"], input[name^="rate"], input[name^="amount"], input[name^="discount"], input[name^="net_amount"], input[name^="tax"], input[name^="tax_amount"], input[name^="net_amount_inc_tax"], input[name^="local_amount"]')
            .on('input', calculateTotals);

        // Call the function once to initialize the total amounts on page load
        calculateTotals();

    });
</script>
