@extends('layout.master')

@section('title')
    @if ($invoice->operation_id == 1)
        Edit-SE Invoice-YARAN
    @elseif($invoice->operation_id == 2)
        Edit-SI Invoice-YARAN
    @elseif($invoice->operation_id == 3)
        Edit-AE Invoice-YARAN
    @elseif($invoice->operation_id == 4)
        Edit-AI Invoice-YARAN
    @endif
    {{-- Edit-SE Invoice-YARAN --}}
@endsection

@section('topbar')
    {{-- <a href="/se_invoice" class="breadcrumb-item">SE Invoice</a> --}}
    @if ($invoice->operation_id == 1)
        <a href="/se_invoice" class="breadcrumb-item">SE Invoice</a>
    @elseif($invoice->operation_id == 2)
        <a href="/si_invoice" class="breadcrumb-item">SI Invoice</a>
    @elseif($invoice->operation_id == 3)
        <a href="/ae_invoice" class="breadcrumb-item">AE Invoice</a>
    @elseif($invoice->operation_id == 4)
        <a href="/ai_invoice" class="breadcrumb-item">AI Invoice</a>
    @endif
    <i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        @if ($invoice->operation_id == 1)
                            Edit SE Invoice
                        @elseif($invoice->operation_id == 2)
                            Edit SI Invoice
                        @elseif($invoice->operation_id == 3)
                            Edit AE Invoice
                        @elseif($invoice->operation_id == 4)
                            Edit AI Invoice
                        @endif
                    </h2>
                    @if ($invoice->job_master_id)
                        @if ($invoice->operation_id == 1)
                            <a title="SE JOB" class="tooltip btn btn-primary me-2 p-2"
                                href="{{ url('/se_job/edit/' . $invoice->job_master_id) }}"><i data-feather="file-text"
                                    class="w-4 h-4 me-1"></i>
                                JOB </a>
                        @elseif ($invoice->operation_id == 2)
                            <a title="SI JOB" class="tooltip btn btn-primary me-2 p-2"
                                href="{{ url('/si_job/edit/' . $invoice->job_master_id) }}"><i data-feather="file-text"
                                    class="w-4 h-4 me-1"></i>
                                JOB </a>
                        @elseif ($invoice->operation_id == 3)
                            <a title="AE JOB" class="tooltip btn btn-primary me-2 p-2"
                                href="{{ url('/ae_job/edit/' . $invoice->job_master_id) }}"><i data-feather="file-text"
                                    class="w-4 h-4 me-1"></i>
                                JOB </a>
                        @elseif ($invoice->operation_id == 4)
                            <a title="AI JOB" class="tooltip btn btn-primary me-2 p-2"
                                href="{{ url('/ai_job/edit/' . $invoice->job_master_id) }}"><i data-feather="file-text"
                                    class="w-4 h-4 me-1"></i>
                                JOB </a>
                        @endif
                    @endif
                    {{-- <a target="_blank" href={{ url('se_invoice_print/' . $invoice->id) }}
                            class="btn btn-success me-2 p-2"><i data-feather="file-text" class="w-4 h-4 me-1"></i>Print</a> --}}
                    @php
    // Get the latest receipt payment (if any)
    $latestReceipt = $invoice->receipt_payment_details->sortByDesc('created_at')->first();
    // Check if invoice_no doesn't start with 'JB'
    $isNotJB = !$latestReceipt || !Str::startsWith($latestReceipt->invoice_no ?? '', 'JB') || $latestReceipt->job_no == $invoice->job_master_id;
@endphp

@if ($isNotJB)
    @if ($invoice->operation_id == 1)
        <a class="btn btn-primary me-2 p-2"
            href="{{ $invoice->receipt_payment_details->isNotEmpty()
                ? url('/receipt/edit/' . $latestReceipt->receipt_payment_id)
                : url('/se_receipt/add?transaction_id=' . $invoice->id) }}">
            <i data-feather="file-text" class="w-4 h-4 me-1"></i>
            Job Payment
        </a>
    @elseif ($invoice->operation_id == 2)
        <a class="btn btn-primary me-2 p-2"
            href="{{ $invoice->receipt_payment_details->isNotEmpty()
                ? url('/receipt/edit/' . $latestReceipt->receipt_payment_id)
                : url('/si_receipt/add?transaction_id=' . $invoice->id) }}">
            <i data-feather="file-text" class="w-4 h-4 me-1"></i>
            Job Payment
        </a>
    @elseif ($invoice->operation_id == 3)
        <a class="btn btn-primary me-2 p-2"
            href="{{ $invoice->receipt_payment_details->isNotEmpty()
                ? url('/receipt/edit/' . $latestReceipt->receipt_payment_id)
                : url('/ae_receipt/add?transaction_id=' . $invoice->id) }}">
            <i data-feather="file-text" class="w-4 h-4 me-1"></i>
            Job Payment
        </a>
    @elseif ($invoice->operation_id == 4)
        <a class="btn btn-primary me-2 p-2"
            href="{{ $invoice->receipt_payment_details->isNotEmpty()
                ? url('/receipt/edit/' . $latestReceipt->receipt_payment_id)
                : url('/ai_receipt/add?transaction_id=' . $invoice->id) }}">
            <i data-feather="file-text" class="w-4 h-4 me-1"></i>
            Job Payment
        </a>
    @endif
@endif

                    <button id="showPrintBtn{{ $invoice->id }}" class="btn btn-success me-2 p-2 showPrintBtn"
                        data-bs-toggle="modal" data-bs-target="#printModal" data-item-id="{{ $invoice->id }}"><i
                            data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                </div>
                <form method="POST" id="myForm" action="{{ url('se_invoice/edit/' . $invoice->id) }}"
                    enctype="multipart/form-data" class="row g-3">
                    @csrf
                    <div class="g-col-12 text-end py-0 px-5">
                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>
                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Tran #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Tran #" value="{{ $invoice->tran_no }}" name="tran_no" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Inv Date</label>
                                    <input id="regular-form-1" type="date" class="form-control"
                                        value="{{ $invoice->inv_date }}" name="inv_date" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Reference</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Reference" value="{{ $invoice->reference }}" name="reference">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Status</label>
                                    <select data-placeholder="Select Status" id="status" name="bl_status"
                                        class="form-select w-full mt-2">
                                        <option {{ $invoice->bl_status == 1 ? 'selected' : '' }} value="1">Active
                                        </option>
                                        <option {{ $invoice->bl_status == 2 ? 'selected' : '' }} value="2">Inactive
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Category</label>
                                    <select id="regular-form-1" name="category" class="tom-select w-full mt-2">
                                        <option {{ $invoice->category == 'Regular' ? 'selected' : '' }} value="Regular">
                                            Regular</option>
                                        <option {{ $invoice->category == 'Security Deposit' ? 'selected' : '' }}
                                            value="Security Deposit">Security Deposit</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-12">
                                    <input class="form-check-input" type="radio" name="settlement" id="settled"
                                        value="settled" {{ $invoice->settlement == 'settled' ? 'checked' : '' }}>
                                    <label class="form-label" for="settled">
                                        Settled
                                    </label>
                                    <input class="form-check-input" type="radio" name="settlement" id="un_settled"
                                        value="un_settled" {{ $invoice->settlement == 'un_selected' ? 'checked' : '' }}>
                                    <label class="form-label" for="un_settled">
                                        Un-Settled
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Client</label>
                                    <select class="tom-select" name="client_id" id="client_id" disabled>
                                        <option value="">Please Select</option>
                                        @foreach ($clients as $item)
                                            <option {{ $invoice->client_id == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Ref. Tran #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Ref. Tran #" value="{{ $invoice->ref_tran_no }}"
                                        name="ref_tran_no" readonly>
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Sequence #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Sequence #" value="{{ $invoice->sequence_no }}"
                                        name="sequence_no">
                                </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label>Invoice Type</label>
                                    <select id="regular-form-1" name="invoice_type" class="tom-select w-full mt-2">
                                        <option {{ $invoice->invoice_type == 'SI' ? 'selected' : '' }} value="SI">SI
                                        </option>
                                        <option {{ $invoice->invoice_type == 'CN' ? 'selected' : '' }} value="CN">CN
                                        </option>
                                        <option {{ $invoice->invoice_type == 'Zero' ? 'selected' : '' }} value="Zero">
                                            Zero</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Operation</label>
                                    <select id="regular-form-1" name="operation_id" class="tom-select w-full mt-2"
                                        disabled>
                                        @foreach ($operations as $item)
                                            <option {{ $invoice->operation_id == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Job #</label>
                                    <input type="hidden" value="{{ $invoice->job_master_id }}" name="job_no">
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Job #" readonly value="{{ $invoice->job_master?->job_no }}"
                                        name="sej_job_no">
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                    <label>Currency</label>
                                    <select id="regular-form-1" name="currency"
                                        class="tom-select w-full mt-2">
                                        <option value="PKR">PKR</option>
                                        <option value="USD">USD</option>
                                        <option value="AED">AED</option>
                                        <option value="GPB">GPB</option>
                                        <option value="EUR">EUR</option>
                                        <option value="BDT">BDT</option>
                                        <option value="OMR">OMR</option>
                                    </select>
                                </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label>Cost Center</label>
                                    <select data-placeholder="Select Cost Center" id="regular-form-1" name="cost_center"
                                        class="tom-select w-full mt-2">
                                        <option {{ $invoice->cost_center == 'Head Office' ? 'selected' : '' }}
                                            value="Head Office">Head Office</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Invoice To</label>
                                    <select id="regular-form-1" name="invoice_to" class="tom-select w-full mt-2">
                                        <option {{ $invoice->invoice_to == 'clearing_agent' ? 'selected' : '' }}
                                            value="clearing_agent">Clearing Agent</option>
                                        <option {{ $invoice->invoice_to == 'importer' ? 'selected' : '' }}
                                            value="importer">Importer</option>
                                        <option {{ $invoice->invoice_to == 'coloador' ? 'selected' : '' }}
                                            value="coloador">Coloador</option>
                                        <option {{ $invoice->invoice_to == 'client' ? 'selected' : '' }} value="client">
                                            Client</option>
                                        <option {{ $invoice->invoice_to == 'client_importer' ? 'selected' : '' }}
                                            value="client_importer">Client/Importer</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input" name="manual"
                                        {{ $invoice->manual == '1' ? 'checked' : '' }} value="1">
                                    <label class="form-label" for="manual">
                                        Manual
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Due Days</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Due Days" value="{{ $invoice->due_days }}" name="due_days">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Invoice A/C</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Invoice A/C" value="{{ $invoice->invoice_ac }}"
                                        name="invoice_ac">
                                </div>
                                <div class="col-md-3 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input"
                                        {{ $invoice->auto_round_off == '1' ? 'checked' : '' }} name="auto_round_off"
                                        value="1">
                                    <label class="form-label" for="auto_round_off">
                                        Auto Round Off
                                    </label>
                                </div>
                                <div class="col-md-3 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input"
                                        {{ $invoice->tax_charges == '1' ? 'checked' : '' }} name="tax_charges"
                                        value="1">
                                    <label class="form-label" for="tax_charges">
                                        Tax Charges
                                    </label>
                                </div>
                            </div>
                            {{-- <div class="text-end mt-3 me-5">
                                <button id="addRowReceivableButton" type="button" class="btn btn-primary">Add
                                    Row</button>
                            </div> --}}
                            <div class="row">
                                <div class="intro-y g-col-12 overflow-auto">
                                    <table id="receiveableTable" class="table table-bordered mt-n2">
                                        <thead>
                                            <tr>
                                                <th class="text-nowrap">S.No</th>
                                                <th class="text-nowrap">Charge Name</th>
                                                <th class="text-nowrap">Charge Descripton</th>
                                                <th class="text-nowrap">Size/Type</th>
                                                <th class="text-nowrap">Rate Group</th>
                                                <th class="text-nowrap">DG/Non-DG</th>
                                                <th class="text-nowrap">Container</th>
                                                <th class="text-nowrap">Qty</th>
                                                <th class="text-nowrap">Rate</th>
                                                <th class="text-nowrap">Currency</th>
                                                <th class="text-nowrap">Amount</th>
                                                <th class="text-nowrap">Discount</th>
                                                <th class="text-nowrap">Net Amount</th>
                                                <th class="text-nowrap">Margin</th>
                                                <th class="text-nowrap">Tax</th>
                                                <th class="text-nowrap">Tax Amount</th>
                                                <th class="text-nowrap">Net Amount Inc Tax</th>
                                                <th class="text-nowrap">Ex. Rate</th>
                                                <th class="text-nowrap">Local Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($invoice->transaction_charges as $index => $item)
                                                <tr>
                                                    <input type="hidden" name="job_charge_recievable_id[]"
                                                        value="{{ $item->job_charge_recievable_id }}" readonly>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td><select class="form-control" name="charge_id[]" id="charge_id"
                                                            disabled>
                                                            @foreach ($charges as $charge)
                                                                <option
                                                                    {{ $item->charge_id == $charge->id ? 'selected' : '' }}
                                                                    value="{{ $charge->id }}">
                                                                    {{ $charge->name }}</option>
                                                            @endforeach
                                                        </select></td>
                                                    <td>
                                                        <input class="form-control" type="text" name="description[]"
                                                            value="{{ $item->description }}" readonly>
                                                    </td>
                                                    <td><select class="form-control" name="size_type[]" id="size_type"
                                                            disabled>
                                                            <option {{ $item->size_type == '20BK' ? 'selected' : '' }}
                                                                value="20BK">20BK</option>
                                                            <option {{ $item->size_type == '20FR' ? 'selected' : '' }}
                                                                value="20FR">20FR</option>
                                                            <option {{ $item->size_type == '20OT' ? 'selected' : '' }}
                                                                value="20OT">20OT</option>
                                                            <option {{ $item->size_type == '20RE' ? 'selected' : '' }}
                                                                value="20RE">20RE</option>
                                                            <option {{ $item->size_type == '20SD' ? 'selected' : '' }}
                                                                value="20SD">20SD</option>
                                                            <option {{ $item->size_type == '20TK' ? 'selected' : '' }}
                                                                value="20TK">20TK</option>
                                                            <option {{ $item->size_type == '40FR' ? 'selected' : '' }}
                                                                value="40FR">40FR</option>
                                                            <option {{ $item->size_type == '40BK' ? 'selected' : '' }}
                                                                value="40BK">40BK</option>
                                                            <option {{ $item->size_type == '40HC' ? 'selected' : '' }}
                                                                value="40HC">40HC</option>
                                                            <option {{ $item->size_type == '40HCRF' ? 'selected' : '' }}
                                                                value="40HCRF">40HCRF</option>
                                                            <option {{ $item->size_type == '40OT' ? 'selected' : '' }}
                                                                value="40OT">40OT</option>
                                                            <option {{ $item->size_type == '40SD' ? 'selected' : '' }}
                                                                value="40SD">40SD</option>
                                                            <option {{ $item->size_type == '40VH' ? 'selected' : '' }}
                                                                value="40VH">40VH</option>
                                                            <option {{ $item->size_type == '45BK' ? 'selected' : '' }}
                                                                value="45BK">45BK</option>
                                                            <option {{ $item->size_type == '45HC' ? 'selected' : '' }}
                                                                value="45HC">45HC</option>
                                                            <option {{ $item->size_type == '45OT' ? 'selected' : '' }}
                                                                value="45OT">45OT</option>
                                                            <option {{ $item->size_type == '45TK' ? 'selected' : '' }}
                                                                value="45TK">45TK</option>
                                                            <option {{ $item->size_type == '45VH' ? 'selected' : '' }}
                                                                value="45VH">45VH</option>
                                                            <option {{ $item->size_type == 'M3' ? 'selected' : '' }}
                                                                value="M3">M3</option>
                                                        </select></td>
                                                    <td>
                                                        <input class="form-control" type="text" name="rate_group[]"
                                                            value="{{ $item->rate_group }}" readonly>
                                                    </td>
                                                    <td><select class="form-control" name="dg_non_dg[]" id="dg_non_dg"
                                                            disabled>
                                                            <option {{ $item->dg_non_dg == 'DG' ? 'selected' : '' }}
                                                                value="DG">
                                                                DG</option>
                                                            <option {{ $item->dg_non_dg == 'Non-DG' ? 'selected' : '' }}
                                                                value="Non-DG">
                                                                Non-DG</option>
                                                            <option {{ $item->dg_non_dg == 'All' ? 'selected' : '' }}
                                                                value="All">
                                                                All</option>
                                                        </select></td>
                                                    <td>
                                                        <input class="form-control" type="text" name="container[]"
                                                            value="{{ $item->container }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control w-24" type="text" name="qty[]"
                                                            value="{{ $item->qty }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control w-24" type="text" name="rate[]"
                                                            value="{{ $item->rate }}" readonly>
                                                    </td>
                                                    <td><select name="currency[]" id="currency" disabled>
                                                            @foreach ($currencies as $currency)
                                                                <option
                                                                    {{ $item->currency == $currency->id ? 'selected' : '' }}
                                                                    value="{{ $currency->id }}">
                                                                    {{ $currency->name }}</option>
                                                            @endforeach
                                                        </select></td>
                                                    <td>
                                                        <input class="form-control" type="text" name="amount[]"
                                                            value="{{ $item->amount }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="discount[]"
                                                            value="{{ $item->discount }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="net_amount[]"
                                                            value="{{ $item->net_amount }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control w-24" type="text" name="margin[]"
                                                            value="{{ $item->margin }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control w-24" type="text" name="tax[]"
                                                            value="{{ $item->tax }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="tax_amount[]"
                                                            value="{{ $item->tax_amount }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text"
                                                            name="net_amount_inc_tax[]"
                                                            value="{{ $item->net_amount_inc_tax }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="ex_rate[]"
                                                            value="{{ $item->ex_rate }}" readonly>
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="local_amount[]"
                                                            value="{{ $item->local_amount }}" readonly>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Remarks</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Remarks" value="{{ $invoice->remarks }}" name="remarks"
                                        readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Voucher #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Voucher #" value="{{ @$transaction_master->voucher_no }}"
                                        name="voucher_no" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Bank
                                        Details</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Bank Details" value="{{ $invoice->bank_details }}"
                                        name="bank_details" readonly>
                                </div>
                                <div class="col-md-3 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input"
                                        {{ $invoice->manual_remarks == '1' ? 'checked' : '' }} name="manual_remarks"
                                        value="1" disabled>
                                    <label class="form-label" for="manual_remarks">
                                        Manual Remarks
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Total
                                        Amount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Total Amount" value="{{ $invoice->grand_total_amount }}"
                                        name="grand_total_amount" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Net Amount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Net Amount" value="{{ $invoice->grand_net_amount }}"
                                        name="grand_net_amount" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Discount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Discount" value="{{ $invoice->grand_discount }}"
                                        name="grand_discount" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Tax Amount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Tax Amount" value="{{ $invoice->grand_tax_amount }}"
                                        name="grand_tax_amount" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Net Amount Inc
                                        Tax</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Net Amount Inc Tax"
                                        value="{{ $invoice->grand_net_amount_inc_tax }}" name="grand_net_amount_inc_tax"
                                        readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Local
                                        Amount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Local Amount" value="{{ $invoice->grand_local_amount }}"
                                        name="grand_local_amount" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @include('sea_export.se_invoice.modals.print')

@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.showPrintBtn').forEach(button => {
            button.addEventListener('click', function() {
                const invoiceID = this.getAttribute('data-item-id');

                document.getElementById('selectedInvoiceID').value = invoiceID;
            });
        });
    });

    $(document).ready(function() {
        $('input[name="show_hide_panel"]').change(function() {
            if ($(this).is(':checked')) {
                $('#show_panel').removeClass('d-none');
            } else {
                $('#show_panel').addClass('d-none');
            }
        });
        $('input[name="print_invoice_note"]').change(function() {
            if ($(this).is(':checked')) {
                $('#invoice_note_div').removeClass('d-none');
            } else {
                $('#invoice_note_div').addClass('d-none');
            }
        });
    });

    function updatePrintLink() {
        const invoiceId = document.getElementById('selectedInvoiceID').value;
        const hide_shipper_consignee = document.getElementById('hide_shipper_consignee').checked;
        const hide_consignee = document.getElementById('hide_consignee').checked;
        const hide_port_of_loading = document.getElementById('hide_port_of_loading').checked;
        const hide_port_of_discharge = document.getElementById('hide_port_of_discharge').checked;
        const hide_exchange_rate = document.getElementById('hide_exchange_rate').checked;
        const hide_hbl = document.getElementById('hide_hbl').checked;
        const hide_mbl = document.getElementById('hide_mbl').checked;
        const print_logo = document.getElementById('print_logo').checked;
        const print_on_letterhead = document.getElementById('print_on_letterhead').checked;
        // const print_balance = document.getElementById('print_balance').checked;
        const show_container = document.getElementById('show_container').checked;
        const show_bank = document.getElementById('show_bank').checked;
        const hide_volume = document.getElementById('hide_volume').checked;
        const show_remarks = document.getElementById('show_remarks').checked;
        const hide_sales_rep_and_ref_no = document.getElementById('hide_sales_rep_and_ref_no').checked;
        const msg_of_system_generated_invoice = document.getElementById('msg_of_system_generated_invoice').checked;
        const print_invoice_note = document.getElementById('print_invoice_note').checked;
        const print_invoice_with_other_invoice = document.getElementById('print_invoice_with_other_invoice').checked;
        const hide_sa_line = document.getElementById('hide_sa_line').checked;
        const invoice_note = document.getElementById('invoice_note').value;
        const print_option = document.querySelector('input[name="print_option"]:checked') ? document.querySelector('input[name="print_option"]:checked').value : '';

        // Set the href attribute with the updated URL
        printLink.href =
            `{{ url('se_invoice_print') }}/${encodeURIComponent(invoiceId)}?hide_shipper_consignee=${encodeURIComponent(hide_shipper_consignee)}&hide_sa_line=${encodeURIComponent(hide_sa_line)}&hide_consignee=${encodeURIComponent(hide_consignee)}&hide_port_of_loading=${encodeURIComponent(hide_port_of_loading)}&hide_port_of_discharge=${encodeURIComponent(hide_port_of_discharge)}&hide_exchange_rate=${encodeURIComponent(hide_exchange_rate)}&hide_hbl=${encodeURIComponent(hide_hbl)}&hide_mbl=${encodeURIComponent(hide_mbl)}&print_logo=${encodeURIComponent(print_logo)}&print_on_letterhead=${encodeURIComponent(print_on_letterhead)}&show_container=${encodeURIComponent(show_container)}&show_bank=${encodeURIComponent(show_bank)}&hide_volume=${encodeURIComponent(hide_volume)}&show_remarks=${encodeURIComponent(show_remarks)}&hide_sales_rep_and_ref_no=${encodeURIComponent(hide_sales_rep_and_ref_no)}&msg_of_system_generated_invoice=${encodeURIComponent(msg_of_system_generated_invoice)}&print_invoice_note=${encodeURIComponent(print_invoice_note)}&print_invoice_with_other_invoice=${encodeURIComponent(print_invoice_with_other_invoice)}&invoice_note=${encodeURIComponent(invoice_note)}&print_option=${encodeURIComponent(print_option)}`;
    }
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Whether this invoice has any related receipt payment details
        var hasReceiptPaymentDetail = @json($invoice->receipt_payment_details()->exists());

        // Get the latest receipt payment detail (if exists)
        var latestReceipt = @json($invoice->receipt_payment_details->sortByDesc('created_at')->first());
        console.log(latestReceipt);

        // Check if the invoice_no starts with 'JB'
        var isJB = latestReceipt && latestReceipt.invoice_no && latestReceipt.invoice_no.startsWith('JB') && latestReceipt.job_no != @json($invoice->job_master_id);

        document.getElementById('status').addEventListener('change', function() {
            var selectedValue = this.value;
            console.log('Selected Status Value:', selectedValue);
            console.log('hasReceiptPaymentDetail:', hasReceiptPaymentDetail);
            console.log('isJB:', isJB);
            console.log('latestReceipt->job_no:', latestReceipt.job_no);
            console.log('$invoice->job_no:', @json($invoice->job_master_id));

            // Block status change if receipt payment exists AND invoice_no starts with 'JB'
            if (selectedValue == 2 && hasReceiptPaymentDetail && !isJB) {
                this.value = 1;
                console.log('Receipt Payment Detail exists. Cannot change status to Inactive.');
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Receipt Payment Detail exists!",
                    showConfirmButton: false,
                    timer: 2500
                });
            }
        });
    });
</script>

<script>
    $(document).ready(function() {
        const dropdownOptions = {
            customers: [""],
            vendors: [""],
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: ["PKR", "USD", "AED", "GBP", "EUR", "BDT", "OMR"],
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        function createCurrencyDropdown(name, currencies) {
            let dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please Select</option>';
            currencies.forEach((currency, index) => {
                dropdown += '<option value="' + (index + 1) + '">' + currency + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('charge_id[]', dropdownOptions
                    .charges) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('size_type[]', dropdownOptions
                    .sizeType) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate_group[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'container[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createCurrencyDropdown('currency[]', dropdownOptions.currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'discount[]', '') + '</td>' +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'margin[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount_inc_tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'ex_rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'local_amount[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>
