@extends('layout.master')

@section('title')
    @if (Request::is('se_invoice/edit/' . $job_master->id))
        Add-SE Invoice-YARAN
    @elseif(Request::is('si_invoice/edit/' . $job_master->id))
        Add-SI Invoice-YARAN
    @elseif(Request::is('ae_invoice/edit/' . $job_master->id))
        Add-AE Invoice-YARAN
    @elseif(Request::is('ai_invoice/edit/' . $job_master->id))
        Add-AI Invoice-YARAN
    @endif
    {{-- Edit-SE Invoice-YARAN --}}
@endsection

@section('topbar')
    {{-- <a href="/se_invoice" class="breadcrumb-item">SE Invoice</a> --}}
    @if (Request::is('se_invoice/edit/' . $job_master->id))
        <a href="/se_invoice" class="breadcrumb-item">SE Invoice</a>
    @elseif(Request::is('si_invoice/edit/' . $job_master->id))
        <a href="/si_invoice" class="breadcrumb-item">SI Invoice</a>
    @elseif(Request::is('ae_invoice/edit/' . $job_master->id))
        <a href="/ae_invoice" class="breadcrumb-item">AE Invoice</a>
    @elseif(Request::is('ai_invoice/edit/' . $job_master->id))
        <a href="/ai_invoice" class="breadcrumb-item">AI Invoice</a>
    @endif
    <i data-feather="chevron-right" class="breadcrumb__icon"></i><a
        href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('se_invoice/edit/' . $job_master->id) }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            @if (Request::is('se_invoice/edit/' . $job_master->id))
                                Edit SE Invoice
                            @elseif(Request::is('si_invoice/edit/' . $job_master->id))
                                Edit SI Invoice
                            @elseif(Request::is('ae_invoice/edit/' . $job_master->id))
                                Edit AE Invoice
                            @elseif(Request::is('ai_invoice/edit/' . $job_master->id))
                                Edit AI Invoice
                            @endif
                        </h2>
                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="invoice_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#invoice" type="button"
                                                            role="tab" aria-controls="invoice_tab"
                                                            aria-selected="true">Invoice</button>
                                                    </li>
                                                    <li id="charges_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#charges" type="button" role="tab"
                                                            aria-controls="charges_tab"
                                                            aria-selected="false">Charges</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="invoice" role="tabpanel"
                                                aria-labelledby="invoice_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Tran #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Tran #" value="{{ $invoice->tran_no }}"
                                                            name="tran_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Inv Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            value="{{ $invoice->inv_date }}" name="inv_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Reference</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Reference" value="{{ $invoice->reference }}"
                                                            name="reference">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Status</label>
                                                        <select data-placeholder="Select Status" id="regular-form-1"
                                                            name="bl_status" class="tom-select w-full mt-2">
                                                            <option {{ $invoice->bl_status == 1 ? 'selected' : '' }}
                                                                value="1">Active</option>
                                                            <option {{ $invoice->bl_status == 2 ? 'selected' : '' }}
                                                                value="2">Inactive</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Category</label>
                                                        <select id="regular-form-1" name="category"
                                                            class="tom-select w-full mt-2">
                                                            <option {{ $invoice->bl_status == 'Regular' ? 'selected' : '' }}
                                                                value="Regular">Regular</option>
                                                            <option
                                                                {{ $invoice->bl_status == 'Security Deposit' ? 'selected' : '' }}
                                                                value="Security Deposit">Security Deposit</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-12">
                                                        <input class="form-check-input" type="radio" name="settlement"
                                                            id="settled" value="settled"
                                                            {{ $invoice->settlement == 'settled' ? 'checked' : '' }}>
                                                        <label class="form-label" for="settled">
                                                            Settled
                                                        </label>
                                                        <input class="form-check-input" type="radio" name="settlement"
                                                            id="un_settled" value="un_settled"
                                                            {{ $invoice->settlement == 'un_selected' ? 'checked' : '' }}>
                                                        <label class="form-label" for="un_settled">
                                                            Un-Settled
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Client</label>
                                                        <select class="tom-select" name="client_id" id="client_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($clients as $item)
                                                                <option
                                                                    {{ $job_master->job_detail->client_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Sequence #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Sequence #"
                                                            value="{{ $invoice->sequence_no }}" name="sequence_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Invoice Type</label>
                                                        <select id="regular-form-1" name="invoice_type"
                                                            class="tom-select w-full mt-2">
                                                            <option {{ $invoice->invoice_type == 'SI' ? 'selected' : '' }}
                                                                value="SI">SI</option>
                                                            <option {{ $invoice->invoice_type == 'CN' ? 'selected' : '' }}
                                                                value="CN">CN</option>
                                                            <option
                                                                {{ $invoice->invoice_type == 'Zero' ? 'selected' : '' }}
                                                                value="Zero">Zero</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Ref. Tran #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Ref. Tran #"
                                                            value="{{ $invoice->ref_tran_no }}" name="ref_tran_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Operation</label>
                                                        <select id="regular-form-1" name="operation_id"
                                                            class="tom-select w-full mt-2">
                                                            @foreach ($operations as $item)
                                                                <option
                                                                    {{ $job_master->operation_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Job #</label>
                                                        <input type="hidden" value="{{ $job_master->id }}"
                                                            name="job_no">
                                                        <input readonly id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Job #" value="{{ $job_master->job_no }}"
                                                            name="sej_job_no">
                                                    </div>
                                                    {{-- <div class="col-md-3 mt-2">
                                                        <label>Currency</label>
                                                        <select id="regular-form-1" name="currency"
                                                            class="tom-select w-full mt-2">
                                                            <option value="PKR">PKR</option>
                                                            <option value="USD">USD</option>
                                                            <option value="AED">AED</option>
                                                            <option value="GPB">GPB</option>
                                                            <option value="EUR">EUR</option>
                                                            <option value="BDT">BDT</option>
                                                            <option value="OMR">OMR</option>
                                                        </select>
                                                    </div> --}}
                                                    <div class="col-md-3 mt-2">
                                                        <label>Cost Center</label>
                                                        <select data-placeholder="Select Cost Center" id="regular-form-1"
                                                            name="cost_center" class="tom-select w-full mt-2">
                                                            <option
                                                                {{ $invoice->cost_center == 'Head Office' ? 'selected' : '' }}
                                                                value="Head Office">Head Office</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Invoice To</label>
                                                        <select id="regular-form-1" name="invoice_to"
                                                            class="tom-select w-full mt-2">
                                                            <option
                                                                {{ $invoice->invoice_to == 'clearing_agent' ? 'selected' : '' }}
                                                                value="clearing_agent">Clearing Agent</option>
                                                            <option
                                                                {{ $invoice->invoice_to == 'importer' ? 'selected' : '' }}
                                                                value="importer">Importer</option>
                                                            <option
                                                                {{ $invoice->invoice_to == 'coloador' ? 'selected' : '' }}
                                                                value="coloador">Coloador</option>
                                                            <option
                                                                {{ $invoice->invoice_to == 'client' ? 'selected' : '' }}
                                                                value="client">Client</option>
                                                            <option
                                                                {{ $invoice->invoice_to == 'client_importer' ? 'selected' : '' }}
                                                                value="client_importer">Client/Importer</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="manual"
                                                            {{ $invoice->manual == '1' ? 'checked' : '' }} value="1">
                                                        <label class="form-label" for="manual">
                                                            Manual
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Due Days</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Due Days" value="{{ $invoice->due_days }}"
                                                            name="due_days">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Invoice A/C</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Invoice A/C"
                                                            value="{{ $invoice->invoice_ac }}" name="invoice_ac">
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input"
                                                            {{ $invoice->auto_round_off == '1' ? 'checked' : '' }}
                                                            name="auto_round_off" value="1">
                                                        <label class="form-label" for="auto_round_off">
                                                            Auto Round Off
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input"
                                                            {{ $invoice->tax_charges == '1' ? 'checked' : '' }}
                                                            name="tax_charges" value="1">
                                                        <label class="form-label" for="tax_charges">
                                                            Tax Charges
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="charges" role="tabpanel"
                                                aria-labelledby="charges_tab">
                                                <div class="text-end mt-3 me-5">
                                                    <button id="addRowReceivableButton" type="button"
                                                        class="btn btn-primary">Add
                                                        Row</button>
                                                </div>
                                                <div class="row">
                                                    <div class="intro-y g-col-12 overflow-auto">
                                                        <table id="receiveableTable" class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-nowrap">S.No</th>
                                                                    <th class="text-nowrap">Charge Name</th>
                                                                    <th class="text-nowrap">Charge Descripton</th>
                                                                    <th class="text-nowrap">Size/Type</th>
                                                                    <th class="text-nowrap">Rate Group</th>
                                                                    <th class="text-nowrap">DG/Non-DG</th>
                                                                    <th class="text-nowrap">Container</th>
                                                                    <th class="text-nowrap">Qty</th>
                                                                    <th class="text-nowrap">Rate</th>
                                                                    <th class="text-nowrap">Currency</th>
                                                                    <th class="text-nowrap">Amount</th>
                                                                    <th class="text-nowrap">Discount</th>
                                                                    <th class="text-nowrap">Net Amount</th>
                                                                    <th class="text-nowrap">Margin</th>
                                                                    <th class="text-nowrap">Tax</th>
                                                                    <th class="text-nowrap">Tax Amount</th>
                                                                    <th class="text-nowrap">Net Amount Inc Tax</th>
                                                                    <th class="text-nowrap">Ex. Rate</th>
                                                                    <th class="text-nowrap">Local Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($invoice->transaction_charges as $index => $item)
                                                                    <tr>
                                                                        <td>{{ $index + 1 }}</td>
                                                                        <td><select class="form-control"
                                                                                name="charge_id[]" id="charge_id">
                                                                                @foreach ($charges as $charge)
                                                                                    <option
                                                                                        {{ $item->charge_id == $charge->id ? 'selected' : '' }}
                                                                                        value="{{ $charge->id }}">
                                                                                        {{ $charge->name }}</option>
                                                                                @endforeach
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="description[]"
                                                                                value="{{ $item->description }}">
                                                                        </td>
                                                                        <td><select class="form-control"
                                                                                name="size_type[]" id="size_type">
                                                                                <option
                                                                                    {{ $item->size_type == '20BK' ? 'selected' : '' }}
                                                                                    value="20BK">20BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20FR' ? 'selected' : '' }}
                                                                                    value="20FR">20FR</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20OT' ? 'selected' : '' }}
                                                                                    value="20OT">20OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20RE' ? 'selected' : '' }}
                                                                                    value="20RE">20RE</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20SD' ? 'selected' : '' }}
                                                                                    value="20SD">20SD</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20TK' ? 'selected' : '' }}
                                                                                    value="20TK">20TK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40FR' ? 'selected' : '' }}
                                                                                    value="40FR">40FR</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40BK' ? 'selected' : '' }}
                                                                                    value="40BK">40BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40HC' ? 'selected' : '' }}
                                                                                    value="40HC">40HC</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40HCRF' ? 'selected' : '' }}
                                                                                    value="40HCRF">40HCRF</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40OT' ? 'selected' : '' }}
                                                                                    value="40OT">40OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40SD' ? 'selected' : '' }}
                                                                                    value="40SD">40SD</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40VH' ? 'selected' : '' }}
                                                                                    value="40VH">40VH</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45BK' ? 'selected' : '' }}
                                                                                    value="45BK">45BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45HC' ? 'selected' : '' }}
                                                                                    value="45HC">45HC</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45OT' ? 'selected' : '' }}
                                                                                    value="45OT">45OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45TK' ? 'selected' : '' }}
                                                                                    value="45TK">45TK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45VH' ? 'selected' : '' }}
                                                                                    value="45VH">45VH</option>
                                                                                <option
                                                                                    {{ $item->size_type == 'M3' ? 'selected' : '' }}
                                                                                    value="M3">M3</option>
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="rate_group[]"
                                                                                value="{{ $item->rate_group }}">
                                                                        </td>
                                                                        <td><select class="form-control"
                                                                                name="dg_non_dg[]" id="dg_non_dg">
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'DG' ? 'selected' : '' }}
                                                                                    value="DG">
                                                                                    DG</option>
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'Non-DG' ? 'selected' : '' }}
                                                                                    value="Non-DG">
                                                                                    Non-DG</option>
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'All' ? 'selected' : '' }}
                                                                                    value="All">
                                                                                    All</option>
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="container[]"
                                                                                value="{{ $item->container }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control w-24"
                                                                                type="text" name="qty[]"
                                                                                value="{{ $item->qty }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control w-24"
                                                                                type="text" name="rate[]"
                                                                                value="{{ $item->rate }}">
                                                                        </td>
                                                                        <td><select name="currency[]" id="currency">
                                                                            @foreach ($currencies as $currency)
                                                                                <option
                                                                                    {{ $item->currency == $currency->id ? 'selected' : '' }}
                                                                                    value="{{ $currency->id }}">
                                                                                    {{ $currency->name }}</option>
                                                                            @endforeach
                                                                        </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="amount[]"
                                                                                value="{{ $item->amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="discount[]"
                                                                                value="{{ $item->discount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="net_amount[]"
                                                                                value="{{ $item->net_amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control w-24"
                                                                                type="text" name="margin[]"
                                                                                value="{{ $item->margin }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control w-24"
                                                                                type="text" name="tax[]"
                                                                                value="{{ $item->tax }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="tax_amount[]"
                                                                                value="{{ $item->tax_amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="net_amount_inc_tax[]"
                                                                                value="{{ $item->net_amount_inc_tax }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="ex_rate[]"
                                                                                value="{{ $item->ex_rate }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="local_amount[]"
                                                                                value="{{ $item->local_amount }}">
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Remarks</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Remarks" value="{{ $invoice->remarks }}"
                                                            name="remarks">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Voucher #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Voucher #"
                                                            value="{{ $invoice->voucher_no }}" name="voucher_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Bank
                                                            Details</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Bank Details"
                                                            value="{{ $invoice->bank_details }}" name="bank_details">
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input"
                                                            {{ $invoice->manual_remarks == '1' ? 'checked' : '' }}
                                                            name="manual_remarks" value="1">
                                                        <label class="form-label" for="manual_remarks">
                                                            Manual Remarks
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Total
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Total Amount"
                                                            value="{{ $invoice->grand_total_amount }}"
                                                            name="grand_total_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Net Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Net Amount"
                                                            value="{{ $invoice->grand_net_amount }}"
                                                            name="grand_net_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Discount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Discount"
                                                            value="{{ $invoice->grand_discount }}" name="grand_discount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Tax Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Tax Amount"
                                                            value="{{ $invoice->grand_tax_amount }}"
                                                            name="grand_tax_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Net Amount Inc
                                                            Tax</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Net Amount Inc Tax"
                                                            value="{{ $invoice->grand_net_amount_inc_tax }}"
                                                            name="grand_net_amount_inc_tax">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Local
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Local Amount"
                                                            value="{{ $invoice->grand_local_amount }}"
                                                            name="grand_local_amount">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        const dropdownOptions = {
            customers: [""],
            vendors: [""],
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: ["PKR", "USD", "AED", "GBP", "EUR", "BDT", "OMR"],
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        function createCurrencyDropdown(name, currencies) {
            let dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please Select</option>';
            currencies.forEach((currency, index) => {
                dropdown += '<option value="' + (index + 1) + '">' + currency + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('charge_id[]', dropdownOptions
                    .charges) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('size_type[]', dropdownOptions
                    .sizeType) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate_group[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'container[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createCurrencyDropdown('currency[]', dropdownOptions.currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'discount[]', '') + '</td>' +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'margin[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount_inc_tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'ex_rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'local_amount[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>
