@extends('layout.master')

@section('title')
    @if (Request::is('se_invoice'))
        SE Invoice-YARAN
    @elseif(Request::is('si_invoice'))
        SI Invoice-YARAN
    @elseif(Request::is('ae_invoice'))
        AE Invoice-YARAN
    @elseif(Request::is('ai_invoice'))
        AI Invoice-YARAN
    @endif
@endsection

@section('topbar')
    @if (Request::is('se_invoice'))
        <a href="/se_invoice" class="breadcrumb--active">SE Invoice</a>
    @elseif(Request::is('si_invoice'))
        <a href="/si_invoice" class="breadcrumb--active">SI Invoice</a>
    @elseif(Request::is('ae_invoice'))
        <a href="/ae_invoice" class="breadcrumb--active">AE Invoice</a>
    @elseif(Request::is('ai_invoice'))
        <a href="/ai_invoice" class="breadcrumb--active">AI Invoice</a>
    @endif
@endsection
@section('content')
    {{-- <h2 class="intro-y fs-lg fw-medium mt-10">
        @if (Request::is('se_invoice'))
            SE Invoice
        @elseif(Request::is('si_invoice'))
            SI Invoice
        @elseif(Request::is('ae_invoice'))
            AE Invoice
        @elseif(Request::is('ai_invoice'))
            AI Invoice
        @endif
    </h2> --}}
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-6">
                @if (Request::is('se_invoice'))
                    SE Invoice
                @elseif(Request::is('si_invoice'))
                    SI Invoice
                @elseif(Request::is('ae_invoice'))
                    AE Invoice
                @elseif(Request::is('ai_invoice'))
                    AI Invoice
                @endif
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button" data-bs-toggle="collapse"
                data-bs-target="#faq-accordion-collapse-1" aria-expanded="true" aria-controls="faq-accordion-collapse-1"> <i
                    data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    <div id="faq-accordion-collapse-1" class="accordion-collapse collapse show mt-5" aria-labelledby="faq-accordion-content-1"
        data-bs-parent="#faq-accordion-1">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <form method="GET" id="myForm" action="{{ url('/se_invoice') }}">
                        <div class="row">
                            <div class="col-md-4">
                                <div>
                                    <label for="filterBy" class="form-label">Select</label>
                                    <select name="filterBy" id="filterBy" class="form-control">
                                        <option value="" {{ request('filterBy') == '' ? 'selected' : '' }}>Select
                                        </option>
                                        <option value="id" {{ request('filterBy') == 'id' ? 'selected' : '' }}>Invoice #
                                        </option>
                                        <option value="ref_tran_no"
                                            {{ request('filterBy') == 'ref_tran_no' ? 'selected' : '' }}>Reference</option>
                                        <option value="client_id"
                                            {{ request('filterBy') == 'client_id' ? 'selected' : '' }}>Client ID</option>
                                        <option value="invoice_type"
                                            {{ request('filterBy') == 'invoice_type' ? 'selected' : '' }}>Invoice Category
                                        </option>
                                        <option value="job_master_id"
                                            {{ request('filterBy') == 'job_master_id' ? 'selected' : '' }}>Job #</option>◘
                                        <option value="status" {{ request('filterBy') == 'status' ? 'selected' : '' }}>Bill
                                            Status</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="filterValue" class="form-label">Name</label>
                                <input type="text" name="filterValue" class="form-control"
                                    value="{{ request('filterValue') }}" placeholder="Enter Name or ID" name="name"
                                    aria-label="Enter Name">
                            </div>
                            <div class="col-md-4 mt-8">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <circle cx="11" cy="11" r="8" />
                                        <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                    </svg>
                                    Search</button>
                                <a href="{{ url('/se_invoice') }}" type="button"
                                    class="btn btn-sm btn-elevated-danger w-24">
                                    {{-- <i data-feather="x"></i> --}}
                                    <!-- https://feathericons.dev/?search=x&iconset=feather -->
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <line x1="18" x2="6" y1="6" y2="18" />
                                        <line x1="6" x2="18" y1="6" y2="18" />
                                    </svg>
                                    Clear</a>
                            </div>
                    </form>
                </div>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
    </div>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            {{-- @if (Request::is('se_invoice'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/se_invoice/add') }}">Add New</a>
            @elseif(Request::is('si_invoice'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/si_invoice/add') }}">Add New</a>
            @elseif(Request::is('ae_invoice'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ae_invoice/add') }}">Add New</a>
            @elseif(Request::is('ai_invoice'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ai_invoice/add') }}">Add New</a>
            @endif --}}
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $invoices->firstItem() }} to
                {{ $invoices->lastItem() }} of {{ $invoices->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Tran #</th>
                        <th>Job #</th>
                        <th>Inv Date</th>
                        <th>Reference</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($invoices as $invoice)
                        <tr>
                            <td>{{ $invoice->tran_no }}</td>
                            <td>{{ $invoice->job_master?->job_no }}</td>
                            <td>{{ $invoice->inv_date }}</td>
                            <td>{{ $invoice->reference }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    {{-- edit --}}
                                    @if ($invoice->operation_id == 1)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/se_invoice/edit/' . $invoice->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>Edit</a>
                                    @elseif ($invoice->operation_id == 2)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/si_invoice/edit/' . $invoice->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>Edit</a>
                                    @elseif ($invoice->operation_id == 3)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/ae_invoice/edit/' . $invoice->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>Edit</a>
                                    @elseif ($invoice->operation_id == 4)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/ai_invoice/edit/' . $invoice->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>Edit</a>
                                    @endif
                                    {{-- job --}}
                                    @if ($invoice->job_master_id)
                                        @if ($invoice->operation_id == 1)
                                            <a title="SE JOB" class="tooltip btn btn-primary me-2 p-2"
                                                href="{{ url('/se_job/edit/' . $invoice->job_master_id) }}"><i
                                                    data-feather="file-text" class="w-4 h-4 me-1"></i>
                                                JOB </a>
                                        @elseif ($invoice->operation_id == 2)
                                            <a title="SI JOB" class="tooltip btn btn-primary me-2 p-2"
                                                href="{{ url('/si_job/edit/' . $invoice->job_master_id) }}"><i
                                                    data-feather="file-text" class="w-4 h-4 me-1"></i>
                                                JOB </a>
                                        @elseif ($invoice->operation_id == 3)
                                            <a title="AE JOB" class="tooltip btn btn-primary me-2 p-2"
                                                href="{{ url('/ae_job/edit/' . $invoice->job_master_id) }}"><i
                                                    data-feather="file-text" class="w-4 h-4 me-1"></i>
                                                JOB </a>
                                        @elseif ($invoice->operation_id == 4)
                                            <a title="AI JOB" class="tooltip btn btn-primary me-2 p-2"
                                                href="{{ url('/ai_job/edit/' . $invoice->job_master_id) }}"><i
                                                    data-feather="file-text" class="w-4 h-4 me-1"></i>
                                                JOB </a>
                                        @endif
                                    @endif
                                    {{-- print --}}
                                    {{-- <a target="_blank" href={{ url('se_invoice_print/' . $invoice->id) }}
                                        class="btn btn-success me-2 p-2"><i data-feather="file-text"
                                            class="w-4 h-4 me-1"></i>Print</a> --}}

                                    <button id="showPrintBtn{{ $invoice->id }}"
                                        class="btn btn-success me-2 p-2 showPrintBtn" data-bs-toggle="modal"
                                        data-bs-target="#printModal" data-item-id="{{ $invoice->id }}"><i
                                            data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                                    {{-- <form id="exportForm" method="GET"
                                        action="{{ route('invoice.export', $invoice->id) }}">
                                        <div class="d-flex align-items-center">
                                            <select name="type" id="exportType" class="form-select me-2"
                                                style="width: auto;">
                                                <option value="" disabled selected>Select Format</option>
                                                <option value="word">Word</option>
                                                <option value="excel">Excel</option>
                                            </select>
                                            <button type="submit" class="btn btn-primary">Download</button>
                                        </div>
                                    </form> --}}


                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        <div class="g-col-12">
            <div class="d-flex justify-content-end align-items-end">
                <div class="me-3">
                    <label for="perPage" class="form-label">Show Items:</label>
                    <select id="perPage" name="perPage" class="form-select" onchange="changePerPage(this)">
                        <option value="100" @if ($perPage == 100) selected @endif>100</option>
                        <option value="200" @if ($perPage == 200) selected @endif>200</option>
                        <option value="250" @if ($perPage == 250) selected @endif>250</option>
                    </select>
                </div>
                <div class="ms-3">
                    <?php echo $invoices->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                </div>
            </div>
        </div>
        {{-- end Pagination --}}
    </div>
    @include('sea_export.se_invoice.modals.print')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    {{-- <script>
        document.getElementById('exportForm').addEventListener('submit', function(e) {
            const type = document.getElementById('exportType').value;
            if (!type) {
                e.preventDefault();
                Swal.fire({
                    icon: 'warning',
                    title: 'Select Format',
                    text: 'Please select a file format (Word or Excel) before downloading.',
                    confirmButtonText: 'OK'
                });
            }
        });
    </script> --}}

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.showPrintBtn').forEach(button => {
                button.addEventListener('click', function() {
                    const invoiceID = this.getAttribute('data-item-id');

                    document.getElementById('selectedInvoiceID').value = invoiceID;
                });
            });
        });

        $(document).ready(function() {
            $('input[name="show_hide_panel"]').change(function() {
                if ($(this).is(':checked')) {
                    $('#show_panel').removeClass('d-none');
                } else {
                    $('#show_panel').addClass('d-none');
                }
            });
            $('input[name="print_invoice_note"]').change(function() {
                if ($(this).is(':checked')) {
                    $('#invoice_note_div').removeClass('d-none');
                } else {
                    $('#invoice_note_div').addClass('d-none');
                }
            });
        });

        function updatePrintLink() {


            const invoiceId = document.getElementById('selectedInvoiceID').value;
            const hide_shipper_consignee = document.getElementById('hide_shipper_consignee').checked;
            const hide_consignee = document.getElementById('hide_consignee').checked;
            const hide_port_of_loading = document.getElementById('hide_port_of_loading').checked;
            const hide_port_of_discharge = document.getElementById('hide_port_of_discharge').checked;
            const hide_exchange_rate = document.getElementById('hide_exchange_rate').checked;
            const hide_hbl = document.getElementById('hide_hbl').checked;
            const hide_mbl = document.getElementById('hide_mbl').checked;
            const print_logo = document.getElementById('print_logo').checked;
            const print_on_letterhead = document.getElementById('print_on_letterhead').checked;
            // const print_balance = document.getElementById('print_balance').checked;
            const show_container = document.getElementById('show_container').checked;
            const show_bank = document.getElementById('show_bank').checked;
            const hide_volume = document.getElementById('hide_volume').checked;
            const show_remarks = document.getElementById('show_remarks').checked;
            const hide_sales_rep_and_ref_no = document.getElementById('hide_sales_rep_and_ref_no').checked;
            const msg_of_system_generated_invoice = document.getElementById('msg_of_system_generated_invoice').checked;
            const print_invoice_note = document.getElementById('print_invoice_note').checked;
            const print_invoice_with_other_invoice = document.getElementById('print_invoice_with_other_invoice').checked;
            const hide_sa_line = document.getElementById('hide_sa_line').checked;
            const invoice_note = document.getElementById('invoice_note').value;
            const print_option = document.querySelector('input[name="print_option"]:checked') ? document.querySelector('input[name="print_option"]:checked').value : '';

            // Set the href attribute with the updated URL
            printLink.href =
                `{{ url('se_invoice_print') }}/${encodeURIComponent(invoiceId)}?hide_shipper_consignee=${encodeURIComponent(hide_shipper_consignee)}&hide_consignee=${encodeURIComponent(hide_consignee)}&hide_port_of_loading=${encodeURIComponent(hide_port_of_loading)}&hide_port_of_discharge=${encodeURIComponent(hide_port_of_discharge)}&hide_exchange_rate=${encodeURIComponent(hide_exchange_rate)}&hide_hbl=${encodeURIComponent(hide_hbl)}&hide_mbl=${encodeURIComponent(hide_mbl)}&print_logo=${encodeURIComponent(print_logo)}&print_on_letterhead=${encodeURIComponent(print_on_letterhead)}&show_container=${encodeURIComponent(show_container)}&show_bank=${encodeURIComponent(show_bank)}&hide_volume=${encodeURIComponent(hide_volume)}&show_remarks=${encodeURIComponent(show_remarks)}&hide_sales_rep_and_ref_no=${encodeURIComponent(hide_sales_rep_and_ref_no)}&msg_of_system_generated_invoice=${encodeURIComponent(msg_of_system_generated_invoice)}&print_invoice_note=${encodeURIComponent(print_invoice_note)}&print_invoice_with_other_invoice=${encodeURIComponent(print_invoice_with_other_invoice)}&hide_sa_line=${encodeURIComponent(hide_sa_line)}&invoice_note=${encodeURIComponent(invoice_note)}&print_option=${encodeURIComponent(print_option)}`;
        }

        function changePerPage(select) {
            const perPage = select.value;
            const urlParams = new URLSearchParams(window.location.search);

            // Add or update your own parameters
            urlParams.set('perPage', perPage);

            // Construct the new URL
            const newUrl = `{{ url('/se_invoice') }}?${urlParams.toString()}`;

            // Redirect to the new URL
            window.location.href = newUrl;

        }
    </script>
@endsection