<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>YARAN - SEINVOICE - PRINT</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <style>
        P {
            font-size: 12px;
        }

        .footer {
            position: absolute;
            bottom: 10px;
            width: 100%;
            display: flex;
            justify-content: space-between;
            font-size: 10px;
            text-align: center;
        }

        .footer-left,
        .footer-center,
        .footer-right {
            flex: 1;
            display: flex;
            justify-content: space-between;
        }

        .footer-left {
            text-align: left;
        }

        .footer-center {
            text-align: center;
        }

        .footer-right {
            text-align: right;
        }

        @media print {
            table {
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .no-print {
                display: none;
            }
        }

        @media print {
            @page {
                size: A4;
                margin: 0;
            }

            .container {
                width: 100%;
                margin: 0;
                padding: 0;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            th,
            td {
                padding: 4px;
            }
        }

        @media print {
            .container {
                width: 100%;
                margin: 0;
            }

            table {
                page-break-inside: auto;
                width: 100%;
            }

            th,
            td {
                page-break-inside: avoid;
            }

            @page {
                size: auto;
                margin: 0;
            }
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;

        }

        table {
            width: 100%;
            height: 60px;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 4px;
            text-align: left;
            font-size: 12px;
        }

        .column1 {
            width: 50%;
        }

        .column2 {
            width: 50%;
        }

        .sr,
        .name,
        .rate,
        .amount,
        .dis,
        .tax,
        .total,
        .qty,
        .curr {
            text-align: right;
            font-size: 11.8px;

        }

        .column-heading {
            background-color: rgb(194, 186, 186);
            text-align: center;
        }

        .sr {
            width: 5%;
            text-align: left;
        }

        .name {
            width: 25%;
            text-align: left;
        }
    </style>
</head>

<body>
    <div class="container" style="margin: 0px 60px; width: 88.1%; font-size: 16px;">
        <div class="logo-heading" style="display: flex;gap: 15%;align-items: center;text-align: center;">
            @if ($print_logo == 'true')
                <div class="logo">
                    {{-- <img src="logo.png" alt="" style="width: 150px; padding-bottom: px;border-top: none;"> --}}
                    {{-- <img src="{{ url('logo2.png') }}" alt=""
                        style="width: 150px; padding-bottom: px;border-top: none;"> --}}
                    <img src="{{ url('logo2.png') }}" alt=""
                        style="width: 150px; padding-bottom: 0px; border-top: none;">
                </div>
            @endif
            @if ($print_on_letterhead == 'true')
                <div class="heading">
                    <h3>YARAN SHIPPING LINE</h3>
                    <p>Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</p>
                    <p style="font-size: 12px;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
                </div>
            @endif
        </div>
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div style="border:3px solid;width: 68%;border-top: none; border-right: none; border-left: none;"></div>
            <h3>Job Invoice</h3>
            <div style="border:3px solid;width: 8%; border-right: none; border-left: none;border-top: none;"></div>
        </div>

        <table style="font-size: 10px;">

            <tr>
                <td>
                    <h4>INVOICE TO</h4>
                    <p>{{ @$invoice->client->name }} <br>
                        {{ @$invoice->client->address }}
                    </p>
                </td>
                <td>
                    @if ($hide_shipper_consignee == 'false')
                        @if ($hide_consignee == 'true')
                            <h4>Shipper</h4>
                            <p>{{ @$invoice->job_master->job_detail->shipper->name }}</p>
                        @else
                            <h4>Shipper/Consignee</h4>
                            <p>
                                {{ @$invoice->job_master->job_detail->shipper->name }}
                                @if (
                                    !empty($invoice->job_master->job_detail->shipper->name) &&
                                        !empty($invoice->job_master->job_detail->consignee->name))
                                    /
                                    <br>
                                @endif
                                {{ @$invoice->job_master->job_detail->consignee->name }}
                            </p>
                        @endif
                    @endif
                </td>
            </tr>
            @if ($hide_sales_rep_and_ref_no == 'false')
                <tr>
                    <td class="column1">
                        <div style="display: flex; justify-content:space-between;">
                            <h4>Reference No.</h4> <br>
                            <p>{{ @$invoice->reference }}</p>
                        </div>
                    </td>
                    <td class="column2">
                        <div style="display: flex; justify-content:space-between;">
                            <h4>Sales Rep</h4>
                            <p>{{ @$invoice->job_master->job_detail->sales_rep->employee_name }}</p>
                        </div>
                    </td>
                </tr>
            @endif
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content: space-between;">
                        @php
                            $operationId = $invoice->job_master->operation_id ?? null;
                        @endphp

                        @if ($operationId == 1 || $operationId == 2)
                            @if ($hide_mbl == 'false')
                                <h4>MBL No.</h4>
                            @endif
                            @if ($hide_hbl == 'false')
                                <h4>Bill of Lading</h4>
                            @endif
                        @else
                            @if ($hide_mbl == 'false')
                                <h4>MAWB No.</h4>
                            @endif
                            @if ($hide_hbl == 'false')
                                <h4>HAWB No.</h4>
                            @endif
                        @endif
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if ($hide_mbl == 'false')
                            <p>{{ @$invoice->job_master->bl_master->mbl_no }}</p>
                        @endif
                        @if ($hide_hbl == 'false')
                            <p>{{ @$invoice->job_master->bl_master->hbl_no }}</p>
                        @endif
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Job No</h4>
                        <h4>Job Date</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$invoice->job_master->job_no }}</p>
                        {{-- <p>{{ @$invoice->job_master->job_date }}</p> --}}
                        <p>{{ \Carbon\Carbon::parse(@$invoice->job_master->job_date)->format('d/m/Y') }}
                        </p>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                            <h4>Vessel / Voyage</h4>
                        @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                            <h4>Air Line / Flight No.</h4>
                        @endif
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 3)
                            <h4>Sailing Date</h4>
                        @elseif (@$invoice->job_master->operation_id == 2 || @$invoice->job_master->operation_id == 4)
                            <h4>Arrival Date</h4>
                        @endif
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                            <p>{{ @$invoice->job_master->job_vessel->vessel->name }} /
                                {{ @$invoice->job_master->job_vessel->voyage->voyage_no }}</p>
                        @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                            <p>{{ @$invoice->job_master->job_vessel->airline->name }} /
                                {{ @$invoice->job_master->job_vessel->flight_no }}</p>
                        @endif
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 3)
                            <p>{{ \Carbon\Carbon::parse(@$invoice->job_master->bl_master->sailing_date)->format('d/m/Y') }}
                            </p>
                        @elseif (@$invoice->job_master->operation_id == 2 || @$invoice->job_master->operation_id == 4)
                            <p>{{ \Carbon\Carbon::parse(@$invoice->job_master->bl_master->arrival_date)->format('d/m/Y') }}
                            </p>
                        @endif
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Invoice No</h4>
                        <h4>Invoice Date</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$invoice->tran_no }}</p>
                        <p>{{ \Carbon\Carbon::parse(@$invoice->inv_date)->format('d/m/Y') }}</p>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                            @if ($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'false')
                                <h4>Port of Loading</h4>
                                <h4>Port of Discharge</h4>
                            @elseif($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'true')
                                <h4>Port of Loading</h4>
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'false')
                                <h4>Port of Discharge</h4>
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'true')
                            @endif
                        @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                            @if ($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'false')
                                <h4>Airport of Loading</h4>
                                <h4>Airport of Discharge</h4>
                            @elseif($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'true')
                                <h4>Airport of Loading</h4>
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'false')
                                <h4>Airport of Discharge</h4>
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'true')
                            @endif
                        @endif
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                            @if ($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'false')
                                <p>{{ @$invoice->job_master->job_detail->port_of_loading->name }}</p>
                                <p>{{ @$invoice->job_master->job_detail->port_of_discharge->name }}</p>
                            @elseif($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'true')
                                <p>{{ @$invoice->job_master->job_detail->port_of_loading->name }}</p>
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'false')
                                <p>{{ @$invoice->job_master->job_detail->port_of_discharge->name }}</p>
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'true')
                            @endif
                        @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                            @if ($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'false')
                                <p>{{ @$invoice->job_master->bl_master->bl_booking_info->port_of_loading->name }}</p>
                                <p>{{ @$invoice->job_master->bl_master->bl_booking_info->port_of_discharge->name }}</p>
                            @elseif($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'true')
                                <p>{{ @$invoice->job_master->bl_master->bl_booking_info->port_of_loading->name }}</p>
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'false')
                                <p>{{ @$invoice->job_master->bl_master->bl_booking_info->port_of_discharge->name }}</p>
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'true')
                            @endif
                        @endif
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Destination Port</h4>
                        @if ($hide_sa_line == 'false')
                            @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                                <h4>Shipping Line</h4>
                            @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                                <h4>Air Line</h4>
                            @endif
                        @endif
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$invoice->job_master->job_routing->final_destination->name }}</p>
                        @if ($hide_sa_line == 'false')
                            @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                                <p>{{ @$invoice->job_master->job_detail->shipping_line->name }}</p>
                            @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                                <p>{{ @$invoice->job_master->job_vessel->airline->name }}</p>
                            @endif
                        @endif
                    </div>
                </td>
            </tr>
            @php
                $total20 = 0;
                $total40 = 0;
            @endphp
            <td class="column2" style="display: flex; gap: 110px; border: 1px solid; width: 100%;height: 47px;">
                @if ($hide_volume == 'false')
                    <div>
                        <h4>Volume</h4>
                        <p>{{ @$invoice->job_master->job_weight->vol }}</p>
                    </div>
                @endif
                <div>
                    <h4>Weight</h4>
                    <p>{{ @$invoice->job_master->job_weight->weight }}</p>
                </div>
                <div>
                    <h4>PCS</h4>
                    @if (@$invoice->job_master->bl_master)
                        @if ($invoice->job_master->bl_master->bl_container_info->isNotEmpty())

                            @foreach ($invoice->job_master->bl_master->bl_container_info as $detail)
                                @php
                                    if (
                                        !empty($detail->container_size_type) &&
                                        $detail->container_size_type !== 'Please Select' &&
                                        $detail->container_size_type !== 'M3'
                                    ) {
                                        if (substr($detail->container_size_type, 0, 2) === '20') {
                                            $total20++;
                                        } else {
                                            $total40++;
                                        }
                                    }
                                @endphp
                            @endforeach
                        @endif
                    @endif
                    @php
                        $pcsText = '';
                        if ($total20) {
                            $pcsText .= $total20 . ' x 20';
                        }
                        if ($total40) {
                            $pcsText .= ($pcsText ? ', ' : '') . $total40 . ' x 40';
                        }
                    @endphp
                    <p style="font-size: 10px">{{ $pcsText ?: @$invoice->job_master->job_weight->pcs ?? '-' }}</p>
                </div>
            </td>
            <td class="column2">
                <div style="display: flex; justify-content:space-between;">
                    <h4>Currency</h4>
                    @if ($hide_exchange_rate == 'false')
                        <h4>Exchange Rate</h4>
                    @endif
                </div>
                <div style="display: flex; justify-content:space-between;">
                    {{-- <p>{{ @$invoice->transaction_charges[0]->currency_name->name }}</p> --}}
                    <p>PKR</p>
                    <p>{{ $invoice->job_master?->selling }}</p>
                </div>
            </td>
            </tr>
        </table>
        @if ($show_container == 'true')
            <div class="contan" style="border: 1px solid; display: flex; gap:114px; ">
                <h5>Container #</h5>
                <p>{{ @$containerNo }}</p>
            </div>
        @endif
        <table>
            <!-- Table Headings -->
            <tr>
                <th class="column-heading">SR#</th>
                <th class="column-heading">Name</th>
                <th class="column-heading">Qty</th>
                <th class="column-heading">Rate</th>
                <th class="column-heading">Currency</th>
                <th class="column-heading">Amount</th>
                <th class="column-heading">Dis</th>
                <th class="column-heading">Tax</th>
                <th class="column-heading">Total Amount</th>
            </tr>

            <!-- Table Rows -->
            @if ($invoice->transaction_charges)
                @foreach ($invoice->transaction_charges as $index => $charges)
                    @php
                        $currencyCodes = [
                            'PAK RUPEES' => 'PKR',
                            'US DOLLAR' => 'USD',
                            'DIRHAM' => 'AED',
                            'POUND' => 'GBP',
                            'EURO' => 'EUR',
                            'BDT' => 'BDT',
                            'OMANI RIYAL' => 'OMR',
                        ];
                    @endphp
                    <tr>
                        <td class="sr">{{ $index + 1 }}</td>
                        <td class="name">{{ $charges->charge->name }}</td>
                        <td class="qty">{{ $charges->qty }}</td>
                        <td class="rate">{{ $charges->rate }}</td>
                        <td class="curr">
                            {{ $currencyCodes[$charges->currency_name->name] ?? $charges->currency_name->name }}
                        </td>
                        <td class="amount">{{ number_format(floor($charges->local_amount * 100) / 100, 2) }}</td>
                        <td class="dis">{{ $charges->discount }}</td>
                        <td class="tax">{{ $charges->tax }}</td>
                        <td class="total">{{ number_format(floor($charges->local_amount * 100) / 100, 2) }}</td>
                    </tr>
                @endforeach
            @endif
        </table>
        <div class="total-discount"
            style="border: 1px solid;display: flex;justify-content: space-between;width: 100%;height: 100px;padding: 8px;">
            <div class="discount">
                <h4>Total Discount</h4>
            </div>
            <div class="discount">
                <p>{{ @$invoice->grand_discount }}</p>
            </div>
            <div class="discount">
                <h4>Tax Amount</h4>
            </div>
            <div class="discount">
                <p>{{ @$invoice->grand_tax_amount }}</p>
            </div>
            <div class="discount">
                <h4>Total Amount</h4>
                <h4>Round Off</h4>
                <h4>Total Amount</h4>
            </div>
            <div class="discount">
                <p style="margin-top: 5px;">{{ number_format(@$invoice->grand_local_amount, 2) }}</p>
                <p style="margin-top: 5px;">
                    @php
                        $rounded = round(@$invoice->grand_local_amount);
                        $original = round(@$invoice->grand_local_amount, 2);
                        $roundOff = number_format($rounded - $original, 2);
                    @endphp
                    {{ $roundOff }}
                </p>
                <p style="margin-top: 5px;">{{ number_format(@$invoice->grand_local_amount, 0) }}</p>
            </div>
        </div>
        <div class="note" style="display: flex;">
            <div style="border: 1px solid; width: 50%; padding: 0px 5px;">
                <h4>Note:</h4>
            </div>
            <div style="border: 1px solid;width: 50%; padding: 0px 5px;">
                <h4>In-Words</h4>
            </div>
        </div>
        {{-- <div class="note" style="display: flex; font-size: 15px;">
            <div style="border: 1px solid; width: 50%; padding: 0px 5px; padding-bottom: 20px;">
                <h4>INVOICE TO</h4>
                <p>{{ @$invoice->client->name }} <br>
                    {{ @$invoice->client->address }}
                </p>
            </div>
            <div style="border: 1px solid;width: 50%; padding: 0px 5px;">
                <h4>Shipper/Consignee</h4>
                <p> {{ @$invoice->job_master->job_detail->shipper->name }} /
                    {{ @$invoice->job_master->job_detail->consignee->name }}</p>
            </div>
        </div> --}}
        <div class="note" style="display: flex; font-size: 15px;">
            <div style="border: 1px solid; width: 50%; padding: 0px 5px;padding-bottom: 30px;">
                @if ($print_invoice_note == 'false')
                    <p>INVOICE IS SYSTEM GENERATED, SIGNATURE NOT REQUIRED: <br>
                        If any discrepancy is noticed in the invoice, kindly inform us in writing <br>
                        within 7 days, otherwise, the above amount will be considered as
                        correct.
                    </p>
                @else
                    <p>{{ $invoice_note }}</p>
                @endif
            </div>
            <div style="border: 1px solid;width: 50%; padding: 0px 5px;">
                @php
                    $formatter = new \NumberFormatter('en', \NumberFormatter::SPELLOUT);
                    $amountInWords = strtoupper($formatter->format(@$invoice->grand_local_amount));
                @endphp
                <p>PKR {{ @$amountInWords }}</p>
            </div>
        </div>
        @if ($show_bank == 'true')
            <div class="note" style="display: flex; font-size: 15px;  margin-top:15px">
                <div style="border: 1px solid; width: 50%; padding: 0px 5px;padding-bottom: 30px;">
                    <h3>Bank Detail</h3>
                    <p>{{ $invoice->bank_details }}</p>
                </div>
            </div>
        @endif
        @if ($msg_of_system_generated_invoice == 'true')
            <div style="margin-top:15px">
                <p>This is computer generated invoice and does not need any signature</p>
            </div>
        @endif
        <div class="footer">
            <div class="footer-left">
                {{-- <p>Printed On: {{ now()->format('Y-m-d H:i:s') }}</p> --}}
                <p>Printed On: {{ now()->setTimezone('Asia/Karachi')->format('Y-m-d H:i:s') }}</p>
            </div>
            <div class="footer-center">
                <p>Printed By: {{ auth()->user()->name }}</p>
            </div>
            <div class="footer-right">
                <p>Page: 1</p>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            window.print(); // Trigger the print dialog once the page loads
        });
    </script>
</body>

</html>
