<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>YARAN - SEINVOICE - WORD</title>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            font-size: 12px;
            margin: 40px;
        }

        p {
            margin: 0;
            padding: 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        .column-heading {
            background-color: #ccc;
            text-align: center;
        }

        .sr,
        .qty,
        .rate,
        .curr,
        .amount,
        .dis,
        .tax,
        .total {
            text-align: right;
        }

        .sr {
            width: 5%;
        }

        .name {
            width: 25%;
            text-align: left;
        }

        .footer {
            font-size: 10px;
            margin-top: 30px;
            display: flex;
            justify-content: space-between;
            border-top: 1px solid #000;
            padding-top: 5px;
        }

        .container {
            width: 100%;
        }

        .logo-heading {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        h3,
        h4 {
            margin: 2px 0;
        }

        .section-divider {
            border-top: 3px solid #000;
            margin: 10px 0;
        }

        .note-box,
        .amount-box {
            border: 1px solid #000;
            padding: 5px;
            height: auto;
        }

        .total-discount {
            display: flex;
            justify-content: space-between;
            border: 1px solid #000;
            padding: 10px;
            margin-top: 10px;
        }

        .contan {
            border: 1px solid #000;
            padding: 5px;
            margin-top: 5px;
        }

        .note-container {
            display: flex;
            margin-top: 10px;
        }

        .note-container>div {
            width: 50%;
            border: 1px solid #000;
            padding: 5px;
        }

        .bank-detail {
            border: 1px solid #000;
            padding: 5px;
            margin-top: 10px;
        }
    </style>
</head>

<body>
    <div class="container">
        <!-- Logo and Header -->
        <table style="width: 100%; margin-bottom: 10px;">
            <tr>
                @if ($print_logo == 'true')
                    <td style="width: 30%; vertical-align: top;">
                        <img src="{{ url('logo2.png') }}" alt="Company Logo"
                            style="width: 80px !important; height: 50px !important; max-width: 80px !important; max-height: 50px !important; object-fit: contain;"
                            width="80" height="50">

                        {{-- <img src="{{ url('logo2.png') }}" alt="Company Logo" style="width: 50px !important; height: 50px !important;"> --}}
                    </td>
                @endif
                @if ($print_on_letterhead == 'true')
                    <td style="text-align: left; vertical-align: top;">
                        <h3 style="margin: 0;">YARAN SHIPPING LINE</h3>
                        <p style="margin: 0;">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                        </p>
                        <p style="margin: 0;">Email: info@yaranshippingline.com | Web: www.yaranshippingline.com</p>
                    </td>
                @endif
            </tr>
        </table>

        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div style="border:3px solid;width: 68%;border-top: none; border-right: none; border-left: none;"></div>
            <h3>Job Invoice</h3>
            <div style="border:3px solid;width: 8%; border-right: none; border-left: none;border-top: none;"></div>
        </div>

        <table style="font-size: 10px; width: 100%; table-layout: fixed;">

            <tr>
                <td style="width: 50%; vertical-align: top;">
                    <strong>INVOICE TO</strong> <br>
                    {{ @$invoice->client->name }} <br>
                    {{ @$invoice->client->address }}
                </td>
                <td style="width: 50%; vertical-align: top;">
                    @if ($hide_shipper_consignee == 'false')
                        @if ($hide_consignee == 'true')
                            <strong>Shipper</strong> <br>
                            {{ @$invoice->job_master->job_detail->shipper->name }}
                        @else
                            <strong>Shipper/Consignee</strong> <br>
                            {{ @$invoice->job_master->job_detail->shipper->name }}
                            @if (
                                !empty($invoice->job_master->job_detail->shipper->name) &&
                                    !empty($invoice->job_master->job_detail->consignee->name))
                                /
                                <br>
                            @endif
                            {{ @$invoice->job_master->job_detail->consignee->name }}
                        @endif
                    @endif
                </td>
            </tr>

            @if ($hide_sales_rep_and_ref_no == 'false')
                <tr>
                    <td class="column1">
                        <div style="display: flex; justify-content:space-between;">
                            <strong>Reference No.</strong> {{ @$invoice->reference }}
                        </div>
                    </td>
                    <td class="column2">
                        <div style="display: flex; justify-content:space-between;">
                            <strong>Sales Rep</strong> {{ @$invoice->job_master->job_detail->sales_rep->employee_name }}
                        </div>
                    </td>
                </tr>
            @endif
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        @if ($hide_mbl == 'false')
                            <strong>MBL No.</strong> {{ @$invoice->job_master->bl_master->mbl_no }}
                        @endif

                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if ($hide_hbl == 'false')
                            <strong>Bill of Lading</strong> {{ @$invoice->job_master->bl_master->hbl_no }}
                        @endif
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <strong>Job No</strong> {{ @$invoice->job_master->job_no }}
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <strong>Job Date</strong>
                        {{ \Carbon\Carbon::parse(@$invoice->job_master->job_date)->format('d/m/Y') }}
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                            <strong>Vessel / Voyage</strong> {{ @$invoice->job_master->job_vessel->vessel->name }} /
                            {{ @$invoice->job_master->job_vessel->voyage->voyage_no }}
                        @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                            <strong>Air Line / Flight No.</strong>
                            {{ @$invoice->job_master->job_vessel->airline->name }} /
                            {{ @$invoice->job_master->job_vessel->flight_no }}
                        @endif

                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 3)
                            <strong>Sailing Date</strong>
                            {{ \Carbon\Carbon::parse(@$invoice->job_master->bl_master->sailing_date)->format('d/m/Y') }}
                        @elseif (@$invoice->job_master->operation_id == 2 || @$invoice->job_master->operation_id == 4)
                            <strong>Arrival Date</strong>
                            {{ \Carbon\Carbon::parse(@$invoice->job_master->bl_master->arrival_date)->format('d/m/Y') }}
                        @endif
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <strong>Invoice No</strong> {{ @$invoice->tran_no }}
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <strong>Invoice Date</strong> {{ \Carbon\Carbon::parse(@$invoice->inv_date)->format('d/m/Y') }}
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                            @if ($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'false')
                                <strong>Port of Loading</strong>
                                {{ @$invoice->job_master->job_detail->port_of_loading->name }} <br>
                                <strong>Port of Discharge</strong>
                                {{ @$invoice->job_master->job_detail->port_of_discharge->name }}
                            @elseif($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'true')
                                <strong>Port of Loading</strong>
                                {{ @$invoice->job_master->job_detail->port_of_loading->name }}
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'false')
                                <strong>Port of Discharge</strong>
                                {{ @$invoice->job_master->job_detail->port_of_discharge->name }}
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'true')
                            @endif
                        @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                            @if ($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'false')
                                <strong>Airport of Loading</strong>
                                {{ @$invoice->job_master->bl_master->bl_booking_info->port_of_loading->name }} <br>
                                <strong>Airport of Discharge</strong>
                                {{ @$invoice->job_master->bl_master->bl_booking_info->port_of_discharge->name }}
                            @elseif($hide_port_of_loading == 'false' && $hide_port_of_discharge == 'true')
                                <strong>Airport of Loading</strong>
                                {{ @$invoice->job_master->bl_master->bl_booking_info->port_of_loading->name }}
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'false')
                                <strong>Airport of Discharge</strong>
                                {{ @$invoice->job_master->bl_master->bl_booking_info->port_of_discharge->name }}
                            @elseif($hide_port_of_loading == 'true' && $hide_port_of_discharge == 'true')
                            @endif
                        @endif
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <strong>Destination Port</strong>
                        {{ @$invoice->job_master->job_routing->final_destination->name }}
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if ($hide_sa_line == 'false')
                            @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 2)
                                <strong>Shipping Line</strong>
                                {{ @$invoice->job_master->job_detail->shipping_line->name }}
                            @elseif (@$invoice->job_master->operation_id == 3 || @$invoice->job_master->operation_id == 4)
                                <strong>Air Line</strong> {{ @$invoice->job_master->job_vessel->airline->name }}
                            @endif
                        @endif
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column2" style="display: flex; gap: 110px; border: 1px solid; width: 100%;height: 47px;">
                    @if ($hide_volume == 'false')
                        <div>
                            <strong>Volume</strong> {{ @$invoice->job_master->job_weight->vol }}
                        </div>
                    @endif
                    <div>
                        <strong>Weight</strong> {{ @$invoice->job_master->job_weight->weight }}
                    </div>
                    <div>
                        @if ($invoice->job_master->bl_master)
                            @if ($invoice->job_master->bl_master->bl_container_info->isNotEmpty())
                                @php
                                    $total20 = 0;
                                    $total40 = 0;
                                @endphp
                                @foreach ($invoice->job_master->bl_master->bl_container_info as $detail)
                                    @php
                                        if (
                                            !empty($detail->container_size_type) &&
                                            $detail->container_size_type !== 'Please Select' &&
                                            $detail->container_size_type !== 'M3'
                                        ) {
                                            if (substr($detail->container_size_type, 0, 2) === '20') {
                                                $total20++;
                                            } else {
                                                $total40++;
                                            }
                                        }
                                    @endphp
                                @endforeach
                            @endif
                        @endif
                        @php
                            $pcsText = '';
                            if ($total20) {
                                $pcsText .= $total20 . ' x 20';
                            }
                            if ($total40) {
                                $pcsText .= ($pcsText ? ', ' : '') . $total40 . ' x 40';
                            }
                        @endphp
                        <strong>PCS</strong> {{ $pcsText ?: @$invoice->job_master->job_weight->pcs ?? '-' }}
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <strong>Currency</strong>{{ @$invoice->transaction_charges[0]->currency_name->name }}

                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if ($hide_exchange_rate == 'false')
                            <strong>Exchange Rate</strong>
                        @endif
                        {{-- <p>283.300000</p> --}}
                    </div>
                </td>
            </tr>
            @if ($show_container == 'true')
                <tr>
                    <td colspan="2" style="border: 1px solid; padding: 8px;">
                        <strong>Container # </strong> {{ @$containerNo }}
                    </td>
                </tr>
            @endif
        </table>

        <table>
            <!-- Table Headings -->
            <tr>
                <th class="column-heading">SR#</th>
                <th class="column-heading">Name</th>
                <th class="column-heading">Qty</th>
                <th class="column-heading">Rate</th>
                <th class="column-heading">Currency</th>
                <th class="column-heading">Amount</th>
                <th class="column-heading">Dis</th>
                <th class="column-heading">Tax</th>
                <th class="column-heading">Total Amount</th>
            </tr>

            <!-- Table Rows -->
            @if ($invoice->transaction_charges)
                @foreach ($invoice->transaction_charges as $index => $charges)
                    @php
                        $currencyCodes = [
                            'PAK RUPEES' => 'PKR',
                            'US DOLLAR' => 'USD',
                            'DIRHAM' => 'AED',
                            'POUND' => 'GBP',
                            'EURO' => 'EUR',
                            'BDT' => 'BDT',
                            'OMANI RIYAL' => 'OMR',
                        ];
                    @endphp
                    <tr>
                        <td class="sr">{{ $index + 1 }}</td>
                        <td class="name">{{ $charges->charge->name }}</td>
                        <td class="qty">{{ $charges->qty }}</td>
                        <td class="rate">{{ $charges->rate }}</td>
                        <td class="curr">
                            {{ $currencyCodes[$charges->currency_name->name] ?? $charges->currency_name->name }}
                        </td>
                        <td class="amount">{{ number_format(floor($charges->local_amount * 100) / 100, 2) }}</td>
                        <td class="dis">{{ $charges->discount }}</td>
                        <td class="tax">{{ $charges->tax }}</td>
                        <td class="total">{{ number_format(floor($charges->local_amount * 100) / 100, 2) }}</td>
                    </tr>
                @endforeach
            @endif
        </table>
        <table style="width: 100%; border: 1px solid; border-collapse: collapse; margin-top: 10px; text-align: left;">
            <tr>
                <th style="border: 1px solid; padding: 8px;">Total Discount</th>
                <td style="border: 1px solid; padding: 8px;">{{ @$invoice->grand_discount }}</td>
                <th style="border: 1px solid; padding: 8px;">Tax Amount</th>
                <td style="border: 1px solid; padding: 8px;">{{ @$invoice->grand_tax_amount }}</td>
                <th style="border: 1px solid; padding: 8px;">
                    <p style="margin: 0;">Total Amount</p>
                    <p style="margin: 0;">Round Off</p>
                    <p style="margin: 0;">Total Amount</p>
                </th>
                <td style="border: 1px solid; padding: 8px;">
                    <p style="margin: 0;">{{ number_format(@$invoice->grand_local_amount, 2) }}</p>
                    <p style="margin: 0;">
                        @php
                            $rounded = round(@$invoice->grand_local_amount);
                            $original = round(@$invoice->grand_local_amount, 2);
                            $roundOff = number_format($rounded - $original, 2);
                        @endphp
                        {{ $roundOff }}
                    </p>
                    <p style="margin: 0;">{{ number_format(@$invoice->grand_local_amount, 0) }}</p>
                </td>
            </tr>
        </table>
        <table style="width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 10px;">
            <tr>
                <th style="width: 50%; border: 1px solid; padding: 5px;">Note:</th>
                <th style="width: 50%; border: 1px solid; padding: 5px;">In-Words</th>
            </tr>
            <tr>
                <td style="border: 1px solid; padding: 5px; padding-bottom: 30px;">
                    @if ($print_invoice_note == 'false')
                        <p>INVOICE IS SYSTEM GENERATED, SIGNATURE NOT REQUIRED: <br>
                            If any discrepancy is noticed in the invoice, kindly inform us in writing <br>
                            within 7 days, otherwise, the above amount will be considered as correct.
                        </p>
                    @else
                        <p>{{ $invoice_note }}</p>
                    @endif
                </td>
                <td style="border: 1px solid; padding: 5px;">
                    @php
                        $formatter = new \NumberFormatter('en', \NumberFormatter::SPELLOUT);
                        $amountInWords = strtoupper($formatter->format(@$invoice->grand_local_amount));
                    @endphp
                    <p>PKR {{ @$amountInWords }}</p>
                </td>
            </tr>
        </table>

        @if ($show_bank == 'true')
            <table style="width: 100%; border-collapse: collapse; margin-top: 15px;">
                <tr>
                    <th style="border: 1px solid; padding: 5px;">Bank Detail</th>
                </tr>
                <tr>
                    <td style="border: 1px solid; padding: 5px; padding-bottom: 30px;">
                        <p>{{ $invoice->bank_details }}</p>
                    </td>
                </tr>
            </table>
        @endif

        @if ($msg_of_system_generated_invoice == 'true')
            <p style="margin-top:15px;">This is computer generated invoice and does not need any signature</p>
        @endif

    </div>
</body>

</html>
