@extends('layout.master')

@section('title')
    @if (Request::is('se_job/add'))
        Add SE Job - YARAN
    @elseif(Request::is('si_job/add'))
        Add SI Job - YARAN
    @elseif(Request::is('ae_job/add'))
        Add AE Job - YARAN
    @elseif(Request::is('ai_job/add'))
        Add AI Job - YARAN
    @endif
@endsection

@section('topbar')
    @if (Request::is('se_job/add'))
        <a href="/se_job" class="breadcrumb-item">SE Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a
            href="" class="breadcrumb--active">Add</a>
    @elseif(Request::is('si_job/add'))
        <a href="/si_job" class="breadcrumb-item">SI Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a
            href="" class="breadcrumb--active">Add</a>
    @elseif(Request::is('ae_job/add'))
        <a href="/ae_job" class="breadcrumb-item">AE Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a
            href="" class="breadcrumb--active">Add</a>
    @elseif(Request::is('ai_job/add'))
        <a href="/ai_job" class="breadcrumb-item">AI Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a
            href="" class="breadcrumb--active">Add</a>
    @endif
@endsection
@section('content')
    <!-- BEGIN: Input -->
    <form method="POST" id="myForm" action="{{ url('se_job/add') }}" enctype="multipart/form-data" class="row g-3">
        @csrf
        <div class="intro-y box">
            <div
                class="d-flex flex-column flex-sm-row align-items-center py-3 px-5 border-bottom border-gray-200 dark-border-dark-5">
                <h2 class="fw-medium fs-base me-auto">
                    @if (Request::is('se_job/add'))
                        Add SE Job
                    @elseif(Request::is('si_job/add'))
                        Add SI Job
                    @elseif(Request::is('ae_job/add'))
                        Add AE Job
                    @elseif(Request::is('ai_job/add'))
                        Add AI Job
                    @endif
                </h2>
                <button type="submit" class="btn btn-primary submitBtn me-2" id="submitBtn">Save</button>
                <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                    Back
                </a>
            </div>
            <input type="hidden" name="tabId" id="tabId" value="">

            <div class="intro-y pe-3">
                @if (Request::is('se_job/add'))
                    <input type="hidden" name="operation_id" value="1">
                @elseif(Request::is('si_job/add'))
                    <input type="hidden" name="operation_id" value="2">
                @elseif(Request::is('ae_job/add'))
                    <input type="hidden" name="operation_id" value="3">
                @elseif(Request::is('ai_job/add'))
                    <input type="hidden" name="operation_id" value="4">
                @endif
                <div class="box p-2">
                    <ul class="nav nav-pills rounded-2" role="tablist">
                        <li id="booking_info_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5 active" data-bs-toggle="pill"
                                data-bs-target="#booking_info" type="button" role="tab"
                                aria-controls="booking_info_tab" aria-selected="true">Booking Info</button>
                        </li>
                        @if (Request::is('se_job/add') || Request::is('si_job/add'))
                            <li id="equipments_tab" class="nav-item flex-1" role="presentation">
                                <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                    data-bs-target="#equipments" type="button" role="tab"
                                    aria-controls="equipments_tab" aria-selected="false">Equipments</button>
                            </li>
                        @endif
                        <li id="charges_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill" data-bs-target="#charges"
                                type="button" role="tab" aria-controls="charges_tab"
                                aria-selected="false">Charges</button>
                        </li>
                        <li id="routing_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill" data-bs-target="#routing"
                                type="button" role="tab" aria-controls="routing_tab"
                                aria-selected="false">Routing</button>
                        </li>
                        <li id="other_info_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                data-bs-target="#other_info" type="button" role="tab"
                                aria-controls="other_info_tab" aria-selected="false">Other
                                Info</button>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="tab-content mt-2">
                <div class="tab-pane fade show active" id="booking_info" role="tabpanel"
                    aria-labelledby="booking_info_tab">
                    @include('sea_export.se_job.tabs.booking_info')
                </div>
                <div class="tab-pane fade" id="equipments" role="tabpanel" aria-labelledby="equipments_tab">
                    {{-- <div class="text-end me-5">
                        <button id="addRowEquipmentBtn" type="button" class="btn btn-primary my-2">Add Row</button>
                    </div> --}}
                    @include('sea_export.se_job.tabs.equipment')
                </div>
                <div class="tab-pane fade" id="charges" role="tabpanel" aria-labelledby="charges_tab">
                    @include('sea_export.se_job.tabs.charges')
                </div>
                <div class="tab-pane fade" id="routing" role="tabpanel" aria-labelledby="routing_tab">
                    @if (Request::is('se_job/add') || Request::is('si_job/add'))
                        @include('sea_export.se_job.tabs.routing')
                    @elseif (Request::is('ae_job/add') || Request::is('ai_job/add'))
                        @include('sea_export.se_job.tabs.ae_job_routing')
                    @endif
                </div>
                <div class="tab-pane fade" id="other_info" role="tabpanel" aria-labelledby="other_info_tab">
                    @if (Request::is('se_job/add'))
                        @include('sea_export.se_job.tabs.other_info')
                    @elseif(Request::is('si_job/add'))
                        @include('sea_export.se_job.tabs.si_job_other_info')
                    @elseif(Request::is('ae_job/add'))
                        @include('sea_export.se_job.tabs.ae_job_other_info')
                    @elseif(Request::is('ai_job/add'))
                        @include('sea_export.se_job.tabs.ai_job_other_info')
                    @endif
                </div>
            </div>
    </form>
    </div>
    @include('sea_export.se_job.modals.addParty')
    @include('sea_export.se_job.modals.addCommodity')
    @include('sea_export.se_job.modals.addUnLocation')
    @include('sea_export.se_job.modals.addEmployee')
    @include('sea_export.se_job.modals.addVessel')
    @include('sea_export.se_job.modals.addVoyage')
    @include('sea_export.se_job.modals.addCharge')
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Include Tom Select JS -->
<script src="https://cdn.jsdelivr.net/npm/tom-select/dist/js/tom-select.complete.min.js"></script>

{{-- <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script> --}}
<script>
    $(document).ready(function() {

        $(window).keydown(function(event) {
            if (event.keyCode == 13) {
                event.preventDefault();
                return false;
            }
        });

        // Get the tab ID from the URL query parameter
        var urlParams = new URLSearchParams(window.location.search);
        var tabId = urlParams.get('tab');
        var innerTabId = urlParams.get('inner_tab');

        // Strip any query parameters from the tabId, just in case
        if (tabId) {
            tabId = tabId.split('?')[0]; // Remove anything after ?

            $('button[data-bs-target="#' + tabId + '"]').tab('show');
            console.log('inner Tab ID:', innerTabId);
            if (innerTabId) {
                $('button[data-bs-target="#' + innerTabId + '"]').tab('show');
            }
        }
    });
</script>

<script>
    $(document).ready(function() {

        $('#submitBtn').on('click', function(e) {
            // Validate form and check if it's valid
            var isValid = validateFormAndSubmit();

            // If form is valid, allow submission (or continue with your submission logic)
            if (isValid) {
                // You can proceed with form submission or any other action
                console.log(
                    'Form is valid. Proceeding with submission...');
            } else {
                // Prevent default form submission if there are errors
                e.preventDefault();
                console.log(
                    'Form submission prevented due to validation errors.'
                );
            }
        });

        function validateFormAndSubmit() {
            var formIsValid = true;

            // Reset validation states and hide all error messages
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').hide();

            if ($('#client_id').val() === '') {
                $('#client_id').addClass('is-invalid');
                $('#client_id').nextAll('.invalid-feedback').first().show();
                formIsValid = false;
            }

            // Additional scenario-based validation
            if (window.location.pathname.includes('se_job/add') || window.location.pathname.includes(
                    'ae_job/add')) {
                if ($('#shipper_id').val() === '' || $('#final_destination_id').val() === '') {
                    $('#shipper_id').addClass('is-invalid');
                    $('#final_destination_id').addClass('is-invalid');
                    $('#shipper_id').nextAll('.invalid-feedback').first().show();
                    $('#final_destination_id').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
            } else if (window.location.pathname.includes(
                    'ai_job/add')) {
                if ($('#consignee_id').val() === '' || $('#final_destination_id').val() === '') {
                    $('#consignee_id').addClass('is-invalid');
                    $('#final_destination_id').addClass('is-invalid');
                    $('#consignee_id').nextAll('.invalid-feedback').first().show();
                    $('#final_destination_id').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
            }

            // If form is not valid, prevent submission and show Swal alert
            if (!formIsValid) {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please fill all required fields",
                    showConfirmButton: false,
                    timer: 2500
                });
            }

            return formIsValid; // Return form validity status
        }

        // Update the hidden input value when the tab changes
        $('button[data-bs-toggle="pill"]').on('shown.bs.tab', function(e) {
            var tabId = $(e.target).attr('data-bs-target').substr(1); // Get the tab ID
            $('#tabId').val(tabId); // Set the tab ID in the hidden input
        });
        $('.ex_rate_edit').on('change', function() {
            // e.preventDefault();
            console.log("ex_rate_edit is change");
            if ($(this).is(':checked')) {
                $('.payable_ex_rate, .receivable_ex_rate').removeAttr('readonly'); // Remove readonly
            } else {
                $('.payable_ex_rate, .receivable_ex_rate').attr('readonly', 'readonly'); // Add readonly
            }
        });

    });
</script>
<script>
    //shipper select same as client select
    function selectSameOption(sourceDropdownId, targetDropdownId) {
        // Get the ID of the source dropdown
        var selectedValue = document.getElementById(sourceDropdownId).value;
        var targetDropdown = document.getElementById(targetDropdownId);
        targetDropdown.value = selectedValue;
        // console.log("Source Dropdown ID:", selectedValue);
        // console.log("Target Dropdown ID:", targetDropdown.value);

        // Trigger change event on target dropdown
        var event = new Event('change');
        targetDropdown.dispatchEvent(event);
    }

    function selectSameOptionTwo(sourceDropdownId) {
        var selectedValue = document.getElementById(sourceDropdownId).value;

        // Update the selected option in each dependent dropdown
        document.getElementById('port_of_discharge_id').value = selectedValue;
        document.getElementById('final_destination_id').value = selectedValue;
        document.getElementById('point_of_discharge_id').value = selectedValue;
        document.getElementById('routing_port_of_discharge_id').value = selectedValue;
        document.getElementById('routing_final_destination_id').value = selectedValue;
        document.getElementById('routing_place_of_receipt_id').value = selectedValue;

        // console.log(document.getElementById('routing_port_of_loading_id'))
        // Trigger change event on each dependent dropdown
        ['port_of_discharge_id', 'final_destination_id', 'routing_port_of_loading_id', 'routing_place_of_receipt_id',
            'routing_final_destination_id', 'point_of_discharge_id'
        ].forEach(function(dropdownId) {
            var event = new Event('change');
            document.getElementById(dropdownId).dispatchEvent(event);
        });
    }
</script>
<script>
    $(document).ready(function() {

        $('#add-coa').hide();
        $('#party_is').change(function() {
            var partyIs = $(this).val();
            if (partyIs == 'customer_vendor') {
                $('#add-coa').show();
            } else {
                $('#add-coa').hide();
            }
        });

        $('#party-name').on('input', function() {
            let partyNameValue = $(this).val();
            $('#coa_name').val(partyNameValue);
            $('#alias').val(partyNameValue);

        });

        $('#vessel_id').change(function() {
            var vesselId = $(this).val();

            if (vesselId) {
                $.ajax({
                    url: '/api/get-voyage-details/' + vesselId,
                    type: 'GET',
                    success: function(data) {
                        console.log('response', data);

                        // Clear the current options in the select
                        $('#voyage_id').empty();

                        // Add "Please Select" as the default option
                        $('#voyage_id').append('<option value="">Please Select</option>');

                        // Loop through the returned data and append the options
                        data.forEach(function(item) {
                            $('#voyage_id').append('<option value="' + item.id +
                                '">' + item.voyage_no + '</option>');
                        });

                        // Select the last option added
                        $('#voyage_id option:last').prop('selected', true);

                        // Trigger the change event to refresh select2
                        $('#voyage_id').trigger('change');
                    },
                    error: function() {
                        $('#voyage_id').empty().append(
                            '<option value="">Please Select</option>');
                        @foreach ($voyages as $item)
                            $('#voyage_id').append(
                                '<option value="{{ $item->id }}">{{ $item->voyage_no }}</option>'
                            );
                        @endforeach

                        // Select the last option added
                        $('#voyage_id option:last').prop('selected', true);

                        $('#voyage_id').trigger('change');
                    }
                });
            } else {
                // If no vessel selected, show all available options
                $('#voyage_id').empty().append('<option value="">Please Select</option>');
                @foreach ($voyages as $item)
                    $('#voyage_id').append(
                        '<option value="{{ $item->id }}">{{ $item->voyage_no }}</option>');
                @endforeach

                // Select the last option added
                $('#voyage_id option:last').prop('selected', true);

                $('#voyage_id').trigger('change');
            }
        });

        $('#voyage_id').change(function() {
            var voyageId = $(this).val();

            if (voyageId) {
                $.ajax({
                    url: '/api/get-voyages-details/' + voyageId,
                    type: 'GET',
                    success: function(data) {
                        console.log('response', data);

                        // Clear the current options in the select
                        $('#etd').empty();
                        $('#eta').empty();
                        $('#cut_off').empty();

                        // Loop through the returned data and set the values
                        data.forEach(function(item) {
                            $('#etd').val(item
                                .export_sailing_date
                            ); // Set the value of 'etd' input
                            $('#eta').val(item
                                .export_dest_eta); // Set the value of 'eta' input
                            $('#cut_off').val(item.export_cut_of_date + ' ' + item
                                .export_cut_of_time
                            ); // Set the value of 'cut_off' input
                        });

                    },
                    error: function() {

                    }
                });
            } else {

            }
        });


        var clickedLabel = '';

        $('.add-charge').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addCharge').modal('show');
        });

        $('.add-commodity').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addCommodity').modal('show');
        });

        $('.add-party').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addParty').modal('show');
            $("#country_id").select2({
                dropdownParent: "#addParty"
            });
            $('#city_id').select2({
                dropdownParent: "#addParty"
            });
            // $('#operation_id').select2({ dropdownParent: "#addParty" });
            // $('#type_id').select2({ dropdownParent: "#addParty" });
        });

        $('.add-employee').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addEmployee').modal('show');
        });

        $('.add-un_location').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addUnLocation').modal('show');
        });

        $('.add-vessel').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addVessel').modal('show');
        });

        $('.add-voyage').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addVoyage').modal('show');
        });

        $('.modal form').submit(function(e) {
            e.preventDefault();
            var formData = $(this).serialize();
            var apiUrl = $(this).closest('.modal').data('api-url');

            $.ajax({
                url: apiUrl,
                type: 'POST',
                data: formData,
                success: function(response) {
                    console.log(response);
                    // Append the response data to the options of the clicked label
                    if (clickedLabel == 'sales_rep_id') {
                        var optionHtml = '<option value="' + response.data.id + '">' +
                            response.data.employee_name + '</option>';
                    } else if (clickedLabel == 'voyage_id') {
                        var optionHtml = '<option value="' + response.data.id + '">' +
                            response.data.voyage_no + '</option>';
                    } else {
                        var optionHtml = '<option value="' + response.data.id + '">' +
                            response.data.name + '</option>';
                    }
                    // Get the select element based on the clicked label
                    var selectElement = $('#' + clickedLabel);

                    if (clickedLabel == 'charge_id') {
                        $('.receivable_charge_id').append(optionHtml);
                        $('.payable_charge_id').append(optionHtml);
                    }
                    if (clickedLabel == 'customer_id') {
                        $('.receivable_customer_id').append(optionHtml);
                    }
                    if (clickedLabel == 'vendor_id') {
                        $('.payable_vendor_id').append(optionHtml);
                    }

                    if (clickedLabel == 'vessel_id') {
                        $('#vessel_modal').append(optionHtml);
                    }

                    if (clickedLabel == 'final_destination_id') {
                        $('#port_of_discharge_id').append(optionHtml);
                        $('#port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_discharge_id').append(optionHtml);
                        $('#routing_final_destination_id').append(optionHtml);
                        $('#point_of_discharge_id').append(optionHtml);
                        $('#point_of_loading_id').append(optionHtml);
                    }

                    if (clickedLabel == 'port_of_discharge_id') {
                        $('#final_destination_id').append(optionHtml);
                        $('#port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_discharge_id').append(optionHtml);
                        $('#routing_final_destination_id').append(optionHtml);
                        $('#point_of_discharge_id').append(optionHtml);
                        $('#point_of_loading_id').append(optionHtml);
                    }
                    if (clickedLabel == 'port_of_loading_id') {
                        $('#port_of_discharge_id').append(optionHtml);
                        $('#final_destination_id').append(optionHtml);
                        $('#routing_port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_discharge_id').append(optionHtml);
                        $('#routing_final_destination_id').append(optionHtml);
                        $('#point_of_discharge_id').append(optionHtml);
                        $('#point_of_loading_id').append(optionHtml);
                    }

                    // Parse formData using URLSearchParams
                    var params = new URLSearchParams(formData);

                    // Get all type_id values
                    var typeIdsArray = params.getAll('type_id[]');

                    if (typeIdsArray.includes('1') && clickedLabel != 'shipper_id') {
                        $('#shipper_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('2') && clickedLabel != 'consignee_id') {
                        $('#consignee_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('11') && clickedLabel !=
                        'custom_clearance_id') {
                        $('#custom_clearance_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('10') && clickedLabel !=
                        'transportation_id') {
                        $('#transportation_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('5') && clickedLabel !=
                        'forwarder_coloader_id') {
                        $('#forwarder_coloader_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('12') && clickedLabel != 'shipping_line_id') {
                        $('#shipping_line_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('6') && clickedLabel != 'local_vendor_id') {
                        $('#local_vendor_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('7') && clickedLabel != 'overseas_agent_id') {
                        $('#overseas_agent_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('17') && clickedLabel != 'air_line_id') {
                        $('#air_line_id').append(optionHtml);
                        $('#airline_id').append(optionHtml);
                    }
                    if (typeIdsArray.includes('17') && clickedLabel != 'airline_id') {
                        $('#air_line_id').append(optionHtml);
                        $('#airline_id').append(optionHtml);
                    }

                    // Append the new option to the select element
                    selectElement.append(optionHtml);
                    $('.modal select option').prop('selected', false);

                    // Clear the form inputs
                    $('.modal').find('input, textarea, select').val('');
                    $('.modal').find('select').each(function() {
                        var tomSelectInstance = this.tomselect;
                        if (tomSelectInstance) {
                            tomSelectInstance
                                .clear(); // Clear the selected value(s)
                            // Do not call clearOptions() to keep the options list
                        }
                    });
                    $('.modal').find('select.select2').each(function() {
                        $(this).val(null).trigger(
                            'change'); // Reset the Select2 elements
                    });
                    $('.modal').modal('hide');
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', status, error);
                    console.error('Response text:', xhr.responseText);

                    let errorMessage = 'An unexpected error occurred.';
                    if (xhr.status === 422) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            errorMessage = response.message || errorMessage;
                        } catch (e) {
                            console.error('Error parsing JSON response:', e);
                        }
                    } else {
                        // Handle other types of errors
                    }
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'error',
                        title: errorMessage,
                        showConfirmButton: false,
                        timer: 2500
                    });
                }
            });

        });
    });
</script>

<script>
    $(document).ready(function() {
        let sellingValue = 0;
        let buyingValue = 0;
        $('input[name="selling"]').on('input', function() {
            sellingValue = $(this).val();
            $('input[name="receivable_ex_rate[]"]').val(sellingValue);
            updateReceivableExRate();
        });

        $('input[name="buying"]').on('input', function() {
            buyingValue = $(this).val();
            $('input[name="payable_ex_rate[]"]').val(buyingValue);
            updatePayableExRate();
        });

        $('select[name="vessel_id"]').on('change', function() {
            var vesselValue = $(this).val();
            $('select[name="feeder_vessel_id"]').val(vesselValue);
        });

        $('select[name="voyage_id"]').on('change', function() {
            var voyageValue = $(this).val();
            $('select[name="routing_voyage_id"]').val(voyageValue);
        });
        $('select[name="port_of_loading_id"]').on('change', function() {
            var portOfLoading = $(this).val();
            document.getElementById('point_of_loading_id').value = portOfLoading;
            document.getElementById('routing_port_of_loading_id').value = portOfLoading;
            // $('select[name="routing_voyage_id"]').val(voyageValue);
        });

        $('#tax_total_receivable').on('input', function() {
            updatePPCCReceiveable();
        });

        $('#tax_total_payable').on('input', function() {
            updatePPCCPayable();
        });

        var rowEquipmentCounter = 1;

        function addRow() {
            var newRow = '<tr>' +
                '<td class="text-nowrap">' + rowEquipmentCounter +
                '<input type="hidden" name="equipment_rows" value=' + rowEquipmentCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDropdown('equipment_size_type[]', dropdownOptions.sizeType) +
                '</td>' +
                '<td><input type="text" name="equipment_rate_group[]" class="form-control"></td>' +
                '<td><input type="text" name="equipment_qty[]" class="form-control"></td>' +
                '<td class="text-nowrap">' + createDropdown('equipment_dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td><input type="text" name="equipment_gross_wt_cnt[]" class="form-control"></td>' +
                '<td><input type="text" name="equipment_teu[]" class="form-control"></td>' +
                '</tr>';
            $('#equipmentTable tbody').append(newRow);
            rowEquipmentCounter++;
        }

        $('#addRowEquipmentBtn').click(function() {
            addRow();
        });

        const dropdownOptions = {
            customers: {!! json_encode($clients) !!},
            vendors: {!! json_encode($vendors) !!},
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: ["PKR", "USD", "AED", "GBP", "EUR", "BDT", "OMR"],
            approvedUsers: {!! json_encode($usersWithApprovedPermission) !!}
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please Select</option>';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createCurrencyDropdown(name, currencies) {
            let dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please Select</option>';
            currencies.forEach((currency, index) => {
                dropdown += '<option value="' + (index + 1) + '">' + currency + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="select2 w-32">';
            dropdown += '<option value="">Please Select</option>';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdownId(name, classname, options) {
            let dropdown = '<select name="' + name + '" class="select2 w-32 ' + classname + '">';
            dropdown += '<option value="">Please Select</option>';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '" data-currency-id="' + option
                    .currency_id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-32" placeholder="' +
                    placeholder + '">';
            }
        }

        function createReadOnly(type, name, placeholder) {
            if (type === "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '" value="1" class="form-check-input" disabled="disabled" placeholder="' + placeholder +
                    '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' + placeholder + '" readonly>';
            }
        }

        function createInputValueReadonly(type, name, value, classname) {
            return '<input type="' + type + '" name="' + name +
                '" value="' + value + '" class="form-control w-24 ' + classname + '" readonly>';
        }

        function createInputValue(type, name, placeholder, value) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '" value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" value="' + value + '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        function calculateAmountPayable(inputField) {
            let row = inputField.closest('tr');
            let qty = parseFloat(row.find('input[name^="payable_qty"]').val());
            let rate = parseFloat(row.find('input[name^="payable_ratee"]').val());
            let discount = parseFloat(row.find('input[name^="payable_discount"]').val());
            let taxAmount = parseFloat(row.find('input[name^="payable_tax_amount_lc"]').val());
            let payableExRate = parseFloat(row.find('input[name^="payable_ex_rate"]').val());
            let tax = taxAmount / payableExRate;
            let amount = 0;
            let totalAmount = 0;

            if (!isNaN(qty) && !isNaN(rate)) {
                amount = qty * rate;
                totalAmount = amount - discount;
                row.find('input[name^="payable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else if (!isNaN(rate)) {
                amount = rate;
                totalAmount = amount - discount;
                row.find('input[name^="payable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else {
                row.find('input[name^="payable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            }

            if (!isNaN(discount) && !isNaN(tax)) {
                totalAmount = (amount + tax) - discount;
                row.find('input[name^="payable_net_amount"]').val(totalAmount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else if (!isNaN(discount)) {
                totalAmount = amount - discount;
                row.find('input[name^="payable_net_amount"]').val(totalAmount.toFixed(2));
            } else if (!isNaN(tax)) {
                totalAmount = amount + tax;
                row.find('input[name^="payable_net_amount"]').val(totalAmount.toFixed(2));
            } else {
                totalAmount = amount;
                row.find('input[name^="payable_net_amount"]').val(totalAmount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            }
            updatePPCCPayable();
            updatePayableExRate();
        }

        let receivableTotal = 0;
        let payableTotal = 0;
        let net = 0;
        let principalReceivableTotal = 0;
        let principalPayableTotal = 0;
        let principalNet = 0;

        function calculateNet() {
            receivableTotal = parseFloat($('#total_receivable').val()) || 0;
            payableTotal = parseFloat($('#total_payable').val()) || 0;
            net = 0;

            if (!isNaN(receivableTotal) && !isNaN(payableTotal)) {
                net = receivableTotal - payableTotal;
            }
            $('#net').val(net.toFixed(2));
        }

        function calculatePrincipalNet() {
            principalReceivableTotal = parseFloat($('#principal_receivable').val()) || 0;
            principalPayableTotal = parseFloat($('#principal_payable').val()) || 0;
            principalNet = 0;
            if (!isNaN(principalReceivableTotal) && !isNaN(principalPayableTotal)) {
                principalNet = principalReceivableTotal - principalPayableTotal;
            }
            $('#principal_net').val(principalNet.toFixed(2));
        }

        let taxAmountPayable = 0;

        function updatePPCCPayable() {
            ppPayableTotal = 0;
            ccPayableTotal = 0;
            principalPayable = 0;
            taxAmountPayable = parseFloat($('#tax_total_payable').val()) || 0;
            totalAmount = 0;

            $('#payableTable tbody tr').each(function() {
                let row = $(this);
                let ppCcValue = row.find('select[name^="payable_ppcc"]').val();
                let netAmount = parseFloat(row.find('input[name^="payable_local_amount"]').val()) || 0;

                if (ppCcValue === 'PP') {
                    ppPayableTotal += netAmount;
                    totalAmount += netAmount;
                } else if (ppCcValue === 'CC') {
                    ccPayableTotal += netAmount;
                    totalAmount += netAmount;
                }

                principalPayable += netAmount;
            });

            if (!isNaN(taxAmountPayable)) {
                totalAmount = totalAmount + taxAmountPayable;
            }

            // Update the respective fields or display the totals somewhere on the page
            $('#pp_payable_total').val(ppPayableTotal.toFixed(2));
            $('#cc_payable_total').val(ccPayableTotal.toFixed(2));
            $('#principal_payable').val(principalPayable.toFixed(2));
            $('#total_payable').val(totalAmount.toFixed(2));
            calculateNet();
            calculatePrincipalNet();
        }

        function calculateAmountReceiveable(inputField) {
            let row = inputField.closest('tr');
            let qty = parseFloat(row.find('input[name^="receivable_qty"]').val());
            let rate = parseFloat(row.find('input[name^="receivable_ratee"]').val());
            let discount = parseFloat(row.find('input[name^="receivable_discount"]').val());
            let taxAmount = parseFloat(row.find('input[name^="receivable_tax_amount_lc"]').val());
            let receivableExRate = parseFloat(row.find('input[name^="receivable_ex_rate"]').val());
            let tax = taxAmount / receivableExRate;
            let amount = 0;
            let totalAmount = 0;

            if (!isNaN(qty) && !isNaN(rate)) {
                amount = qty * rate;
                totalAmount = amount - discount;
                row.find('input[name^="receivable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else if (!isNaN(rate)) {
                amount = rate;
                totalAmount = amount - discount;
                row.find('input[name^="receivable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else {
                row.find('input[name^="receivable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            }

            if (!isNaN(discount) && !isNaN(tax)) {
                totalAmount = (amount + tax) - discount;
                row.find('input[name^="receivable_net_amount"]').val(totalAmount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else if (!isNaN(discount)) {
                totalAmount = amount - discount;
                row.find('input[name^="receivable_net_amount"]').val(totalAmount.toFixed(2));
            } else if (!isNaN(tax)) {
                totalAmount = amount + tax;
                row.find('input[name^="receivable_net_amount"]').val(totalAmount.toFixed(2));
            } else {
                totalAmount = amount;
                row.find('input[name^="receivable_net_amount"]').val(totalAmount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            }

            updatePPCCReceiveable();
            updateReceivableExRate();
        }

        let taxAmountReceiveable = 0;

        function updatePPCCReceiveable() {
            ppReceivableTotal = 0;
            ccReceivableTotal = 0;
            principalReceivable = 0;
            taxAmountReceiveable = parseFloat($('#tax_total_receivable').val()) || 0;
            totalAmount = 0;

            $('#receiveableTable tbody tr').each(function() {
                let row = $(this);
                let ppCcValue = row.find('select[name^="receivable_ppcc"]').val();
                let netAmount = parseFloat(row.find('input[name^="receivable_local_amount"]').val()) ||
                    0;

                if (ppCcValue === 'PP') {
                    ppReceivableTotal += netAmount;
                    totalAmount += netAmount;
                } else if (ppCcValue === 'CC') {
                    ccReceivableTotal += netAmount;
                    totalAmount += netAmount;
                }

                principalReceivable += netAmount;
            });

            if (!isNaN(taxAmountReceiveable)) {
                totalAmount = totalAmount + taxAmountReceiveable;
            }

            // Update the respective fields or display the totals somewhere on the page
            $('#pp_receivable_total').val(ppReceivableTotal.toFixed(2));
            $('#cc_receivable_total').val(ccReceivableTotal.toFixed(2));
            $('#principal_receivable').val(principalReceivable.toFixed(2));
            $('#total_receivable').val(totalAmount.toFixed(2));
            calculateNet();
            calculatePrincipalNet();
        }

        let rowPayableCounter = 1;
        let rowReceivableCounter = 1;
        var currentDateFromController = "<?php echo $currentDate; ?>";

        function addRowPayable() {
            let row = '<tr>' +
                '<td class="text-nowrap">' +
                '<button type="button" class="btn btn-danger delete-payable-row">' +
                'Delete' +
                '</button>' +
                '</td>' +
                '<td class="text-nowrap">' + rowPayableCounter +
                '<input type="hidden" name="payable_rows" value=' + rowPayableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_bill_invoice[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdownId('payable_charge_id[]', 'payable_charge_id',
                    dropdownOptions.charges) + '</td>' +
                '<td class="text-nowrap">' +
                '<div class="form-group">' +
                '<input type="text" name="payable_description[]" class="form-control w-52" />' +
                '<div class="invalid-feedback">Description is required</div>' +
                '</div>' +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_type[]', dropdownOptions.type) + '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_basis[]', dropdownOptions.basis) +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_ppcc[]', dropdownOptions.ppcc) + '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_size_type[]', dropdownOptions.sizeType) +
                '</td>' +
                '<td class="text-nowrap">' + createInputValue('text', 'payable_rate_group[]', '', 'ALL') +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'payable_manual[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('number', 'payable_qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_ratee[]', '') + '</td>' +
                '<td class="text-nowrap">' + createCurrencyDropdown('payable_currency[]', dropdownOptions
                    .currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInputValue('text', 'payable_margin[]', '', '0.00') +
                '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_discount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'payable_tax_apply[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'payable_tax_rev_share[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_tax_amount_lc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInputValueReadonly('text', 'payable_ex_rate[]',
                    buyingValue, 'payable_ex_rate') +
                '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_local_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_vendor_code[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('payable_vendor_id[]', dropdownOptions
                    .vendors) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_manifest_remarks[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_tariff_code[]', '') + '</td>' +
                //'<td class="text-nowrap">' + createInput('checkbox', 'payable_approved[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createDynamicDropdown('payable_approved_by[]', dropdownOptions
                //     .approvedUsers) + '</td>' +
                // '<td class="text-nowrap">' + createInputValue('date', 'payable_approved_date[]', '',
                //     currentDateFromController) + '</td>' +
                // '<td class="text-nowrap">' + createInputValue('date', 'payable_approval_log[]', '',
                //     currentDateFromController) + '</td>' +
                '</tr>';
            $('#payableTable tbody').append(row);
            rowPayableCounter++;

            // Attach event listeners to quantity and rate inputs in the newly added row
            $('#payableTable tbody tr:last-child input[name^="payable_qty"], #payableTable tbody tr:last-child input[name^="payable_ratee"], #payableTable tbody tr:last-child input[name^="payable_ex_rate"], #payableTable tbody tr:last-child input[name^="payable_discount"], #payableTable tbody tr:last-child input[name^="payable_tax_amount_lc"]')
                .on('input', function() {
                    calculateAmountPayable($(this));
                });

            // Attach event listener to the newly added charge dropdown
            $('#payableTable tbody tr:last-child select[name^="payable_charge_id"]').on('change', function() {
                checkForDuplicateChargesPayable();
                updateCurrencyBasedOnChargePayable($(this));
                setPayableValues($(this).closest('tr'));
                updatePayableExRate();
            });

            // Attach event listener to the ppcc change
            $('#payableTable tbody tr:last-child select[name^="payable_ppcc"]').on('change', function() {
                updatePPCCPayable();
            });

            // Attach event listener to the ppcc change
            $('#payableTable tbody tr:last-child select[name^="payable_currency"]').on('change', function() {
                calculateAmountPayable($(this));
            });

            // Attach event listener to delete the row when the delete button is clicked
            $('#payableTable tbody tr:last-child .delete-payable-row').on('click', function() {
                $(this).closest('tr').remove();
                rowPayableCounter--;
            });

            // Reinitialize select2 on the newly added dropdowns
            $('.select2').select2();
        }

        function setPayableValues(tr) {
            console.log("Setting payable values for row:");
            console.log(tr);

            // Check if payable_charge_id has a selected value
            var chargeId = $(tr).find('select[name^="payable_charge_id"]').val();
            if (chargeId !== null && chargeId !== '') {
                // Set values based on 'name' attributes of select options within the provided tr
                $(tr).find('select[name^="payable_type"]').val('Inv');
                $(tr).find('select[name^="payable_basis"]').val('Unit');
                $(tr).find('select[name^="payable_ppcc"]').val('PP');
                $(tr).find('select[name^="payable_dg_non_dg"]').val('Non-DG');
            } else {
                $(tr).find('select[name^="payable_type"]').val('');
                $(tr).find('select[name^="payable_basis"]').val('');
                $(tr).find('select[name^="payable_ppcc"]').val('');
                $(tr).find('select[name^="payable_dg_non_dg"]').val('');
            }
        }

        function updateCurrencyBasedOnChargePayable(chargeDropdown) {
            const selectedChargeOption = chargeDropdown.find('option:selected');
            const currencyId = selectedChargeOption.data('currency-id');

            if (currencyId) {
                const currencyDropdown = chargeDropdown.closest('tr').find('select[name^="payable_currency"]');
                console.log(currencyId);
                currencyDropdown.val(currencyId);
            }
        }

        // Function to check for duplicate charges and make description required if duplicates are found
        function checkForDuplicateChargesPayable() {
            let charges = {};
            $('#payableTable tbody tr').each(function() {
                let chargeDropdown = $(this).find('select[name^="payable_charge_id"]');
                let descriptionInput = $(this).find('input[name^="payable_description"]');
                let descriptionContainer = descriptionInput.closest('.form-group');
                let selectedCharge = chargeDropdown.val();

                if (charges[selectedCharge]) {
                    // Duplicate charge found, make description required and add Bootstrap validation classes
                    descriptionInput.prop('required', true);
                    descriptionContainer.addClass('was-validated');
                    descriptionInput.addClass('is-invalid');
                } else {
                    // No duplicate charge, remove required attribute and Bootstrap validation classes
                    descriptionInput.prop('required', false);
                    descriptionContainer.removeClass('was-validated');
                    descriptionInput.removeClass('is-invalid');
                    charges[selectedCharge] = true;
                }
            });
            addRowPayable();
        }


        function addRowReceivable() {
            let row = '<tr>' +
                '<td class="text-nowrap">' +
                '<button type="button" class="btn btn-danger delete-receivable-row">' +
                'Delete' +
                '</button>' +
                '</td>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_bill_invoice[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdownId(
                    'receivable_charge_id[]', 'receivable_charge_id', dropdownOptions
                    .charges) + '</td>' +
                '<td class="text-nowrap">' +
                '<div class="form-group">' +
                '<input type="text" name="receivable_description[]" class="form-control w-52" />' +
                '<div class="invalid-feedback">Description is required.</div>' +
                '</div>' +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_type[]', dropdownOptions.type) +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_basis[]', dropdownOptions.basis) +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_ppcc[]', dropdownOptions.ppcc) +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_size_type[]', dropdownOptions
                    .sizeType) + '</td>' +
                '<td class="text-nowrap">' + createInputValue('text', 'receivable_rate_group[]', '', 'ALL') +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'receivable_manual[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('number', 'receivable_qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_ratee[]', '') + '</td>' +
                '<td class="text-nowrap">' + createCurrencyDropdown('receivable_currency[]', dropdownOptions
                    .currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInputValue('text', 'receivable_margin[]', '', '0.00') +
                '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_discount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'receivable_tax_apply[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'receivable_tax_rev_share[]', '') +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_tax_amount_lc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInputValueReadonly('text', 'receivable_ex_rate[]',
                    sellingValue, 'receivable_ex_rate') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_local_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('receivable_customer_id[]', dropdownOptions
                    .customers) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_manifest_remarks[]', '') +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_tariff_code[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('checkbox', 'receivable_approved[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createDynamicDropdown('receivable_approved_by[]', dropdownOptions
                //     .approvedUsers) + '</td>' +
                // '<td class="text-nowrap">' + createInputValue('date', 'receivable_approved_date[]', '',
                //     currentDateFromController) + '</td>' +
                // '<td class="text-nowrap">' + createInputValue('date', 'receivable_approval_log[]', '',
                //     currentDateFromController) + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;

            // Attach event listeners to quantity and rate inputs in the newly added row
            $('#receiveableTable tbody tr:last-child input[name^="receivable_qty"], #receiveableTable tbody tr:last-child input[name^="receivable_ratee"], #receiveableTable tbody tr:last-child input[name^="receivable_discount"], #receiveableTable tbody tr:last-child input[name^="receivable_ex_rate"], #receiveableTable tbody tr:last-child input[name^="receivable_tax_amount_lc"]')
                .on('input', function() {
                    calculateAmountReceiveable($(this));
                });

            // Attach event listener to the newly added charge dropdown
            $('#receiveableTable tbody tr:last-child select[name^="receivable_charge_id"]').on('change',
                function() {
                    checkForDuplicateCharges();
                    updateCurrencyBasedOnCharge($(this));
                    setReceiveableValues($(this).closest('tr'));
                    updateReceivableExRate();
                });

            $('#receiveableTable tbody tr:last-child select[name^="receivable_currency"]').on('change',
                function() {
                    calculateAmountReceiveable($(this));
                });

            // Attach event listener to the ppcc change
            $('#receiveableTable tbody tr:last-child select[name^="receivable_ppcc"]').on('change', function() {
                updatePPCCReceiveable();
            });

            // Attach event listener to delete the row when the delete button is clicked
            $('#receiveableTable tbody tr:last-child .delete-receivable-row').on('click', function() {
                $(this).closest('tr').remove();
                rowReceivableCounter--;
            });

            // Reinitialize select2 on the newly added dropdowns
            $('.select2').select2();
        }

        function setReceiveableValues(tr) {
            // Check if payable_charge_id has a selected value
            var chargeId = $(tr).find('select[name^="receivable_charge_id"]').val();
            if (chargeId !== null && chargeId !== '') {
                // Set values based on 'name' attributes of select options within the provided tr
                $(tr).find('select[name^="receivable_type"]').val('Inv');
                $(tr).find('select[name^="receivable_basis"]').val('Unit');
                $(tr).find('select[name^="receivable_ppcc"]').val('PP');
                $(tr).find('select[name^="receivable_dg_non_dg"]').val('Non-DG');
            } else {
                $(tr).find('select[name^="receivable_type"]').val('');
                $(tr).find('select[name^="receivable_basis"]').val('');
                $(tr).find('select[name^="receivable_ppcc"]').val('');
                $(tr).find('select[name^="receivable_dg_non_dg"]').val('');
            }
        }

        function updateReceivableExRate() {
            var exRate = $('#ex_rate').val();
            var sellingRate = $('#selling_rate').val();

            $('#receiveableTable tbody tr').each(function() {
                let row = $(this);
                var ReceivableCurrency = row.find('select[name^="receivable_currency"]').val();
                var receivableExRateInput = row.find('input[name^="receivable_ex_rate"]');
                var receivableNetAmount = parseFloat(row.find('input[name^="receivable_net_amount"]')
                    .val()) || 0;
                var localAmountInput = row.find('input[name^="receivable_local_amount"]');

                if (receivableExRateInput.is('[readonly]')) {
                    if (ReceivableCurrency == 2 || exRate == 2) {
                        receivableExRateInput.val(1);
                    } else if (ReceivableCurrency === exRate) {
                        receivableExRateInput.val(sellingRate);
                    } else {
                        receivableExRateInput.val(0);
                    }
                }

                // Calculate local amount if receivable_ex_rate > 0
                var receivableExRate = parseFloat(receivableExRateInput.val());
                if (receivableExRate > 0) {
                    var localAmount = receivableNetAmount * receivableExRate;
                    localAmountInput.val(localAmount);
                } else {
                    localAmountInput.val(0);
                }
            });
            updatePPCCReceiveable();
        }

        function updatePayableExRate() {
            var exRate = $('#ex_rate').val();
            var buyingRate = $('#buying_rate').val();

            $('#payableTable tbody tr').each(function() {
                let row = $(this);
                var payableCurrency = row.find('select[name^="payable_currency"]').val();
                var payableExRateInput = row.find('input[name^="payable_ex_rate"]');
                var payableNetAmount = parseFloat(row.find('input[name^="payable_net_amount"]')
                    .val()) || 0;
                var localAmountInput = row.find('input[name^="payable_local_amount"]');

                if (payableExRateInput.is('[readonly]')) {
                    if (payableCurrency == 2 || exRate == 2) {
                        payableExRateInput.val(1);
                    } else if (payableCurrency === exRate) {
                        payableExRateInput.val(buyingRate);
                    } else {
                        payableExRateInput.val(0);
                    }
                }

                // Calculate local amount if receivable_ex_rate > 0
                var payableExRate = parseFloat(payableExRateInput.val());
                if (payableExRate > 0) {
                    var localAmount = payableNetAmount * payableExRate;
                    localAmountInput.val(localAmount);
                } else {
                    localAmountInput.val(0);
                }
            });
            updatePPCCPayable();
        }

        // Event listeners for changes
        $('#ex_rate').change(function() {
            updateReceivableExRate();
            updatePayableExRate();
        });
        $('#selling_rate').change(updateReceivableExRate);
        $('#buying_rate').change(updatePayableExRate);

        function updateCurrencyBasedOnCharge(chargeDropdown) {
            const selectedChargeOption = chargeDropdown.find('option:selected');
            const currencyId = selectedChargeOption.data('currency-id');

            if (currencyId) {
                const currencyDropdown = chargeDropdown.closest('tr').find(
                    'select[name^="receivable_currency"]');
                console.log(currencyId);
                currencyDropdown.val(currencyId);
            }
        }

        // Function to check for duplicate charges and make description required if duplicates are found
        function checkForDuplicateCharges() {
            let charges = {};
            $('#receiveableTable tbody tr').each(function() {
                let chargeDropdown = $(this).find('select[name^="receivable_charge_id"]');
                let descriptionInput = $(this).find('input[name^="receivable_description"]');
                let descriptionContainer = descriptionInput.closest('.form-group');
                let selectedCharge = chargeDropdown.val();

                if (charges[selectedCharge]) {
                    // Duplicate charge found, make description required and add Bootstrap validation classes
                    descriptionInput.prop('required', true);
                    descriptionContainer.addClass('was-validated');
                    descriptionInput.addClass('is-invalid');
                } else {
                    // No duplicate charge, remove required attribute and Bootstrap validation classes
                    descriptionInput.prop('required', false);
                    descriptionContainer.removeClass('was-validated');
                    descriptionInput.removeClass('is-invalid');
                    charges[selectedCharge] = true;
                }
            });
            addRowReceivable();
        }
        // Function to calculate local amount based on currency and amount
        function calculateLocalAmount(currency, amount) {
            // Define conversion rates for each currency
            var conversionRates = {
                "USD": 278.31,
                "AED": 75.77,
                "BDT": 2.37,
                "OMR": 723.22,
                "EUR": 301.54,
                "GBP": 353.88
                // Add more conversion rates as needed
            };

            // Check if the currency is in the conversion rates table
            if (conversionRates.hasOwnProperty(currency)) {
                var conversionRate = conversionRates[currency];
                return amount * conversionRate;
            } else {
                // If currency not found, return the original amount
                return amount;
            }
        }

        // Event listener for currency dropdown change in payable rows
        $('#payableTable tbody').on('change', 'select[name^="payable_currency"]', function() {
            updatePayableExRate();
            // var currency = $(this).val();
            // var amount = parseFloat($(this).closest('tr').find('input[name^="payable_net_amount[]"]')
            //     .val());
            // var localAmountInput = $(this).closest('tr').find('input[name^="payable_local_amount[]"]');
            // var localAmount = calculateLocalAmount(currency, amount);
            // localAmountInput.val(localAmount.toFixed(2));
        });

        // Event listener for amount input change in payable rows
        $('#payableTable tbody').on('input', 'input[name^="payable_net_amount[]"]', function() {
            updatePayableExRate();
            // var currency = $(this).closest('tr').find('select[name^="payable_currency"]').val();
            // var amount = parseFloat($(this).val());
            // var localAmountInput = $(this).closest('tr').find('input[name^="payable_local_amount[]"]');
            // var localAmount = calculateLocalAmount(currency, amount);
            // localAmountInput.val(localAmount.toFixed(2));
        });

        // Event listener for currency dropdown change in receivable rows
        $('#receiveableTable tbody').on('change', 'select[name^="receivable_currency"]', function() {
            updateReceivableExRate();
            // var currency = $(this).val();
            // var amount = parseFloat($(this).closest('tr').find('input[name^="receivable_net_amount[]"]')
            //     .val());
            // var localAmountInput = $(this).closest('tr').find(
            //     'input[name^="receivable_local_amount[]"]');
            // var localAmount = calculateLocalAmount(currency, amount);
            // localAmountInput.val(localAmount.toFixed(2));
        });

        // Event listener for amount input change in receivable rows
        $('#receiveableTable tbody').on('input', 'input[name^="receivable_net_amount[]"]', function() {
            updateReceivableExRate();
            // var currency = $(this).closest('tr').find('select[name^="receivable_currency"]').val();
            // var amount = parseFloat($(this).val());
            // var localAmountInput = $(this).closest('tr').find(
            //     'input[name^="receivable_local_amount[]"]');
            // var localAmount = calculateLocalAmount(currency, amount);
            // localAmountInput.val(localAmount.toFixed(2));
        });

        // $('#addRowPayableButton').click(addRowPayable);
        // $('#addRowReceivableButton').click(addRowReceivable);
        // let isFirstClick = true;

        $('#addRowPayableButton').click(function() {
            addRowPayable();

            // Check validation for subsequent clicks
            // if (!isFirstClick) {
            validatePayableRows();
            // }

            // After first click, set isFirstClick to false
            // isFirstClick = false;
        });

        $('#addRowReceivableButton').click(function() {
            addRowReceivable();

            // Check validation for subsequent clicks
            // if (!isFirstClick) {
            validateReceivableRows();
            // }

            // After first click, set isFirstClick to false
            // isFirstClick = false;
        });
        addRowPayable();
        addRowReceivable();

        function validatePayableRows() {
            // Example validation for payable rows
            $('#payableTable tbody tr').each(function(index) {
                let row = $(this);
                if (index === 0) return; // Skip validation for the first row

                if (row.find('select[name="payable_vendor_id[]"]').val() == "") {
                    row.find('select[name="payable_vendor_id[]"]').addClass('is-invalid');
                    // Show error message if needed
                } else {
                    row.find('select[name="payable_vendor_id[]"]').removeClass('is-invalid');
                    // Clear error messages or other validation states
                }
            });
        }

        function validateReceivableRows() {
            // Example validation for receivable rows
            $('#receiveableTable tbody tr').each(function(index) {
                let row = $(this);
                if (index === 0) return; // Skip validation for the first row

                if (row.find('select[name="receivable_customer_id[]"]').val() == "") {
                    row.find('select[name="receivable_customer_id[]"]').addClass('is-invalid');
                    // Show error message if needed
                } else {
                    row.find('select[name="receivable_customer_id[]"]').removeClass('is-invalid');
                    // Clear error messages or other validation states
                }
            });
        }

        $('#country_id').change(function() {
            var countryId = $(this).val();
            var citiesDropdown = $('#city_id');

            if (countryId) {
                $.ajax({
                    url: '/api/get-cities/' + countryId,
                    type: 'GET',
                    success: function(data) {
                        console.log(data);
                        citiesDropdown.empty(); // Clear any existing options
                        citiesDropdown.append(
                            '<option value="">Select City</option>'); // Add default option

                        $.each(data.data, function(key, city) {
                            console.log(city);
                            citiesDropdown.append('<option value="' + city.id +
                                '">' + city.name + '</option>');
                        });

                    },
                    error: function() {
                        console.log('response', 'error');
                    }
                });
            } else {
                citiesDropdown.empty(); // Clear the cities dropdown
                citiesDropdown.append('<option value="">Select City</option>'); // Add default option
            }
        });

    });
</script>
