@extends('layout.master')

@section('title')
    @if ($job_master->operation_id == 1)
        Edit-SE-Job-YARAN
    @elseif($job_master->operation_id == 2)
        {{-- @elseif(Request::is('si_job/edit/') . $job_master->id && $job_master->operation_id) --}}
        Edit-SI-Job-YARAN
    @elseif($job_master->operation_id == 3)
        {{-- @elseif(Request::is('ae_job/edit/') . $job_master->id && $job_master->operation_id) --}}
        Edit-AE-Job-YARAN
    @elseif($job_master->operation_id == 4)
        {{-- @elseif(Request::is('ai_job/edit/') . $job_master->id && $job_master->operation_id) --}}
        Edit-AI-Job-YARAN
    @endif
    {{-- Edit-SE Job-YARAN --}}
@endsection

@section('topbar')
    @if ($job_master->operation_id == 1)
        <a href="/se_job" class="breadcrumb-item">
            SE Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href=""
            class="breadcrumb--active">Edit</a>
    @elseif($job_master->operation_id == 2)
        {{-- @elseif(Request::is('si_job/edit/') . $job_master->id && $job_master->operation_id) --}}
        <a href="/se_job" class="breadcrumb-item">
            SI Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href=""
            class="breadcrumb--active">Edit</a>
    @elseif($job_master->operation_id == 3)
        {{-- @elseif(Request::is('ae_job/edit/') . $job_master->id && $job_master->operation_id) --}}
        <a href="/se_job" class="breadcrumb-item">
            AE Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href=""
            class="breadcrumb--active">Edit</a>
    @elseif($job_master->operation_id == 4)
        {{-- @elseif(Request::is('ai_job/edit/') . $job_master->id && $job_master->operation_id) --}}
        <a href="/se_job" class="breadcrumb-item">
            AI Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href=""
            class="breadcrumb--active">Edit</a>
    @endif
    {{-- <a href="/se_job" class="breadcrumb-item">
        SE Job</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href=""
        class="breadcrumb--active">Edit</a> --}}
@endsection
@section('content')
    <!-- BEGIN: Input -->
    <div class="intro-y box">
        <div
            class="d-flex flex-column flex-sm-row align-items-center py-3 px-5 border-bottom border-gray-200 dark-border-dark-5">
            <h2 class="fw-medium fs-base me-auto">
                {{-- @if (Request::is('se_job/edit/') . $job_master->id && $job_master->operation_id) --}}
                @if ($job_master->operation_id == 1)
                    Edit SE Job
                @elseif($job_master->operation_id == 2)
                    {{-- @elseif(Request::is('si_job/edit/') . $job_master->id && $job_master->operation_id) --}}
                    Edit SI Job
                @elseif($job_master->operation_id == 3)
                    {{-- @elseif(Request::is('ae_job/edit/') . $job_master->id && $job_master->operation_id) --}}
                    Edit AE Job
                @elseif($job_master->operation_id == 4)
                    {{-- @elseif(Request::is('ai_job/edit/') . $job_master->id && $job_master->operation_id) --}}
                    Edit AI Job
                @endif
            </h2>
            @if ($job_master->status == 2)
                <div class="border alert-outline-success alert alert-success-soft d-flex align-items-center mb-2 me-auto"
                    role="alert">
                    <h2 class="fw-bold fs-xl">
                        <i data-feather="alert-circle" class="me-2"></i>
                        JOB APPROVED
                    </h2>
                </div>
            @endif
            <div class="d-flex align-items-center">
                @if ($job_master->status == 1)
                    <form id="updateStatusForm" action="{{ url('/se_job/updateStatus/' . $job_master->id) }}"
                        method="post">
                        @csrf
                        <!-- Hidden input file_no -->
                        <input type="hidden" id="hiddenFileNo" name="hidden_file_no">
                        <button title="Approve Job" class="btn btn-success me-2 p-2 mt-3" type="submit" id="approveJob"><i
                                data-feather="check" class="w-4 h-4 me-1"></i> Job Approve </button>
                    </form>
                @else
                    <form action="{{ url('/se_job/unapproveJob/' . $job_master->id) }}" method="post">
                        @csrf
                        <button title="Unapprove Job" class="btn btn-danger me-2 p-2 mt-3" type="submit"><i
                                data-feather="x" class="w-4 h-4 me-1"></i> Job Unapprove </button>
                    </form>
                @endif
                <button id="showPrintBtn{{ $job_master->id }}" class="btn btn-success me-2 p-2 showPrintBtn"
                    data-bs-toggle="modal" data-bs-target="#printModal" data-item-id="{{ $job_master->id }}"><i
                        data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                @if ($job_master->operation_id == 1)
                    <a title="SE B/L" class="tooltip btn btn-primary me-2 p-2"
                        href="{{ url('/se_bl/add/' . $job_master->id) }}"><i data-feather="file-text"
                            class="w-4 h-4 me-1"></i>
                        B/L </a>
                @elseif ($job_master->operation_id == 2)
                    <a title="SI B/L" class="tooltip btn btn-primary me-2 p-2"
                        href="{{ url('/si_bl/add/' . $job_master->id) }}"><i data-feather="file-text"
                            class="w-4 h-4 me-1"></i>
                        B/L </a>
                @elseif ($job_master->operation_id == 3)
                    <a title="AE B/L" class="tooltip btn btn-primary me-2 p-2"
                        href="{{ url('/ae_bl/add/' . $job_master->id) }}"><i data-feather="file-text"
                            class="w-4 h-4 me-1"></i>
                        B/L </a>
                @elseif ($job_master->operation_id == 4)
                    <a title="AI B/L" class="tooltip btn btn-primary me-2 p-2"
                        href="{{ url('/ai_bl/add/' . $job_master->id) }}"><i data-feather="file-text"
                            class="w-4 h-4 me-1"></i>
                        B/L </a>
                @endif
                {{-- <a title="SE B/L" class="btn btn-primary me-2 p-2" href="{{ url('/se_bl/add/' . $job_master->id) }}"><i
                        data-feather="file-text" class="w-4 h-4 me-1"></i>
                    B/L </a> --}}
                @if ($job_master->operation_id == 1)
                    <a title="CRO" class="btn btn-warning me-2 p-2" href="{{ url('/cro/add/' . $job_master->id) }}"><i
                            data-feather="file-text" class="w-4 h-4 me-1"></i>
                        CRO </a>
                @endif

                {{-- <button type="button" id="invoice-btn" title="Invoice" class=" btn btn-outline-primary me-2 p-2"><i
                        data-feather="file-text" class="w-4 h-4 me-1"></i> Invoices </button>
                <button type="button" id="bill-btn" title="Bill" class=" btn btn-outline-success me-2 p-2"
                    href="{{ url('/se_bill/add/' . $job_master->id) }}"><i data-feather="file-text"
                        class="w-4 h-4 me-1"></i> Bills </button> --}}
                {{-- <div class="d-flex justify-content-center me-2">
                    <div class="dropdown">
                        <button title="Customer Invoices" class=" dropdown-toggle btn btn-outline-primary"
                            aria-expanded="false" data-bs-toggle="dropdown"><i data-feather="printer"
                                class="w-4 h-4"></i></button>
                        <div class="dropdown-menu w-48">
                            <ul class="dropdown-content">
                                @foreach ($job_master->job_charges_receivable as $invoice)
                                    <li>
                                        <a href="" class="dropdown-item fs-base"> <i data-feather="printer"
                                                class="w-4 h-4 me-2"></i>
                                            {{ $invoice->customer->name }}'s Invoice
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-center">
                    <div class="dropdown">
                        <button title="Vendor Invoices" class=" dropdown-toggle btn btn-outline-success"
                            aria-expanded="false" data-bs-toggle="dropdown"><i data-feather="printer"
                                class="w-4 h-4"></i></button>
                        <div class="dropdown-menu w-48">
                            <ul class="dropdown-content">
                                @foreach ($job_master->job_charges_payable as $invoice)
                                    <li>
                                        <a href="" class="dropdown-item fs-base"> <i data-feather="printer"
                                                class="w-4 h-4 me-2"></i>
                                            {{ $invoice->vendor->name }}'s Invoice
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div> --}}
            </div>
        </div>

        <form method="POST" id="myForm" action={{ url('se_job/edit/' . $job_master->id) }} enctype="multipart/form-data"
            class="row g-3">
            @csrf
            <div class="g-col-12 text-end py-0 px-5">
                <button type="submit" class="btn btn-primary submitBtn me-2" id="submitBtn">Save</button>
                <a href="{{ url('/se_job') }}" type="button" class="btn btn-secondary waves-effect">
                    Back
                </a>
            </div>
            <div class="intro-y pe-3">
                {{-- @if (Request::is('se_job/edit/') . $job_master->id && $job_master->operation_id)
                    <input type="hidden" name="operation_id" value="1">
                @elseif(Request::is('si_job/edit/') . $job_master->id && $job_master->operation_id)
                    <input type="hidden" name="operation_id" value="2">
                @elseif(Request::is('ae_job/edit/') . $job_master->id && $job_master->operation_id)
                    <input type="hidden" name="operation_id" value="3">
                @elseif(Request::is('ai_job/edit/') . $job_master->id && $job_master->operation_id)
                    <input type="hidden" name="operation_id" value="4">
                    @endif --}}
                <input type="hidden" name="operation_id" value="{{ $job_master->operation_id }}">
                <div class="box p-2">
                    <ul class="nav nav-pills rounded-2" role="tablist">
                        <li id="booking_info_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5 active" data-bs-toggle="pill"
                                data-bs-target="#booking_info" type="button" role="tab"
                                aria-controls="booking_info_tab" aria-selected="true">Booking Info</button>
                        </li>
                        <li id="equipments_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                data-bs-target="#equipments" type="button" role="tab"
                                aria-controls="equipments_tab" aria-selected="false">Equipments</button>
                        </li>
                        <li id="charges_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill" data-bs-target="#charges"
                                type="button" role="tab" aria-controls="charges_tab"
                                aria-selected="false">Charges</button>
                        </li>
                        <li id="routing_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill" data-bs-target="#routing"
                                type="button" role="tab" aria-controls="routing_tab"
                                aria-selected="false">Routing</button>
                        </li>
                        <li id="other_info_tab" class="nav-item flex-1" role="presentation">
                            <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                data-bs-target="#other_info" type="button" role="tab"
                                aria-controls="other_info_tab" aria-selected="false">Other
                                Info</button>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="tab-content mt-2">
                <div class="tab-pane fade show active" id="booking_info" role="tabpanel"
                    aria-labelledby="booking_info_tab">
                    @include('sea_export.se_job.edit_tabs.booking_info')
                </div>
                <div class="tab-pane fade" id="equipments" role="tabpanel" aria-labelledby="equipments_tab">
                    <div class="text-end mt-3 mb-3 me-5">
                        {{-- <button id="addRowEquipmentBtn" type="button" class="btn btn-primary">Add Row</button> --}}
                    </div>
                    @include('sea_export.se_job.edit_tabs.equipment')
                </div>
                <div class="tab-pane fade" id="charges" role="tabpanel" aria-labelledby="charges_tab">
                    @include('sea_export.se_job.edit_tabs.charges')
                </div>
                <div class="tab-pane fade" id="routing" role="tabpanel" aria-labelledby="routing_tab">
                    @if ($job_master->operation_id == 3)
                        @include('sea_export.se_job.edit_tabs.ae_job_routing')
                    @else
                        @include('sea_export.se_job.edit_tabs.routing')
                    @endif
                </div>
                <div class="tab-pane fade" id="other_info" role="tabpanel" aria-labelledby="other_info_tab">
                    @if ($job_master->operation_id == 1)
                        @include('sea_export.se_job.edit_tabs.other_info')
                    @elseif($job_master->operation_id == 2)
                        @include('sea_export.se_job.edit_tabs.si_job_other_info')
                    @elseif($job_master->operation_id == 3)
                        @include('sea_export.se_job.edit_tabs.ae_job_other_info')
                    @elseif($job_master->operation_id == 4)
                        @include('sea_export.se_job.edit_tabs.ai_job_other_info')
                    @endif
                </div>
            </div>
        </form>
    </div>
    @include('sea_export.se_job.modals.addParty')
    @include('sea_export.se_job.modals.addCommodity')
    @include('sea_export.se_job.modals.addUnLocation')
    @include('sea_export.se_job.modals.addEmployee')
    @include('sea_export.se_job.modals.addVessel')
    @include('sea_export.se_job.modals.addVoyage')
    @include('sea_export.se_job.modals.addCharge')
    @include('sea_export.se_job.modals.print')
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Include Tom Select JS -->
<script src="https://cdn.jsdelivr.net/npm/tom-select/dist/js/tom-select.complete.min.js"></script>
<script>
    $(document).ready(function() {

        $(window).keydown(function(event) {
            if (event.keyCode == 13) {
                event.preventDefault();
                return false;
            }
        });

        $('#add-coa').hide();
        $('#party_is').change(function() {
            var partyIs = $(this).val();
            if (partyIs == 'customer_vendor') {
                $('#add-coa').show();
            } else {
                $('#add-coa').hide();
            }
        });

        $('#party-name').on('input', function() {
            let partyNameValue = $(this).val();
            $('#coa_name').val(partyNameValue);
            $('#alias').val(partyNameValue);

        });

        var urlParams = new URLSearchParams(window.location.search);
        var tabId = urlParams.get('tab');
        var innerTabId = urlParams.get('inner_tab');

        // Strip any query parameters from the tabId, just in case
        if (tabId) {
            tabId = tabId.split('?')[0]; // Remove anything after ?

            $('button[data-bs-target="#' + tabId + '"]').tab('show');
            console.log('inner Tab ID:', innerTabId);
            if (innerTabId) {
                $('button[data-bs-target="#' + innerTabId + '"]').tab('show');
            }
        }
    });
</script>
{{-- <script>
    document.addEventListener('DOMContentLoaded', function() {
        const printModal = document.getElementById('printModal');
        const printForm = document.getElementById('printForm');
        const selectedJobIdInput = document.getElementById('selectedJobId');
        console.log(selectedJobIdInput);

        printModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget; // Button that triggered the modal
            const jobId = button.getAttribute('data-item-id'); // Extract info from data-* attributes

            // Debugging: Log the jobId to ensure it's being retrieved correctly
            console.log('Job ID:', jobId);

            // Update the input value and form action URL
            selectedJobIdInput.value = jobId;
            const apiUrl = "{{ url('job_print') }}";
            printForm.action = `${apiUrl}/${jobId}`;

            // Debugging: Log the form action to ensure it's set correctly
            console.log('Form Action URL:', printForm.action);
        });
    });
</script> --}}
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get all radio buttons
        const radioButtons = document.querySelectorAll('input[name="reportOptions"]');
        // Add event listener to each radio button
        radioButtons.forEach(function(radio) {
            radio.addEventListener('change', function() {
                // Hide all divs
                $('#divInterestRate').addClass('d-none');
                $('#divShowSummary').addClass('d-none');
                $('#divShowExtendedInformation').addClass('d-none');
                $('#divRemarks').addClass('d-none');
                $('#divShowContainer').addClass('d-none');
                $('#divShowAmountInsteadOfRate').addClass('d-none');
                $('#divShowOnlyRealized').addClass('d-none');
                $('#divExcludeConsoleShare').addClass('d-none');
                $('#divIncludeTax').addClass('d-none');
                $('#divExcludeExRateGL').addClass('d-none');
                $('#divShowSignature').addClass('d-none');
                $('#divExcludeFinancialCost').addClass('d-none');
                $('#divName').addClass('d-none');
                $('#divCurrency').addClass('d-none');
                $('#divShowContainer').addClass('d-none');
                $('#divShowBank').addClass('d-none');
                $('#divPrintOnlyUnapprovedCharges').addClass('d-none');
                $('#divAddDiscriptionWithCharges').addClass('d-none');
                $('#divAddDiscriptionOnly').addClass('d-none');
                $('#divOnlyOceanFreightCharges').addClass('d-none');
                $('#divExcludeOceanFreight').addClass('d-none');
                $('#divBankDetail').addClass('d-none');
                $('#divClient').addClass('d-none');
                $('#divRegular').addClass('d-none');
                $('#divSecurityDeposit').addClass('d-none');
                $('#divDetention').addClass('d-none');
                $('#divDemurrage').addClass('d-none');
                $('#divPrintBalanceAdjustment').addClass('d-none');
                $('#divMessageOfSystemGeneratedInvoice').addClass('d-none');
                $('#divPrincipal').addClass('d-none');
                $('#divVendor').addClass('d-none');
                $('#divEDI').addClass('d-none');

                // Show the selected div
                if (this.id === 'report1') {
                    $('#divFormat').removeClass('d-none');
                    $('#divCharges').removeClass('d-none');
                    $('#divPrintCompanyHeader').removeClass('d-none');
                } else if (this.id === 'report2') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divInterestRate').removeClass('d-none');
                    $('#divShowSummary').removeClass('d-none');
                    $('#divShowExtendedInformation').removeClass('d-none');
                    $('#divRemarks').removeClass('d-none');
                    $('#divShowContainer').removeClass('d-none');
                    $('#divShowAmountInsteadOfRate').removeClass('d-none');
                    $('#divShowOnlyRealized').removeClass('d-none');
                    $('#divExcludeConsoleShare').removeClass('d-none');
                    $('#divIncludeTax').removeClass('d-none');
                    $('#divExcludeExRateGL').removeClass('d-none');
                    $('#divShowSignature').removeClass('d-none');
                    $('#divExcludeFinancialCost').removeClass('d-none');
                } else if (this.id === 'report3') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divExcludeConsoleShare').removeClass('d-none');
                    $('#divIncludeTax').removeClass('d-none');
                    $('#divExcludeExRateGL').removeClass('d-none');
                } else if (this.id === 'report4') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                } else if (this.id === 'report5') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divName').removeClass('d-none');
                    $('#divCurrency').removeClass('d-none');
                    $('#divShowContainer').removeClass('d-none');
                    $('#divShowBank').removeClass('d-none');
                    $('#divPrintOnlyUnapprovedCharges').removeClass('d-none');
                    $('#divAddDiscriptionWithCharges').removeClass('d-none');
                    $('#divAddDiscriptionOnly').removeClass('d-none');
                    $('#divOnlyOceanFreightCharges').removeClass('d-none');
                    $('#divExcludeOceanFreight').removeClass('d-none');
                    $('#divBankDetail').removeClass('d-none');
                } else if (this.id === 'report6') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divCurrency').removeClass('d-none');
                    $('#divClient').removeClass('d-none');
                    $('#divShowContainer').removeClass('d-none');
                    $('#divShowSignature').removeClass('d-none');
                    $('#divRegular').removeClass('d-none');
                    $('#divSecurityDeposit').removeClass('d-none');
                    $('#divDetention').removeClass('d-none');
                    $('#divDemurrage').removeClass('d-none');
                    $('#divPrintBalanceAdjustment').removeClass('d-none');
                    $('#divMessageOfSystemGeneratedInvoice').removeClass('d-none');
                } else if (this.id === 'report7') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divCurrency').removeClass('d-none');
                    $('#divPrincipal').removeClass('d-none');
                } else if (this.id === 'report8') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divVendor').removeClass('d-none');
                } else if (this.id === 'report9') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divEDI').removeClass('d-none');
                }
            });
        });

        $('#format').change(function() {
            var format = $(this).val();

            if (format == 2) {
                $('#divPrintCompanyHeader').addClass('d-none');
                $('#printCompanyHeader').prop('checked', false);
                $('#divCharges').addClass('d-none');
                $('#showCharges').prop('checked', false);
            } else if (format == 1) {
                $('#divPrintCompanyHeader').addClass('d-none');
                $('#printCompanyHeader').prop('checked', false);
                $('#divCharges').removeClass('d-none');
            } else if (format == 3) {
                $('#divCharges').removeClass('d-none');
                $('#divPrintCompanyHeader').removeClass('d-none');
            }
        });
    });

    // $('.modal form').submit(function(e) {
    //         e.preventDefault();
    //         var formData = $(this).serialize();
    //         var apiUrl = $(this).closest('.modal').data('api-url');

    //         $.ajax({
    //             url: apiUrl,
    //             type: 'POST',
    //             data: formData,
    //             success: function(response) {
    //                 console.log(response);
    //             },
    //             error: function(xhr, status, error) {
    //                 // Handle error response
    //                 // console.error(xhr.responseText);
    //                 // Optionally, display an error message
    //             }
    //         });

    //     });
</script>
<script>
    $(document).ready(function() {
        // Update the hidden input value when the tab changes
        $('button[data-bs-toggle="pill"]').on('shown.bs.tab', function(e) {
            var tabId = $(e.target).attr('data-bs-target').substr(1); // Get the tab ID
            $('#tabId').val(tabId); // Set the tab ID in the hidden input
        });
        $('.ex_rate_edit').on('change', function() {
            // e.preventDefault();
            console.log("ex_rate_edit is change");
            if ($(this).is(':checked')) {
                $('.payable_ex_rate, .receivable_ex_rate').removeAttr('readonly'); // Remove readonly
            } else {
                $('.payable_ex_rate, .receivable_ex_rate').attr('readonly', 'readonly'); // Add readonly
            }
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('#submitBtn').on('click', function(e) {
            // Validate form and check if it's valid
            var isValid = validateFormAndSubmit();

            // If form is valid, allow submission (or continue with your submission logic)
            if (isValid) {
                // You can proceed with form submission or any other action
                console.log(
                    'Form is valid. Proceeding with submission...');
            } else {
                // Prevent default form submission if there are errors
                e.preventDefault();
                console.log(
                    'Form submission prevented due to validation errors.'
                );
            }
        });

        function validateFormAndSubmit() {
            var formIsValid = true;

            // Reset validation states and hide all error messages
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').hide();
            var jobMasterId = @json($job_master->id);
            console.log(jobMasterId);

            if ($('#client_id').val() === '') {
                $('#client_id').addClass('is-invalid');
                $('#client_id').nextAll('.invalid-feedback').first().show();
                formIsValid = false;
            }

            // Additional scenario-based validation
            if (window.location.pathname.includes(`se_job/edit/${jobMasterId}`) || window.location.pathname
                .includes(`ae_job/edit/${jobMasterId}`)) {
                console.log('here');
                if ($('#final_destination_id').val() === '' || $('#shipper_id').val() === '') {
                    $('#shipper_id').addClass('is-invalid');
                    $('#shipper_id').nextAll('.invalid-feedback').first().show();
                    $('#final_destination_id').addClass('is-invalid');
                    $('#final_destination_id').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
            } else if (window.location.pathname.includes(`ai_job/edit/${jobMasterId}`)) {
                if ($('#final_destination_id').val() === '' || $('#consignee_id').val() === '') {
                    $('#consignee_id').addClass('is-invalid');
                    $('#consignee_id').nextAll('.invalid-feedback').first().show();
                    $('#final_destination_id').addClass('is-invalid');
                    $('#final_destination_id').nextAll('.invalid-feedback').first().show();
                    formIsValid = false;
                }
            }

            // If form is not valid, prevent submission and show Swal alert
            if (!formIsValid) {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please fill all required fields",
                    showConfirmButton: false,
                    timer: 2500
                });
            }

            return formIsValid; // Return form validity status
        }
    });
</script>
<script>
    //shipper select same as client select
    function selectSameOption(sourceDropdownId, targetDropdownId) {
        // Get the ID of the source dropdown
        var selectedValue = document.getElementById(sourceDropdownId).value;
        var targetDropdown = document.getElementById(targetDropdownId);
        targetDropdown.value = selectedValue;
        // console.log("Source Dropdown ID:", selectedValue);
        // console.log("Target Dropdown ID:", targetDropdown.value);

        // Trigger change event on target dropdown
        var event = new Event('change');
        targetDropdown.dispatchEvent(event);
    }

    function selectSameOptionTwo(sourceDropdownId) {
        var selectedValue = document.getElementById(sourceDropdownId).value;

        // Update the selected option in each dependent dropdown
        document.getElementById('port_of_discharge_id').value = selectedValue;
        document.getElementById('final_destination_id').value = selectedValue;
        document.getElementById('point_of_loading_id').value = selectedValue;
        document.getElementById('point_of_discharge_id').value = selectedValue;
        document.getElementById('routing_port_of_loading_id').value = selectedValue;
        document.getElementById('routing_port_of_discharge_id').value = selectedValue;
        document.getElementById('routing_final_destination_id').value = selectedValue;
        document.getElementById('routing_place_of_receipt_id').value = selectedValue;
        // console.log(document.getElementById('routing_port_of_loading_id'))
        // Trigger change event on each dependent dropdown
        ['port_of_discharge_id', 'final_destination_id', 'routing_port_of_loading_id', 'routing_port_of_discharge_id',
            'routing_place_of_receipt_id', 'routing_final_destination_id', 'point_of_loading_id',
            'point_of_discharge_id'
        ].forEach(function(dropdownId) {
            var event = new Event('change');
            document.getElementById(dropdownId).dispatchEvent(event);
        });
    }
</script>
<script>
    $(document).ready(function() {

        $('#country_id').change(function() {
            var countryId = $(this).val();
            var citiesDropdown = $('#city_id');

            if (countryId) {
                $.ajax({
                    url: '/api/get-cities/' + countryId,
                    type: 'GET',
                    success: function(data) {
                        console.log(data);
                        citiesDropdown.empty(); // Clear any existing options
                        citiesDropdown.append(
                            '<option value="">Select City</option>'); // Add default option

                        $.each(data.data, function(key, city) {
                            console.log(city);
                            citiesDropdown.append('<option value="' + city.id +
                                '">' + city.name + '</option>');
                        });

                    },
                    error: function() {
                        console.log('response', 'error');
                    }
                });
            } else {
                citiesDropdown.empty(); // Clear the cities dropdown
                citiesDropdown.append('<option value="">Select City</option>'); // Add default option
            }
        });


        $('select[name="vessel_id"]').on('change', function() {
            var vesselValue = $(this).val();
            $('select[name="feeder_vessel_id"]').val(vesselValue);
        });

        $('select[name="voyage_id"]').on('change', function() {
            var voyageValue = $(this).val();
            $('select[name="routing_voyage_id"]').val(voyageValue);
        });

        $('.readonly-checkbox').prop('disabled', true);

        $('#approveCharge').on('click', function() {
            const isReceivableActive = $('#receivable_tab button').hasClass('active');
            const isPayableActive = $('#payable_tab button').hasClass('active');

            let checkedInputs = $('.checkbox-receivable:checked');
            let checkedInputsPaybale = $('.checkbox-payable:checked');

            if (checkedInputs.length === 0 && checkedInputsPaybale.length === 0) {
                if (isReceivableActive) {
                    checkedInputs = $('.checkbox-receivable');
                } else if (isPayableActive) {
                    checkedInputsPaybale = $('.checkbox-payable');
                }
            }

            const checkedIds = checkedInputs.map(function() {
                return $(this).val();
            }).get();

            const checkedIdsPayble = checkedInputsPaybale.map(function() {
                return $(this).val();
            }).get();

            // if (checkedInputs.length === 0 && checkedInputsPaybale.length === 0) {
            //     checkedInputsPaybale = $('.checkbox-payable');
            // }

            var jobMasterStatus = @json($job_master->status);

            console.log(checkedIds);
            console.log(checkedIdsPayble);

            if (jobMasterStatus == 2) {
                $.ajax({
                    url: '{{ url('/se_job/updateStatusCharges/' . $job_master->id) }}',
                    type: 'POST',
                    data: {
                        job_receievable_charges_ids: checkedIds,
                        job_payable_charges_ids: checkedIdsPayble,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        window.location.reload();
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseJSON.data,
                            showConfirmButton: false,
                            timer: 2500
                        })
                    }
                });
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please Approve the Job!",
                    showConfirmButton: false,
                    timer: 2500
                })
            }

        });

        $('#unApproveCharge').on('click', function() {
            const isReceivableActive = $('#receivable_tab button').hasClass('active');
            const isPayableActive = $('#payable_tab button').hasClass('active');

            let checkedInputs = $('.checkbox-receivable:checked');
            let checkedInputsPaybale = $('.checkbox-payable:checked');

            if (checkedInputs.length === 0 && checkedInputsPaybale.length === 0) {
                if (isReceivableActive) {
                    checkedInputs = $('.checkbox-receivable');
                } else if (isPayableActive) {
                    checkedInputsPaybale = $('.checkbox-payable');
                }
            }

            const checkedIds = checkedInputs.map(function() {
                return $(this).val();
            }).get();

            // if (checkedInputs.length === 0 && checkedInputsPaybale.length === 0) {
            //     checkedInputsPaybale = $('.checkbox-payable');
            // }

            const checkedIdsPayble = checkedInputsPaybale.map(function() {
                return $(this).val();
            }).get();

            $.ajax({
                url: '{{ url('/se_job/unapproveCharges/' . $job_master->id) }}',
                type: 'POST',
                data: {
                    job_receievable_charges_ids: checkedIds,
                    job_payable_charges_ids: checkedIdsPayble,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'error',
                        title: xhr.responseJSON.data,
                        showConfirmButton: false,
                        timer: 2500
                    })
                }
            });

        });

        $('#autoAgentInvoiceButton').on('click', function() {
            let checkedInputs = $('.checkbox-receivable:checked');
            if (checkedInputs.length === 0) {
                checkedInputs = $('.checkbox-receivable').not(':disabled');
            }

            // const checkedIds = checkedInputs.map(function() {
            //     return $(this).val();
            // }).get();

            // const allApproved = checkedInputs.filter(function() {
            //     return $(this).data('status') == 2;
            // }).length === checkedIds.length;

            // if (allApproved) {
            const checkedIds = checkedInputs.filter(function() {
                return $(this).data('status') == 2;
            }).map(function() {
                return $(this).val();
            }).get();

            if (checkedIds.length > 0) {
                $.ajax({
                    url: '{{ url('se_agent_invoice/auto/add/' . $job_master->id) }}',
                    type: 'POST',
                    data: {
                        job_receievable_charges_ids: checkedIds,
                        _token: '{{ csrf_token() }}'
                    },
                    // success: function(response) {
                    //     window.location.reload();
                    // },
                    success: function(response) {
                        let url = new URL(window.location);
                        url.searchParams.set("tab",
                            "charges"); // Updates or adds tab=charges
                        window.location.href = url.toString();
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseJSON.error,
                            showConfirmButton: false,
                            timer: 2500
                        })
                    }
                });
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please Approve the Job!",
                    showConfirmButton: false,
                    timer: 2500
                })
            }
        });
        $('#manualAgentInvoiceButton').on('click', function() {
            let checkedInputs = $('.checkbox-receivable:checked');
            if (checkedInputs.length === 0) {
                checkedInputs = $('.checkbox-receivable').not(':disabled');
            }
            const approvedInputs = checkedInputs.filter(function() {
                return $(this).data('status') == 2;
            });
            const approvedIds = approvedInputs.map(function() {
                return $(this).val();
            }).get();

            // 🔍 Collect currency values of approved inputs
            // const currencies = approvedInputs.map(function() {
            //     return $(this).closest('tr').find('input[name="receivable_currency[]"]').val();
            // }).get();

            // // ✅ Check if all currencies are the same
            // const allSameCurrency = currencies.every((val, i, arr) => val === arr[0]);


            if (approvedIds.length > 0) {
                // if (allSameCurrency) {
                    const url = '{{ url('/se_agent_invoice/manual/add/' . $job_master->id) }}' +
                        '?job_receievable_charges_ids=' + approvedIds.join(',');

                    $.ajax({
                        url: '{{ url('se_agent_invoice/check_cc/' . $job_master->id) }}',
                        type: 'POST',
                        data: {
                            job_receievable_charges_ids: approvedIds,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            // console.log('response', response)
                            window.location.href = url;
                            // window.location.reload();
                        },
                        error: function(xhr, status, error) {
                            Swal.fire({
                                toast: true,
                                position: 'top-end',
                                icon: 'error',
                                title: xhr.responseJSON.error,
                                showConfirmButton: false,
                                timer: 2500
                            })
                        }
                    });
                // } else {
                //     Swal.fire({
                //         toast: true,
                //         position: 'top-end',
                //         icon: 'error',
                //         title: "Selected charges must have the same currency!",
                //         showConfirmButton: false,
                //         timer: 2500
                //     });

                // }
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please Approve the Job!",
                    showConfirmButton: false,
                    timer: 2500
                });
            }
        });

        $('#job_receievable_charges_all').on('change', function() {
            $('.checkbox-receivable').not(':disabled').prop('checked', $(this).is(':checked'));
        });

        $('#job_payable_charges_all').on('change', function() {
            $('.checkbox-payable').not(':disabled').prop('checked', $(this).is(':checked'));
        });

        $('#autoInvoiceButton').on('click', function() {
            let checkedInputs = $('.checkbox-receivable:checked');
            if (checkedInputs.length === 0) {
                checkedInputs = $('.checkbox-receivable').not(':disabled');
            }

            const checkedIds = checkedInputs.filter(function() {
                return $(this).data('status') == 2;
            }).map(function() {
                return $(this).val();
            }).get();


            // const checkedIds = checkedInputs.map(function() {
            //     return $(this).val();
            // }).get();

            // const allApproved = checkedInputs.filter(function() {
            //     return $(this).data('status') == 2;
            // }).length === checkedIds.length;

            // if (allApproved) {
            if (checkedIds.length > 0) {
                $.ajax({
                    url: '{{ url('se_invoice/auto/add/' . $job_master->id) }}',
                    type: 'POST',
                    data: {
                        job_receievable_charges_ids: checkedIds,
                        _token: '{{ csrf_token() }}'
                    },
                    // success: function(response) {
                    //     window.location.reload();
                    // },
                    success: function(response) {
                        let url = new URL(window.location);
                        url.searchParams.set("tab",
                            "charges"); // Updates or adds tab=charges
                        window.location.href = url.toString();
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseJSON.error,
                            showConfirmButton: false,
                            timer: 2500
                        })
                    }
                });
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please Approve the Job Charges!",
                    showConfirmButton: false,
                    timer: 2500
                })
            }
        });
        // $('#manualInvoiceButton').on('click', function() {
        //     let checkedInputs = $('.checkbox-receivable:checked');
        //     if (checkedInputs.length === 0) {
        //         checkedInputs = $('.checkbox-receivable').not(':disabled');
        //     }

        //     const approvedIds = checkedInputs.filter(function() {
        //         return $(this).data('status') == 2;
        //     }).map(function() {
        //         return $(this).val();
        //     }).get();

        //     if (approvedIds.length > 0) {
        //         const url = '{{ url('se_invoice/manual/add/' . $job_master->id) }}' +
        //             '?job_receievable_charges_ids=' + approvedIds.join(',');
        //         window.location.href = url;
        //     } else {
        //         Swal.fire({
        //             toast: true,
        //             position: 'top-end',
        //             icon: 'error',
        //             title: "Please Approve the Job Charges!",
        //             showConfirmButton: false,
        //             timer: 2500
        //         });
        //     }
        // });
        $('#manualInvoiceButton').on('click', function() {
            let checkedInputs = $('.checkbox-receivable:checked');
            if (checkedInputs.length === 0) {
                checkedInputs = $('.checkbox-receivable').not(':disabled');
            }

            const approvedInputs = checkedInputs.filter(function() {
                return $(this).data('status') == 2;
            });

            const approvedIds = approvedInputs.map(function() {
                return $(this).val();
            }).get();

            // const currencies = approvedInputs.map(function() {
            //     return $(this).closest('tr').find('input[name="receivable_currency[]"]').val();
            // }).get();

            // const allSameCurrency = currencies.every((val, i, arr) => val === arr[0]);

            if (approvedIds.length > 0) {
                // if (allSameCurrency) {
                    const url = '{{ url('se_invoice/manual/add/' . $job_master->id) }}' +
                        '?job_receievable_charges_ids=' + approvedIds.join(',');
                    window.location.href = url;
                // } else {
                //     Swal.fire({
                //         toast: true,
                //         position: 'top-end',
                //         icon: 'error',
                //         title: "Selected charges must have the same currency!",
                //         showConfirmButton: false,
                //         timer: 2500
                //     });
                // }
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please Approve the Job Charges!",
                    showConfirmButton: false,
                    timer: 2500
                });
            }
        });

        // $('#manualInvoiceButton').on('click', function() {
        //     let checkedInputs = $('.checkbox-receivable:checked');
        //     if (checkedInputs.length === 0) {
        //         checkedInputs = $('.checkbox-receivable');
        //     }

        //     const checkedIds = checkedInputs.map(function() {
        //         return $(this).val();
        //     }).get();

        //     const allApproved = checkedInputs.filter(function() {
        //         return $(this).data('status') == 2;
        //     }).length === checkedIds.length;

        //     if (allApproved) {
        //         $.ajax({
        //             url: '{{ url('se_invoice/manual/add/' . $job_master->id) }}',
        //             type: 'GET',
        //             data: {
        //                 job_receievable_charges_ids: checkedIds,
        //                 _token: '{{ csrf_token() }}'
        //             },
        //             success: function(response) {
        //                 // window.location.reload();
        //             },
        //             error: function(xhr, status, error) {
        //                 Swal.fire({
        //                     toast: true,
        //                     position: 'top-end',
        //                     icon: 'error',
        //                     title: xhr.responseJSON.error,
        //                     showConfirmButton: false,
        //                     timer: 2500
        //                 })
        //             }
        //         });
        //     } else {
        //         Swal.fire({
        //             toast: true,
        //             position: 'top-end',
        //             icon: 'error',
        //             title: "Please Approve the Job!",
        //             showConfirmButton: false,
        //             timer: 2500
        //         })
        //     }
        // });

        $('#autoBillButton').on('click', function() {
            let checkedInputs = $('.checkbox-payable:checked');
            if (checkedInputs.length === 0) {
                checkedInputs = $('.checkbox-payable').not(':disabled');
            }

            // const checkedIds = checkedInputs.map(function() {
            //     return $(this).val();
            // }).get();


            // const allApproved = checkedInputs.filter(function() {
            //     return $(this).data('status') == 2;
            // }).length === checkedIds.length;

            // console.log(allApproved);

            // if (allApproved) {
            const checkedIds = checkedInputs.filter(function() {
                return $(this).data('status') == 2;
            }).map(function() {
                return $(this).val();
            }).get();

            if (checkedIds.length > 0) {
                $.ajax({
                    url: '{{ url('se_bill/auto/add/' . $job_master->id) }}',
                    type: 'POST',
                    data: {
                        job_payable_charges_ids: checkedIds,
                        _token: '{{ csrf_token() }}'
                    },
                    // success: function(response) {
                    //     window.location.reload();
                    // },
                    success: function(response) {
                        let url = new URL(window.location);
                        url.searchParams.set("tab",
                            "charges");
                        url.searchParams.set("inner_tab",
                            "payable");
                        window.location.href = url.toString();
                    },
                    error: function(xhr, status, error) {
                        // Handle errors
                        console.log('error', error);
                        console.log('xhr', xhr);
                        console.log('status', status);
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseJSON.error,
                            showConfirmButton: false,
                            timer: 2500
                        })
                    }
                });
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please Approve the Job Charges!",
                    showConfirmButton: false,
                    timer: 2500
                })
            }
        });

        $('#manualBillButton').on('click', function() {
            let checkedInputs = $('.checkbox-payable:checked');
            if (checkedInputs.length === 0) {
                checkedInputs = $('.checkbox-payable').not(':disabled');
            }

            const approvedInputs = checkedInputs.filter(function() {
                return $(this).data('status') == 2;
            });

            const approvedIds = approvedInputs.map(function() {
                return $(this).val();
            }).get();

            // const currencies = approvedInputs.map(function() {
            //     return $(this).closest('tr').find('input[name="payable_currency[]"]').val();
            // }).get();

            // const allSameCurrency = currencies.every((val, i, arr) => val === arr[0]);

            if (approvedIds.length > 0) {
                // if (allSameCurrency) {
                    const url = '{{ url('se_bill/manual/add/' . $job_master->id) }}' +
                        '?job_payable_charges_ids=' + approvedIds.join(',');
                    window.location.href = url;
                // } else {
                //     Swal.fire({
                //         toast: true,
                //         position: 'top-end',
                //         icon: 'error',
                //         title: "Selected charges must have the same currency!",
                //         showConfirmButton: false,
                //         timer: 2500
                //     });
                // }
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "Please Approve the Job Charges!",
                    showConfirmButton: false,
                    timer: 2500
                });
            }
        });

        // document.getElementById('updateStatusForm').addEventListener('submit', function(event) {
        //     event.preventDefault(); // Prevent the form from submitting immediately

        //     // Get the value of the "File #" input field
        //     var fileNo = document.getElementById('file_no').value;

        //     // Check if the "File #" field is empty
        //     if (!fileNo) {
        //         // Show SweetAlert2 alert if the field is empty
        //         Swal.fire({
        //             toast: true,
        //             position: 'top-end',
        //             icon: 'error',
        //             title: "Please enter File #",
        //             showConfirmButton: false,
        //             timer: 2500
        //         });
        //     } else {
        //         // If the field is not empty, set the file_no to hidden input then submit the form
        //         document.getElementById('hiddenFileNo').value = fileNo;
        //         this.submit();
        //     }
        // });

        // Attach event listener to each manual checkbox
        $('.manual-checkbox').on('change', function() {
            // Get the checked status of the current manual checkbox
            var isChecked = $(this).is(':checked');
            // Get the data-id attribute to identify the corresponding quantity input field
            var id = $(this).data('id');
            // Find the corresponding quantity input field using the id
            var qtyInput = $('#' + id);
            // Set the readonly attribute of the quantity input field based on the checkbox status
            qtyInput.prop('readonly', !isChecked);
        });

        // Attach event listener to the checkbox
        $('.manual-checkbox-payable').on('change', function() {
            // Get the checked status of the checkbox
            var isChecked = $(this).is(':checked');

            var id = $(this).data('id');
            // Find the corresponding quantity input field using the id
            var qtyInput = $('#' + id);
            // Set the readonly attribute based on the checkbox status
            qtyInput.prop('readonly', !isChecked);
        });

        $('.select2').select2({
            placeholder: 'Please Select',
            allowClear: true,
            width: '100%'
        });

        var clickedLabel = '';

        $('.add-charge').on('click', function(e) {
            // console.log('here')
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addCharge').modal('show');
        });

        $('.add-commodity').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addCommodity').modal('show');
        });

        $('.add-party').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addParty').modal('show');
            $("#country_id").select2({
                dropdownParent: "#addParty"
            });
            $('#city_id').select2({
                dropdownParent: "#addParty"
            });
            $('#operation_id').select2({
                dropdownParent: "#addParty"
            });
            $('#type_id').select2({
                dropdownParent: "#addParty"
            });
        });

        $('.add-employee').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addEmployee').modal('show');
        });

        $('.add-un_location').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addUnLocation').modal('show');
        });

        $('.add-vessel').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addVessel').modal('show');
        });

        $('.add-voyage').on('click', function(e) {
            e.preventDefault();
            clickedLabel = $(this).data('id');
            $('#addVoyage').modal('show');
        });

        $('.modal form').submit(function(e) {
            if ($(this).hasClass('print-modal')) {
                // If the form has the class 'print-modal', do not proceed with the following code
                console.log('.modal form');
                return;
            }
            e.preventDefault();
            var formData = $(this).serialize();
            var apiUrl = $(this).closest('.modal').data('api-url');

            var clickedLabelId = clickedLabel; // Store the clicked label ID

            $.ajax({
                url: apiUrl,
                type: 'POST',
                data: formData,
                success: function(response) {
                    console.log(response);
                    // Append the response data to the options of the clicked label
                    if (clickedLabel == 'sales_rep_id') {
                        var optionHtml = '<option value="' + response.data.id + '">' +
                            response.data.employee_name + '</option>';
                    } else if (clickedLabel == 'voyage_id') {
                        var optionHtml = '<option value="' + response.data.id + '">' +
                            response.data.voyage_no + '</option>';
                    } else {
                        var optionHtml = '<option value="' + response.data.id + '">' +
                            response.data.name + '</option>';
                    }
                    // Get the select element based on the clicked label
                    var selectElement = $('#' + clickedLabel);

                    if (clickedLabel == 'charge_id') {
                        $('.receivable_charge_id').append(optionHtml);
                        $('.payable_charge_id').append(optionHtml);
                    }

                    if (clickedLabel == 'customer_id') {
                        $('.receivable_customer_id').append(optionHtml);
                    }

                    if (clickedLabel == 'vendor_id') {
                        $('.payable_vendor_id').append(optionHtml);
                    }

                    if (clickedLabel == 'vessel_id') {
                        $('#vessel_modal').append(optionHtml);
                    }

                    if (clickedLabel == 'final_destination_id') {
                        $('#port_of_discharge_id').append(optionHtml);
                        $('#port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_discharge_id').append(optionHtml);
                        $('#routing_final_destination_id').append(optionHtml);
                        $('#point_of_discharge_id').append(optionHtml);
                        $('#point_of_loading_id').append(optionHtml);
                    }

                    if (clickedLabel == 'port_of_discharge_id') {
                        $('#final_destination_id').append(optionHtml);
                        $('#port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_discharge_id').append(optionHtml);
                        $('#routing_final_destination_id').append(optionHtml);
                        $('#point_of_discharge_id').append(optionHtml);
                        $('#point_of_loading_id').append(optionHtml);
                    }
                    if (clickedLabel == 'port_of_loading_id') {
                        $('#port_of_discharge_id').append(optionHtml);
                        $('#final_destination_id').append(optionHtml);
                        $('#routing_port_of_loading_id').append(optionHtml);
                        $('#routing_port_of_discharge_id').append(optionHtml);
                        $('#routing_final_destination_id').append(optionHtml);
                        $('#point_of_discharge_id').append(optionHtml);
                        $('#point_of_loading_id').append(optionHtml);
                    }

                    // Parse formData using URLSearchParams
                    var params = new URLSearchParams(formData);

                    // Get all type_id values
                    var typeIdsArray = params.getAll('type_id[]');

                    if (typeIdsArray.includes('1') && clickedLabel != 'shipper_id') {
                        $('#shipper_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('2') && clickedLabel != 'consignee_id') {
                        $('#consignee_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('11') && clickedLabel !=
                        'custom_clearance_id') {
                        $('#custom_clearance_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('10') && clickedLabel !=
                        'transportation_id') {
                        $('#transportation_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('5') && clickedLabel !=
                        'forwarder_coloader_id') {
                        $('#forwarder_coloader_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('12') && clickedLabel != 'shipping_line_id') {
                        $('#shipping_line_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('6') && clickedLabel != 'local_vendor_id') {
                        $('#local_vendor_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('7') && clickedLabel != 'overseas_agent_id') {
                        $('#overseas_agent_id').append(optionHtml);
                    }

                    if (typeIdsArray.includes('17') && clickedLabel != 'air_line_id') {
                        $('#air_line_id').append(optionHtml);
                        $('#airline_id').append(optionHtml);
                    }
                    if (typeIdsArray.includes('17') && clickedLabel != 'airline_id') {
                        $('#air_line_id').append(optionHtml);
                        $('#airline_id').append(optionHtml);
                    }

                    // Append the new option to the select element
                    selectElement.append(optionHtml);
                    $('.modal select option').prop('selected', false);

                    // Clear the form inputs
                    $('.modal').find('input, textarea').val('');
                    $('.modal').find('select').each(function() {
                        var tomSelectInstance = this.tomselect;
                        if (tomSelectInstance) {
                            tomSelectInstance
                                .clear(); // Clear the selected value(s)
                            // Do not call clearOptions() to keep the options list
                        }
                    });
                    $('.modal').modal('hide');
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', status, error);
                    console.error('Response text:', xhr.responseText);

                    let errorMessage = 'An unexpected error occurred.';
                    if (xhr.status === 422) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            errorMessage = response.message || errorMessage;
                        } catch (e) {
                            console.error('Error parsing JSON response:', e);
                        }
                    } else {
                        // Handle other types of errors
                    }
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'error',
                        title: errorMessage,
                        showConfirmButton: false,
                        timer: 2500
                    });
                }
            });

        });

    });
</script>
<script>
    $(document).ready(function() {

        $('#vessel_id').change(function() {
            var vesselId = $(this).val();

            if (vesselId) {
                $.ajax({
                    url: '/api/get-voyage-details/' + vesselId,
                    type: 'GET',
                    success: function(data) {
                        console.log('response', data);

                        // Clear the current options in the select
                        $('#voyage_id').empty();

                        // Add "Please Select" as the default option
                        $('#voyage_id').append('<option value="">Please Select</option>');

                        // Loop through the returned data and append the options
                        data.forEach(function(item) {
                            $('#voyage_id').append('<option value="' + item.id +
                                '">' + item.voyage_no + '</option>');
                        });

                        // Select the last option added
                        $('#voyage_id option:last').prop('selected', true);

                        // Trigger the change event to refresh select2
                        $('#voyage_id').trigger('change');
                    },
                    error: function() {
                        $('#voyage_id').empty().append(
                            '<option value="">Please Select</option>');
                        @foreach ($voyages as $item)
                            $('#voyage_id').append(
                                '<option value="{{ $item->id }}">{{ $item->voyage_no }}</option>'
                            );
                        @endforeach

                        // Select the last option added
                        $('#voyage_id option:last').prop('selected', true);

                        $('#voyage_id').trigger('change');
                    }
                });
            } else {
                // If no vessel selected, show all available options
                $('#voyage_id').empty().append('<option value="">Please Select</option>');
                @foreach ($voyages as $item)
                    $('#voyage_id').append(
                        '<option value="{{ $item->id }}">{{ $item->voyage_no }}</option>');
                @endforeach

                // Select the last option added
                $('#voyage_id option:last').prop('selected', true);

                $('#voyage_id').trigger('change');
            }
        });

        $('#voyage_id').change(function() {
            var voyageId = $(this).val();

            if (voyageId) {
                $.ajax({
                    url: '/api/get-voyages-details/' + voyageId,
                    type: 'GET',
                    success: function(data) {
                        console.log('response', data);

                        // Clear the current options in the select
                        $('#etd').empty();
                        $('#eta').empty();
                        $('#cut_off').empty();

                        // Loop through the returned data and set the values
                        data.forEach(function(item) {
                            $('#etd').val(item
                                .export_sailing_date
                            ); // Set the value of 'etd' input
                            $('#eta').val(item
                                .export_dest_eta); // Set the value of 'eta' input
                            $('#cut_off').val(item.export_cut_of_date + ' ' + item
                                .export_cut_of_time
                            ); // Set the value of 'cut_off' input
                        });

                    },
                    error: function() {

                    }
                });
            } else {

            }
        });


        const defaultGrossWeight = {
            '20BK': 2000,
            '20FR': 2900,
            '20OT': 3000,
            '20RE': 3500,
            '20SD': 2350,
            '20TK': 4500,
            '40FR': 5000,
            '40BK': 5500,
            '40HC': 3900,
            '40HCRF': 6500,
            '40OT': 7000,
            '40SD': 3750,
            '40VH': 8000,
            '45BK': 8500,
            '45HC': 4800,
            '45OT': 9500,
            '45TK': 10000,
            '45VH': 10500,
            'M3': 11000
        };

        function updateValues() {
            $('.equipment_size_type').each(function(index) {
                const selectedSizeType = $(this).val();
                const quantity = parseInt($('.equipment_qty').eq(index).val()) || 0;
                const teu = $('.equipment_teu').eq(index);
                const grossWt = $('.equipment_gross_wt_cnt').eq(index);

                if (selectedSizeType.startsWith('40') || selectedSizeType.startsWith('45')) {
                    teu.val(2 * quantity);
                } else {
                    teu.val(1 * quantity);
                }

                if (defaultGrossWeight[selectedSizeType] !== undefined) {
                    grossWt.val(defaultGrossWeight[selectedSizeType] * quantity);
                }
            });
        }

        // Initial call to set the values on page load
        updateValues();

        $('.equipment_size_type, .equipment_qty').on('change input', updateValues);

        // let sellingValue = 0;
        let buyingValue = $('input[name="buying"]').val();
        var sellingValue = $('input[name="selling"]')
            .val(); // Initialize sellingValue with the current value of the input
        let containerCount = {{ $count }};
        $('input[name="selling"]').on('input', function() {
            var inputVal = $(this).val(); // Get the current input value
            sellingValue = inputVal !== "" ? inputVal :
                sellingValue; // If input is not empty, update sellingValue; otherwise, keep the previous value
            // $('input[name="receivable_ex_rate[]"]').val(
            //     sellingValue); // Set the value of receivable_ex_rate[] to sellingValue
            updateReceivableExRate();
        });

        $('input[name="buying"]').on('input', function() {
            var inputVal = $(this).val(); // Get the current input value
            buyingValue = inputVal !== "" ? inputVal : buyingValue;
            // $('input[name="payable_ex_rate[]"]').val(buyingValue);
            updatePayableExRate();
        });


        $('#tax_total_receivable').on('input', function() {
            updatePPCCReceiveable();
        });

        $('#tax_total_payable').on('input', function() {
            updatePPCCPayable();
        });

        $('#invoice-btn').click(function() {
            var job_status = "{{ $job_master->status }}";

            if (job_status == 2) {
                window.location.href = '/se_invoice/add/' + "{{ $job_master->id }}"
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'Job is not Approved!',
                    showConfirmButton: false,
                    timer: 2500
                })
            }
        })

        $('#bill-btn').click(function() {
            var job_status = "{{ $job_master->status }}";

            if (job_status == 2) {
                window.location.href = '/se_bill/add/' + "{{ $job_master->id }}"
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'Job is not Approved!',
                    showConfirmButton: false,
                    timer: 2500
                })
            }
        })

        // var rowEquipmentCounter = 1;
        // let lastRowEquipmentCounter = parseInt(document.getElementById('lastRowEquipmentCounter').value);
        // let rowEquipmentCounter = isNaN(lastRowEquipmentCounter) ? 1 : lastRowEquipmentCounter;

        function addRow() {
            var newRow = '<tr>' +
                '<td class="text-nowrap">' + rowEquipmentCounter +
                '<input type="hidden" name="equipment_rows" value=' + rowEquipmentCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDropdown('equipment_size_type[]', dropdownOptions.sizeType) +
                '</td>' +
                '<td><input type="text" name="equipment_rate_group[]" class="form-control"></td>' +
                '<td><input type="text" name="equipment_qty[]" class="form-control"></td>' +
                '<td class="text-nowrap">' + createDropdown('equipment_dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td><input type="text" name="equipment_gross_wt_cnt[]" class="form-control"></td>' +
                '<td><input type="text" name="equipment_teu[]" class="form-control"></td>' +
                '</tr>';
            $('#equipmentTable tbody').append(newRow);
            rowEquipmentCounter++;
        }

        $('#addRowEquipmentBtn').click(function() {
            addRow();
        });

        const dropdownOptions = {
            customers: {!! json_encode($clients) !!},
            overseasAgent: {!! json_encode($overseas_agent) !!},
            vendors: {!! json_encode($vendors) !!},
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: ["PKR", "USD", "AED", "GBP", "EUR", "BDT", "OMR"],
            approvedUsers: {!! json_encode($usersWithApprovedPermission) !!}
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please Select</option>';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDropdownWithValue(name, options, selectedValue = null) {
            var dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please select</option>';
            console.log('selectedContainerSizeType', selectedValue)
            options.forEach(function(option) {
                var selected = (selectedValue && selectedValue === option) ? ' selected' : '';
                dropdown += '<option value="' + option + '"' + selected + '>' + option + '</option>';
            });

            dropdown += '</select>';
            return dropdown;
        }


        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="select2 w-48">';
            dropdown += '<option value="">Please select</option>';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createCurrencyDropdown(name, currencies) {
            let dropdown = '<select name="' + name + '" class="form-control w-32">';
            dropdown += '<option value="">Please Select</option>';
            currencies.forEach((currency, index) => {
                dropdown += '<option value="' + (index + 1) + '">' + currency + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdownId(name, classname, options) {
            let dropdown = '<select name="' + name + '" class="select2 w-32 ' + classname + '">';
            dropdown += '<option value="">Please Select</option>';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '" data-currency-id="' + option
                    .currency_id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        function createReadOnly(type, name, placeholder) {
            if (type === "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '" value="1" class="form-check-input" disabled="disabled" placeholder="' + placeholder +
                    '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' + placeholder + '" readonly>';
            }
        }

        function createInputValueReadonly(type, name, value, classname) {
            return '<input type="' + type + '" name="' + name +
                '" value="' + value + '" class="form-control w-24 ' + classname + '" readonly>';
        }

        function createInputValue(type, name, placeholder, value) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '" value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" value="' + value + '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        function createInputReadonly(type, name, value, isManual) {
            var readonly = (isManual) ? '' : 'readonly';
            return '<input type="' + type + '" name="' + name + '" value="' + value +
                '" class="form-control w-24" ' + readonly + '>';
        }

        function calculateAmountPayable(inputField) {
            // console.log("here");
            let row = inputField.closest('tr');
            let qty = parseFloat(row.find('input[name^="payable_qty"]').val()) || 1;
            let rate = parseFloat(row.find('input[name^="payable_ratee"]').val()) || 0;
            let discount = parseFloat(row.find('input[name^="payable_discount"]').val()) || 0;
            let taxAmount = parseFloat(row.find('input[name^="payable_tax_amount_lc"]').val()) || 0;
            let payableExRate = parseFloat(row.find('input[name^="payable_ex_rate"]').val()) || 0;
            let tax = taxAmount / payableExRate;
            let amount = 0;
            let totalAmount = 0;

            if (!isNaN(qty) && !isNaN(rate)) {
                amount = qty * rate;
                totalAmount = amount - discount;
                row.find('input[name^="payable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else if (!isNaN(rate)) {
                amount = rate;
                totalAmount = amount - discount;
                row.find('input[name^="payable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else {
                row.find('input[name^="payable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            }

            if (!isNaN(discount) && !isNaN(tax)) {
                totalAmount = (amount + tax) - discount;
                row.find('input[name^="payable_net_amount"]').val(totalAmount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else if (!isNaN(discount)) {
                totalAmount = amount - discount;
                row.find('input[name^="payable_net_amount"]').val(totalAmount.toFixed(2));
            } else if (!isNaN(tax)) {
                totalAmount = amount + tax;
                row.find('input[name^="payable_net_amount"]').val(totalAmount.toFixed(2));
            } else {
                totalAmount = amount;
                row.find('input[name^="payable_net_amount"]').val(totalAmount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            }
            updatePPCCPayable();
            updatePayableExRate();
        }

        let receivableTotal = 0;
        let payableTotal = 0;
        let net = 0;
        let principalReceivableTotal = 0;
        let principalPayableTotal = 0;
        let principalNet = 0;

        function calculateNet() {
            receivableTotal = parseFloat($('#total_receivable').val()) || 0;
            payableTotal = parseFloat($('#total_payable').val()) || 0;
            net = 0;

            if (!isNaN(receivableTotal) && !isNaN(payableTotal)) {
                net = receivableTotal - payableTotal;
            }
            $('#net').val(net.toFixed(2));
        }

        function calculatePrincipalNet() {
            principalReceivableTotal = parseFloat($('#principal_receivable').val()) || 0;
            principalPayableTotal = parseFloat($('#principal_payable').val()) || 0;
            principalNet = 0;
            if (!isNaN(principalReceivableTotal) && !isNaN(principalPayableTotal)) {
                principalNet = principalReceivableTotal - principalPayableTotal;
            }
            $('#principal_net').val(principalNet.toFixed(2));
        }

        let taxAmountPayable = 0;

        function updatePPCCPayable() {
            ppPayableTotal = 0;
            ccPayableTotal = 0;
            principalPayable = 0;
            taxAmountPayable = parseFloat($('#tax_total_payable').val()) || 0;
            totalAmount = 0;

            $('#payableTable tbody tr').each(function() {
                let row = $(this);
                var payableStatus = row.find('input[name^="pay_bill_check"]').val();
                if (payableStatus != 2) {
                    var ppCcValue = row.find('select[name^="payable_ppcc"]').val();
                } else {
                    var ppCcValue = row.find('input[name^="payable_ppcc"]').val();

                }
                // let ppCcValue = row.find('select[name^="payable_ppcc"]').val();
                let netAmount = parseFloat(row.find('input[name^="payable_local_amount"]').val()) || 0;

                if (ppCcValue === 'PP') {
                    ppPayableTotal += netAmount;
                    totalAmount += netAmount;
                } else if (ppCcValue === 'CC') {
                    ccPayableTotal += netAmount;
                    totalAmount += netAmount;
                }

                principalPayable += netAmount;
            });

            if (!isNaN(taxAmountPayable)) {
                totalAmount = totalAmount + taxAmountPayable;
            }

            // Update the respective fields or display the totals somewhere on the page
            $('#pp_payable_total').val(ppPayableTotal.toFixed(2));
            $('#cc_payable_total').val(ccPayableTotal.toFixed(2));
            $('#principal_payable').val(principalPayable.toFixed(2));
            $('#total_payable').val(totalAmount.toFixed(2));
            calculateNet();
            updatePPCCReceiveable();
        }

        function calculateAmountReceiveable(inputField) {
            let row = inputField.closest('tr');
            let qty = parseFloat(row.find('input[name^="receivable_qty"]').val()) || 1;
            let rate = parseFloat(row.find('input[name^="receivable_ratee"]').val()) || 0;
            let discount = parseFloat(row.find('input[name^="receivable_discount"]').val()) || 0;
            let taxAmount = parseFloat(row.find('input[name^="receivable_tax_amount_lc"]').val()) || 0;
            let receivableExRate = parseFloat(row.find('input[name^="receivable_ex_rate"]').val()) || 0;
            let tax = taxAmount / receivableExRate;
            let amount = 0;
            let totalAmount = 0;

            if (!isNaN(qty) && !isNaN(rate)) {
                amount = qty * rate;
                totalAmount = amount - discount;
                row.find('input[name^="receivable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else if (!isNaN(rate)) {
                amount = rate;
                totalAmount = amount - discount;
                row.find('input[name^="receivable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else {
                row.find('input[name^="receivable_amount"]').val(amount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            }

            if (!isNaN(discount) && !isNaN(tax)) {
                totalAmount = (amount + tax) - discount;
                row.find('input[name^="receivable_net_amount"]').val(totalAmount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            } else if (!isNaN(discount)) {
                totalAmount = amount - discount;
                row.find('input[name^="receivable_net_amount"]').val(totalAmount.toFixed(2));
            } else if (!isNaN(tax)) {
                totalAmount = amount + tax;
                row.find('input[name^="receivable_net_amount"]').val(totalAmount.toFixed(2));
            } else {
                totalAmount = amount;
                row.find('input[name^="receivable_net_amount"]').val(totalAmount.toFixed(
                    2)); // You can adjust the number of decimal places as needed
            }
            updatePPCCReceiveable();
            updateReceivableExRate();
        }

        let taxAmountReceiveable = 0;

        function updatePPCCReceiveable() {
            ppReceivableTotal = 0;
            ccReceivableTotal = 0;
            principalReceivable = 0;
            taxAmountReceiveable = parseFloat($('#tax_total_receivable').val()) || 0;
            totalAmount = 0;

            $('#receiveableTable tbody tr').each(function() {
                let row = $(this);
                var receivableStatus = row.find('input[name^="rec_bill_check"]').val();
                if (receivableStatus != 2) {
                    var ppCcValue = row.find('select[name^="receivable_ppcc"]').val();
                } else {
                    var ppCcValue = row.find('input[name^="receivable_ppcc"]').val();

                }
                let netAmount = parseFloat(row.find('input[name^="receivable_local_amount"]').val()) ||
                    0;

                if (ppCcValue === 'PP') {
                    ppReceivableTotal += netAmount;
                    totalAmount += netAmount;
                } else if (ppCcValue === 'CC') {
                    ccReceivableTotal += netAmount;
                    totalAmount += netAmount;
                }

                principalReceivable += netAmount;
            });

            if (!isNaN(taxAmountReceiveable)) {
                totalAmount = totalAmount + taxAmountReceiveable;
            }

            // Update the respective fields or display the totals somewhere on the page
            $('#pp_receivable_total').val(ppReceivableTotal.toFixed(2));
            $('#cc_receivable_total').val(ccReceivableTotal.toFixed(2));
            $('#principal_receivable').val(principalReceivable.toFixed(2));
            $('#total_receivable').val(totalAmount.toFixed(2));
            calculateNet();
            calculatePrincipalNet();
        }
        var selectedContainerSizeType = @json($selectedContainerSizeType);

        // Get the value of lastRowpayableCounter
        let lastRowpayableCounter = parseInt(document.getElementById('lastRowpayableCounter').value);
        let lastReceivableCounter = parseInt(document.getElementById('lastRowReceivableCounter').value);
        let rowPayableCounter = isNaN(lastRowpayableCounter) ? 1 : lastRowpayableCounter;
        let rowReceivableCounter = isNaN(lastReceivableCounter) ? 1 : lastReceivableCounter;
        var currentDateFromController = "<?php echo $currentDate; ?>";

        function addRowPayable() {
            var selectedValue = selectedContainerSizeType ? selectedContainerSizeType : null;
            // console.log(selectedValue);
            let row = '<tr>' +
                '<td class="text-nowrap">' +
                '<button type="button" class="btn btn-danger delete-payable-row">' +
                'Delete' +
                '</button>' +
                '<input type="hidden" name="pay_bill_check[]" value="1">' +
                '</td>' +
                '<td></td>' +
                '<td class="text-nowrap">' + rowPayableCounter +
                '<input type="hidden" name="payable_rows" value=' + rowPayableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_bill_invoice[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdownId('payable_charge_id[]', 'payable_charge_id',
                    dropdownOptions
                    .charges) + '</td>' +
                '<td class="text-nowrap">' +
                '<div class="form-group">' +
                '<input type="text" name="payable_description[]" class="form-control w-52" />' +
                '<div class="invalid-feedback">Description is required</div>' +
                '</div>' +
                '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'payable_particular[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'payable_description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_type[]', dropdownOptions.type) + '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_basis[]', dropdownOptions.basis) +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_ppcc[]', dropdownOptions.ppcc) + '</td>' +
                '<td class="text-nowrap">' + createDropdownWithValue('payable_size_type[]', dropdownOptions
                    .sizeType, selectedValue) +
                '</td>' +
                '<td class="text-nowrap">' + createInputValue('text', 'payable_rate_group[]', '', 'ALL') +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('payable_dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'payable_manual[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInputReadonly('text', 'payable_qty[]', containerCount,
                    isManual) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_ratee[]', '') + '</td>' +
                '<td class="text-nowrap">' + createCurrencyDropdown('payable_currency[]', dropdownOptions
                    .currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInputValue('text', 'payable_margin[]', '', '0.00') +
                '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_discount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'payable_tax_apply[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'payable_tax_rev_share[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_tax_amount_lc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInputValueReadonly('text', 'payable_ex_rate[]',
                    buyingValue, 'payable_ex_rate') +
                '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_local_amount[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'payable_customer_code[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdownId('payable_vendor_id[]', 'payable_vendor_id',
                    dropdownOptions
                    .vendors) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_manifest_remarks[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'payable_tariff_code[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('checkbox', 'payable_approved[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_approved_by[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'payable_approved_date[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('date', 'payable_approval_log[]', '') + '</td>' +
                '</tr>';
            $('#payableTable tbody').append(row);
            rowPayableCounter++;

            $('#payableTable tbody tr:last-child input[name^="payable_qty"], #payableTable tbody tr:last-child input[name^="payable_ex_rate"], #payableTable tbody tr:last-child input[name^="payable_ratee"], #payableTable tbody tr:last-child input[name^="payable_discount"], #payableTable tbody tr:last-child input[name^="payable_tax_amount_lc"]', )
                .on('input', function() {
                    // console.log("Input detected");
                    calculateAmountPayable($(this));
                });
            // Attach event listener to the newly added charge dropdown
            $('#payableTable tbody tr:last-child select[name^="payable_charge_id"]').on('change', function() {
                checkForDuplicateChargesPayable();
                updateCurrencyBasedOnChargePayable($(this));
                setPayableValues($(this).closest('tr'));
                updatePayableExRate();
            });

            // Attach event listener to the ppcc change
            $('#payableTable tbody tr:last-child select[name^="payable_ppcc"]').on('change', function() {
                updatePPCCPayable();
            });

            // Attach event listener to the ppcc change
            $('#payableTable tbody tr:last-child select[name^="payable_currency"]').on('change', function() {
                calculateAmountPayable($(this));
            });

            var isManual = false;
            $('#payableTable tbody tr:last-child input[name^="payable_manual"]').on('change', function() {
                // Get the checked status of the checkbox
                var isChecked = $(this).is(':checked');
                // Update isManual variable accordingly
                isManual = isChecked;
                // Update the readonly attribute of the quantity input fields based on the checkbox status
                $(this).closest('tr').find('input[name^="payable_qty"]').prop('readonly', !isChecked);
            });

            // Attach event listener to delete the row when the delete button is clicked
            $('#payableTable tbody tr:last-child .delete-payable-row').on('click', function() {
                $(this).closest('tr').remove();
                rowPayableCounter--;
            });

            // Reinitialize select2 on the newly added dropdowns
            $('.select2').select2();

        }

        function setPayableValues(tr) {
            console.log("Setting payable values for row:");
            console.log(tr);

            // Check if payable_charge_id has a selected value
            var chargeId = $(tr).find('select[name^="payable_charge_id"]').val();
            if (chargeId !== null && chargeId !== '') {
                // Set values based on 'name' attributes of select options within the provided tr
                $(tr).find('select[name^="payable_type"]').val('Inv');
                $(tr).find('select[name^="payable_basis"]').val('Unit');
                $(tr).find('select[name^="payable_ppcc"]').val('PP');
                $(tr).find('select[name^="payable_dg_non_dg"]').val('Non-DG');
            } else {
                $(tr).find('select[name^="payable_type"]').val('');
                $(tr).find('select[name^="payable_basis"]').val('');
                $(tr).find('select[name^="payable_ppcc"]').val('');
                $(tr).find('select[name^="payable_dg_non_dg"]').val('');
            }
        }

        function updateCurrencyBasedOnChargePayable(chargeDropdown) {
            const selectedChargeOption = chargeDropdown.find('option:selected');
            console.log(selectedChargeOption);
            const currencyId = selectedChargeOption.data('currency-id');
            // console.log(currencyId);


            if (currencyId) {
                const currencyDropdown = chargeDropdown.closest('tr').find('select[name^="payable_currency"]');
                console.log(currencyId);
                currencyDropdown.val(currencyId);
            }
        }
        // var isManual = false;
        // $('input[name^="payable_manual"]').on('change', function() {
        //     // Get the checked status of the checkbox
        //     var isChecked = $(this).is(':checked');
        //     // Update isManual variable accordingly
        //     isManual = isChecked;
        //     // Update the readonly attribute of the quantity input fields based on the checkbox status
        //     $('input[name^="payable_qty"]').prop('readonly', !isChecked);
        // });

        // Function to check for duplicate charges and make description required if duplicates are found
        function checkForDuplicateChargesPayable() {
            let charges = {};
            $('#payableTable tbody tr').each(function() {
                let chargeDropdown = $(this).find('select[name^="payable_charge_id"]');
                let descriptionInput = $(this).find('input[name^="payable_description"]');
                let descriptionContainer = descriptionInput.closest('.form-group');
                let selectedCharge = chargeDropdown.val();

                if (charges[selectedCharge]) {
                    // Duplicate charge found, make description required and add Bootstrap validation classes
                    descriptionInput.prop('required', true);
                    descriptionContainer.addClass('was-validated');
                    descriptionInput.addClass('is-invalid');
                } else {
                    // No duplicate charge, remove required attribute and Bootstrap validation classes
                    descriptionInput.prop('required', false);
                    descriptionContainer.removeClass('was-validated');
                    descriptionInput.removeClass('is-invalid');
                    charges[selectedCharge] = true;
                }
            });
            addRowPayable();
        }

        function addRowReceivable() {
            var selectedValue = selectedContainerSizeType ? selectedContainerSizeType : null;
            console.log('selectedContainerSizeType', selectedValue)
            let row = '<tr>' +
                '<td class="text-nowrap">' +
                '<button type="button" class="btn btn-danger delete-receivable-row">' +
                'Delete' +
                '</button>' +
                '<input type="hidden" name="rec_bill_check[]" value="1">' +
                '</td>' +
                '<td></td>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_bill_invoice[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdownId('receivable_charge_id[]',
                    'receivable_charge_id', dropdownOptions
                    .charges) + '</td>' +
                '<td class="text-nowrap">' +
                '<div class="form-group">' +
                '<input type="text" name="receivable_description[]" class="form-control w-52" />' +
                '<div class="invalid-feedback">Description is required.</div>' +
                '</div>' +
                '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'receivable_description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_type[]', dropdownOptions.type) +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_basis[]', dropdownOptions.basis) +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_ppcc[]', dropdownOptions.ppcc) +
                '</td>' +
                '<td class="text-nowrap">' + createDropdownWithValue('receivable_size_type[]', dropdownOptions
                    .sizeType, selectedValue) + '</td>' +
                '<td class="text-nowrap">' + createInputValue('text', 'receivable_rate_group[]', '', 'ALL') +
                '</td>' +
                '<td class="text-nowrap">' + createDropdown('receivable_dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'receivable_manual[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInputReadonly('text', 'receivable_qty[]', containerCount,
                    isManualRec) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_ratee[]', '') + '</td>' +
                '<td class="text-nowrap">' + createCurrencyDropdown('receivable_currency[]', dropdownOptions
                    .currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInputValue('text', 'receivable_margin[]', '', '0.00') +
                '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_discount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'receivable_tax_apply[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('checkbox', 'receivable_tax_rev_share[]', '') +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_tax_amount_lc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInputValueReadonly('text', 'receivable_ex_rate[]',
                    sellingValue, 'receivable_ex_rate') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_local_amount[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'receivable_customer_code[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdownId('receivable_customer_id[]',
                    'receivable_customer_id', dropdownOptions
                    .customers) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_manifest_remarks[]', '') +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'receivable_tariff_code[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('checkbox', 'receivable_approved[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('text', 'receivable_approved_by[]', '') + '</td>' +
                '<td class="text-nowrap">' + createReadOnly('date', 'receivable_approved_date[]', '') +
                '</td>' +
                '<td class="text-nowrap">' + createReadOnly('date', 'receivable_approval_log[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;

            $('#receiveableTable tbody tr:last-child input[name^="receivable_qty"], #receiveableTable tbody tr:last-child input[name^="receivable_ratee"], #receiveableTable tbody tr:last-child input[name^="receivable_discount"], #receiveableTable tbody tr:last-child input[name^="receivable_ex_rate"], #receiveableTable tbody tr:last-child input[name^="receivable_tax_amount_lc"]')
                .on('input', function() {
                    // console.log("Input detected");
                    calculateAmountReceiveable($(this));
                });


            $('#receiveableTable tbody tr:last-child select[name^="receivable_ppcc"]').on('change',
                function() {
                    clientORAgent($(this));
                });

            $('#receiveableTable tbody tr:last-child select[name^="receivable_currency"]').on('change',
                function() {
                    calculateAmountReceiveable($(this));
                });

            // Attach event listener to the newly added charge dropdown
            $('#receiveableTable tbody tr:last-child select[name^="receivable_charge_id"]').on('change',
                function() {
                    checkForDuplicateCharges();
                    updateCurrencyBasedOnCharge($(this));
                    setReceiveableValues($(this).closest('tr'));
                    updateReceivableExRate();
                });

            // Attach event listener to the ppcc change
            $('#receiveableTable tbody tr:last-child select[name^="receivable_ppcc"]').on('change', function() {
                updatePPCCReceiveable();
            });

            var isManualRec = false;
            $('#receiveableTable tbody tr:last-child input[name^="receivable_manual"]').on('change',
                function() {
                    // Get the checked status of the checkbox
                    var isChecked = $(this).is(':checked');
                    // Update isManual variable accordingly
                    isManualRec = isChecked;
                    // Update the readonly attribute of the quantity input fields based on the checkbox status
                    $(this).closest('tr').find('input[name^="receivable_qty"]').prop('readonly', !
                        isChecked);
                });

            // Attach event listener to delete the row when the delete button is clicked
            $('#receiveableTable tbody tr:last-child .delete-receivable-row').on('click', function() {
                $(this).closest('tr').remove();
                rowReceivableCounter--;
            });

            // Reinitialize select2 on the newly added dropdowns
            $('.select2').select2();
        }


        function clientORAgent(element) {
            console.log('here');
            var ppccValue = element.val();
            var customerDropdown = element.closest('tr').find('select[name^="receivable_customer_id"]');
            // if (ppccValue === 'PP') {
            //     customerDropdown.html(dropdownOptions.customers);
            // } else if (ppccValue === 'CC') {
            //     customerDropdown.html(dropdownOptions.overseasAgent);
            // }
            // Clear the dropdown options first
            // Clear the existing options
            customerDropdown.empty();

            // Add the default option
            customerDropdown.append('<option value="">Please Select</option>');

            // Depending on ppccValue, populate the dropdown with the correct options
            if (ppccValue === 'PP') {
                dropdownOptions.customers.forEach(function(option) {
                    customerDropdown.append('<option value="' + option.id + '" data-currency-id="' +
                        option.currency_id + '">' + option.name + '</option>');
                });
            } else if (ppccValue === 'CC') {
                dropdownOptions.overseasAgent.forEach(function(option) {
                    customerDropdown.append('<option value="' + option.id + '" data-currency-id="' +
                        option.currency_id + '">' + option.name + '</option>');
                });
            }
        }

        function setReceiveableValues(tr) {

            // Check if payable_charge_id has a selected value
            var chargeId = $(tr).find('select[name^="receivable_charge_id"]').val();
            if (chargeId !== null && chargeId !== '') {
                // Set values based on 'name' attributes of select options within the provided tr
                $(tr).find('select[name^="receivable_type"]').val('Inv');
                $(tr).find('select[name^="receivable_basis"]').val('Unit');
                $(tr).find('select[name^="receivable_ppcc"]').val('PP');
                $(tr).find('select[name^="receivable_dg_non_dg"]').val('Non-DG');
            } else {
                $(tr).find('select[name^="receivable_type"]').val('');
                $(tr).find('select[name^="receivable_basis"]').val('');
                $(tr).find('select[name^="receivable_ppcc"]').val('');
                $(tr).find('select[name^="receivable_dg_non_dg"]').val('');
            }
        }

        $('.payable_charge_id').each(function() {
            $(this).change(function() {
                // updateCurrencyBasedOnChargePayable($(this));
                setPayableValues($(this).closest('tr'));
            });
        });

        $('.receivable_ppcc').each(function() {
            $(this).change(
                function() {
                    clientORAgent($(this));
                });
        });

        $('.receivable_charge_id').each(function() {
            $(this).change(function() {
                // updateCurrencyBasedOnCharge($(this));
                setReceiveableValues($(this).closest('tr'));
            });
        });

        function updateReceivableExRate() {
            var exRate = $('#ex_rate').val();
            var sellingRate = $('#selling_rate').val();

            $('#receiveableTable tbody tr').each(function() {
                let row = $(this);
                var receivableStatus = row.find('input[name^="rec_bill_check"]').val();
                console.log("receivableStatus: ", receivableStatus);

                if (receivableStatus != 2) {
                    var ReceivableCurrency = row.find('select[name^="receivable_currency"]').val();
                    console.log("ReceivableCurrency: ", ReceivableCurrency);
                    console.log("exRate: ", exRate);
                    var receivableExRateInput = row.find('input[name^="receivable_ex_rate"]');
                    var receivableNetAmount = parseFloat(row.find(
                            'input[name^="receivable_net_amount"]')
                        .val()) || 0;
                    var localAmountInput = row.find('input[name^="receivable_local_amount"]');

                    // if (ReceivableCurrency == "PKR" || exRate == 2) {
                    //     receivableExRateInput.val(1);
                    // } else if (ReceivableCurrency === exRate) {
                    //     receivableExRateInput.val(sellingRate);
                    // } else if (ReceivableCurrency == "USD" && exRate == 1) {
                    //     receivableExRateInput.val(sellingRate);
                    // } else if (ReceivableCurrency == "AED" && exRate == 3) {
                    //     receivableExRateInput.val(sellingRate);
                    // } else if (ReceivableCurrency == "BDT" && exRate == 4) {
                    //     receivableExRateInput.val(sellingRate);
                    // } else if (ReceivableCurrency == "OMR" && exRate == 5) {
                    //     receivableExRateInput.val(sellingRate);
                    // } else if (ReceivableCurrency == "EUR" && exRate == 6) {
                    //     receivableExRateInput.val(sellingRate);
                    // } else if (ReceivableCurrency == "GBP" && exRate == 7) {
                    //     receivableExRateInput.val(sellingRate);
                    // } else {
                    //     receivableExRateInput.val(0);
                    // }

                    if (receivableExRateInput.is('[readonly]')) {
                        if (ReceivableCurrency == 1 || exRate == 1) {
                            receivableExRateInput.val(1);
                        } else if (ReceivableCurrency === exRate) {
                            receivableExRateInput.val(sellingRate);
                        } else {
                            receivableExRateInput.val(0);
                        }
                    }

                    // Calculate local amount if receivable_ex_rate > 0
                    var receivableExRate = parseFloat(receivableExRateInput.val());
                    if (receivableExRate > 0) {
                        var localAmount = receivableNetAmount * receivableExRate;
                        localAmountInput.val(localAmount);
                    } else {
                        localAmountInput.val(0);
                    }
                }
            });
            updatePPCCReceiveable();
        }

        function updatePayableExRate() {
            var exRate = $('#ex_rate').val();
            var buyingRate = $('#buying_rate').val();

            $('#payableTable tbody tr').each(function() {
                let row = $(this);
                var payableStatus = row.find('input[name^="pay_bill_check"]').val();
                if (payableStatus != 2) {
                    var payableCurrency = row.find('select[name^="payable_currency"]').val();
                    // console.log(payableCurrency);
                    var payableExRateInput = row.find('input[name^="payable_ex_rate"]');
                    var payableNetAmount = parseFloat(row.find('input[name^="payable_net_amount"]')
                        .val()) || 0;
                    var localAmountInput = row.find('input[name^="payable_local_amount"]');

                    // if (payableCurrency == "PKR" || exRate == 2) {
                    //     payableExRateInput.val(1);
                    // } else if (payableCurrency === exRate) {
                    //     payableExRateInput.val(buyingRate);
                    // } else if (payableCurrency == "USD" && exRate == 1) {
                    //     payableExRateInput.val(buyingRate);
                    // } else if (payableCurrency == "AED" && exRate == 3) {
                    //     payableExRateInput.val(buyingRate);
                    // } else if (payableCurrency == "BDT" && exRate == 4) {
                    //     payableExRateInput.val(buyingRate);
                    // } else if (payableCurrency == "OMR" && exRate == 5) {
                    //     payableExRateInput.val(buyingRate);
                    // } else if (payableCurrency == "EUR" && exRate == 6) {
                    //     payableExRateInput.val(buyingRate);
                    // } else if (payableCurrency == "GBP" && exRate == 7) {
                    //     payableExRateInput.val(buyingRate);
                    // } else {
                    //     payableExRateInput.val(0);
                    // }

                    if (payableExRateInput.is('[readonly]')) {
                        if (payableCurrency == 1 || exRate == 1) {
                            payableExRateInput.val(1);
                        } else if (payableCurrency === exRate) {
                            payableExRateInput.val(buyingRate);
                        } else {
                            payableExRateInput.val(0);
                        }
                    }

                    // Calculate local amount if receivable_ex_rate > 0
                    var payableExRate = parseFloat(payableExRateInput.val());
                    if (payableExRate > 0) {
                        var localAmount = payableNetAmount * payableExRate;
                        localAmountInput.val(localAmount);
                    } else {
                        localAmountInput.val(0);
                    }
                }
            });
            updatePPCCPayable();
        }

        // Event listeners for changes
        $('#ex_rate').change(function() {
            updateReceivableExRate();
            updatePayableExRate();
        });
        $('#selling_rate').change(updateReceivableExRate);
        $('#buying_rate').change(updatePayableExRate);

        function updateCurrencyBasedOnCharge(chargeDropdown) {
            const selectedChargeOption = chargeDropdown.find('option:selected');
            const currencyId = selectedChargeOption.data('currency-id');

            console.log(currencyId);

            if (currencyId) {
                const currencyDropdown = chargeDropdown.closest('tr').find(
                    'select[name^="receivable_currency"]');
                console.log(currencyId);
                currencyDropdown.val(currencyId);
            }
        }
        // var isManualRec = false;
        // $('input[name^="receivable_manual"]').on('change', function() {
        //     // Get the checked status of the checkbox
        //     var isChecked = $(this).is(':checked');
        //     // Update isManual variable accordingly
        //     isManualRec = isChecked;
        //     // Update the readonly attribute of the quantity input fields based on the checkbox status
        //     $('input[name^="receivable_qty"]').prop('readonly', !isChecked);
        // });

        // Function to check for duplicate charges and make description required if duplicates are found
        function checkForDuplicateCharges() {
            let charges = {};
            $('#receiveableTable tbody tr').each(function() {
                let chargeDropdown = $(this).find('select[name^="receivable_charge_id"]');
                let descriptionInput = $(this).find('input[name^="receivable_description"]');
                let descriptionContainer = descriptionInput.closest('.form-group');
                let selectedCharge = chargeDropdown.val();
                
                let isReadOnly = descriptionInput.prop('readonly');
                if (charges[selectedCharge]) {
                    // Duplicate charge found, make description required and add Bootstrap validation classes
                    descriptionInput.prop('required', true);
                    descriptionContainer.addClass('was-validated');
                    descriptionInput.addClass('is-invalid');
                } else {
                    // No duplicate charge, remove required attribute and Bootstrap validation classes
                    descriptionInput.prop('required', false);
                    descriptionContainer.removeClass('was-validated');
                    descriptionInput.removeClass('is-invalid');
                    charges[selectedCharge] = true;
                }
                 if (isReadOnly) {
                    descriptionInput.prop('required', true);
                    descriptionInput.removeClass('is-invalid');
                }
            });
            addRowReceivable();
        }

        // Function to calculate local amount based on currency and amount
        function calculateLocalAmount(currency, amount) {
            // Define conversion rates for each currency
            var conversionRates = {
                "USD": 278.31,
                "AED": 75.77,
                "BDT": 2.37,
                "OMR": 723.22,
                "EUR": 301.54,
                "GBP": 353.88
                // Add more conversion rates as needed
            };

            // Check if the currency is in the conversion rates table
            if (conversionRates.hasOwnProperty(currency)) {
                var conversionRate = conversionRates[currency];
                return amount * conversionRate;
            } else {
                // If currency not found, return the original amount
                return amount;
            }
        }

        // Event listener for currency dropdown change in payable rows
        $('#payableTable tbody').on('change', 'select[name^="payable_currency"]', function() {
            updatePayableExRate();
            // var currency = $(this).val();
            // var amount = parseFloat($(this).closest('tr').find('input[name^="payable_amount[]"]')
            //     .val());
            // var localAmountInput = $(this).closest('tr').find('input[name^="payable_local_amount[]"]');
            // var localAmount = calculateLocalAmount(currency, amount);
            // localAmountInput.val(localAmount.toFixed(2));
        });


        // Event listener for amount input change in payable rows
        $('#payableTable tbody').on('input', 'input[name^="payable_amount[]"]', function() {
            updatePayableExRate();
            // var currency = $(this).closest('tr').find('select[name^="payable_currency"]').val();
            // var amount = parseFloat($(this).val());
            // var localAmountInput = $(this).closest('tr').find('input[name^="payable_local_amount[]"]');
            // var localAmount = calculateLocalAmount(currency, amount);
            // localAmountInput.val(localAmount.toFixed(2));
        });

        // Event listener for currency dropdown change in receivable rows
        $('#receiveableTable tbody').on('change', 'select[name^="receivable_currency"]', function() {
            updateReceivableExRate();
            // var currency = $(this).val();
            // var amount = parseFloat($(this).closest('tr').find('input[name^="receivable_amount[]"]')
            //     .val());
            // var localAmountInput = $(this).closest('tr').find(
            //     'input[name^="receivable_local_amount[]"]');
            // var localAmount = calculateLocalAmount(currency, amount);
            // localAmountInput.val(localAmount.toFixed(2));
        });

        // Event listener for amount input change in receivable rows
        $('#receiveableTable tbody').on('input', 'input[name^="receivable_amount[]"]', function() {
            updateReceivableExRate();
            // var currency = $(this).closest('tr').find('select[name^="receivable_currency"]').val();
            // var amount = parseFloat($(this).val());
            // var localAmountInput = $(this).closest('tr').find(
            //     'input[name^="receivable_local_amount[]"]');
            // var localAmount = calculateLocalAmount(currency, amount);
            // localAmountInput.val(localAmount.toFixed(2));
        });

        // Function to attach event listeners to inputs for calculating amounts
        function attachEventListeners() {
            $('#receiveableTable tbody tr input[name^="receivable_qty"], #receiveableTable tbody tr input[name^="receivable_ratee"], #receiveableTable tbody tr input[name^="receivable_discount"], #receiveableTable tbody tr:last-child input[name^="receivable_ex_rate"], #receiveableTable tbody tr input[name^="receivable_tax_amount_lc"]')
                .on('input', function() {
                    calculateAmountReceiveable($(this));
                });
            $('#receiveableTable tbody tr:last-child select[name^="receivable_currency"]').on('change',
                function() {
                    calculateAmountReceiveable($(this));
                });
            $('#payableTable tbody tr input[name^="payable_qty"], #payableTable tbody tr:last-child input[name^="payable_ex_rate"], #payableTable tbody tr input[name^="payable_ratee"], #payableTable tbody tr input[name^="payable_discount"], #payableTable tbody tr input[name^="payable_tax_amount_lc"]', )
                .on('input', function() {
                    // console.log("Input detected");
                    calculateAmountPayable($(this));
                });
            // Attach event listener to the ppcc change
            $('#payableTable tbody tr:last-child select[name^="payable_currency"]').on('change', function() {
                calculateAmountPayable($(this));
            });
            updateReceivableExRate();
            updatePayableExRate();
        }

        $('#addRowPayableButton').click(addRowPayable);
        $('#addRowReceivableButton').click(addRowReceivable);
        attachEventListeners();
        addRowPayable();
        addRowReceivable();

    });
</script>
