<!-- BEGIN: Modal Content -->
<div id="addParty" class="modal" tabindex="-1" aria-hidden="true" data-api-url="{{ url('/api/se_job/add/party') }}">
    <div class="modal-dialog modal-xl">
        <div class="modal-content"> <!-- BEGIN: Modal Header -->
            <form method="POST">
                @csrf
                <div class="modal-header">
                    <h2 class="fw-medium fs-base mr-auto">Add Party</h2>
                </div> <!-- END: Modal Header --> <!-- BEGIN: Modal Body -->
                <div class="modal-body grid-cols-12 gap-4 gap-y-3">
                    <div class="row mb-5">
                        <div class="col-md-4 mt-2">
                            <label for="party_is" class="form-label">Party</label>
                            <select id="party_is" name="party_is" class="select2 w-full">
                                <option value="customer">Customer</option>
                                <option value="vendor">Vendor</option>
                                <option value="customer_vendor">Customer/Vendor</option>
                                <option value="non_gl_parties">Non GL Parties</option>
                            </select>
                        </div>
                        <div class="col-md-4 mt-2">
                            <label for="name" class="form-label">Name</label>
                            <input id="party-name" type="text" class="form-control" placeholder="Enter Name"
                                name="name">
                        </div>
                        <div class="col-md-4 mt-2">
                            <label for="reg_date" class="form-label">Reg. Date</label>
                            <input id="reg_date" type="date" class="form-control" placeholder="Enter Reg. Date"
                                name="reg_date" value="{{ $currentDate }}">
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="license_no" class="form-label">License No.</label>
                            <input id="license_no" type="text" class="form-control" placeholder="Enter License No."
                                name="license_no">
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="contact_person" class="form-label">Contact Person</label>
                            <input id="contact_person" type="text" class="form-control"
                                placeholder="Enter Contact Person" name="contact_person">
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="ntn_no" class="form-label">NTN #</label>
                            <input id="ntn_no" type="text" class="form-control" placeholder="Enter NTN #"
                                name="ntn_no">
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="strn_no" class="form-label">STRN #</label>
                            <input id="strn_no" type="text" class="form-control" placeholder="Enter STRN #"
                                name="strn_no">
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="email" class="form-label">Email</label>
                            <input id="email" type="text" class="form-control" placeholder="Enter Email"
                                name="email">
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="phone_no" class="form-label">Phone No.</label>
                            <input id="phone_no" type="text" class="form-control" placeholder="Enter Phone No."
                                name="phone_no">
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="mobile" class="form-label">Phone No. 2</label>
                            <input id="mobile" type="text" class="form-control" placeholder="Enter Phone No."
                                name="mobile">
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="website" class="form-label">Website</label>
                            <input id="website" type="text" class="form-control" placeholder="Enter Website"
                                name="website">
                        </div>
                        <div class="col-md-8 mt-2">
                            <label for="address" class="form-label">Address</label>
                            <textarea id="address" name="address" class="form-control" cols="30" rows="2"></textarea>
                        </div>
                        <div class="col-md-4 mt-2">
                            <label for="country_id" class="form-label">Country</label>
                            <select data-placeholder="Select Country" id="country_id" name="country_id"
                                class="select2 w-full">
                                <option value=""></option>
                                @foreach ($countries as $country)
                                    <option value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mt-2">
                            <label for="city_id" class="form-label">City</label>
                            <select data-placeholder="Select City" id="city_id" name="city_id"
                                class="select2 w-full">
                                <option value=""></option>
                            </select>
                        </div>
                        <div class="col-md-3 mt-2">
                            <label for="zip_code" class="form-label">Zip Code</label>
                            <input id="zip_code" type="text" class="form-control" placeholder="Enter Zip Code"
                                name="zip_code">
                        </div>
                        <div class="col-md-4 mt-2">
                            <label for="operation_id" class="form-label">Operations</label>
                            <select multiple data-placeholder="Select Operations" id="operation_id"
                                name="operation_id[]" class="select2 w-full">
                                @foreach ($party_operations as $party_operation)
                                    <option value="{{ $party_operation->id }}">{{ $party_operation->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mt-2">
                            <label for="type_id" class="form-label">Party Type</label>
                            <div class="mt-2">
                                <select multiple data-placeholder="Select Party Type" id="type_id" name="type_id[]"
                                    class="select2 w-full">
                                    @foreach ($party_types as $party_type)
                                        <option value="{{ $party_type->id }}">{{ $party_type->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 d-flex align-items-end">
                            <div class="form-group me-5">
                                <input id="import_nomination" type="checkbox" class="form-check-input"
                                    name="import_nomination" value="1">
                                <label class="form-label" for="import_nomination">Import Nomination</label>
                            </div>
                            <div class="form-group">
                                <input id="export_nomination" type="checkbox" class="form-check-input"
                                    name="export_nomination" value="1">
                                <label class="form-label" for="export_nomination">Export Nomination</label>
                            </div>
                        </div>
                        <div class="col-md-4 d-flex flex-column justify-content-end mt-3">
                            <div class="form-group">
                                <input id="company_restriction" type="checkbox" class="form-check-input"
                                    name="company_restriction" value="1">
                                <label class="form-label" for="company_restriction">Apply Company Restriction</label>
                            </div>
                            <div class="form-group">
                                <input id="cost_center_restriction" type="checkbox" class="form-check-input"
                                    name="cost_center_restriction" value="1">
                                <label class="form-label" for="cost_center_restriction">Apply Cost Center
                                    Restriction</label>
                            </div>
                        </div>
                        <div id="add-coa">
                            <div
                                class="d-flex flex-column flex-sm-row align-items-center pb-5 pt-5 border-bottom border-gray-200 dark-border-dark-5">
                                <h2 class="fw-medium fs-base me-auto">
                                    Add Chart of Account
                                </h2>
                            </div>

                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label>Parent Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Account" id="parent_account_id"
                                            name="parent_account_id" class="select2 w-full">
                                            <option value="">Please Select Parent Account
                                            </option>
                                            @foreach ($parent_accounts as $account)
                                                <option value="{{ $account->id }}">
                                                    {{ $account->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <label for="regular-form-1" class="form-label">Account Code</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Account Code" name="account_code">
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input id="coa_name" type="text" class="form-control"
                                        placeholder="Enter Name" name="coa_name">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Alias</label>
                                    <input id="alias" type="text" class="form-control"
                                        placeholder="Enter Alias" name="alias">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Max Child Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Max Child Account" id="max_child_account"
                                            name="max_child_account" class="select2 w-full">
                                            <option value="99">99</option>
                                            <option value="999">999</option>
                                            <option value="999">999</option>
                                            <option value="9999">9999</option>
                                            <option value="99999">99999</option>
                                            <option value="999999">999999</option>
                                            <option value="9999999">9999999</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Category" id="category_id"
                                            name="category_id" class="select2 w-full">
                                            <option value="">Please Select Category</option>
                                            @foreach ($account_categories as $category)
                                                <option value="{{ $category->id }}">
                                                    {{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Sub Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Sub Category" id="sub_category_id"
                                            name="sub_category_id" class="select2 w-full">
                                            <option value="">Please Select Sub Category</option>
                                            @foreach ($account_sub_categories as $sub_category)
                                                <option value="{{ $sub_category->id }}">
                                                    {{ $sub_category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Reference
                                        No</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Reference No" name="reference_number">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="select2 w-full">
                                            <option value="1">Active</option>
                                            <option value="0">In Active</option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div> <!-- END: Modal Body --> <!-- BEGIN: Modal Footer -->
                <div class="modal-footer text-right">
                    <button type="button" data-bs-dismiss="modal"
                        class="btn btn-outline-secondary w-20 mr-1">Back</button>
                    <button type="submit" class="btn btn-primary w-20">Save</button>
                </div> <!-- END: Modal Footer -->
            </form>
        </div>
    </div>
</div> <!-- END: Modal Content -->
