<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>YARAN - SEJOB - PRINT</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;

        }

        p {
            font-size: 14px !important;
        }
    </style>
</head>

<body>
    <div class="container" style="margin:  35px;">
        <div class="logo-heading" style="display:flex; text-align: center; gap: 27%;">
            <div class="logo">
                {{-- <img src="logo-invoice.png" alt="" style="width: 160px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;"> --}}
                <img style="width: 160px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;"
                    src="{{ url('/logo-invoice.png') }}" alt="" />
            </div>
            <div class="heading">
                <h2>YARAN SHIPPING LINE</h2>
                <p></p>
            </div>
        </div>
        @if ($format != 2)
            <div class="border-line" style="border: 2px solid rgb(43, 40, 40); margin-top: 1%;">

            </div>
        @endif


        @if ($format == 3)
            <div class="booking-confirmation"
                style="border: 1px solid;height: 35px; display: flex;justify-content: space-between;padding: 2px 8px; margin-top: 1%;background-color: rgb(43, 40, 40); color: white;">
                <h4>{{ \Carbon\Carbon::parse(@$job_master->job_date)->format('d-M-Y') }}</h4>
                <h3>BOOKING CONFIRMATION</h3>
                <h4>{{ @$job_master->job_no }}</h4>
            </div>
            <div class="clients" style="display: flex; margin-top: 1%;">
                <div class="box1" style="border: 1px solid; height: 220px; width: 28%; padding: 6px;">
                    <h4>Clients</h4>
                    <p>{{ @$job_master->job_detail->client->name }}</p>
                </div>
                <div class="box2" style="border: 1px solid; height: 220px; width: 34%; padding: 6px;">
                    <h4>Shipper</h4>
                    <p>{{ @$job_master->job_detail->shipper->name }}</p> <br>
                    <h4>Consignee</h4>
                    <p>{{ @$job_master->job_detail->consignee->name }}</p> <br>
                    <h4>Notify</h4>
                    <p>{{ @$job_master->bl_master->notify_party->name }}</p> <br>

                </div>
                <div class="box3" style="border: 1px solid; height: 220px; width: 38%; padding: 6px;">
                    <h4>Carrier</h4>
                    <p>{{ @$job_master->job_detail->shipping_line->name }}</p> <br>
                    <h4>Carrier's BKG NO</h4> <br>
                    <p>{{ @$job_master->job_vessel->c_bkg_ed }}</p> <br>
                    <h4>Sales Person</h4>
                    <p>{{ @$job_master->job_detail->sales_rep->employee_name }}</p>
                </div>
            </div>
        @elseif ($format == 2)
            <div class="booking-confirmation"
                style="text-align:center; height: 35px; padding: 2px 8px; margin-top: 1%;">
                <h3>BOOKING CONFIRMATION</h3>
            </div>
            <div class="clients" style="display: flex; margin-top: 1%; border: 1px solid;">
                <div class="box1" style="height: 150px; width: 50%; padding: 6px;">
                    <h4>Job # :</h4>
                    <p>{{ @$job_master->job_no }}</p> <br>
                    <h4>Shipping Line :</h4>
                    <p>{{ @$job_master->job_detail->shipping_line->name }}</p>
                </div>
                <div class="box2" style="height: 150px; width: 50%; padding: 6px;">
                    <h4>Job Date :</h4>
                    <p>{{ @$job_master->job_date }}</p> <br>
                    <h4>Line Agent :</h4>
                    <p>{{ @$job_master->job_detail->shipping_line->name }}</p>
                </div>
            </div>
            <div class="clients" style="display: flex; border: 1px solid;">
                <div class="box1" style="height: 360px; width: 50%; padding: 6px;">
                    <h4>Vessel / Voy. No :</h4>
                    <p>{{ @$job_master->job_vessel->vessel->name }} /
                        {{ @$job_master->job_vessel->voyage->voyage_no }}</p> <br>
                    <h4>PL of Rec :</h4>
                    <p>{{ @$job_master->job_routing->place_of_receipt->name }}</p> <br>
                    <h4>Carrier's BKG No :</h4>
                    <p>{{ @$job_master->job_vessel->c_bkg_ed }}</p> <br>
                    <h4>VGM Cut-off Date :</h4>
                    <p>{{ @$job_master->job_vessel->cut_off }}</p> <br>
                </div>
                <div class="box2" style="height: 360px; width: 25%; padding: 6px;">
                    <h4>AES :</h4>
                    <p>{{ \Carbon\Carbon::parse(@$job_master->shipt_date)->format('d-M-Y') }}</p> <br>
                    <h4>E.Rls :</h4>
                    <p>{{ \Carbon\Carbon::parse(@$job_master->shipt_date)->format('d-M-Y') }}</p> <br>
                    <h4>POL :</h4>
                    <p>{{ @$job_master->job_detail->port_of_loading->name }}</p> <br>
                    <h4>File No :</h4>
                    <p>{{ @$job_master->file_no }}</p> <br>

                </div>
                <div class="box3" style="height: 360px; width: 25%; padding: 6px;">
                    <h4>E.Rec :</h4>
                    <p>{{ \Carbon\Carbon::parse(@$job_master->shipt_date)->format('d-M-Y') }}</p> <br>
                    <h4>Cut of :</h4>
                    <p>{{ @$job_master->job_vessel->cut_off }}</p> <br>
                    <h4>Date :</h4>
                    <p>{{ \Carbon\Carbon::parse(@$job_master->job_date)->format('d-M-Y') }}</p>
                </div>
            </div>
        @elseif ($format == 1)
            <div class="booking-confirmation"
                style="text-align:center; border: 1px solid;height: 35px;padding: 2px 8px; margin-top: 1%;background-color: rgb(43, 40, 40); color: white;">
                <h3>BOOKING CONFIRMATION</h3>
            </div>
        @endif
        <table border="1" style="width: 100%; border-collapse: collapse;">

            @if ($format == 3)
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="vessel" style="padding-bottom: 10px;">
                            <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                <h4 style="white-space:nowrap">Vessel / Voy. No :</h4>
                                <p>{{ @$job_master->job_vessel->vessel->name }} /
                                    {{ @$job_master->job_vessel->voyage->voyage_no }}</p>
                            </div>
                            <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                <h4>Earliest Receive :</h4>
                                <p>{{ \Carbon\Carbon::now()->format('d-m-Y') }}</p>
                            </div>
                            <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                <h4>File No :</h4>
                                <p>{{ @$job_master->file_no }}</p>
                            </div>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="vessel" style="padding-bottom: 10px; ">
                            <div style="display: flex; gap: 72px; padding: 3px 10px;">
                                <h4>AES CutOff :</h4>
                                <p>{{ \Carbon\Carbon::now()->format('d-m-Y') }}</p>
                            </div>
                            <div style="display: flex; gap: 40px; padding: 3px 10px;">
                                <h4>Earliest PickUp :</h4>
                                <p>{{ \Carbon\Carbon::now()->format('d-m-Y') }}</p>
                            </div>
                            <div style="display: flex; gap: 68px; padding: 3px 10px;">
                                <h4>VGM Cutoff :</h4>
                                <p>{{ \Carbon\Carbon::now()->format('d-m-Y') }}</p>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="2">
                        <h3>ROUTING</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="dates" style="display: flex;">
                            <div class="vessel" style=" padding-bottom: 10px;">
                                <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                    <h4 style="white-space:nowrap">Origin :</h4>
                                    <p>{{ @$job_master->job_routing->port_of_loading->name }}</p>
                                </div>

                                <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                    <h4 style="white-space:nowrap">Loading :</h4>
                                    <p>{{ @$job_master->job_routing->port_of_loading->name }}</p>
                                </div>
                                <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                    <h4 style="white-space:nowrap">Discharge : </h4>
                                    <p>{{ @$job_master->job_routing->port_of_discharge->name }}</p>
                                </div>
                                <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                    <h4 style="white-space:nowrap">Final Dest. : </h4>
                                    <p>{{ @$job_master->job_routing->final_destination->name }}</p>
                                </div>
                            </div>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="vessel" style="padding-bottom: 10px; ">
                            <div style="display: flex; gap: 65px; padding: 3px 10px;">
                                <h4>Cut Off Date :</h4>
                                <p>{{ @$job_master->job_vessel->cut_off }}</p>
                            </div>
                            <div style="display: flex; gap: 68px; padding: 3px 10px;margin-left: 12%;">
                                <h4>ETD :</h4>
                                <p>{{ @$job_master->job_vessel->etd }}</p>
                            </div>
                            <div style="display: flex; gap: 68px; padding: 3px 10px;margin-left: 12%;">
                                <h4>ETA :</h4>
                                <p>{{ @$job_master->job_vessel->eta }}</p>
                            </div>
                        </div>
                    </td>
                </tr>
            @elseif($format == 1)
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="vessel" style="padding-bottom: 10px;">
                            <div style="padding: 3px 10px;">
                                <h4 style="white-space:nowrap">Client :</h4>
                                <p>{{ @$job_master->job_detail->client->name }}</p>
                            </div>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="vessel" style="padding-bottom: 10px;">
                            <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                <h4 style="white-space:nowrap">Your Sale Rep is :</h4>
                                <p>{{ @$job_master->job_detail->sales_rep->employee_name }}</p>
                            </div>
                            <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                <h4 style="white-space:nowrap">Your Doc Rep is :</h4>
                                <p></p>
                            </div>
                            <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                <h4 style="white-space:nowrap">Doc Rep Phone No :</h4>
                                <p></p>
                            </div>
                            <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                <h4>Doc Rep Email :</h4>
                                <p></p>
                            </div>
                            <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                <h4>Your Billing Rep is :</h4>
                                <p></p>
                            </div>
                            <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                <h4>Billing Rep Email :</h4>
                                <p></p>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="vessel" style="padding-bottom: 10px;">
                            <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                <h4 style="white-space:nowrap">Carrier :</h4>
                                <p>{{ @$job_master->job_detail->shipping_line->name }}</p>
                            </div>
                            <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                <h4 style="white-space:nowrap">Vessel / Voy. No :</h4>
                                <p>{{ @$job_master->job_vessel->vessel->name }} /
                                    {{ @$job_master->job_vessel->voyage->voyage_no }}</p>
                            </div>
                            <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                <h4 style="white-space:nowrap">Carrier's BKG NO :</h4>
                                <p>{{ @$job_master->job_vessel->c_bkg_ed }}</p>
                            </div>
                            <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                <h4>Job # :</h4>
                                <p>{{ @$job_master->job_no }}</p>
                            </div>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="vessel" style="padding-bottom: 10px; ">
                            <div style="display: flex; gap: 10px; padding: 3px 10px;">
                                <h4>Booking Request # :</h4>
                                <p>{{ @$job_master->book_reg }}</p>
                            </div>
                            <div style="display: flex; gap: 10px; padding: 3px 10px;">
                                <h4>Customer Ref # :</h4>
                                <p>{{ @$job_master->customer_reference_no }}</p>
                            </div>
                            <div style="display: flex; gap: 68px; padding: 3px 10px;">
                                <h4>File No :</h4>
                                <p>{{ @$job_master->file_no }}</p>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; background-color: rgb(43, 40, 40); color: white;">
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 5px">
                            <h3 style="margin: 0;">ROUTING</h3>
                            <h3 style="margin: 0;">DATES</h3>
                        </div>
                    </td>
                    <td style="width: 50%; background-color: rgb(43, 40, 40);"></td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 5px">
                            <div class="dates" style="display: flex;">
                                <div class="vessel" style=" padding-bottom: 10px;">
                                    <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                        <h4 style="white-space:nowrap">Origin :</h4>
                                        <p>{{ @$job_master->job_routing->port_of_loading->name }}</p>
                                    </div>

                                    <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                        <h4 style="white-space:nowrap">Loading :</h4>
                                        <p>{{ @$job_master->job_routing->port_of_loading->name }}</p>
                                    </div>
                                    <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                        <h4 style="white-space:nowrap">Discharge : </h4>
                                        <p>{{ @$job_master->job_routing->port_of_discharge->name }}</p>
                                    </div>
                                    <div style="display: flex; gap: 10px;padding: 3px 10px;">
                                        <h4 style="white-space:nowrap">Final Dest. : </h4>
                                        <p>{{ @$job_master->job_routing->final_destination->name }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="vessel" style="padding-bottom: 10px; ">
                                <div style="display: flex; gap: 10px; padding: 3px 10px;">
                                    <h4>Cut Off Date :</h4>
                                    <p>{{ @$job_master->job_vessel->cut_off }}</p>
                                </div>
                                <div style="display: flex; gap: 10px; padding: 3px 10px;margin-left: 12%;">
                                    <h4>ETD :</h4>
                                    <p>{{ @$job_master->job_vessel->etd }}</p>
                                </div>
                                <div style="display: flex; gap: 10px; padding: 3px 10px;margin-left: 12%;">
                                    <h4>ETA :</h4>
                                    <p>{{ @$job_master->job_vessel->eta }}</p>
                                </div>
                            </div>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <div class="vessel" style="padding-bottom: 10px; ">
                            <div style="display: flex; gap: 72px; padding: 3px 10px;">
                                <h4>AES Date :</h4>
                                <p>{{ \Carbon\Carbon::parse(@$job_master->job_date)->format('d-m-Y') }}</p>
                            </div>
                            <div style="display: flex; gap: 22px; padding: 3px 10px;">
                                <h4>SI Cut-Off Date :</h4>
                                <p>{{ \Carbon\Carbon::parse(@$job_master->job_date)->format('d-m-Y') }}</p>
                            </div>
                            <div style="display: flex; gap: 17px; padding: 3px 10px;">
                                <h4>Earliest Receive :</h4>
                                <p>{{ \Carbon\Carbon::parse(@$job_master->job_date)->format('d-m-Y') }}</p>
                            </div>
                            <div style="display: flex; gap: 17px; padding: 3px 10px;">
                                <h4>Earliest Release :</h4>
                                <p>{{ \Carbon\Carbon::parse(@$job_master->job_date)->format('d-m-Y') }}</p>
                            </div>
                            <div style="display: flex; gap: 68px; padding: 3px 10px;">
                                <h4>VGM Cutoff :</h4>
                            </div>
                        </div>
                    </td>
                </tr>
            @endif
            <tr>
                <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                    colspan="2">
                    @if ($format == 1)
                        <h3>CARGO DESCRIPTION</h3>
                    @else
                        <h3>AS PER YOUR DESCRIPTION</h3>
                    @endif
                </td>
            </tr>
            <tr>
                <td style="width: 50%; vertical-align: top;">
                    <div class="dates" style="display: flex;">
                        <div class="vessel" style=" padding-bottom: 10px;">
                            <div style="display: flex; gap: 40px;padding: 3px 10px;">
                                <h4>Commodity :</h4>
                                <p>{{ @$job_master->job_detail->commodity->name }}</p>
                            </div>
                            <div style="display: flex; gap: 50px;padding: 3px 10px;">
                                <div class="div">
                                    <h4>Hazardous :</h4>
                                </div>
                                <div class="div" style="display: flex; gap: 3px;">
                                    <h4 style="border: 1px solid;width: 25px; height:25px ;"></h4>
                                    <p>Yes</p>
                                </div>
                                <div class="div" style="display: flex; gap: 3px;">
                                    <h4 style="border: 1px solid;width: 25px; height:25px ;"> <span
                                            style="display: flex;justify-content: center;"> ✔</span></h4>
                                    <p>No</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </td>
                <td style="width: 50%; vertical-align: top;">
                    <div class="vessel" style="padding-bottom: 10px; ">
                        <div style="display: flex; gap: 80px; padding: 3px 10px;">
                            <h4>No of PKGS :</h4>
                            <p>{{ @$job_master->bl_master->bl_detail->pkgs }}</p>
                        </div>
                        <div style="display: flex; gap: 54px; padding: 3px 10px;">
                            <h4>Containers(s) :</h4>
                            <p>{{ @$containerNo }}</p>
                        </div>
                    </div>
                </td>
            </tr>
            @if ($format == 3)
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="2">
                        <h3>EMPTY CONTAINER PICK-UP LOCATION :</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Location :</h4>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top; height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Address :</h4>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="2">
                        <h3>LOADED CONTAINER RETURN LOCATION :</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Location :</h4>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top; height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Address :</h4>
                        </div>
                    </td>
                </tr>
            @elseif($format == 2)
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="2">
                        <h3>EMPTY CONTAINER PICK-UP LOCATION :</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Location :</h4>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top; height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Address :</h4>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="2">
                        <h3>EMPTY CONTAINER RETURN LOCATION :</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Location :</h4>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top; height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Address :</h4>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="2">
                        <h3>CHASIS PICK-UP LOCATION :</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Location :</h4>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top; height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Address :</h4>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="2">
                        <h3>CHASIS RETURN LOCATION :</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Location :</h4>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top; height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Address :</h4>
                        </div>
                    </td>
                </tr>
            @elseif($format == 1)
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;">
                        <h3>EMPTY CONTAINER PICK-UP LOCATION :</h3>
                    </td>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;">
                        <h3>LOADED CONTAINER RETURN LOCATION :</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Location :</h4>
                            <h4>Address :</h4>
                        </div>
                    </td>
                    <td style="width: 50%; vertical-align: top; height: 20px; padding: 3px 10px;">
                        <div class="div">
                            <h4>Location :</h4>
                            <h4>Address :</h4>
                        </div>
                    </td>
                </tr>
            @endif
        </table>
        <table border="1" style="width: 100%; border-collapse: collapse;">
            @if ($show_charges == 'on')
                <tr>
                    <th>CHARGES</th>
                    <th>QTY</th>
                    <th>Rate Amount</th>
                    <th>CURR</th>
                    <th>EX. RATE</th>
                    <th>AMOUNT</th>
                    <th>AMOUNT (L)</th>
                </tr>
                @foreach ($job_master->job_charges_receivable as $index => $item)
                    <tr>
                        <td>{{ @$item->charge->name }}</td>
                        <td>{{ @$item->qty }}</td>
                        <td>{{ @$item->rate }}</td>
                        <td>{{ @$item->currency_name->name }}</td>
                        <td>{{ @$item->ex_rate }}</td>
                        <td>{{ @$item->net_amount }}</td>
                        <td>{{ @$item->local_amount }}</td>
                    </tr>
                @endforeach
            @endif
            @if ($format == 2 || $format == 3)
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="7">
                        <h3>REMARKS</h3>
                    </td>
                </tr>
                @if ($format == 2)
                    <tr>
                        <td style="width: 100%; text-align: left;padding: 3px 10px;" colspan="7">
                            <p>
                                To SHIPPER/CHA'S <br> <br>
                                1) Ensure the empty container received from our yard is in clean and sound
                                condition
                                cost for any
                                subsequent rejection will be to your account. <br> <br>
                                2) Loaded Containers must be returned in safe
                                and
                                sound
                                condition at our
                                nominated site within stipulated fee time (No.of Days 7) failing which detention charges
                                as
                                per
                                line's
                                tariff will be
                                Recovered. <br> <br>
                                3) Any loss or damage to the container while custody of shipper, transporter,
                                forward
                                shall
                                be fully indemnified
                                for repair/replacement /reimbursement as notified by owner/hirer.
                            </p>
                        </td>
                    </tr>
                @else
                    <tr>
                        <td style="width: 100%; text-align: left;padding: 3px 10px;" colspan="7">
                            <p>REMARKS
                                To SHIPPER/CHAS 1) Ensure the empty container received from our yard is in clean and
                                sound
                                condition
                                cost for any
                                subsequent rejection will be to your account. ?2) Loaded Containers must be returned in
                                safe
                                and
                                sound
                                condition at our
                                nominated site within stipulated fee time (No.of,Days 7) failing which detention charges
                                as
                                per
                                line's
                                tariff will be
                                Recovered, 3) Any loss or damage to the container while custody of shipper, transporter,
                                forward
                                shall
                                be fully indemnified
                                for repair/replacement /reimbursement as notified by owner/hirer, 4) Shipper/forwarder
                                will
                                fully
                                indemnify the line from any
                                claims for costs ,charges legal expenses, arising from death or injury caused to any
                                person
                                or
                                damage to
                                any property arising
                                our of use ,operation ,or transportation of these containers while in the? possession of
                                the
                                shipper
                                /forwarder/transporter or
                                their agent, 5) Original BL's must be collected from our office immediately after
                                Vessel's
                                departure
                                from the port a delayed
                                document surcharge (DDS) as per company 's slab will be levied thereafter, DD's must be
                                paid
                                prior to
                                release of the OBL.
                                6) Ensure that the cargo weight in the container does not exceed the maximum permissible
                                load
                                ability as
                                stipulated on the
                                CSC plate .In event the container is over loaded, and gross container weight exceeds,
                                permissible
                                limited, all consequent
                                time charges incurred for shifting and cross stuffing will be to account of shipper.?
                            </p>
                        </td>
                    </tr>
                @endif
            @endif
            @if ($format == 1)
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="7">
                        <h3>FREETIME</h3>
                    </td>
                </tr>
                <tr>
                    <td style="height: 20px; padding: 3px 10px;" colspan="7">
                        <div class="div">
                            <p style="font-weight: 700; text-align: center">FREETIME AT DESTINATION : <span
                                    style="font-weight: 400">14</span></p>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100%; text-align: center;background-color: rgb(43, 40, 40);color: white;"
                        colspan="7">
                        <h3>IMPORTANT - PLEASE READ</h3>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100%; text-align: left;padding: 3px 10px;" colspan="7">
                        <p>REMARKS
                            To SHIPPER/CHAS 1) Ensure the empty container received from our yard is in clean and sound
                            condition
                            cost for any
                            subsequent rejection will be to your account. ?2) Loaded Containers must be returned in safe
                            and
                            sound
                            condition at our
                            nominated site within stipulated fee time (No.of,Days 7) failing which detention charges as
                            per
                            line's
                            tariff will be
                            Recovered, 3) Any loss or damage to the container while custody of shipper, transporter,
                            forward
                            shall
                            be fully indemnified
                            for repair/replacement /reimbursement as notified by owner/hirer, 4) Shipper/forwarder will
                            fully
                            indemnify the line from any
                            claims for costs ,charges legal expenses, arising from death or injury caused to any person
                            or
                            damage to
                            any property arising
                            our of use ,operation ,or transportation of these containers while in the? possession of the
                            shipper
                            /forwarder/transporter or
                            their agent, 5) Original BL's must be collected from our office immediately after Vessel's
                            departure
                            from the port a delayed
                            document surcharge (DDS) as per company 's slab will be levied thereafter, DD's must be paid
                            prior to
                            release of the OBL.
                            6) Ensure that the cargo weight in the container does not exceed the maximum permissible
                            load
                            ability as
                            stipulated on the
                            CSC plate .In event the container is over loaded, and gross container weight exceeds,
                            permissible
                            limited, all consequent
                            time charges incurred for shifting and cross stuffing will be to account of shipper.?</p>
                    </td>
                </tr>
            @endif
        </table>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            window.print(); // Trigger the print dialog once the page loads
        });
    </script>
</body>

</html>
