<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>YARAN - SEJOB - PRINT</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <style>
        P {
            font-size: 12px;
        }

        .footer {
            position: absolute;
            bottom: 10px;
            width: 100%;
            display: flex;
            justify-content: space-between;
            font-size: 10px;
            text-align: center;
        }

        .footer-left,
        .footer-center,
        .footer-right {
            flex: 1;
            display: flex;
            justify-content: space-between;
        }

        .footer-left {
            text-align: left;
        }

        .footer-center {
            text-align: center;
        }

        .footer-right {
            text-align: right;
        }

        @media print {
            table {
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .no-print {
                display: none;
            }
        }

        @media print {
            @page {
                size: A4;
                margin: 0;
            }

            .container {
                width: 100%;
                margin: 0;
                padding: 0;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            th,
            td {
                padding: 4px;
            }
        }

        @media print {
            .container {
                width: 100%;
                margin: 0;
            }

            table {
                page-break-inside: auto;
                width: 100%;
            }

            th,
            td {
                page-break-inside: avoid;
            }

            @page {
                size: auto;
                margin: 0;
            }
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;

        }

        table {
            width: 100%;
            height: 60px;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 4px;
            text-align: left;
            font-size: 12px;
        }

        .column1 {
            width: 50%;
        }

        .column2 {
            width: 50%;
        }

        .sr,
        .name,
        .rate,
        .amount,
        .dis,
        .tax,
        .total,
        .qty,
        .curr {
            text-align: right;
            font-size: 11.8px;

        }

        .column-heading {
            background-color: rgb(194, 186, 186);
            text-align: center;
        }

        .sr {
            width: 5%;
            text-align: left;
        }

        .name {
            width: 25%;
            text-align: left;
        }
    </style>
</head>

<body>
    <div class="container" style="margin: 0px 60px; width: 88.1%; font-size: 16px;">
        <div class="logo-heading" style="display: flex;gap: 15%;align-items: center;text-align: center;">
            <div class="logo">
                <img src="{{ url('logo2.png') }}" alt=""
                    style="width: 150px; padding-bottom: 0px; border-top: none;">
            </div>
            <div class="heading">
                <h3>YARAN SHIPPING LINE</h3>
                <p>Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</p>
                <p style="font-size: 12px;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div style="border:3px solid;width: 75%;border-top: none; border-right: none; border-left: none;"></div>
            <h3>INVOICE</h3>
            <div style="border:3px solid;width: 8%; border-right: none; border-left: none;border-top: none;"></div>
        </div>

        <table style="font-size: 10px;">

            <tr>
                <td>
                    <h4>Client</h4>
                    <p>{{ @$customer->name }} <br>
                        {{ @$customer->address }}
                    </p>
                </td>
                <td>
                    <h4>Shipper/Consignee</h4>
                    <p>
                        {{ @$job_master->job_detail->shipper->name }}
                        @if (!empty($job_master->job_detail->shipper->name) && !empty($job_master->job_detail->consignee->name))
                            /
                            <br>
                        @endif
                        {{ @$job_master->job_detail->consignee->name }}
                    </p>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Reference No.</h4> <br>
                        <p>{{ @$job_master->customer_reference_no }}</p>
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Sales Rep</h4>
                        <p>{{ @$job_master->job_detail->sales_rep->employee_name }}</p>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>MBL No.</h4>
                        <h4>Bill of Lading</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$job_master->bl_master->mbl_no }}</p>
                        <p>{{ @$job_master->bl_master->hbl_no }}</p>
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Job No</h4>
                        {{-- <h4>Job Date</h4> --}}
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$job_master->job_no }}</p>
                        {{-- <p>{{ @$invoice->job_master->job_date }}</p> --}}
                        {{-- <p>{{ \Carbon\Carbon::parse(@$invoice->job_master->job_date)->format('d/m/Y') }}
                        </p> --}}
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$job_master->operation_id == 1 || @$job_master->operation_id == 2)
                            <h4>Vessel / Voyage</h4>
                        @elseif (@$job_master->operation_id == 3 || @$job_master->operation_id == 4)
                            <h4>Air Line / Flight No.</h4>
                        @endif
                        {{-- @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 3)
                            <h4>Sailing Date</h4>
                        @elseif (@$invoice->job_master->operation_id == 2 || @$invoice->job_master->operation_id == 4)
                            <h4>Arrival Date</h4>
                        @endif --}}
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$job_master->operation_id == 1 || @$job_master->operation_id == 2)
                            <p>{{ @$job_master->job_vessel->vessel->name }} /
                                {{ @$job_master->job_vessel->voyage->voyage_no }}</p>
                        @elseif (@$job_master->operation_id == 3 || @$job_master->operation_id == 4)
                            <p>{{ @$job_master->job_vessel->airline->name }} /
                                {{ @$job_master->job_vessel->flight_no }}</p>
                        @endif
                        {{-- @if (@$invoice->job_master->operation_id == 1 || @$invoice->job_master->operation_id == 3)
                            <p>{{ \Carbon\Carbon::parse(@$invoice->job_master->bl_master->sailing_date)->format('d/m/Y') }}
                            </p>
                        @elseif (@$invoice->job_master->operation_id == 2 || @$invoice->job_master->operation_id == 4)
                            <p>{{ \Carbon\Carbon::parse(@$invoice->job_master->bl_master->arrival_date)->format('d/m/Y') }}
                            </p>
                        @endif --}}
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$job_master->operation_id == 2)
                            <h4>ETA Date</h4>
                        @else
                            <h4>Departure Date</h4>
                        @endif
                        <h4>Job Date</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$job_master->operation_id == 2)
                            <p>{{ \Carbon\Carbon::parse(@$job_master->job_vessel->eta)->format('d/m/Y') }}</p>
                        @else
                            <p>{{ \Carbon\Carbon::parse(@$job_master->bl_master->sailing_date)->format('d/m/Y') }}</p>
                        @endif
                        <p>{{ \Carbon\Carbon::parse(@$job_master->job_date)->format('d/m/Y') }}</p>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$job_master->operation_id == 1 || @$job_master->operation_id == 2)
                            <h4>Port of Loading</h4>
                            <h4>Port of Discharge</h4>
                        @elseif (@$job_master->operation_id == 3 || @$job_master->operation_id == 4)
                            <h4>Airport of Loading</h4>
                            <h4>Airport of Discharge</h4>
                        @endif
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        @if (@$job_master->operation_id == 1 || @$job_master->operation_id == 2)
                            <p>{{ @$job_master->job_detail->port_of_loading->name }}</p>
                            <p>{{ @$job_master->job_detail->port_of_discharge->name }}</p>
                        @elseif (@$job_master->operation_id == 3 || @$job_master->operation_id == 4)
                            <p>{{ @$job_master->bl_master->bl_booking_info->port_of_loading->name }}</p>
                            <p>{{ @$job_master->bl_master->bl_booking_info->port_of_discharge->name }}</p>
                        @endif
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Destination Port</h4>
                        @if (@$job_master->operation_id == 1 || @$job_master->operation_id == 2)
                            <h4>Shipping Line</h4>
                        @elseif (@$job_master->operation_id == 3 || @$job_master->operation_id == 4)
                            <h4>Air Line</h4>
                        @endif
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$job_master->job_routing->final_destination->name }}</p>
                        @if (@$job_master->operation_id == 1 || @$job_master->operation_id == 2)
                            <p>{{ @$job_master->job_detail->shipping_line->name }}</p>
                        @elseif (@$job_master->operation_id == 3 || @$job_master->operation_id == 4)
                            <p>{{ @$job_master->job_vessel->airline->name }}</p>
                        @endif
                    </div>
                </td>
            </tr>
            <td class="column2" style="display: flex; gap: 110px; border: 1px solid; width: 100%;height: 47px;">
                <div>
                    <h4>Volume</h4>
                    <p>{{ @$job_master->job_weight->vol }}</p>
                </div>
                <div>
                    <h4>Weight</h4>
                    {{-- <p>{{ @$job_master->job_weight->weight }}</p> --}}
                    <p>
                        @php
                            $weight = null;
                            if ($job_master->bl_master && $job_master->bl_master->bl_container_info->isNotEmpty()) {
                                $weight = $job_master->bl_master->bl_container_info->sum('container_gross_wt');
                            } else {
                                $weight = @$job_master->job_weight->weight;
                            }
                        @endphp
                        {{ $weight }}
                    </p>
                </div>
                <div>
                    <h4>PCS</h4>
                    <p>{{ @$job_master->job_weight->pcs }}</p>
                </div>
            </td>
            <td class="column2">
                <div style="display: flex; justify-content:space-between;">
                    <h4>Currency</h4>
                    <h4>Exchange Rate</h4>
                </div>
                <div style="display: flex; justify-content:space-between;">
                    <p>{{ @$job_master->currency_name->name }}</p>
                    <p>{{ @$job_master->selling }}</p>
                </div>
            </td>
            </tr>
        </table>
        @if ($show_container == 'on')
            <div class="contan" style="border: 1px solid; display: flex; gap:114px; ">
                <h5>Container #</h5>
                <p>{{ @$containerNo }}</p>
            </div>
        @endif
        <table>
            <!-- Table Headings -->
            <tr>
                <th class="column-heading">SR#</th>
                <th class="column-heading">Charges</th>
                <th class="column-heading">Qty</th>
                <th class="column-heading">Rate</th>
                <th class="column-heading">Curr</th>
                <th class="column-heading">Amount</th>
                <th class="column-heading">Dis</th>
                <th class="column-heading">Tax</th>
                <th class="column-heading">Local Amount</th>
            </tr>
            @php
                $totalDiscount = 0;
                $totalTax = 0;
                $totalAmount = 0;
            @endphp
            <!-- Table Rows -->
            @php
                $currencyCodes = [
                    'PAK RUPEES' => 'PKR',
                    'US DOLLAR' => 'USD',
                    'DIRHAM' => 'AED',
                    'POUND' => 'GBP',
                    'EURO' => 'EUR',
                    'BDT' => 'BDT',
                    'OMANI RIYAL' => 'OMR',
                ];
            @endphp
            @if ($job_master->job_charges_receivable)
                @foreach ($job_master->job_charges_receivable as $index => $item)
                    @if ($print_only_unapproved_charges == 'on')
                        @if ($item->status == 1)
                            @if ($only_ocean_freight_charges == 'on')
                                @if ($item->charge_id == 2)
                                    @php
                                        $totalDiscount += $item->discount;
                                        $totalTax += $item->tax;
                                        $totalAmount += $item->local_amount;
                                    @endphp
                                    <tr>
                                        <td class="sr">{{ $index + 1 }}</td>
                                        <td class="name">{{ $item->charge->name }}</td>
                                        <td class="qty">{{ $item->qty }}</td>
                                        <td class="rate">{{ $item->rate }}</td>
                                        <td class="curr">
                                            {{ $currencyCodes[$item->currency_name->name] ?? $item->currency_name->name }}
                                            {{-- {{ $item->currency_name->name }} --}}
                                        </td>
                                        <td class="amount">{{ $item->amount }}</td>
                                        <td class="dis">{{ $item->discount }}</td>
                                        <td class="tax">{{ $item->tax }}</td>
                                        <td class="total">{{ $item->local_amount }}</td>
                                    </tr>
                                @endif
                            @elseif ($exclude_ocean_freight == 'on')
                                @if ($item->charge_id != 2)
                                    @php
                                        $totalDiscount += $item->discount;
                                        $totalTax += $item->tax;
                                        $totalAmount += $item->local_amount;
                                    @endphp
                                    <tr>
                                        <td class="sr">{{ $index + 1 }}</td>
                                        <td class="name">{{ $item->charge->name }}</td>
                                        <td class="qty">{{ $item->qty }}</td>
                                        <td class="rate">{{ $item->rate }}</td>
                                        <td class="curr">
                                            {{ $currencyCodes[$item->currency_name->name] ?? $item->currency_name->name }}
                                            {{-- {{ $item->currency_name->name }} --}}
                                        </td>
                                        <td class="amount">{{ $item->amount }}</td>
                                        <td class="dis">{{ $item->discount }}</td>
                                        <td class="tax">{{ $item->tax }}</td>
                                        <td class="total">{{ $item->local_amount }}</td>
                                    </tr>
                                @endif
                            @else
                                @php
                                    $totalDiscount += $item->discount;
                                    $totalTax += $item->tax;
                                    $totalAmount += $item->local_amount;
                                @endphp
                                <tr>
                                    <td class="sr">{{ $index + 1 }}</td>
                                    <td class="name">{{ $item->charge->name }}</td>
                                    <td class="qty">{{ $item->qty }}</td>
                                    <td class="rate">{{ $item->rate }}</td>
                                    <td class="curr">
                                        {{ $currencyCodes[$item->currency_name->name] ?? $item->currency_name->name }}
                                        {{-- {{ $item->currency_name->name }} --}}
                                    </td>
                                    <td class="amount">{{ $item->amount }}</td>
                                    <td class="dis">{{ $item->discount }}</td>
                                    <td class="tax">{{ $item->tax }}</td>
                                    <td class="total">{{ $item->local_amount }}</td>
                                </tr>
                            @endif
                        @endif
                    @else
                        @if ($only_ocean_freight_charges == 'on')
                            @if ($item->charge_id == 2)
                                @php
                                    $totalDiscount += $item->discount;
                                    $totalTax += $item->tax;
                                    $totalAmount += $item->local_amount;
                                @endphp
                                <tr>
                                    <td class="sr">{{ $index + 1 }}</td>
                                    <td class="name">{{ $item->charge->name }}</td>
                                    <td class="qty">{{ $item->qty }}</td>
                                    <td class="rate">{{ $item->rate }}</td>
                                    <td class="curr">
                                        {{ $currencyCodes[$item->currency_name->name] ?? $item->currency_name->name }}
                                        {{-- {{ $item->currency_name->name }} --}}
                                    </td>
                                    <td class="amount">{{ $item->amount }}</td>
                                    <td class="dis">{{ $item->discount }}</td>
                                    <td class="tax">{{ $item->tax }}</td>
                                    <td class="total">{{ $item->local_amount }}</td>
                                </tr>
                            @endif
                        @elseif ($exclude_ocean_freight == 'on')
                            @if ($item->charge_id != 2)
                                @php
                                    $totalDiscount += $item->discount;
                                    $totalTax += $item->tax;
                                    $totalAmount += $item->local_amount;
                                @endphp
                                <tr>
                                    <td class="sr">{{ $index + 1 }}</td>
                                    <td class="name">{{ $item->charge->name }}</td>
                                    <td class="qty">{{ $item->qty }}</td>
                                    <td class="rate">{{ $item->rate }}</td>
                                    <td class="curr">
                                        {{ $currencyCodes[$item->currency_name->name] ?? $item->currency_name->name }}
                                        {{-- {{ $item->currency_name->name }} --}}
                                    </td>
                                    <td class="amount">{{ $item->amount }}</td>
                                    <td class="dis">{{ $item->discount }}</td>
                                    <td class="tax">{{ $item->tax }}</td>
                                    <td class="total">{{ $item->local_amount }}</td>
                                </tr>
                            @endif
                        @else
                            @php
                                $totalDiscount += $item->discount;
                                $totalTax += $item->tax;
                                $totalAmount += $item->local_amount;
                            @endphp
                            <tr>
                                <td class="sr">{{ $index + 1 }}</td>
                                <td class="name">{{ $item->charge->name }}</td>
                                <td class="qty">{{ $item->qty }}</td>
                                <td class="rate">{{ $item->rate }}</td>
                                <td class="curr">
                                    {{ $currencyCodes[$item->currency_name->name] ?? $item->currency_name->name }}
                                    {{-- {{ $item->currency_name->name }} --}}
                                </td>
                                <td class="amount">{{ $item->amount }}</td>
                                <td class="dis">{{ $item->discount }}</td>
                                <td class="tax">{{ $item->tax }}</td>
                                <td class="total">{{ $item->local_amount }}</td>
                            </tr>
                        @endif
                    @endif
                @endforeach
            @endif
        </table>
        <div class="total-discount"
            style="border: 1px solid;display: flex;justify-content: space-between;width: 100%;height: 100px;padding: 8px;">
            <div class="discount">
                <h4>Total Discount</h4>
            </div>
            <div class="discount">
                <p>{{ $totalDiscount }}</p>
            </div>
            <div class="discount">
                <h4>Tax Amount</h4>
            </div>
            <div class="discount">
                <p>{{ $totalTax }}</p>
            </div>
            <div class="discount">
                <h4>Invoice Total (PKR)</h4>
                <h4>Total Amount</h4>
            </div>
            <div class="discount">
                <p>{{ $totalAmount }}</p>
                <p>{{ $totalAmount }}</p>
            </div>
        </div>
        <div class="note" style="display: flex;">
            <div style="border: 1px solid; width: 50%; padding: 0px 5px;">
                <h4>Note:</h4>
            </div>
            <div style="border: 1px solid;width: 50%; padding: 0px 5px;">
                <h4>In-Words</h4>
            </div>
        </div>
        <div class="note" style="display: flex; font-size: 15px;">
            <div style="border: 1px solid;width: 50%; padding: 0px 5px;">
            </div>
            <div style="border: 1px solid;width: 50%; padding: 0px 5px;">
                @php
                    $formatter = new \NumberFormatter('en', \NumberFormatter::SPELLOUT);
                    $amountInWords = strtoupper($formatter->format($totalAmount));
                @endphp
                <p>PKR {{ @$totalAmount }}</p>
            </div>
        </div>
        @if ($show_bank == 'on')
            <div class="note" style="display: flex; font-size: 15px;  margin-top:15px">
                <div style="border: 1px solid; width: 50%; padding: 0px 5px;padding-bottom: 30px;">
                    <h3>Bank Detail</h3>
                </div>
            </div>
        @endif
        <div class="footer">
            <div class="footer-left">
                {{-- <p>Printed On: {{ now()->format('Y-m-d H:i:s') }}</p> --}}
                <p>Printed On: {{ now()->setTimezone('Asia/Karachi')->format('Y-m-d H:i:s') }}</p>
            </div>
            <div class="footer-center">
                <p>Printed By: {{ auth()->user()->name }}</p>
            </div>
            <div class="footer-right">
                <p>Page: 1</p>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            window.print(); // Trigger the print dialog once the page loads
        });
    </script>
</body>

</html>
