@extends('layout.master')

@section('title')
    Add-SE Milestone-YARAN
@endsection

@section('topbar')
    <a href="/se_milestone" class="breadcrumb-item">SE Milestone</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="" enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            @if (Request::is('se_milestone/add'))
                                Add SE Milestone
                            @elseif(Request::is('si_milestone/add'))
                                Add SI Milestone
                            @elseif(Request::is('ae_milestone/add'))
                                Add AE Milestone
                            @elseif(Request::is('ai_milestone/add'))
                                Add AI Milestone
                            @endif
                        </h2>
                        
                        <button type="submit" class="btn btn-primary submitBtn"
                            id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-12 mt-5">
                                    <input class="form-check-input" type="radio" name="milestonewise_or_jobwise"
                                        id="job_wise" onclick="showFields('job_wise')">
                                    <label class="form-label" for="job_wise">
                                        Job Wise
                                    </label>
                                    <input class="form-check-input" type="radio" name="milestonewise_or_jobwise"
                                        id="milestone_wise" onclick="showFields('milestone_wise')">
                                    <label class="form-label" for="milestone_wise">
                                        Milestone Wise
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2 hidden" id="job_no">
                                    <label for="regular-form-1" class="form-label">Job #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Job No" name="job_no">
                                </div>
                                <div class="col-md-3 mt-2 hidden" id="job_date">
                                    <label for="regular-form-1" class="form-label">Job Date</label>
                                    <input id="regular-form-1" type="date" class="form-control"name="job_date">
                                </div>
                                <div class="col-md-3 mt-2 hidden" id="milestone">
                                    <label for="regular-form-1" class="form-label">Milestone</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Milestone" name="milestone">
                                </div>
                                <div class="col-md-3 mt-2 hidden" id="from">
                                    <label for="regular-form-1" class="form-label">From</label>
                                    <input id="regular-form-1" type="date" class="form-control"name="from">
                                </div>
                                <div class="col-md-3 mt-2 hidden" id="till">
                                    <label for="regular-form-1" class="form-label">Till</label>
                                    <input id="regular-form-1" type="date" class="form-control"name="till">
                                </div>
                                <div class="col-md-3 mt-12 hidden" id="done">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input" name="done">
                                    <label class="form-label" for="done">
                                        Done
                                    </label>
                                </div>
                                <div class="col-md-2 mt-10 hidden" id="pending">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input" name="pending">
                                    <label class="form-label" for="pending">
                                        Pending
                                    </label>
                                </div>
                                <div class="col-md-4 mt-2 hidden" id="next_days">
                                    <label for="regular-form-1" class="form-label">Next Days</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Next Days" name="next-days">
                                </div>
                                <div class="col-md-2 mt-10 hidden" id="due">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input" name="due">
                                    <label class="form-label" for="due">
                                        Due
                                    </label>
                                </div>
                                <div class="col-md-4 mt-2 hidden" id="within_last_days">
                                    <label for="regular-form-1" class="form-label">Within Last Days</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Within Last Days" name="within_last_days">
                                </div>
                                <div class="col-md-3 mt-2 hidden" id="vessel">
                                    <label for="regular-form-1" class="form-label">Vessel</label>
                                    <select class="tom-select" name="vessel_id" id="vessel_id">
                                        <option value="">Please Select</option>
                                        @foreach ($vessels as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2 hidden" id="voyage">
                                    <label for="regular-form-1" class="form-label">Voyage</label>
                                    <select class="tom-select" name="voyage_id" id="voyage_id">
                                        <option value="">Please Select</option>
                                        @foreach ($voyages as $item)
                                            <option value="{{ $item->id }}">{{ $item->voyage_no }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="documentational_tab" class="nav-item flex-1"
                                                        role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#documentational"
                                                            type="button" role="tab"
                                                            aria-controls="documentational_tab"
                                                            aria-selected="true">Documentational</button>
                                                    </li>
                                                    <li id="operational_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#operational" type="button" role="tab"
                                                            aria-controls="operational_tab"
                                                            aria-selected="false">Operational</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="documentational" role="tabpanel"
                                                aria-labelledby="documentational_tab">
                                                <div class="row">
                                                    <div class="intro-y g-col-12 overflow-auto">
                                                        <table class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th>S.No</th>
                                                                    <th>Code</th>
                                                                    <th>Name</th>
                                                                    <th>Customer</th>
                                                                    <th>Shipping Line</th>
                                                                    <th>Anticipated Date</th>
                                                                    <th>Done</th>
                                                                    <th>Actual Date</th>
                                                                    <th>Remarks</th>
                                                                    <th>Action</th>
                                                                    <th>Update On</th>
                                                                    <th>Update By</th>
                                                                    <th>Update Log</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="operational" role="tabpanel"
                                                aria-labelledby="operational_tab">
                                                <div class="row">
                                                    <div class="intro-y g-col-12 overflow-auto">
                                                        <table class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th>S.No</th>
                                                                    <th>Code</th>
                                                                    <th>Name</th>
                                                                    <th>Anticipated Date</th>
                                                                    <th>Done</th>
                                                                    <th>Actual Date</th>
                                                                    <th>Customer</th>
                                                                    <th>Remarks</th>
                                                                    <th>Action</th>
                                                                    <th>Update On</th>
                                                                    <th>Update By</th>
                                                                    <th>Update Log</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
    <style>
        /* CSS to initially hide elements with the 'hidden' class */
        .hidden {
            display: none;
        }
    </style>

    <script>
        function showFields(option) {
            // Reset all fields to be hidden
            document.querySelectorAll('.hidden').forEach(function(el) {
                el.style.display = 'none';
            });

            // Show the relevant fields based on the selected option
            switch (option) {
                case 'job_wise':
                    document.getElementById('job_no').style.display = 'block';
                    document.getElementById('job_date').style.display = 'block';
                    break;
                case 'milestone_wise':
                    document.getElementById('milestone').style.display = 'block';
                    document.getElementById('from').style.display = 'block';
                    document.getElementById('till').style.display = 'block';
                    document.getElementById('done').style.display = 'block';
                    document.getElementById('pending').style.display = 'block';
                    document.getElementById('next_days').style.display = 'block';
                    document.getElementById('due').style.display = 'block';
                    document.getElementById('within_last_days').style.display = 'block';
                    document.getElementById('vessel').style.display = 'block';
                    document.getElementById('voyage_no').style.display = 'block';
                    break;
                default:
                    break;
            }
        }
    </script>
@endsection
