@extends('layout.master')

@section('title')
    @if (Request::is('se_receipt/add'))
        Add - SE Receipt / Payment-YARAN
    @elseif(Request::is('si_receipt/add'))
        Add - SI Receipt / Payment-YARAN
    @elseif(Request::is('ae_receipt/add'))
        Add - AE Receipt / Payment-YARAN
    @elseif(Request::is('ai_receipt/add'))
        Add - AI Receipt / Payment-YARAN
    @elseif(Request::is('receipt/add'))
        Add - Receipt / Payment-YARAN
    @endif
    {{-- Add-SE Receipt / Payment-YARAN --}}
@endsection

@section('topbar')
    @if (Request::is('se_receipt/add'))
        <a href="/se_receipt" class="breadcrumb-item">SE Receipt / Payment</a><i data-feather="chevron-right"
            class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
    @elseif(Request::is('si_receipt/add'))
        <a href="/si_receipt" class="breadcrumb-item">SI Receipt / Payment</a><i data-feather="chevron-right"
            class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
    @elseif(Request::is('ae_receipt/add'))
        <a href="/ae_receipt" class="breadcrumb-item">AE Receipt / Payment</a><i data-feather="chevron-right"
            class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
    @elseif(Request::is('ai_receipt/add'))
        <a href="/ai_receipt" class="breadcrumb-item">AI Receipt / Payment</a><i data-feather="chevron-right"
            class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
    @elseif(Request::is('receipt/add'))
        <a href="/receipt" class="breadcrumb-item">Receipt / Payment</a><i data-feather="chevron-right"
            class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
    @endif
    {{-- <a href="/se_receipt" class="breadcrumb-item">SE Receipt / Payment</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a> --}}
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="" enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            @if (Request::is('se_receipt/add'))
                                Add SE Receipt / Payment
                            @elseif(Request::is('si_receipt/add'))
                                Add SI Receipt / Payment
                            @elseif(Request::is('ae_receipt/add'))
                                Add AE Receipt / Payment
                            @elseif(Request::is('ai_receipt/add'))
                                Add AI Receipt / Payment
                            @elseif(Request::is('receipt/add'))
                                Add Receipt / Payment
                            @endif
                        </h2>
                        <button type="submit" class="btn btn-primary submitBtn me-2" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect me-2">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-2 mt-2">
                                    <label>Type</label>
                                    <select id="type-select" placeholder="Please Select" name="type"
                                        class="tom-select w-full mt-2 get-invoices" required>
                                        <option value="">Please Select</option>
                                        <option value="receipt" @if (isset($transaction) && !preg_match('/^jb/i', $transaction->tran_no)) selected @endif>Receipt
                                        </option>
                                        <option value="payment" @if (isset($transaction) && preg_match('/^jb/i', $transaction->tran_no)) selected @endif>Payment
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Tran #</label>
                                    <input id="trans_no" readonly type="text" class="form-control"
                                        placeholder="Enter Tran #" name="tran_no">
                                </div>
                                @if (Request::is('se_receipt/add'))
                                    <input type="hidden" name="operation_id" id="operation-id" value="1">
                                @elseif(Request::is('si_receipt/add'))
                                    <input type="hidden" name="operation_id" id="operation-id" value="2">
                                @elseif(Request::is('ae_receipt/add'))
                                    <input type="hidden" name="operation_id" id="operation-id" value="3">
                                @elseif(Request::is('ai_receipt/add'))
                                    <input type="hidden" name="operation_id" id="operation-id" value="4">
                                @elseif(Request::is('receipt/add'))
                                    <div class="col-md-2 mt-2">
                                        <label>Operation</label>
                                        <select id="operation-id" name="operation_id"
                                            class="get-invoices tom-select w-full mt-2">
                                            @foreach ($operations as $item)
                                                <option value="{{ $item->id }}">
                                                    {{ $item->name }}
                                                </option>
                                            @endforeach
                                            <option value="all">All</option>
                                        </select>
                                    </div>
                                @endif
                                <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Tran Date</label>
                                    <input id="regular-form-1" type="date"
                                        value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}" class="form-control"
                                        name="tran_date">
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label>Status</label>
                                    <select id="regular-form-1" name="status" class="tom-select w-full mt-2">
                                        <option value="1" {{ isset($transaction) ? 'selected' : '' }}>Active</option>
                                        <option value="2">Not Active</option>
                                    </select>
                                </div>
                                {{-- <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Sequence #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Sequence #" name="sequence_no">
                                </div> --}}
                                <div class="col-md-2 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input" name="refund">
                                    <label class="form-label" for="refund">
                                        Refund
                                    </label>
                                </div>
                                {{-- <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">HBL #</label>
                                    <input id="regular-form-1" type="text" class="form-control" placeholder="Enter HBL #"
                                        name="hbl_no">
                                </div> --}}
                                {{-- <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Advance Bal</label>
                                    <input id="advance_bal" type="text" class="form-control" placeholder="Enter Advance Bal"
                                        name="advance_bal">
                                </div> --}}
                                <div class="col-md-2 mt-2">
                                    <label>Cost Center</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Cost Center" id="cost_center_id"
                                            name="cost_center_id" class="tom-select w-full">
                                            @foreach ($cost_centers as $cost_center)
                                                <option value="{{ $cost_center->id }}">{{ $cost_center->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label class="mb-2">Client / Vendor</label>
                                    <select id="client-id-select" name="client_id" class="get-invoices select2 w-full mt-2"
                                        required>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label>Account Type</label>
                                    <select id="account-type-select" placeholder="Please Select" name="account_type"
                                        class="tom-select w-full mt-2" required>
                                        <option value="">Please Select</option>
                                        <option value="Cash">Cash
                                        </option>
                                        <option value="Bank">Bank
                                        </option>
                                        <option value="Adjustment">Adjustment
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Account #</label>
                                    <select name="account_id" id="account_id" class="select2 w-full mt-2">
                                        <option value="">Please Select</option>
                                        {{-- @foreach ($accounts as $account)
                                        <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach --}}
                                    </select>
                                </div>
                                {{-- <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Code</label>
                                    <input id="regular-form-1" type="text" class="form-control" placeholder="Enter Code"
                                        name="code">
                                </div> --}}
                                {{-- <div class="col-md-2 mt-2">
                                    <label>Operation</label>
                                    <select id="regular-form-1" name="operation" class="tom-select w-full mt-2">
                                        <option value="1">Sea Export</option>
                                    </select>
                                </div> --}}
                                {{-- <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Job #</label>
                                    <input id="regular-form-1" type="text" class="form-control" placeholder="Enter Job #"
                                        name="job_no">
                                </div> --}}
                                {{-- <div class="col-md-2 mt-2">
                                    <label for="tran-mode-select" class="form-label">Tran Mode: </label>
                                    <select id="tran-mode-select" name="tran_mode" class="tom-select w-full">
                                        <option value="">Please Select</option>
                                        <option value="cash">Cash</option>
                                        <option value="bank">Bank</option>
                                        <option value="adjustment">Adjustment</option>
                                        <option value="security_in_hand">Security In Hand</option>
                                        <option value="adjust_from_security">Adjust From Security</option>
                                    </select>
                                </div> --}}
                                
                                {{-- <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Terminal inv #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Terminal inv #" name="terminal_inv_no">
                                </div> --}}
                                {{-- <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Code</label>
                                    <input id="regular-form-1" type="text" class="form-control" placeholder="Enter Code"
                                        name="code">
                                </div> --}}
                                {{-- <div class="col-md-2 mt-2">
                                    <label>On Account</label>
                                    <select id="regular-form-1" name="on_account" class="tom-select w-full mt-2">
                                        <option value="1">Client</option>
                                        <option value="2">Importer</option>
                                        <option value="3">Shipper</option>
                                        <option value="4">Clearing Agent</option>
                                        <option value="5">Coloader</option>
                                        <option value="6">Clearing</option>
                                        <option value="7">Other</option>
                                        <option value="8">Investor</option>
                                        <option value="9">3rd Party</option>
                                        <option value="10">Personal A/C</option>
                                    </select>
                                </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label for="nature" class="form-label">Nature</label>
                                    <select name="nature" id="nature" class="form-control">
                                        <option value="">Please select Nature</option>
                                        <option value="Online Transfer">Online Transfer</option>
                                        <option value="Credit Card">Credit Card</option>
                                        <option value="Cheque">Cheque</option>
                                        <option value="Pay Order">Pay Order</option>
                                        <option value="TT">TT</option>
                                        <option value="Cash">Cash</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2 cheque_fields" style="display: none;">
                                    <label for="cheque_number" class="form-label">Cheque Number</label>
                                    <input id="cheque_number" type="text" readonly class="form-control name-validate"
                                        placeholder="Enter Cheque Number" name="cheque_number">
                                </div>

                                <div class="col-md-3 mt-2 cheque_fields" style="display: none;">
                                    <div class="d-flex">
                                        <div class="">
                                            <label for="regular-form-1" class="form-label">Cheque Date</label>
                                            <input id="regular-form-1" type="date" class="form-control name-validate"
                                                placeholder="Enter Cheque Date" name="cheque_date">
                                        </div>
                                        <div class="d-flex align-items-end justify-content-end ms-3">
                                            <button type="button" id="btnPickCheque"
                                                class="btn btn-primary btn-xs">Pick</button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3 mt-2 date" style="display: none;">
                                    <label for="online_transfer_or_cash_date" class="form-label">Date</label>
                                    <input id="date" type="date" class="form-control name-validate" name="date">
                                </div>

                                <div class="col-md-3 mt-2 ref_no" style="display: none;">
                                    <label for="online_transfer_reference_no" class="form-label">Reference No</label>
                                    <input id="ref_no" type="text" class="form-control name-validate"
                                        placeholder="Enter Reference Number" name="ref_no">
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-5 mt-2">
                                    <label for="total_receiving_amount" class="form-label">Total Amount</label>
                                    <input id="total_receiving_amount" type="text" class="form-control"
                                        placeholder="Enter Total Amount" name="total_receiving_amount">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Currency</label>
                                    <select name="currency" id="currency" class="tom-select w-full mt-2">
                                        <option value="1">PKR</option>
                                        <option value="2">USD</option>
                                        <option value="3">AED</option>
                                        <option value="4">GPB</option>
                                        <option value="5">EUR</option>
                                        <option value="6">BDT</option>
                                        <option value="7">OMR</option>
                                    </select>
                                </div>
                                {{-- <div class="col-md-2 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input" name="continue">
                                    <label class="form-label" for="continue">
                                        Continue
                                    </label>
                                </div> --}}
                                <div class="col-md-4 mt-2">
                                    <label for="exchange_rate" class="form-label">Exchange Rate</label>
                                    <input id="exchange_rate" type="text" class="form-control"
                                        placeholder="Enter Exchange Rate" name="exchange_rate">
                                </div>
                                {{-- <div class="col-md-2 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input"
                                        name="multi_currency">
                                    <label class="form-label" for="multi_currency">
                                        Multi Currency
                                    </label>
                                </div>
                                <div class="col-md-2 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input" name="reversal">
                                    <label class="form-label" for="reversal">
                                        Reversal
                                    </label>
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Rev Tran #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Rev Tran #" name="rev_tran_no">
                                </div> --}}
                                <div class="col-md-2 mt-2">
                                    <label for="tax" class="form-label">Tax (%)</label>
                                    <input id="tax" type="text" class="form-control" placeholder="Enter Tax (%)" name="tax">
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label for="tax_amt" class="form-label">Tax Amt</label>
                                    <input id="tax_amt" type="text" class="form-control" placeholder="Enter Tax Amt"
                                        name="tax_amt">
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Invoice #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Invoice #" name="invoice_no">
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Bank Charges</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Bank Charges" name="bank_charges">
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Gain/Loss(FC)</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Gain/Loss(FC)" name="gain_loss">
                                </div>
                                <div class="col-md-2 mt-10">
                                    <button type="button" id="adjust_invoice" class="btn btn-primary">Adjust
                                        Invoice</button>
                                </div>
                                <div class="tab-content mt-2">
                                    <div class="tab-pane fade show active" id="charges" role="tabpanel"
                                        aria-labelledby="charges_tab">
                                        <div class="text-end mt-3 mb-3 me-5">
                                            {{-- <button id="addRowReceivableButton" type="button"
                                                class="btn btn-primary">Refresh
                                                Invoices</button> --}}
                                        </div>
                                        <div class="row">
                                            <div class="intro-y g-col-12 overflow-auto">
                                                <table id="receiveableTable" class="table table-bordered mt-n2">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-nowrap">S.No</th>
                                                            <th class="text-nowrap">Job No.</th>
                                                            <th class="text-nowrap">Invoice No.</th>
                                                            <th class="text-nowrap">Ref No.</th>
                                                            <th class="text-nowrap">HBL No.</th>
                                                            <th class="text-nowrap">MBL No.</th>
                                                            <th class="text-nowrap">Inv Curr</th>
                                                            <th class="text-nowrap">Invoice Bal</th>
                                                            <th class="text-nowrap">Rcvd Amount</th>
                                                            <th class="text-nowrap">Rcvd Converted Amount</th>
                                                            <th class="text-nowrap">Balance</th>
                                                            <th class="text-nowrap"></th>
                                                            <th class="text-nowrap">File No.</th>
                                                            <th class="text-nowrap">Container</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if (isset($transaction))
                                                            <tr>
                                                                <td>1</td>
                                                                <input type="hidden" name="invoice_id[]"
                                                                    value="{{ $transaction->id }}">
                                                                <td><a
                                                                        href="{{ url('/se_job/edit/' . $transaction->job_master_id) }}">{{ $transaction->job_master_id }}</a>
                                                                    <input type="hidden" name="job_master_id[]"
                                                                        class="form-control w-24"
                                                                        value="{{ $transaction->job_master_id }}">
                                                                </td>
                                                                <td><input type="text" name="invoice_tran_no[]"
                                                                        class="form-control w-24"
                                                                        value="{{ $transaction->tran_no }}">
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="ref_tran_no[]"
                                                                        class="form-control w-24"
                                                                        value="{{ isset($transaction) && preg_match('/^jb/i', $transaction->tran_no) ? $transaction->ref_bill_no : $transaction->ref_tran_no }}">
                                                                </td>
                                                                <td><input type="text" name="hbl_no[]" class="form-control w-24"
                                                                        value="{{ $transaction->job_master?->bl_master?->hbl_no }}">
                                                                </td>
                                                                <td><input type="text" name="mbl_no[]" class="form-control w-24"
                                                                        value="{{ $transaction->job_master?->bl_master?->mbl_no }}">
                                                                </td>
                                                                <td><input type="text" name="inv_curr[]"
                                                                        class="form-control w-24" value="PKR">
                                                                </td>
                                                                <td><input type="text" name="rcvd_amount[]"
                                                                        class="form-control w-24 rcvd-amount">
                                                                </td>
                                                                <td><input type="text" name="rcvd_converted_amount[]"
                                                                        class="form-control w-24 rcvd-conv-amount">
                                                                </td>
                                                                <td><input type="text" name="grand_total_amount[]"
                                                                        class="form-control w-24 grand_total_amount"
                                                                        value="{{ $transaction->grand_local_amount }}">
                                                                </td>
                                                                <td><input type="text" name="balance[]"
                                                                        class="form-control w-24 balance">
                                                                </td>
                                                                <td><input type="text" name="file_no[]"
                                                                        class="form-control w-24"
                                                                        value="{{ $transaction->job_master?->file_no }}">
                                                                </td>
                                                                @php
                                                                    $containerNumbers = isset(
                                                                        $transaction->job_master->bl_master
                                                                            ->bl_container_info,
                                                                    )
                                                                        ? implode(
                                                                            ', ',
                                                                            $transaction->job_master->bl_master->bl_container_info
                                                                                ->pluck('container_no')
                                                                                ->toArray(),
                                                                        )
                                                                        : '';
                                                                @endphp
                                                                <td><input type="text" name="container[]"
                                                                        class="form-control w-24"
                                                                        value="{{ $containerNumbers }}">
                                                                </td>
                                                            </tr>
                                                        @endif
                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-8 mt-2">
                                            <label for="regular-form-1" class="form-label">Remarks</label>
                                            <textarea name="remarks" id="regular-form-1" cols="30" rows="8"
                                                class="form-control" placeholder="Enter Remarks"></textarea>
                                        </div>
                                        <div class="col-md-4 mt-2">
                                            <label for="regular-form-1" class="form-label">Total Amount</label>
                                            <input id="total_amount" readonly type="text" class="form-control"
                                                placeholder="Enter Total Amount" name="total_amount">
                                            <input type="hidden" id="original_total_amount" name="original_total_amount">
                                            <label for="regular-form-1" class="form-label">Advance</label>
                                            <input id="advance_amount" readonly type="text" class="form-control"
                                                placeholder="Enter Advance" name="advance">
                                            <label for="regular-form-1" class="form-label">Net Received / Payment</label>
                                            <input id="net_received" readonly type="text" class="form-control"
                                                placeholder="Enter Net Received / Payment" name="net_received">
                                            <label for="total_amount_conv" class="form-label">Net Received / Payment
                                                Converted</label>
                                            <input id="total_amount_conv" readonly type="text" class="form-control"
                                                placeholder="Enter Net Received / Payment Converted"
                                                name="total_amount_conv">
                                        </div>
                                    </div>

                                    <div class="row d-none">
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Voucher #</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Voucher #" name="voucher_no">
                                        </div>

                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">RF</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter RF" name="rf">
                                        </div>

                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Normal</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Normal" name="normal">
                                        </div>

                                    </div>
                                    <div class="row d-none">
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Security</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Security" name="security">
                                        </div>
                                        <div class="col-md-3 mt-2">
                                            <label for="regular-form-1" class="form-label">Detention</label>
                                            <input id="regular-form-1" type="text" class="form-control"
                                                placeholder="Enter Detention" name="detention">
                                        </div>

                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>

    <!-- BEGIN: Modal Content -->
    <div id="pickChequeModal" class="modal fade" tabindex="-1" aria-hidden="true"
        data-api-url="{{ url('/api/se_job/add/commodity') }}">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Bank</th>
                                    <th>#</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="tbodyChequeDetails"></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div> <!-- END: Modal Content -->
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        // function updateTotalAmount() {
        //     let total = 0;

        //     $('.rcvd-amount').each(function() {
        //         const val = parseFloat($(this).val()) || 0;
        //         total += val;
        //     });

        //     $('#total_amount').val(total.toFixed(2));
        //     $('#original_total_amount').val(total.toFixed(2));
        // }

        // function updateTotalAmountConv() {
        //     let total = 0;

        //     $('.rcvd-conv-amount').each(function() {
        //         const value = parseFloat($(this).val()) || 0;
        //         total += value;
        //     });

        //     $('#total_amount_conv').val(total.toFixed(2));
        // }

        // Example: Call this function on input change
        // $(document).on('input', '.rcvd-amount', updateTotalAmount);
        // $(document).on('input', '.rcvd-amount', function() {
        //     updateTotalAmount();
        //     // updateTotalAmountConv();
        // });
        // var currency = $('#currency').val();
        // if (currency == 1) {
        //     $('#exchange_rate').val(1).prop('readonly', true);
        // } else {
        //     $('#exchange_rate').val('').prop('readonly', false);
        // }

        // $('#currency').change(function () {
        //     var currencyy = $(this).val();
        //     if (currencyy == 1) {
        //         $('#exchange_rate').val(1).prop('readonly', true);
        //     } else {
        //         $('#exchange_rate').val('').prop('readonly', false);
        //     }
        // });

        // $('#exchange_rate').on('input', function() {
        //     var exchangeRate = parseFloat($(this).val()) || 1;
        //     $('#receiveableTable tbody tr').each(function() {
        //         var $rcvdAmountInput = $(this).find('.rcvd-amount');
        //         var rcvdAmount = parseFloat($rcvdAmountInput.val()) || 1;
        //         var rcvdConvertedAmount = rcvdAmount / exchangeRate;
        //         $(this).find('input[name="rcvd_converted_amount[]"]').val(rcvdConvertedAmount
        //             .toFixed(2));
        //     });
        // });

        // $('#receiveableTable').on('input', '.rcvd-amount', function() {
        //     var exchangeRate = parseFloat($('#exchange_rate').val()) || 1;
        //     var rcvdAmount = parseFloat($(this).val()) || 0;
        //     var rcvdConvertedAmount = rcvdAmount / exchangeRate;
        //     $(this).closest('tr').find('input[name="rcvd_converted_amount[]"]').val(rcvdConvertedAmount
        //         .toFixed(2));
        // });


        // function calculateTaxAmount() {
        //     var taxPercentage = parseFloat($('#tax').val());
        //     var originalTotalAmount = parseFloat($('#original_total_amount')
        //         .val()); // New hidden field for original total amount
        //     if (!isNaN(taxPercentage) && !isNaN(originalTotalAmount)) {
        //         var taxAmount = (taxPercentage / 100) * originalTotalAmount;
        //         var finalAmount = originalTotalAmount + taxAmount;
        //         $('#tax_amt').val(taxAmount.toFixed(2)); // Round to 2 decimal places
        //         $('#total_amount').val(finalAmount.toFixed(2)); // Round to 2 decimal places
        //     } else {
        //         $('#tax_amt').val('');
        //         $('#total_amount').val(originalTotalAmount.toFixed(2));
        //     }
        // }

        // function calculateTaxPercentage() {
        //     var taxAmount = parseFloat($('#tax_amt').val());
        //     var originalTotalAmount = parseFloat($('#original_total_amount')
        //         .val()); // New hidden field for original total amount
        //     if (!isNaN(taxAmount) && !isNaN(originalTotalAmount)) {
        //         var taxPercentage = (taxAmount / originalTotalAmount) * 100;
        //         var finalAmount = originalTotalAmount + taxAmount;
        //         $('#tax').val(taxPercentage.toFixed(2)); // Round to 2 decimal places
        //         $('#total_amount').val(finalAmount.toFixed(2)); // Round to 2 decimal places
        //     } else {
        //         $('#tax').val('');
        //         $('#total_amount').val(originalTotalAmount.toFixed(2));
        //     }
        // }

        // $('#tax').on('input', function() {
        //     calculateTaxAmount();
        // });

        // $('#tax_amt').on('input', function() {
        //     calculateTaxPercentage();
        // });

        // Initialize original total amount
        $('#original_total_amount').val($('#total_amount').val());

        $('#type-select').change(function () {
            handleTypeChange($(this).val());
        });
        @if (isset($transaction) && !preg_match('/^jb/i', $transaction->tran_no))
            handleTypeChange('receipt');
        @elseif (isset($transaction) && preg_match('/^jb/i', $transaction->tran_no))
            handleTypeChange('payment');
        @endif


        function handleTypeChange(selectedType) {
            console.log('selectedType', selectedType);
            var tran_no = parseFloat("{{ $transaction_no }}") || 0;
            var year = new Date().getFullYear();

            var nature_value = $('#nature').val();

            if (nature_value == 'Cheque' && selectedType == 'receipt') {
                $('#cheque_number').removeAttr('readonly');
                $('#btnPickCheque').css('display', 'none');
            } else {
                $('#cheque_number').prop('readonly', true);
                $('#btnPickCheque').css('display', 'block');
            }

            if (selectedType == "receipt") {
                $('#trans_no').val('JR-' + (tran_no + 1) + '/' + year);
            } else if (selectedType == "payment") {
                $('#trans_no').val('JP-' + (tran_no + 1) + '/' + year);
            }

            $.ajax({
                url: "{{ url('api/get_accounts_for_receipt') }}?type=" + selectedType,
                method: 'GET',
                success: function (response) {
                    var existingClientId = @json(isset($transaction)
                        ? (preg_match('/^jb/i', $transaction->tran_no)
                            ? $transaction->vendor_id
                            : $transaction->client_id)
                    : '');
                    $('#client-id-select').empty().append(
                        '<option value="">Please Select</option>');
                    $.each(response.data, function (key, account) {
                        let selected = (account.id == existingClientId) ? 'selected' : '';
                        $('#client-id-select').append('<option value="' + account.id +
                            '" ' + selected + '>' + account.name + '</option>');
                    });
                },
                error: function (xhr, status, error) {
                    console.error('Error fetching accounts:', error);
                }
            });
        }

        $('#account-type-select').change(function () {
            handleAccountTypeChange($(this).val());
        });

        function handleAccountTypeChange(selectedType) {
            console.log('selectedAccountType', selectedType);
            $.ajax({
                url: "{{ url('api/get_accounts_for_receipt_account_type') }}?type=" + selectedType,
                method: 'GET',
                success: function (response) {
                    $('#account_id').empty().append(
                        '<option value="">Please Select</option>');
                    $.each(response.data, function (key, account) {
                        $('#account_id').append('<option value="' + account.id +
                            '" >' + account.name + '</option>');
                    });
                },
                error: function (xhr, status, error) {
                    console.error('Error fetching accounts:', error);
                }
            });
        }


        let rowReceivableCounter = 0;

        function createInput(type, name, placeholder, class_name = null) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                if (class_name) {
                    return '<input type="' + type + '" name="' + name +
                        '" class="form-control ' + class_name + '" placeholder="' +
                        placeholder + '">';
                } else {
                    return '<input type="' + type + '" name="' + name +
                        '" class="form-control" placeholder="' +
                        placeholder + '">';
                }
            }
        }

        function addRowReceivable() {
            let row = '<tr>' +
                '<td class="text-nowrap">' + (rowReceivableCounter + 1) +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'debit[]', '', 'input_debit w-40') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'credit[]', '', 'input_credit w-40') +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'narration[]', '', 'input_narration') +
                '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);

        $('#nature').change(function () {
            var nature_value = $('#nature').val();
            var type_select = $('#type-select').val();

            if (nature_value == 'Cheque' && type_select == 'receipt') {
                $('#cheque_number').removeAttr('readonly');
                $('#btnPickCheque').css('display', 'none');
            } else {
                $('#cheque_number').prop('readonly', true);
                $('#btnPickCheque').css('display', 'block');
            }

            if (nature_value == 'Cheque') {
                $('.cheque_fields').css('display', 'block');
                $('.date').css('display', 'none');
                $('.ref_no').css('display', 'none');
            } else {
                $('.cheque_fields').css('display', 'none');
            }

            if (nature_value == 'Online Transfer') {
                $('.date').css('display', 'block');
                $('.ref_no').css('display', 'block');
            } else {
                $('.cheque_date').css('display', 'none');
                $('.cheque_number').css('display', 'none');
            }

            if (nature_value == 'Cash') {
                $('.date').css('display', 'block');
                $('.ref_no').css('display', 'block');
            } else {
                $('.cheque_date').css('display', 'none');
                $('.cheque_number').css('display', 'none');
            }

            if (nature_value == 'Pay Order') {
                $('.date').css('display', 'block');
                $('.ref_no').css('display', 'block');
            } else {
                $('.cheque_date').css('display', 'none');
                $('.cheque_number').css('display', 'none');
            }

            if (nature_value == 'Credit Card') {
                $('.date').css('display', 'block');
                $('.ref_no').css('display', 'block');
            } else {
                $('.cheque_date').css('display', 'none');
                $('.cheque_number').css('display', 'none');
            }

            if (nature_value == 'TT') {
                $('.date').css('display', 'block');
                $('.ref_no').css('display', 'block');
            } else {
                $('.cheque_date').css('display', 'none');
                $('.cheque_number').css('display', 'none');
            }

        })


        $('#btnPickCheque').click(function () {
            $('#tbodyChequeDetails').html('');
            let account_id = $('#account_id').val();
            console.log('account_id', account_id)
            $.ajax({
                url: "{{ url('api/get_cheques') }}",
                type: 'GET',
                data: {
                    account_id: account_id
                },
                success: function (response) {
                    console.log('response', response);
                    Object.keys(response.data).forEach(function (key) {
                        $('#tbodyChequeDetails').append(
                            '<tr><td class="tdChequeId">' + response.data[key]
                                .id + '</td><td>' + response.data[key].id +
                            '</td><td class="tdChequeNumber">' + response.data[
                                key].cheque_number +
                            '</td><td><button class="btn btn-primary btn-sm chequeId" type="button">Pick</button></td></tr>'
                        )
                    })
                },
                error: function (xhr, status, error) {
                    // Handle error response
                    console.error(xhr.responseText);
                    // Optionally, display an error message
                }
            });

            $('#pickChequeModal').modal('show');
        })

        $(document).on('click', '.chequeId', function (e) {
            console.log($(this).closest('tr'))
            var row = $(this).closest('tr');
            var cheque_id = row.find('.tdChequeId')[0].innerHTML;
            var cheque_number = row.find('.tdChequeNumber')[0].innerHTML;

            $('#cheque_number').val(cheque_number);

            $('#pickChequeModal').modal('hide');
        })

        // Adjust amounts when the total receiving amount changes

        // function updateAdvanceAmount() {
        //     var totalAmount = parseFloat($('#total_receiving_amount').val()) || 0;
        //     $('#advance_amount').val(totalAmount);
        // }

        // Call on input
        // $('#total_receiving_amount').on('input', updateAdvanceAmount);

        // function updateTotalReceivingAmountSingle(checkbox) {
        //     let row = $(checkbox).closest('tr');
        //     let amount = parseFloat(row.find('.grand_total_amount').val()) || 0;

        //     // Get number of checked checkboxes AFTER this change
        //     let checkedCount = $('.rec_check:checked').length;

        //     let total = parseFloat($('#total_receiving_amount').val()) || 0;

        //     if ($(checkbox).is(':checked')) {
        //         if (checkedCount === 1) {
        //             // First checkbox being checked — reset total
        //             total = amount;
        //         } else {
        //             total += amount;
        //         }
        //     } else {
        //         total -= amount;
        //     }

        //     $('#total_receiving_amount').val(total.toFixed(2));
        //     updateAdvanceAmount();
        // }


        // $(document).on('change', '.rec_check', function() {
        //     updateTotalReceivingAmountSingle(this);
        // });
        // $('#adjust_invoice').on('click', function() {
        //     var totalAmount = parseFloat($('#total_receiving_amount').val()) || 0;
        //     var exchangeRate = parseFloat($('#exchange_rate').val()) || 1;
        //     var remainingAmount = totalAmount * exchangeRate;


        //     $('#advance_amount').val('');
        //     $('#net_received').val(totalAmount);
        //     $('#total_amount_conv').val(totalAmount * exchangeRate);

        //     // Determine checked rows
        //     var $checkedRows = $('#receiveableTable tbody tr').has('.rec_check:checked');
        //     var $allRows = $('#receiveableTable tbody tr');

        //     var $targetRows = $checkedRows.length > 0 ? $checkedRows : $allRows;

        //     // First: Reset all rows if checkboxes are used
        //     if ($checkedRows.length > 0) {
        //         $allRows.each(function() {
        //             $(this).find('.rcvd-amount, .rcvd-conv-amount, .balance').val('0.00');
        //         });
        //     }

        //     $targetRows.each(function() {
        //         var $rcvdAmountInput = $(this).find('.rcvd-amount');
        //         var $balanceInput = $(this).find('.balance');
        //         var $rcvdAmountConvInput = $(this).find('.rcvd-conv-amount');
        //         var grandTotalAmount = parseFloat($(this).find('.grand_total_amount').val()) ||
        //             0;

        //         if (remainingAmount >= grandTotalAmount) {
        //             $rcvdAmountInput.val(grandTotalAmount.toFixed(2));
        //             $rcvdAmountConvInput.val((grandTotalAmount * exchangeRate).toFixed(2));
        //             remainingAmount -= grandTotalAmount;
        //         } else {
        //             $rcvdAmountInput.val((remainingAmount / exchangeRate).toFixed(2));
        //             $rcvdAmountConvInput.val((remainingAmount).toFixed(2));
        //             remainingAmount = 0;
        //         }

        //         var rcvdAmount = parseFloat($rcvdAmountConvInput.val()) || 0;
        //         var balance = grandTotalAmount - rcvdAmount;
        //         $balanceInput.val(balance.toFixed(2));

        //         updateTotalAmount();
        //         // updateTotalAmountConv();
        //     });

        //     if (remainingAmount > 0) {
        //         $('#advance_amount').val(remainingAmount.toFixed(2));
        //     }

        //     // Calculate total received and balance
        //     var totalRcvdAmount = 0;
        //     $('#receiveableTable tbody tr').each(function() {
        //         var rcvdAmount = parseFloat($(this).find('.rcvd-amount').val()) || 0;
        //         totalRcvdAmount += rcvdAmount;
        //     });

        //     var balanceAmount = totalAmount - totalRcvdAmount;
        //     $('#balance_amount').val(balanceAmount.toFixed(2));
        // });



        $('.get-invoices').change(function () {
            var clientId = $('#client-id-select').val();
            var selectedType = $('#type-select').val();
            var operation_id = $('#operation-id').val();

            if (clientId) {
                $.ajax({
                    url: '/api/get_invoices_for_client', // Adjust the URL to your actual endpoint
                    method: 'GET',
                    data: {
                        client_id: clientId,
                        type: selectedType,
                        operation_id: operation_id
                    },
                    success: function (response) {
                        console.log('response', response);
                        // Clear existing table rows
                        $('#receiveableTable tbody').empty();

                        // Helper function to handle null or undefined values
                        function formatValue(value, defaultValue = '-') {
                            return value ? value : defaultValue;
                        }

                        // Populate table with the received data
                        $.each(response.invoices, function (index, invoice) {
                            var containerNumbers = (invoice.job_master?.bl_master
                                ?.bl_container_info || [])
                                .map(function (container) {
                                    return container.container_no;
                                }).join(', ');
                            var row = '<tr>' +
                                '<td class="text-nowrap">' + (index + 1) + '</td>' +
                                '<td class="text-nowrap"><input type="hidden" class="form-control" name="invoice_id[]" value="' +
                                invoice.id +
                                '"><a href="/se_job/edit/' + invoice.job_master_id +
                                '">' + invoice.job_master_id +
                                '</a><input type="hidden" class="form-control" name="job_master_id[]" value="' +
                                formatValue(invoice.job_master_id) +
                                '" ></td>' +
                                '<td class="text-nowrap"><a href="/se_invoice/edit/' +
                                invoice.id +
                                '">' + invoice.tran_no +
                                '</a><input type="hidden" class="form-control" name="invoice_tran_no[]" value="' +
                                formatValue(invoice.tran_no) + '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control" name="ref_tran_no[]" value="' +
                                formatValue(invoice.ref_tran_no) +
                                '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control" name="hbl_no[]" value="' +
                                formatValue(invoice.job_master?.bl_master?.hbl_no) +
                                '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control" name="mbl_no[]" value="' +
                                formatValue(invoice.job_master?.bl_master?.mbl_no) +
                                '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control" name="inv_curr[]" value="' +
                                formatValue(invoice.inv_curr, 'PKR') +
                                '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control grand_total_amount" name="grand_total_amount[]" value="' +
                                formatValue(invoice.grand_local_amount) +
                                '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control rcvd-amount" name="rcvd_amount[]" value="' +
                                formatValue(invoice.rcvd_amount) +
                                '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control rcvd-conv-amount" name="rcvd_converted_amount[]" value="' +
                                formatValue(invoice.rcvd_amount) +
                                '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control balance" name="balance[]" ></td>' +
                                '<td class="text-nowrap"><input type="checkbox" class="form-check-input rec_check" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control" name="file_no[]" value="' +
                                formatValue(invoice.job_master?.file_no) +
                                '" ></td>' +
                                '<td class="text-nowrap"><input type="text" class="form-control" name="container[]" value="' +
                                formatValue(containerNumbers) +
                                '" ></td>' +
                                '</tr>';
                            $('#receiveableTable tbody').append(row);
                        });

                        // $('#total_amount').val(response.total_amount);
                        // $('#original_total_amount').val(response.total_amount);
                    },
                    error: function (xhr, status, error) {
                        console.error('Error fetching invoices:', error);
                    }
                });
            } else {
                // Clear table if no client is selected
                $('#receiveableTable tbody').empty();
            }
        });

        //new methods for amount handling
        const num = (v) => {
            const n = parseFloat((v ?? '').toString().replace(/,/g, ''));
            return Number.isFinite(n) ? n : 0;
        };

        const fmt = (v) => (Number.isFinite(v) ? v : 0).toFixed(2);

        const getER = () => {
            const cur = $('#currency').val();
            // PKR = 1 & readonly, others user-specified
            return cur == '1' ? 1 : (num($('#exchange_rate').val()) || 1);
        };

        const rowsAll = () => $('#receiveableTable tbody tr');
        const rowsChecked = () => $('#receiveableTable tbody tr').has('.rec_check:checked');

        const targetRows = () => {
            const chk = rowsChecked();
            return chk.length ? chk : rowsAll();
        };

        const clearRowAmounts = ($rows) => {
            $rows.each(function () {
                $(this).find('.rcvd-amount').val('0.00');
                $(this).find('.rcvd-conv-amount').val('0.00');
                $(this).find('.balance').val(fmt(num($(this).find('.grand_total_amount').val())));
            });
        };

        const sumConv = ($rows) => {
            let s = 0;
            $rows.each(function () {
                s += num($(this).find('.rcvd-conv-amount').val());
            });
            return s;
        };

        const fifoDistribute = (totalConv, $rows, er) => {
            // Distribute totalConv across rows in order
            let remaining = totalConv;

            $rows.each(function () {
                const $r = $(this);
                const grand = num($r.find('.grand_total_amount').val()); // local currency
                const take = Math.min(remaining, grand);

                // Set received (local & FC)
                $r.find('.rcvd-conv-amount').val(fmt(take));
                $r.find('.rcvd-amount').val(fmt(take / er));
                $r.find('.balance').val(fmt(grand - take));

                remaining -= take;
                if (remaining <= 0) return false; // break loop
            });

            // Any rows not touched should keep zeros/balances recalculated:
            $rows.each(function () {
                const $r = $(this);
                const conv = num($r.find('.rcvd-conv-amount').val());
                const grand = num($r.find('.grand_total_amount').val());
                $r.find('.balance').val(fmt(grand - conv));
                $r.find('.rcvd-amount').val(fmt(conv / er));
            });

            return remaining; // leftover (if > 0) goes to advance
        };

        const updateHeaderTotalsFromConv = (sumConvLocal) => {
            const er = getER();
            const tra = num($('#total_receiving_amount').val());     // user-entered (FC)
            const maxConv = tra * er;

            // Clamp to available total (based on TRA & ER)
            const usedConv = Math.min(sumConvLocal, maxConv);
            const advanceConv = Math.max(0, maxConv - usedConv);

            $('#total_amount_conv').val(fmt(maxConv));
            $('#total_amount').val(fmt(usedConv));
            $('#net_received').val(fmt(tra));              // FC
            $('#advance_amount').val(fmt(advanceConv));              // local currency left to advance
        };

        const recalcBalancesAndHeader = () => {
            const er = getER();
            const $rows = targetRows();

            // Re-sync .rcvd-amount (FC) and balances from .rcvd-conv-amount (local)
            $rows.each(function () {
                const $r = $(this);
                const conv = num($r.find('.rcvd-conv-amount').val());
                const grand = num($r.find('.grand_total_amount').val());
                $r.find('.rcvd-amount').val(fmt(conv / er));
                $r.find('.balance').val(fmt(grand - conv));
            });

            updateHeaderTotalsFromConv(sumConv($rows));
        };

        /* ---------------------- basic scenario ---------------------- */
        // When user types in total_receiving_amount:
        //   advance_amount = TRA
        //   net_received  = TRA
        //   total_amount_conv = TRA * ER
        const applyBasicMirror = () => {
            const tra = num($('#total_receiving_amount').val());
            const er = getER();
            $('#advance_amount').val(fmt(tra));            // temporarily in FC; requirement says mirror — keeping exact value
            $('#net_received').val(fmt(tra));
            $('#total_amount_conv').val(fmt(tra * er));    // local
        };

        // Currency / ER rules (PKR => ER=1 and readonly)
        const enforceERReadonly = () => {
            const cur = $('#currency').val();
            if (cur == '1') {
                $('#exchange_rate').val(1).prop('readonly', true);
            } else {
                $('#exchange_rate').prop('readonly', false);
            }
        };

        enforceERReadonly();
        $('#currency').on('change', enforceERReadonly);

        $('#exchange_rate').on('input', function () {
            // Keep mirrors fresh when ER changes
            applyBasicMirror();
            recalcBalancesAndHeader();
        });

        $('#total_receiving_amount').on('input', function () {
            applyBasicMirror();
        });

        /* --------------- adjust invoice: FIFO allocation --------------- */
        $('#adjust_invoice').on('click', function () {
            const tra = num($('#total_receiving_amount').val()); // FC
            const er = getER();
            let totalConv = tra * er;                             // local

            // Clear advance; set mirrors
            $('#advance_amount').val('');
            $('#net_received').val(fmt(tra));
            $('#total_amount_conv').val(fmt(totalConv));

            const $rows = targetRows();

            // Reset all rows (only when allocating)
            clearRowAmounts(rowsAll());

            // FIFO distribute
            const leftover = fifoDistribute(totalConv, $rows, er);

            // Whatever is left after covering all rows goes to Advance (local)
            if (leftover > 0) {
                $('#advance_amount').val(fmt(leftover));
                // Net received should reflect what actually got allocated to invoices (local/er)
                // const usedConv = totalConv - leftover;
                // $('#net_received').val(fmt(usedConv / er));
                // $('#total_amount_conv').val(fmt(usedConv));
            }
            const remainingAmount = totalConv - num($('#advance_amount').val());
            $('#total_amount').val(fmt(remainingAmount));
        });

        /* -------- scenario 2: when any .rcvd-conv-amount is edited ------- */
        // Rule:
        //  - Sum .rcvd-conv-amount of checked rows; if none checked, sum all rows.
        //  - Cap total to available (TRA*ER); if over, reduce the just-edited cell to fit.
        //  - Recompute per-row .rcvd-amount (FC) and .balance.
        //  - Update header totals + advance.
        let lastEditedCell = null;

        $('#receiveableTable').on('focus', '.rcvd-conv-amount', function () {
            lastEditedCell = this;
        });

        $('#receiveableTable').on('input', '.rcvd-conv-amount', function () {
            const er = getER();
            const tra = num($('#total_receiving_amount').val());
            const maxConv = tra * er;

            const $rows = targetRows();

            // Current total of edited set
            let total = sumConv($rows);

            // If over budget, trim the last edited field
            if (total > maxConv && lastEditedCell) {
                const over = total - maxConv;
                const $cell = $(lastEditedCell);
                const cur = num($cell.val());
                const newVal = Math.max(0, cur - over);
                $cell.val(fmt(newVal));

                // Recalculate total after trim
                total = sumConv($rows);
            }

            // Sync FC & balances and header totals
            recalcBalancesAndHeader();
        });

        /* ---------- checkbox behavior (re-evaluate target rows) ---------- */
        $(document).on('change', '.rec_check', function () {
            // Check if at least one checkbox is checked
            const anyChecked = $('.rec_check:checked').length > 0;

            // Handle rows based on checkbox status
            rowsAll().each(function () {
                const $row = $(this);
                const $checkbox = $row.find('.rec_check');
                const $rcvdAmount = $row.find('.rcvd-amount');
                const $rcvdConvAmount = $row.find('.rcvd-conv-amount');

                // If the row is unchecked and at least one row is checked, clear the amounts
                if (!$checkbox.is(':checked') && anyChecked) {
                    $rcvdAmount.val(null);
                    $rcvdConvAmount.val(null);
                }
            });

            // Recalculate the balances and update the header totals
            recalcBalancesAndHeader();
        });

        /* ----------------- optional: keep total_amount live ---------------- */
        const updateTotalAmountFC = () => {
            let total = 0;
            rowsAll().each(function () {
                total += num($(this).find('.rcvd-amount').val());
            });
            $('#total_amount').val(fmt(total));
            $('#original_total_amount').val(fmt(total));
        };

        // Keep #total_amount in sync if user edits FC side manually (rare)
        $('#receiveableTable').on('input', '.rcvd-amount', function () {
            updateTotalAmountFC();
        });

        // Initialize mirrors on load
        applyBasicMirror();
    });
</script>