@extends('layout.master')

@section('title')
    @if (Request::is('se_receipt'))
        SE Receipt / Payment-YARAN
    @elseif(Request::is('si_receipt'))
        SI Receipt / Payment-YARAN
    @elseif(Request::is('ae_receipt'))
        AE Receipt / Payment-YARAN
    @elseif(Request::is('ai_receipt'))
        AI Receipt / Payment-YARAN
    @endif
@endsection

@section('topbar')
    @if (Request::is('se_receipt'))
        <a href="/se_receipt" class="breadcrumb--active">SE Receipt / Payment</a>
    @elseif(Request::is('si_receipt'))
        <a href="/si_receipt" class="breadcrumb--active">SI Receipt / Payment</a>
    @elseif(Request::is('ae_receipt'))
        <a href="/ae_receipt" class="breadcrumb--active">AE Receipt / Payment</a>
    @elseif(Request::is('ai_receipt'))
        <a href="/ai_receipt" class="breadcrumb--active">AI Receipt / Payment</a>
    @endif
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        @if (Request::is('se_receipt'))
            SE Receipt / Payment
        @elseif(Request::is('si_receipt'))
            SI Receipt / Payment
        @elseif(Request::is('ae_receipt'))
            AE Receipt / Payment
        @elseif(Request::is('ai_receipt'))
            AI Receipt / Payment
        @endif
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            @if (Request::is('se_receipt'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/se_receipt/add') }}">Add New</a>
            @elseif(Request::is('si_receipt'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/si_receipt/add') }}">Add New</a>
            @elseif(Request::is('ae_receipt'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ae_receipt/add') }}">Add New</a>
            @elseif(Request::is('ai_receipt'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ai_receipt/add') }}">Add New</a>
            @endif
            {{-- <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $rategroups->firstItem() }} to
                {{ $rategroups->lastItem() }} of {{ $rategroups->total() }} entries</div> --}}
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Trans #</th>
                        <th>Tran date</th>
                        <th>Client</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($receipt_payment as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item->trans_no }}</td>
                            <td>{{ $item->trans_date }}</td>
                            <td>{{ @$item->party->name }}</td>
                            <td>{{ $item->created_at }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if (Request::is('se_receipt'))
                                        <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/se_receipt/edit/' . $item->id) }}"><i data-feather="edit"
                                                class="w-4 h-4"></i> </a>
                                    @elseif(Request::is('si_receipt'))
                                        <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/si_receipt/edit/' . $item->id) }}"><i data-feather="edit"
                                                class="w-4 h-4"></i> </a>
                                    @elseif(Request::is('ae_receipt'))
                                        <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/ae_receipt/edit/' . $item->id) }}"><i data-feather="edit"
                                                class="w-4 h-4"></i> </a>
                                    @elseif(Request::is('ai_receipt'))
                                        <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/ai_receipt/edit/' . $item->id) }}"><i data-feather="edit"
                                                class="w-4 h-4"></i> </a>
                                    @endif
                                    {{-- <a target="_blank" href={{ url('receipt_print/' . $item->id) }}
                                        class="btn btn-success me-2 p-2"><i data-feather="file-text"
                                            class="w-4 h-4 me-1"></i>Print</a> --}}
                                    <button id="showPrintBtn{{ $item->id }}"
                                        class="btn btn-success me-2 p-2 showPrintBtn" data-bs-toggle="modal"
                                        data-bs-target="#printModal" data-item-id="{{ $item->id }}"><i
                                            data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @include('sea_export.se_receipt.modals.print')

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add event listener to all buttons with the class 'showPrintBtn'
            document.querySelectorAll('.showPrintBtn').forEach(button => {
                button.addEventListener('click', function() {
                    // Get the bl_id from the button's data-item-id attribute
                    const receiptID = this.getAttribute('data-item-id');

                    // Set the value of the hidden input field
                    // document.getElementById('selectedBLId').value = blId;
                    const form = document.getElementById(
                        'printForm');
                    form.setAttribute('action', `/receipt_print/${receiptID}`);
                });
            });
        });
    </script>
@endsection
