<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <style>
        * {
            margin: 5px 5px;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;

        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #302c2c;
            padding: 8px;
            text-align: left;
            font-size: 14px;
        }

        th {
            background-color: #b3aeae;
            font-weight: bold;
            text-align: center;
        }

        .total-row td {
            text-align: right;
            font-weight: bold;
        }

        .total-row td:first-child {
            text-align: left;
        }
    </style>
</head>

<body>
    @php
        $currencyMapping = [
            1 => 'PKR',
            2 => 'USD',
            3 => 'AED',
            4 => 'GPB',
            5 => 'EUR',
            6 => 'BDT',
            7 => 'OMR',
        ];

        $currencyValue = @$receipt_payment->currency;
        $currencyName = isset($currencyMapping[$currencyValue]) ? $currencyMapping[$currencyValue] : 'Unknown Currency';
    @endphp
    <div class="container" style="margin: 0px 60px; width: 88.1%; font-size: 16px;">
        <div class="logo-heading" style="display: flex;gap: 15%;align-items: center;text-align: center;">
            <div class="logo" style="{{ $print_logo == 'on' ? 'visibility: hidden;' : '' }}">
                <img src="{{ url('/logo-invoice.png') }}" alt=""
                    style="width: 150px; padding-bottom: px;border-top: none;">
            </div>
            <div class="heading" style="{{ $print_on_letterhead == 'on' ? 'visibility: hidden;' : '' }}">
                <h3>YARAN SHIPPING LINE</h3>
                <p></p>
                <p style="font-size: 12px;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div style="border:3px solid;width: 68%;border-top: none; border-right: none; border-left: none;"></div>
            @if ($receipt_payment->type == 'payment')
                <h3> Payment </h3>
            @else
                <h3> Receipt </h3>
            @endif
            <div style="border:3px solid;width: 8%; border-right: none; border-left: none;border-top: none;"></div>
        </div>
        <div class="reciept" style="display: flex; justify-content: space-between;">
            <div style=" display: flex; gap: 10px;">
                @if ($receipt_payment->type == 'payment')
                    <h4>Payment # :</h4>
                @else
                    <h4>Receipt # :</h4>
                @endif
                <p style="border-bottom: 1px solid; width: 170px;">{{ @$receipt_payment->trans_no }}</p>
            </div>
            <div style="display: flex;">
                <h4>Date : </h4>
                <p style="border-bottom: 1px solid; width: 170px;">
                    {{ \Carbon\Carbon::parse(@$receipt_payment->date)->format('d/m/Y') }}</p>
            </div>
        </div>
        <div class="from">
            <div style="display: flex; gap: 10px;">
                @if ($receipt_payment->type == 'payment')
                    <h4>Pay To :</h4>
                @else
                    <h4>Receive From :</h4>
                @endif
                <p style="border-bottom: 1px solid; width: 420px;">{{ @$receipt_payment->client->name }}</p>
            </div>
        </div>
        <div class="from">
            <div style="display: flex; gap: 20px;">
                <h4>The sum of : </h4>
                @php
                    $formatter = new \NumberFormatter('en', \NumberFormatter::SPELLOUT);
                    $amountInWords = strtoupper($formatter->format(@$receipt_payment->total_received_amount));
                @endphp
                <p style="border-bottom: 1px solid; width: 420px;">{{ $currencyName }} {{ $amountInWords }}
                </p>
            </div>
        </div>
        <div class="reciept" style="display: flex; gap: 2px;font-size: 15px;">
            <div style=" display: flex;">
                <h4>By :</h4>
                <p style="border-bottom: 1px solid; width: 95px;">{{ @$receipt_payment->nature }}</p>
            </div>
            <div style="display: flex;">
                <h4>Cheque # : </h4>
                <p style="border-bottom: 1px solid; width: 95px;">{{ @$receipt_payment->cheque_number }}</p>
            </div>
            <div style="display: flex;">
                <h4>Cheque Date : </h4>
                <p style="border-bottom: 1px solid; width: 95px;">
                    {{ \Carbon\Carbon::parse(@$receipt_payment->cheque_date)->format('d/m/Y') }}</p>
            </div>
        </div>
        <div class="reciept" style="display: flex; gap: 2px;font-size: 15px;">
            @if ($show_account_no == 'on')
                <div style="display: flex;">
                    <h4>Account # :</h4>
                    <p style="border-bottom: 1px solid; width: 150px;">
                        {{ @$receipt_payment->account->name }}</p>
                </div>
            @endif
            @if ($print_option == 1)
                <div style="display: flex;">
                    <h4>Curr </h4>
                    <p style="border-bottom: 1px solid; width: 100px;">{{ $currencyName }}</p>
                </div>
            @endif
        </div>
        @if ($print_option == 1)

            <table>
                <thead>
                    <tr>
                        <th rowspan="2">S#</th>
                        <th rowspan="2">Inv No</th>
                        <th rowspan="2">Inv Date</th>
                        <th rowspan="2">Ref#</th>
                        @if ($hbl_mbl_option == 1)
                            <th rowspan="2">HBL #/MBL #</th>
                        @elseif ($hbl_mbl_option == 2)
                            <th rowspan="2">HBL #</th>
                        @elseif ($hbl_mbl_option == 3)
                            <th rowspan="2">MBL #</th>
                        @endif
                        <th rowspan="2">Job #</th>
                        <th rowspan="2">Invoice
                            Type</th>
                        <th>Curr</th>
                        <th>Inv Settle Amount</th>
                        <th rowspan="2">Exch
                            Rate</th>
                        <th rowspan="2">Local Amount</th>
                    </tr>

                </thead>
                <tbody>
                    @if ($receipt_payment_detail)
                        @foreach ($receipt_payment_detail as $index => $receipt)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $receipt->invoice_no }}</td>
                                <td>{{ $receipt_payment->trans_date }}</td>
                                <td>{{ $receipt->ref_no }}</td>
                                @if ($hbl_mbl_option == 1)
                                    <td>{{ $receipt->hbl_no }} / {{ $receipt->mbl_no }}</td>
                                @elseif ($hbl_mbl_option == 2)
                                    <td>{{ $receipt->hbl_no }}</td>
                                @elseif ($hbl_mbl_option == 3)
                                    <td>{{ $receipt->mbl_no }}</td>
                                @endif
                                <td>{{ @$receipt->job_master->job_no }}</td>
                                <td>{{ $receipt_payment->type }}</td>
                                <td>{{ $receipt->inv_curr }}</td>
                                <td>{{ $receipt->rcvd_amount }}</td>
                                <td>{{ $receipt_payment->exchange_rate }}</td>
                                <td>{{ $receipt->rcvd_converted_amount }}</td>
                            </tr>
                        @endforeach
                    @endif
                    @if (@$receipt_payment->advance > 0 && $receipt_payment->advance != null)
                        <tr>
                            <td colspan="10">Advance:</td>
                            <td>{{ @$receipt_payment->advance }}</td>
                        </tr>
                    @endif
                    <tr class="total-row">
                        <td colspan="10" style="padding-left: 75%;">Total :</td>
                        <td>{{ @$receipt_payment->net_received }}</td>
                    </tr>
                </tbody>
            </table>
            <div class="Remarks">
                <div style="display: flex;gap: 10px; margin-top: 2%;">
                    <h4>Remarks: </h4>
                    <p>{{ @$receipt_payment->remarks }}</p>
                </div>
            </div>
        @else
            @php
                $invoiceNos = [];
                $totalAmount = 0;
            @endphp
            @if ($receipt_payment_detail)
                @foreach ($receipt_payment_detail as $index => $receipt)
                    @php
                        $invoiceNos[] = $receipt->invoice_no;
                        $totalAmount += $receipt->invoice_amount;
                    @endphp
                @endforeach
            @endif
            @php
                $invoiceNosString = implode(',', $invoiceNos);
            @endphp
            <div style="display: flex;">
                <h4>Against Invoice Numbers :</h4>
                <p style="border-bottom: 1px solid; width: 100px;">
                    {{ $invoiceNosString }}</p>
            </div>
            <div class="Remarks">
                <div style="display: flex;gap: 10px; margin-top: 2%;">
                    <h4>Remarks: </h4>
                    <p style="border-bottom: 1px solid;">{{ @$receipt_payment->remarks }}</p>
                </div>
            </div>
            <div style="display: flex;">
                <h4>PKR :</h4>
                <p style="border-bottom: 1px solid; width: 100px;">
                    {{ $totalAmount }}</p>
            </div>
            <div class="Remarks">
                <div style="display: flex;gap: 10px; margin-top: 2%;">
                    <h4>For :</h4>
                    <p style="border-bottom: 1px solid;">YARAN SHIPPING LINE</p>
                </div>
            </div>

        @endif

    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            window.print(); // Trigger the print dialog once the page loads
        });
    </script>
</body>

</html>
