<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">

</head>

<body style="font-family: 'Poppins', sans-serif; font-size: 14px; margin: 0; padding: 0;">
    @php
        $currencyMapping = [1 => 'PKR', 2 => 'USD', 3 => 'AED', 4 => 'GPB', 5 => 'EUR', 6 => 'BDT', 7 => 'OMR'];
        $currencyValue = @$receipt_payment->currency;
        $currencyName = isset($currencyMapping[$currencyValue]) ? $currencyMapping[$currencyValue] : 'Unknown Currency';
        $formatter = new \NumberFormatter('en', \NumberFormatter::SPELLOUT);
        $amountInWords = strtoupper($formatter->format(@$receipt_payment->total_received_amount));
    @endphp

    <table style="width: 100%; margin: 20px 60px;">
        <tr>
            @if ($print_logo == 'on')
                <td style="width: 40%;">
                    <img src="{{ url('logo2.png') }}" alt="Company Logo"
                        style="width: 80px !important; height: 50px !important; max-width: 80px !important; max-height: 50px !important; object-fit: contain;"
                        width="80" height="50">
                </td>
            @endif
            @if ($print_on_letterhead == 'on')
                <td style="text-align: center;">
                    <h3 style="margin: 0;">YARAN SHIPPING LINE</h3>
                    <p style="margin: 0;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
                </td>
            @endif
        </tr>
    </table>

    <table style="width: 100%; margin: 0 60px;">
        <tr>
            <td style="border-top: 3px solid #000; width: 68%;"></td>
            <td style="text-align: center; font-weight: bold;">
                {{ $receipt_payment->type == 'payment' ? 'Payment' : 'Receipt' }}
            </td>
            <td style="border-top: 3px solid #000; width: 8%;"></td>
        </tr>
    </table>

    <table style="width: 100%; margin: 10px 60px;">
        <tr>
            <td style="width: 50%;">
                <strong>{{ $receipt_payment->type == 'payment' ? 'Payment # :' : 'Receipt # :' }}</strong>
                <span style="border-bottom: 1px solid #000;">{{ @$receipt_payment->trans_no }}</span>
            </td>
            <td style="text-align: right;">
                <strong>Date : </strong>
                <span style="border-bottom: 1px solid #000;">
                    {{ \Carbon\Carbon::parse(@$receipt_payment->date)->format('d/m/Y') }}
                </span>
            </td>
        </tr>
    </table>

    <table style="width: 100%; margin: 10px 60px;">
        <tr>
            <td colspan="3">
                <strong>{{ $receipt_payment->type == 'payment' ? 'Pay To :' : 'Receive From :' }}</strong>
                <span style="border-bottom: 1px solid #000;">{{ @$receipt_payment->client->name }}</span>
            </td>
        </tr>
        <tr>
            <td colspan="3">
                <strong>The sum of :</strong>
                <span style="border-bottom: 1px solid #000;">{{ $currencyName }} {{ $amountInWords }}</span>
            </td>
        </tr>
        <tr>
            <td>
                <strong>By :</strong>
                <span style="border-bottom: 1px solid #000;">{{ @$receipt_payment->nature }}</span>
            </td>
            <td>
                <strong>Cheque # :</strong>
                <span style="border-bottom: 1px solid #000;">{{ @$receipt_payment->cheque_number }}</span>
            </td>
            <td>
                <strong>Cheque Date :</strong>
                <span style="border-bottom: 1px solid #000;">
                    {{ \Carbon\Carbon::parse(@$receipt_payment->cheque_date)->format('d/m/Y') }}
                </span>
            </td>
        </tr>

        <tr>
            @if ($show_account_no == 'on')
                <td>
                    <strong>Account # :</strong>
                    <span style="border-bottom: 1px solid #000;">{{ @$receipt_payment->account->name }}</span>
                </td>
            @endif
            @if ($print_option == 1)
                <td>
                    <strong>Curr :</strong>
                    <span style="border-bottom: 1px solid #000;">{{ $currencyName }}</span>
                </td>
            @endif
        </tr>
    </table>

    @if ($print_option == 1)
        <table style="width: 100%; border-collapse: collapse; margin: 20px 60px;">
            <thead>
                <tr>
                    <th style="border: 1px solid #000;">S#</th>
                    <th style="border: 1px solid #000;">Inv No</th>
                    <th style="border: 1px solid #000;">Inv Date</th>
                    <th style="border: 1px solid #000;">Ref#</th>
                    @if ($hbl_mbl_option == 1)
                        <th style="border: 1px solid #000;">HBL #/MBL #</th>
                    @elseif ($hbl_mbl_option == 2)
                        <th style="border: 1px solid #000;">HBL #</th>
                    @elseif ($hbl_mbl_option == 3)
                        <th style="border: 1px solid #000;">MBL #</th>
                    @endif
                    <th style="border: 1px solid #000;">Job #</th>
                    <th style="border: 1px solid #000;">Invoice Type</th>
                    <th style="border: 1px solid #000;">Curr</th>
                    <th style="border: 1px solid #000;">Inv Settle Amount</th>
                    <th style="border: 1px solid #000;">Exch Rate</th>
                    <th style="border: 1px solid #000;">Local Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($receipt_payment_detail as $index => $receipt)
                    <tr>
                        <td style="border: 1px solid #000;">{{ $index + 1 }}</td>
                        <td style="border: 1px solid #000;">{{ $receipt->invoice_no }}</td>
                        <td style="border: 1px solid #000;">{{ $receipt_payment->trans_date }}</td>
                        <td style="border: 1px solid #000;">{{ $receipt->ref_no }}</td>
                        <td style="border: 1px solid #000;">
                            @if ($hbl_mbl_option == 1)
                                {{ $receipt->hbl_no }} / {{ $receipt->mbl_no }}
                            @elseif ($hbl_mbl_option == 2)
                                {{ $receipt->hbl_no }}
                            @elseif ($hbl_mbl_option == 3)
                                {{ $receipt->mbl_no }}
                            @endif
                        </td>
                        <td style="border: 1px solid #000;">{{ @$receipt->job_master->job_no }}</td>
                        <td style="border: 1px solid #000;">{{ $receipt_payment->type }}</td>
                        <td style="border: 1px solid #000;">{{ $receipt->inv_curr }}</td>
                        <td style="border: 1px solid #000;">{{ $receipt->rcvd_amount }}</td>
                        <td style="border: 1px solid #000;">{{ $receipt_payment->exchange_rate }}</td>
                        <td style="border: 1px solid #000;">{{ $receipt->rcvd_converted_amount }}</td>
                    </tr>
                @endforeach
                @if (@$receipt_payment->advance > 0)
                    <tr>
                        <td colspan="10" style="border: 1px solid #000;">Advance:</td>
                        <td style="border: 1px solid #000;">{{ @$receipt_payment->advance }}</td>
                    </tr>
                @endif
                <tr>
                    <td colspan="10" style="text-align: right; font-weight: bold; border: 1px solid #000;">Total :
                    </td>
                    <td style="border: 1px solid #000;">{{ @$receipt_payment->net_received }}</td>
                </tr>
            </tbody>
        </table>

        <table style="width: 100%; margin: 10px 60px;">
            <tr>
                <td><strong>Remarks: </strong> {{ @$receipt_payment->remarks }}</td>
            </tr>
        </table>
    @else
        @php
            $invoiceNos = [];
            $totalAmount = 0;
            foreach ($receipt_payment_detail as $receipt) {
                $invoiceNos[] = $receipt->invoice_no;
                $totalAmount += $receipt->invoice_amount;
            }
        @endphp
        <table style="width: 100%; margin: 10px 60px;">
            <tr>
                <td><strong>Against Invoice Numbers :</strong> <span
                        style="border-bottom: 1px solid;">{{ implode(',', $invoiceNos) }}</span></td>
            </tr>
            <tr>
                <td><strong>Remarks: </strong><span
                        style="border-bottom: 1px solid;">{{ @$receipt_payment->remarks }}</span></td>
            </tr>
            <tr>
                <td><strong>PKR :</strong> <span style="border-bottom: 1px solid;">{{ $totalAmount }}</span></td>
            </tr>
            <tr>
                <td><strong>For :</strong> <span style="border-bottom: 1px solid;">YARAN SHIPPING LINE</span></td>
            </tr>
        </table>
    @endif

</body>

</html>
