@extends('layout.master')

@section('title')
Edit-UN Location-YARAN
@endsection

@section('topbar')
<a href="/un_locations" class="breadcrumb-item">UN Location</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            {{ Form::model($un_location, ['route' => ['un_locations.update', $un_location->id], 'method' => 'PUT']) }}
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Edit UN Location
                    </h2>
                    
                    <button type="submit" class="btn btn-primary submitBtn"
                        id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>

                <div id="input" class="p-5">
                    <div class=" col-md-12">
                        <div class="row mb-5">
                            <div class="col-md-6 mt-1">
                                <label for="regular-form-1" class="form-label">Location</label>
                                <input id="regular-form-1" value="{{ $un_location->name }}" type="text" class="form-control "
                                    placeholder="Enter Location" name="location">
                            </div>
                            <div class="col-md-6 d-flex align-items-end">
                                <div class="form-group me-5">
                                    <input id="regular-form-1" {{ $un_location->country == '1' ? 'checked' : '' }} type="checkbox" class="form-check-input" name="country"
                                        value="1">
                                    <label class="form-label" for="country">
                                        Country
                                    </label>
                                </div>
                                <div class="form-group me-5">
                                    <input id="regular-form-1" {{ $un_location->city == '1' ? 'checked' : '' }} type="checkbox" class="form-check-input" name="city"
                                        value="1">
                                    <label class="form-label" for="city">
                                        City
                                    </label>
                                </div>
                                <div class="form-group me-5">
                                    <input id="regular-form-1" {{ $un_location->airport == '1' ? 'checked' : '' }} type="checkbox" class="form-check-input" name="airport"
                                        value="1">
                                    <label class="form-label" for="airport">
                                        Airport
                                    </label>
                                </div>
                                <div class="form-group me-5">
                                    <input id="regular-form-1" {{ $un_location->seaport == '1' ? 'checked' : '' }} type="checkbox" class="form-check-input" name="seaport"
                                        value="1">
                                    <label class="form-label" for="seaport">
                                        Seaport
                                    </label>
                                </div>
                                <div class="form-group me-5">
                                    <input id="regular-form-1" {{ $un_location->terminal == '1' ? 'checked' : '' }} type="checkbox" class="form-check-input" name="terminal"
                                        value="1">
                                    <label class="form-label" for="terminal">
                                        Terminal
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Coordinates</label>
                                <input id="regular-form-1" value="{{ $un_location->coordinates }}" type="text" class="form-control "
                                    placeholder="Enter Coordinates" name="coordinates">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">Latitude</label>
                                <input id="regular-form-1" value="{{ $un_location->latitude }}" type="text" class="form-control "
                                    placeholder="Enter Latitude" name="latitude">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">Longitude</label>
                                <input id="regular-form-1"  value="{{ $un_location->longitude }}" type="text" class="form-control "
                                    placeholder="Enter Longitude" name="longitude">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">State</label>
                                <input id="regular-form-1" value="{{ $un_location->state }}" type="text" class="form-control "
                                    placeholder="Enter State" name="state">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">Phone Prefix</label>
                                <input id="regular-form-1" value="{{ $un_location->phone_prefix }}" type="text" class="form-control "
                                    placeholder="Enter Phone Prefix" name="phone_prefix">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">EPASS Code</label>
                                <input id="regular-form-1" value="{{ $un_location->epass_code }}" type="text" class="form-control "
                                    placeholder="Enter EPASS Code" name="epass_code">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">Category / Region</label>
                                <input id="regular-form-1" value="{{ $un_location->category_region }}" type="text" class="form-control "
                                    placeholder="Enter Category / Region" name="category_region">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Status</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Status" id="status" name="status"
                                        class="tom-select w-full">
                                        <option {{ $un_location->status == '1' ? 'selected' : '' }} value="1">Active</option>
                                        <option {{ $un_location->status == '0' ? 'selected' : '' }} value="0">In Active</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
