@extends('layout.master')

@section('title')
UN Location-YARAN
@endsection

@section('topbar')
<a href="/un_locations" class="breadcrumb--active">UN Location</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        UN Locations
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('un_locations.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $un_locations->firstItem() }} to
                {{ $un_locations->lastItem() }} of {{ $un_locations->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($un_locations as $index => $un_location)
                        <tr>
                            <td>{{ $index+1 }}</td>
                            <td>{{ $un_location->name }}</td>
                            <td>{{ $un_location->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('un_locations.edit', [$un_location->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['un_locations.destroy', $un_location->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
         <div class="g-col-12">
            <div class="d-flex justify-content-end align-items-end">
                <div class="me-3">
                    <form method="GET" id="perPageForm" class="d-flex align-items-center">
                        <label for="perPage" class="form-label me-2">Show Items:</label>
                        <select id="perPage" name="perPage" class="form-select"
                            onchange="document.getElementById('perPageForm').submit();">
                            <option value="100" @if ($perPage == 100) selected @endif>100</option>
                            <option value="200" @if ($perPage == 200) selected @endif>200</option>
                            <option value="250" @if ($perPage == 250) selected @endif>250</option>
                        </select>
                    </form>

                </div>
                <div class="ms-3">
                    <?php echo $un_locations->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                </div>
            </div>
        </div>
    </div>
@endsection
