
@extends('layout.master')

@section('title')
Edit-User-YARAN
@endsection

@section('topbar')
<a href="/user" class="breadcrumb-item">User</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/user/edit'. '/' . $user->id) }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Edit User
                    </h2>
                    <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>

                <div id="input" class="p-5">
                    <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input id="regular-form-1" type="text" class="form-control name-validate"
                                    value="{{ $user->name }}"   placeholder="Enter Name" name="name">
                                    <span class="text-danger validation-name" style="display: none;">
                                        <i class="mdi mdi-alert"></i> Name is invalid
                                    </span>
                                </div>
                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Email</label>
                                    <input id="regular-form-1" type="text" class="form-control email-validate"
                                    value="{{ $user->email }}"   placeholder="Enter Email" name="email">
                                    <span class="text-danger validation-email" style="display: none;">
                                        <i class="mdi mdi-alert"></i>Email format is invalid
                                    </span>
                                </div>
                            </div>
                            <div class="row mb-5">
                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Password</label>
                                    <input id="regular-form-1" type="text" class="form-control password-validate"
                                        placeholder="Enter Password" name="password">
                                    <span class="text-danger validation-password" style="display: none;">
                                        <i class="mdi mdi-alert"></i> Password format should be Combination of Special
                                        Character, a Number and a Capital Letter.
                                    </span>
                                </div>
                                <div class="col-md-6">
                                    <label>Role</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select your Role" id="role" name="role_id"
                                            class="tom-select w-full">
                                            @foreach ($roles as $role)
                                            <option {{ @$user_role->role_id == $role->id ? 'selected' : '' }}
                                                value="{{ $role->id }}">{{ $role->title }}</option>
                                        @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-5">
                                <div class="col-md-6">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select your favorite Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option {{ $user->status == 1 ? 'selected' : '' }} value="1">Active</option>
                                        <option {{ $user->status == 0 ? 'selected' : '' }} value="0">InActive
                                        </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">profile Pic</label>
                                    <input id="regular-form-1" type="file" class="form-control "
                                       + name="profile_pic">
                                       @if ($user->profile_pic)
                                        <p class="mt-2">Current File: {{ $user->profile_pic }}</p>
                                    @else
                                        <p class="mt-2">No file selected.</p>
                                    @endif
                                    @if ($user->profile_pic)
                                        <img width="100px" height="100px" src="{{ url('uploads/' . $user->profile_pic) }}"
                                            alt="">
                                    @endif

                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

