@extends('layout.master')

@section('title')
User-YARAN
@endsection

@section('topbar')
<a href="/user" class="breadcrumb--active">User</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Users
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ url('/user/add') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $users->firstItem() }} to
                {{ $users->lastItem() }} of {{ $users->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <form id="MyForm" method="post" action="{{ url('/role/index') }}">
                        @csrf
                        <tr>
                            <th>Id</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Actions</th>
                    </form>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $user)
                        <tr>
                            <td>{{ $user->id }}</td>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->status == 1 ? 'Active' : 'InActive' }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @can('User_Edit')
                                        <a class="btn btn-primary me-2 p-2" href="{{ url('/user/edit/' . $user->id) }}"><i
                                                data-feather="edit" class="w-4 h-4"></i> </a>
                                    @endcan
                                    @can('User_Delete')
                                        <form method="post" action="{{ url('/user/delete/' . $user->id) }}">
                                            @csrf
                                            <button type="submit" class="btn btn-danger p-2">
                                                <i data-feather="trash-2" class="w-4 h-4"></i>
                                            </button>
                                        </form>
                                        {{-- <div class="g-col-6 g-col-sm-3 g-col-lg-2 g-col-xl-1">
                                    <i data-feather="trash-2" class="d-block mx-auto"></i>
                                    <div class="text-center fs-xs mt-2">trash-2</div>
                                </div> --}}
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
