@extends('layout.master')

@section('title')
User-YARAN
@endsection

@section('topbar')
<a href="/user" class="breadcrumb--active">User</a>
@endsection
@section('content')
    <!-- BEGIN: Bordered Table -->
    <div class="intro-y box mt-5">
        <div class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
            <h2 class="fw-medium fs-base me-auto">
                User Table
            </h2>
            @can('Add-user')
                <div class="  pt-3 pt-md-0">
                    <div class="dt-buttons btn-group flex-wrap">
                        <a href="{{ url('/user/add') }}" class="btn btn-primary w-24 me-1 mb-2" type="button"><span>
                                <span>Add New </span></span></a>
                    </div>
                </div>
            @endcan
            {{-- <div class="form-check form-switch w-full w-sm-auto ms-sm-auto mt-3 mt-sm-0 ps-0">
            <label class="form-check-label ms-0 ms-sm-2" for="show-example-2">Show example code</label>
            <input id="show-example-2" data-target="#bordered-table" class="show-code form-check-input me-0 ms-3" type="checkbox">
        </div> --}}
        </div>

        <div id="bordered-table" class="p-5">
            <div class="preview">
                <div class="overflow-x-auto">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th class="text-nowrap">ID</th>
                                <th class="text-nowrap"> Name</th>
                                <th class="text-nowrap">Email</th>
                                <th class="text-nowrap">Status</th>
                                <th class="text-nowrap">Action</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $user)
                                <tr>
                                    <td>{{ $user->id }}</td>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>
                                        {{-- <form method="POST" action="{{ url('/user/toggleStatus/' . $user->id) }}"
                                        enctype="multipart/form-data" class="user-form">
                                        @csrf
                                        <label class="switch switch-primary switch-lg">
                                            <input type="checkbox" class="switch-input"
                                                {{ $user->status == 1 ? 'checked' : '' }}
                                                onchange="submitForm({{ $user->id }})" />
                                            <span class="switch-toggle-slider">
                                                <span class="switch-on"></span>
                                                <span class="switch-off"></span>
                                            </span>
                                            <span
                                                class="switch-label {{ $user->status == 1 ? 'text-primary' : '' }}">{{ $user->status == 1 ? 'Active' : 'InActive' }}</span>
                                        </label>
                                    </form> --}}
                                        @if ($user->status == 1)
                                            <span class=" me-1">Active</span>
                                        @else
                                            <span class=" me-1">InActive</span>
                                        @endif
                                    </td>

                                    <td>
                                        <div class="d-flex align-items-center">
                                            @can('User_Edit')
                                                <a class="btn btn-primary me-2 p-2-5"
                                                    href="{{ url('/user/edit/' . $user->id) }}"><i data-feather="edit"
                                                        class="d-block mx-auto"></i> </a>
                                            @endcan
                                            @can('User_Delete')
                                                <form method="post" action="{{ url('/user/delete/' . $user->id) }}">
                                                    @csrf
                                                    <button type="submit" class="btn btn-danger p-2-5">
                                                        <i data-feather="trash-2" class="d-block mx-auto"></i>
                                                    </button>
                                                </form>
                                                {{-- <div class="g-col-6 g-col-sm-3 g-col-lg-2 g-col-xl-1">
                                            <i data-feather="trash-2" class="d-block mx-auto"></i>
                                            <div class="text-center fs-xs mt-2">trash-2</div>
                                        </div> --}}
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
    <!-- END: Bordered Table -->
@endsection
