@extends('layout.master')

@section('title')
Vessel Mapping-YARAN
@endsection

@section('topbar')
<a href="/vesselmappings" class="breadcrumb--active">Vessel Mapping</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Vessel Mappings
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('vesselmappings.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $vesselmappings->firstItem() }} to
                {{ $vesselmappings->lastItem() }} of {{ $vesselmappings->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Integration Code</th>
                        <th>Integration Name</th>
                        <th>CSUL Code</th>
                        <th>CSUL Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($vesselmappings as $vesselmapping)
                        <tr>
                            <td>{{ $vesselmapping->id }}</td>
                            <td>{{ $vesselmapping->integration_code }}</td>
                            <td>{{ $vesselmapping->integration_name }}</td>
                            <td>{{ $vesselmapping->csul_code }}</td>
                            <td>{{ $vesselmapping->csul_name }}</td>
                            <td>{{ $vesselmapping->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('vesselmappings.edit', [$vesselmapping->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['vesselmappings.destroy', $vesselmapping->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
