@extends('layout.master')

@section('title')
Edit-Vessel-YARAN
@endsection

@section('topbar')
<a href="/vessels" class="breadcrumb-item">Vessel</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            {{ Form::model($vessel, ['route' => ['vessels.update', $vessel->id], 'method' => 'PUT']) }}
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Edit Vessel
                    </h2>
                    
                    <button type="submit" class="btn btn-primary submitBtn"
                        id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>

                <div id="input" class="p-5">
                    <div class=" col-md-12">
                        <div class="row mb-5">
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Name</label>
                                <input id="regular-form-1" type="text" class="form-control" value="{{ $vessel->name }}"
                                    placeholder="Enter Name" name="name">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Owner</label>
                                <input id="regular-form-1" type="text" class="form-control" value="{{ $vessel->owner }}"
                                    placeholder="Enter Owner" name="owner">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Principle Code</label>
                                <input id="regular-form-1" type="text" class="form-control"
                                    placeholder="Enter Principle Code" value="{{ $vessel->principle_code }}"
                                    name="principle_code">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Call Sign</label>
                                <input id="regular-form-1" type="text" class="form-control"
                                    value="{{ $vessel->call_sign }}" placeholder="Enter Call Sign" name="call_sign">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">GRT</label>
                                <input id="regular-form-1" type="text" class="form-control" value="{{ $vessel->grt }}"
                                    placeholder="Enter GRT" name="grt">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">NRT</label>
                                <input id="regular-form-1" type="text" class="form-control" value="{{ $vessel->nrt }}"
                                    placeholder="Enter NRT" name="nrt">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Imo No.</label>
                                <input id="regular-form-1" type="text" class="form-control" value="{{ $vessel->imo_no }}"
                                    placeholder="Enter Imo No." name="imo_no">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Country</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Country" id="country" name="country_id"
                                        class="tom-select w-full">
                                        <option value="">Select</option>
                                        @foreach ($countries as $country)
                                            <option {{ $vessel->country_id == $country->id ? 'selected' : '' }}
                                                value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Status</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Status" id="status" name="status"
                                        class="tom-select w-full">
                                        <option {{ $vessel->status == 1 ? 'selected' : '' }} value="1">Active</option>
                                        <option {{ $vessel->status == 0 ? 'selected' : '' }} value="0">InActive
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
