@extends('layout.master')

@section('title')
Vessel-YARAN
@endsection

@section('topbar')
<a href="/vessels" class="breadcrumb--active">Vessel</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Vessels
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('vessels.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $vessels->firstItem() }} to
                {{ $vessels->lastItem() }} of {{ $vessels->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Owner</th>
                        <th>Country</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($vessels as $vessel)
                        <tr>
                            <td>{{ $vessel->id }}</td>
                            <td>{{ $vessel->name }}</td>
                            <td>{{ $vessel->owner ?? '-' }}</td>
                            <td>{{ $vessel->country->name ?? '-' }}</td>
                            <td>{{ $vessel->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('vessels.edit', [$vessel->id]) }}" class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['vessels.destroy', $vessel->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
