@extends('layout.master')

@section('title')
Edit-Voucher-YARAN
@endsection

@section('topbar')
<a href="{{ url('accounts/voucher/edit', $transaction_master->id) }}" class="breadcrumb-item">Voucher</a><i
    data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
<div class="row  mt-5">
    <div class="  col-md-12 ">
        <!-- BEGIN: Input -->
        <form method="POST" id="myForm" action="{{ url('accounts/voucher/edit', $transaction_master->id) }}"
            enctype="multipart/form-data" class="row g-3">
            @csrf
        <div class="intro-y box">
            <div
                class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                <h2 class="fw-medium fs-base me-auto">
                    Edit Voucher
                </h2>
                
                <button type="submit" class="btn btn-primary submitBtn"
                    id="submitBtn">Save</button>
                <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                    Back
                </a>
            </div>

            <div id="input" class="p-5">
                <div class=" col-md-12">
                        <div class="row mb-5">

                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Date</label>
                                <input value="{{ $transaction_master->date }}" id="regular-form-1" required type="date"
                                    class="form-control name-validate" name="date">
                            </div>

                            <div class="col-md-6 mt-2">
                                <label>Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Type" id="transaction_type_master_id"
                                        name="transaction_type_master_id" class="tom-select w-full">
                                        <option value="">Please Select Type</option>
                                        @foreach ($transaction_type_master as $type)
                                        <option {{ $transaction_master->transaction_type_master_id == $type->id ?
                                            'selected' : '' }} value="{{ $type->id }}">{{ $type->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6 mt-2">
                                <label>Settlement Account</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Settlement Account" id="settlement_account"
                                        name="settlement_account" class="tom-select w-full">
                                        <option value="">Please Select Settlement Account</option>
                                        @foreach ($chart_of_accounts as $account)
                                        <option {{ $transaction_master->settlement_account == $account->id ? 'selected'
                                            : '' }} value="{{ $account->id }}">{{ $account->name . ' - ' .
                                            $account->account_code }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6 mt-2">
                                <label>Cost Center</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Cost Center" id="cost_center_id"
                                        name="cost_center_id" class="tom-select w-full">
                                        <option value="">Please Select Cost Center</option>
                                        @foreach ($cost_centers as $cost_center)
                                        <option {{ $transaction_master->cost_center_id == $cost_center->id ? 'selected'
                                            : '' }} value="{{ $cost_center->id }}">{{ $cost_center->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6 mt-2">
                                <label>Bank Sub Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Bank Type" id="bank_sub_type" name="bank_sub_type"
                                        class="tom-select w-full">
                                        <option value="">Please Select Bank Type</option>
                                        <option {{ $transaction_master->bank_sub_type == 'ACH' ? 'selected' : '' }}
                                            value="ACH">ACH</option>
                                        <option {{ $transaction_master->bank_sub_type == 'Wire Transfer' ? 'selected' :
                                            '' }} value="Wire Transfer">Wire Transfer</option>
                                        <option {{ $transaction_master->bank_sub_type == 'Online Transfer' ? 'selected'
                                            : '' }} value="Online Transfer">Online Transfer</option>
                                        <option {{ $transaction_master->bank_sub_type == 'Credit Card' ? 'selected' : ''
                                            }} value="Credit Card">Credit Card</option>
                                        <option {{ $transaction_master->bank_sub_type == 'Cheque' ? 'selected' : '' }}
                                            value="Cheque">Cheque</option>
                                        <option {{ $transaction_master->bank_sub_type == 'PO' ? 'selected' : '' }}
                                            value="PO">PO</option>
                                        <option {{ $transaction_master->bank_sub_type == 'TT' ? 'selected' : '' }}
                                            value="TT">TT</option>
                                        <option {{ $transaction_master->bank_sub_type == 'Cash' ? 'selected' : '' }}
                                            value="Cash">Cash</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6 mt-2">
                                <label>Currency</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Currency</option>
                                        <option {{ $transaction_master->currency_id == 1 ? 'selected' : '' }}
                                            value="1">PAK RUPEES</option>
                                        <option {{ $transaction_master->currency_id == 2 ? 'selected' : '' }}
                                            value="2">US DOLLAR</option>
                                        <option {{ $transaction_master->currency_id == 3 ? 'selected' : '' }}
                                            value="3">DIRHAM</option>
                                        <option {{ $transaction_master->currency_id == 4 ? 'selected' : '' }}
                                            value="4">POUND</option>
                                        <option {{ $transaction_master->currency_id == 5 ? 'selected' : '' }}
                                            value="5">EURO</option>
                                        <option {{ $transaction_master->currency_id == 6 ? 'selected' : '' }}
                                            value="6">BDT</option>
                                        <option {{ $transaction_master->currency_id == 7 ? 'selected' : '' }}
                                            value="7">OMANI RIYAL</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Exchange Rate</label>
                                <input value="{{ $transaction_master->exchange_rate }}" id="regular-form-1" required
                                    type="number" class="form-control name-validate" placeholder="Enter Exchange Rate"
                                    value="1.000000" name="exchange_rate">
                            </div>

                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Cheque Number</label>
                                <input value="{{ $transaction_master->cheque_number }}" id="regular-form-1" type="text"
                                    class="form-control name-validate" placeholder="Enter Cheque Number"
                                    name="cheque_number">
                            </div>

                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Cheque Date</label>
                                <input value="{{ $transaction_master->cheque_date }}" id="regular-form-1" type="date"
                                    class="form-control name-validate" placeholder="Enter Cheque Date"
                                    name="cheque_date">
                            </div>

                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Pay To</label>
                                <input value="{{ $transaction_master->pay_to }}" id="regular-form-1" type="text"
                                    class="form-control name-validate" placeholder="Enter Pay To" name="pay_to">
                            </div>

                        </div>

                        <div class="row mb-5">
                            <div class="mt-5">
                                <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                    <div class="intro-y pe-1">
                                        <div class="box p-2">
                                            <ul class="nav nav-pills rounded-2" role="tablist">
                                                <li id="invoice_tab" class="nav-item flex-1" role="presentation">
                                                    <button class="nav-link w-full pt-2 pb-2.5 active"
                                                        data-bs-toggle="pill" data-bs-target="#invoice" type="button"
                                                        role="tab" aria-controls="invoice_tab"
                                                        aria-selected="true">Detail</button>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="tab-content mt-2">
                                        <div class="tab-pane fade show active" id="charges" role="tabpanel"
                                            aria-labelledby="charges_tab">
                                            <div class="text-end mt-3 me-5">
                                                <button id="addRowReceivableButton" type="button"
                                                    class="btn btn-primary">Add
                                                    Row</button>
                                            </div>
                                            <div class="row">
                                                <div class="intro-y g-col-12 overflow-auto">
                                                    <table id="receiveableTable" class="table table-bordered mt-n2">
                                                        <thead>
                                                            <tr>
                                                                <th class="text-nowrap">S.No</th>
                                                                <th class="text-nowrap">Account</th>
                                                                <th class="text-nowrap">Cost Center</th>
                                                                {{-- <th class="text-nowrap">Debit (VC)</th>
                                                                <th class="text-nowrap">Credit (VC)</th> --}}
                                                                <th class="text-nowrap">Debit (LC)</th>
                                                                <th class="text-nowrap">Credit (LC)</th>
                                                                <th class="text-nowrap">Narration</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach ($transaction_master->detail as $index => $detail)
                                                            <tr>
                                                                <td>1</td>
                                                                <td>
                                                                    <select class="form-control" name="account_id[]"
                                                                        id="account_id">
                                                                        <option value="">Select Account</option>
                                                                        @foreach ($chart_of_accounts as $account)
                                                                        <option {{ $detail->account_id == $account->id ? 'selected' : '' }} value="{{ $account->id }}">{{
                                                                            $account->name . ' - ' .
                                                                            $account->account_code }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <select class="form-control"
                                                                        name="cost_center_detail[]"
                                                                        id="cost_center_detail">
                                                                        <option value="">Select Cost Center</option>
                                                                        @foreach ($cost_centers as $cost_center)
                                                                        <option {{ $detail->cost_center_id == $cost_center->id ? 'selected' : '' }} value="{{ $cost_center->id }}">{{
                                                                            $cost_center->name }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                                {{-- <td>
                                                                    <input class="form-control w-24" type="text"
                                                                        name="debit_vc[]">
                                                                </td>
                                                                <td>
                                                                    <input class="form-control w-24" type="text"
                                                                        name="credit_vc[]">
                                                                </td> --}}
                                                                <td>
                                                                    <input value="{{ $detail->debit_lc }}" class="form-control w-24" type="text"
                                                                        name="debit_lc[]">
                                                                </td>
                                                                <td>
                                                                    <input value="{{ $detail->credit_lc }}" class="form-control w-24" type="text"
                                                                        name="credit_lc[]">
                                                                </td>
                                                                <td>
                                                                    <input value="{{ $detail->narration }}" class="form-control w-24" type="text"
                                                                        name="narration[]">
                                                                </td>
                                                            </tr>
                                                            @endforeach

                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        const dropdownOptions = {
            chart_of_accounts: {!! json_encode($chart_of_accounts) !!},
            cost_centers: {!! json_encode($cost_centers) !!}
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + (rowReceivableCounter + 1) +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('account_id[]', dropdownOptions
                    .chart_of_accounts) +
                '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('cost_center_id[]', dropdownOptions
                    .cost_centers) + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'debit_vc[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'credit_vc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'debit_lc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'credit_lc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'narration[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>