@extends('layout.master')

@section('title')
Voucher-YARAN
@endsection

@section('topbar')
<a href="{{ url('accounts/voucher') }}" class="breadcrumb--active">Voucher</a>
@endsection
@section('content')
<h2 class="intro-y fs-lg fw-medium mt-10">
    Voucher
</h2>
<div class="grid columns-12 gap-6 mt-5">
    <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
        <a class="btn btn-primary shadow-md me-2" href="{{ url('accounts/voucher/add') }}">Add New</a>
        <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $transaction_master->firstItem() }} to
            {{ $transaction_master->lastItem() }} of {{ $transaction_master->total() }} entries</div>
    </div>
    <!-- BEGIN: Data List -->

    <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
        <table class="table table-bordered mt-n2">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Date</th>
                    <th>Type</th>
                    <th>Voucher No</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($transaction_master as $transaction)
                <tr>
                    <td>{{ $transaction->id }}</td>
                    <td>{{ $transaction->date }}</td>
                    <td>{{ @$transaction->type->name }}</td>
                    <td>{{ @$transaction->voucher_no }}</td>
                    <td>{{ @$transaction->detail->sum('debit_lc') }}</td>
                    <td>{{ @$transaction->detail->sum('credit_lc') }}</td>
                    <td>
                        <div class="d-flex gap-2">
                            <a href="{{ url('accounts/voucher/edit', $transaction->id) }}"
                                class="btn btn-primary">Edit</a>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="grid columns-12 gap-6 mt-4">
            <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center">
                <div class="d-flex d-md-block mx-auto text-gray-600">
                    <?php echo $transaction_master->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection