@extends('default')

@section('title')
Edit-Voyage-YARAN
@endsection

@section('topbar')
<a href="/voyages" class="breadcrumb-item">Voyage</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')

	@if($errors->any())
		<div class="alert alert-danger">
			@foreach ($errors->all() as $error)
				{{ $error }} <br>
			@endforeach
		</div>
	@endif

	{{ Form::model($voyage, array('route' => array('voyages.update', $voyage->id), 'method' => 'PUT')) }}

		<div class="mb-3">
			{{ Form::label('vessel_id', 'Vessel_id', ['class'=>'form-label']) }}
			{{ Form::text('vessel_id', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('voyage_no', 'Voyage_no', ['class'=>'form-label']) }}
			{{ Form::text('voyage_no', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('point_of_discharge_id', 'Point_of_discharge_id', ['class'=>'form-label']) }}
			{{ Form::text('point_of_discharge_id', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('point_of_loading_id', 'Point_of_loading_id', ['class'=>'form-label']) }}
			{{ Form::text('point_of_loading_id', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('import_sail_date_time', 'Import_sail_date_time', ['class'=>'form-label']) }}
			{{ Form::string('import_sail_date_time', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('import_arrival_date', 'Import_arrival_date', ['class'=>'form-label']) }}
			{{ Form::text('import_arrival_date', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('export_sailing_date', 'Export_sailing_date', ['class'=>'form-label']) }}
			{{ Form::text('export_sailing_date', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('export_dest_eta', 'Export_dest_eta', ['class'=>'form-label']) }}
			{{ Form::text('export_dest_eta', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('export_cut_of_date', 'Export_cut_of_date', ['class'=>'form-label']) }}
			{{ Form::text('export_cut_of_date', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('export_cut_of_time', 'Export_cut_of_time', ['class'=>'form-label']) }}
			{{ Form::text('export_cut_of_time', null, array('class' => 'form-control')) }}
		</div>
		<div class="mb-3">
			{{ Form::label('status', 'Status', ['class'=>'form-label']) }}
			{{ Form::text('status', null, array('class' => 'form-control')) }}
		</div>

		{{ Form::submit('Edit', array('class' => 'btn btn-primary')) }}

	{{ Form::close() }}
@stop
