@extends('default')

@section('title')
Voyage-YARAN
@endsection

@section('topbar')
<a href="/voyages" class="breadcrumb--active">Voyage</a>
@endsection
@section('content')

	<div class="d-flex justify-content-end mb-3"><a href="{{ route('voyages.create') }}" class="btn btn-info">Create</a></div>

	<table class="table table-bordered">
		<thead>
			<tr>
				<th>id</th>
				<th>vessel_id</th>
				<th>voyage_no</th>
				<th>point_of_discharge_id</th>
				<th>point_of_loading_id</th>
				<th>import_sail_date_time</th>
				<th>import_arrival_date</th>
				<th>export_sailing_date</th>
				<th>export_dest_eta</th>
				<th>export_cut_of_date</th>
				<th>export_cut_of_time</th>
				<th>status</th>

				<th>Action</th>
			</tr>
		</thead>
		<tbody>
			@foreach($voyages as $voyage)

				<tr>
					<td>{{ $voyage->id }}</td>
					<td>{{ $voyage->vessel_id }}</td>
					<td>{{ $voyage->voyage_no }}</td>
					<td>{{ $voyage->point_of_discharge_id }}</td>
					<td>{{ $voyage->point_of_loading_id }}</td>
					<td>{{ $voyage->import_sail_date_time }}</td>
					<td>{{ $voyage->import_arrival_date }}</td>
					<td>{{ $voyage->export_sailing_date }}</td>
					<td>{{ $voyage->export_dest_eta }}</td>
					<td>{{ $voyage->export_cut_of_date }}</td>
					<td>{{ $voyage->export_cut_of_time }}</td>
					<td>{{ $voyage->status }}</td>

					<td>
						<div class="d-flex gap-2">
                            <a href="{{ route('voyages.show', [$voyage->id]) }}" class="btn btn-info">Show</a>
                            <a href="{{ route('voyages.edit', [$voyage->id]) }}" class="btn btn-primary">Edit</a>
                            {!! Form::open(['method' => 'DELETE','route' => ['voyages.destroy', $voyage->id]]) !!}
                                {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                            {!! Form::close() !!}
                        </div>
					</td>
				</tr>

			@endforeach
		</tbody>
	</table>

@stop
