@extends('layout.master')

@section('title')
Edit-Voyage-YARAN
@endsection

@section('topbar')
<a href="/voyages" class="breadcrumb-item">Voyage</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            {{ Form::model($voyage, ['route' => ['voyages.update', $voyage->id], 'method' => 'PUT']) }}
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Edit Voyage
                    </h2>
                    
                    <button type="submit" class="btn btn-primary submitBtn"
                        id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>

                <div id="input" class="p-5">
                    <div class=" col-md-12">
                        <div class="row mb-5">
                            <div class="col-md-3 mt-1">
                                <label for="regular-form-1" class="form-label">Voyage #</label>
                                <input id="regular-form-1" value="{{ $voyage->voyage_no }}" type="text"
                                    class="form-control " placeholder="Enter Voyage #" name="voyage_no">
                            </div>
                            <div class="col-md-3 mt-1">
                                <label for="regular-form-1" class="form-label">Vessel</label>
                                <select class="tom-select" name="vessel_id" id="vessel_id">
                                    <option value="">Please Select</option>
                                    @foreach ($vessels as $item)
                                        <option {{ $voyage->vessel_id == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-1">
                                <label for="regular-form-1" class="form-label">Point Of Discharge</label>
                                <select class="tom-select" name="point_of_discharge_id" id="point_of_discharge_id">
                                    <option value="">Please Select</option>
                                    @foreach ($un_locations as $item)
                                        <option {{ $voyage->point_of_discharge_id == $item->id ? 'selected' : '' }} value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-1">
                                <label for="regular-form-1" class="form-label">Point Of Loading</label>
                                <select class="tom-select" name="point_of_loading_id" id="point_of_loading_id">
                                    <option value="">Please Select</option>
                                    @foreach ($un_locations as $item)
                                        <option {{ $voyage->point_of_loading_id == $item->id ? 'selected' : '' }} value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Import Orgn Sail Date/Time</label>
                                <input id="regular-form-1"  value="{{ $voyage->import_sail_date_time }}" type="datetime-local" class="form-control "
                                    placeholder="Enter Import Orgn Sail Date/Time" name="import_sail_date_time">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label for="regular-form-1" class="form-label">Import Arrival Date</label>
                                <input id="regular-form-1" value="{{ $voyage->import_arrival_date }}" type="date" class="form-control "
                                    placeholder="Enter Import Arrival Date" name="import_arrival_date">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">Export Sailing Date</label>
                                <input id="regular-form-1" value="{{ $voyage->export_sailing_date }}" type="date" class="form-control "
                                    placeholder="Enter Export Sailing Date" name="export_sailing_date">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">Export Dest. ETA</label>
                                <input id="regular-form-1" value="{{ $voyage->export_dest_eta }}" type="date" class="form-control "
                                    placeholder="Enter Export Dest. ETA" name="export_dest_eta">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">Export Cut Of Date</label>
                                <input id="regular-form-1" value="{{ $voyage->export_cut_of_date }}" type="date" class="form-control "
                                    placeholder="Enter Export Cut Of Date" name="export_cut_of_date">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="regular-form-1" class="form-label">Export Cut Of Time</label>
                                <input id="regular-form-1" value="{{ $voyage->export_cut_of_time }}" type="time" class="form-control "
                                    placeholder="Enter Export Cut Of Time" name="export_cut_of_time">
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Type</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Status" id="type" name="type"
                                        class="tom-select w-full">
                                        <option {{ $voyage->type == 'import' ? 'selected' : '' }} value="import">Import</option>
                                        <option {{ $voyage->type == 'export' ? 'selected' : '' }} value="export">Export</option>
                                        <option {{ $voyage->type == 'both' ? 'selected' : '' }} value="both">Both</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 mt-2">
                                <label>Status</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Status" id="status" name="status"
                                        class="tom-select w-full">
                                        <option {{ $voyage->status == '1' ? 'selected' : '' }} value="1">Active
                                        </option>
                                        <option {{ $voyage->status == '0' ? 'selected' : '' }} value="0">In
                                            Active</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
