@extends('layout.master')

@section('title')
Voyage-YARAN
@endsection

@section('topbar')
<a href="/voyages" class="breadcrumb--active">Voyage</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Voyages
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('voyages.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $voyages->firstItem() }} to
                {{ $voyages->lastItem() }} of {{ $voyages->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Voyage #</th>
                        <th>Vessel</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($voyages as $voyage)
                        <tr>
                            <td>{{ $voyage->id }}</td>
                            <td>{{ $voyage->voyage_no }}</td>
                            <td>{{ @$voyage->vessel->name }}</td>
                            <td class="text-capitalize">{{ $voyage->type }}</td>
                            <td>{{ $voyage->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('voyages.edit', [$voyage->id]) }}" class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['voyages.destroy', $voyage->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
         
    </div>
@endsection
