@extends('layout.master')

@section('title')
Wharf-YARAN
@endsection

@section('topbar')
<a href="/wharves" class="breadcrumb--active">Wharf</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Wharf
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('wharves.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $wharves->firstItem() }} to
                {{ $wharves->lastItem() }} of {{ $wharves->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Code</th>
                        <th>Short Name</th>
                        <th>Wharf</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($wharves as $wharf)
                        <tr>
                            <td>{{ $wharf->id }}</td>
                            <td>{{ $wharf->code }}</td>
                            <td>{{ $wharf->short_name }}</td>
                            <td>{{ $wharf->wharf }}</td>
                            <td>{{ $wharf->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('wharves.edit', [$wharf->id]) }}" class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['wharves.destroy', $wharf->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
