<?php

use App\Http\Controllers\Accounts\ChartOfAccountController;
use App\Http\Controllers\Accounts\ChequeBookController;
use App\Http\Controllers\ApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/getAll/party', [ApiController::class, 'getParty']);
Route::get('/get-party-details/{id}', [ApiController::class, 'getPartyDetails']);
Route::get('/get-voyage-details/{id}', [ApiController::class, 'getVoyageDetails']);
Route::get('/get-voyages-details/{id}', [ApiController::class, 'getVoyagesDetails']);
Route::get('/get-consignee-details/{id}', [ApiController::class, 'getConsigneeDetails']);
Route::get('/get-cities/{id}', [ApiController::class, 'getCityByCountryId']);
Route::get('/get-transaction-master/{id}', [ApiController::class, 'getTransactionMaster']);
Route::get('/getAll/commodity', [ApiController::class, 'getCommodity']);
Route::post('/se_job/add/party', [ApiController::class, 'party_store']);
Route::post('/se_job/add/commodity', [ApiController::class, 'commodity_store']);
Route::post('/se_job/add/un_location', [ApiController::class, 'un_location_store']);
Route::post('/se_job/add/employee', [ApiController::class, 'employee_store']);
Route::post('/se_job/add/vessel', [ApiController::class, 'vessel_store']);
Route::post('/se_job/add/voyage', [ApiController::class, 'voyage_store']);
Route::post('/se_job/add/charge', [ApiController::class, 'charge_store']);
Route::get('/get_voucher_types/{payment_type}', [ApiController::class, 'getVoucherTypes']);
Route::post('/get_accounts', [ApiController::class, 'getAccounts']);
Route::get('/get_cheques', [ApiController::class, 'getCheques']);
Route::get('/get_accounts_for_receipt', [ApiController::class, 'getAccountsforReceipt']);
Route::get('/get_accounts_for_receipt_account_type', [ApiController::class, 'getAccountsforReceiptAccountType']);
Route::get('/get_invoices_for_client', [ApiController::class, 'getInvoicesForClient']);

Route::get('get-conversion-rate/{id}', [ApiController::class, 'getConversionRate']);
Route::post('accounts/cheque_book/clone', [ApiController::class, 'cloneCheque']);

Route::get('get-accounts-by-level/{level}', [ApiController::class, 'getAccountsByLevel']);

Route::get('/generate-account-code', [ApiController::class, 'generateAccountCode']);

Route::get('/get-chart-of-accounts', [ApiController::class, 'getChartOfAccounts']);
Route::get('/get-chart-of-accounts-excel', [ApiController::class, 'getChartOfAccountsExcel']);

Route::post('accounts/cheque_book/cancel', [ApiController::class, 'cancelCheque']);
Route::delete('accounts/cheque_book/delete', [ApiController::class, 'deleteCheque']);
