<?php

use App\Http\Controllers\Accounts\AccountMovementController;
use App\Http\Controllers\Accounts\AccountsReportController;
use App\Http\Controllers\Accounts\BillsController;
use App\Http\Controllers\Accounts\ChartOfAccountController;
use App\Http\Controllers\Accounts\ChequeBookController;
use App\Http\Controllers\Accounts\CostCenterController;
use App\Http\Controllers\Accounts\DepartmentController;
use App\Http\Controllers\Accounts\GeneralVoucherController;
use App\Http\Controllers\Accounts\InvoiceController;
use App\Http\Controllers\Accounts\LocationController;
use App\Http\Controllers\Accounts\OpeningBalancesController;
use App\Http\Controllers\Accounts\PaymentController;
use App\Http\Controllers\Accounts\ReceiptController;
use App\Http\Controllers\Accounts\VoucherController;
use App\Http\Controllers\AgentPaymentRequisitionController;
use App\Http\Controllers\AirportsController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BankDetailRegistersController;
use App\Http\Controllers\ChargesCategoriesController;
use App\Http\Controllers\ChargesController;
use App\Http\Controllers\CitiesController;
use App\Http\Controllers\CommoditiesController;
use App\Http\Controllers\Commodity_groupsController;
use App\Http\Controllers\CommoditymappingsController;
use App\Http\Controllers\CostCenterGroupsController;
use App\Http\Controllers\CountriesController;
use App\Http\Controllers\CroController;
use App\Http\Controllers\CustomerGroupsController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DrawnBanksController;
use App\Http\Controllers\EmployeeMappingsController;
use App\Http\Controllers\EmployeesController;
use App\Http\Controllers\EquipmentsizetypesController;
use App\Http\Controllers\ExportBookingRequestController;
use App\Http\Controllers\FixedSalesTaxController;
use App\Http\Controllers\HsCodesController;
use App\Http\Controllers\IncoTermsController;
use App\Http\Controllers\JobController;
use App\Http\Controllers\LocalizationSetupsController;
use App\Http\Controllers\Location_typesController;
use App\Http\Controllers\NearByPortsController;
use App\Http\Controllers\OverseasAgentNetworksController;
use App\Http\Controllers\Packages_codingsController;
use App\Http\Controllers\Party_s_c_a_c__i_a_t_a__codesController;
use App\Http\Controllers\Party_SCAC_IATA_CodesController;
use App\Http\Controllers\PartyController;
use App\Http\Controllers\PartyLocationsController;
use App\Http\Controllers\PartyMappingsController;
use App\Http\Controllers\PartyTypesController;
use App\Http\Controllers\RateGroupsController;
use App\Http\Controllers\ReportFixedTextsController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SalesrepstatusesController;
use App\Http\Controllers\SEAgentInvoiceController;
use App\Http\Controllers\SEAgentReceiptController;
use App\Http\Controllers\SEBillController;
use App\Http\Controllers\SEBlController;
use App\Http\Controllers\SEConsoleReleaseInstructionController;
use App\Http\Controllers\SEInvoiceController;
use App\Http\Controllers\SEJobController;
use App\Http\Controllers\SELetterListController;
use App\Http\Controllers\SELetterProcessController;
use App\Http\Controllers\SELettersController;
use App\Http\Controllers\SELetterTemplateController;
use App\Http\Controllers\SELoadingUpdationController;
use App\Http\Controllers\SEManifestController;
use App\Http\Controllers\TeamsController;
use App\Http\Controllers\SEMilestoneController;
use App\Http\Controllers\SENocController;
use App\Http\Controllers\SEPaymentController;
use App\Http\Controllers\SEPaymentRequisitionController;
use App\Http\Controllers\SEQueryController;
use App\Http\Controllers\SEQueryCustomerServiceController;
use App\Http\Controllers\SEQuotationController;
use App\Http\Controllers\SEReceiptController;
use App\Http\Controllers\SESwitchBlController;
use App\Http\Controllers\ShippingInstructionController;
use App\Http\Controllers\StuffingPlanController;
use App\Http\Controllers\Un_locationsController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VendorGroupsController;
use App\Http\Controllers\VesselMappingsController;
use App\Http\Controllers\VesselsController;
use App\Http\Controllers\VoyagesController;
use App\Http\Controllers\WharvesController;
use App\Http\Controllers\ReportsController;
use App\Models\OverseasAgentNetwork;
use App\Models\VesselMapping;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ImportController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::get('/', [AuthController::class, 'login'])->name('login');

Route::get('/register', function () {
    return view('auth.register');
});
Route::get('/reset', function () {
    return view('auth.reset');
});
Route::get('/forgot', function () {
    return view('auth.forgot');
});

//register
// Route::post('/create', [AuthController::class, 'create'])->name('create');
Route::post('/check', [AuthController::class, 'check'])->name('check');
// Route::get('/verify', [AuthController::class, 'verify'])->name('verify');

//forgot password
Route::get('/password/forgot', [AuthController::class, 'showForgotForm'])->name('forgot.password.form');
Route::post('/password/forgot', [AuthController::class, 'sendResetLink'])->name('forgot.password.link');
Route::get('/password/reset/{token}', [AuthController::class, 'showResetForm'])->name('reset.password.form');
Route::post('/password/reset', [AuthController::class, 'resetPassword'])->name('reset.password');

//logout
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

//dashboard
Route::get('/dashboard', [DashboardController::class, 'index']);

//user
Route::get('/user', [UserController::class, 'index']);
Route::get('/user/add', [UserController::class, 'add']);
Route::post('/user/add', [UserController::class, 'store']);
Route::get('/user/edit/{user}', [UserController::class, 'edit']);
Route::post('/user/edit/{user}', [UserController::class, 'update']);
Route::post('/user/delete/{id}', [UserController::class, 'delete']);


//role id
Route::get('/role', [RoleController::class, 'index']);
Route::get('/role/add', [RoleController::class, 'add']);
Route::post('/role/add', [RoleController::class, 'store']);
Route::get('/role/edit/{role}', [RoleController::class, 'edit']);
Route::post('/role/edit/{role}', [RoleController::class, 'update']);
Route::post('/role/delete/{id}', [RoleController::class, 'delete']);

//Master
Route::resource('customergroups', CustomerGroupsController::class);
Route::resource('vendorgroups', VendorGroupsController::class);
Route::resource('overseasagentnetworks', OverseasAgentNetworksController::class);
Route::resource('chargescategories', ChargesCategoriesController::class);
Route::resource('airports', AirportsController::class);
Route::resource('cities', CitiesController::class);
Route::resource('countries', CountriesController::class);
Route::resource('commodity_groups', Commodity_groupsController::class);
Route::resource('party_s_c_a_c__i_a_t_a__codes', Party_s_c_a_c__i_a_t_a__codesController::class);
Route::resource('costcentergroups', CostCenterGroupsController::class);
Route::resource('vesselmappings', VesselMappingsController::class);
Route::resource('partymappings', PartyMappingsController::class);
Route::resource('localizationsetups', LocalizationSetupsController::class);
Route::resource('incoterms', IncoTermsController::class);
Route::resource('hscodes', HsCodesController::class);
Route::resource('rategroups', RateGroupsController::class);
Route::resource('bankdetailregisters', BankDetailRegistersController::class);
Route::resource('drawnbanks', DrawnBanksController::class);
Route::resource('vessels', VesselsController::class);
Route::resource('charges', ChargesController::class);
Route::resource('employeemappings', EmployeeMappingsController::class);
Route::resource('commoditymappings', CommoditymappingsController::class);
Route::resource('packages_codings', Packages_codingsController::class);
Route::resource('wharves', WharvesController::class);
Route::resource('salesrepstatuses', SalesrepstatusesController::class);
Route::resource('reportfixedtexts', ReportFixedTextsController::class);
Route::resource('teams', TeamsController::class);
Route::resource('nearbyports', NearByPortsController::class);
Route::resource('equipmentsizetypes', EquipmentsizetypesController::class);
Route::resource('employees', EmployeesController::class);
Route::resource('partytypes', PartyTypesController::class);
Route::resource('commodities', CommoditiesController::class);
Route::resource('un_locations', Un_locationsController::class);
Route::resource('voyages', VoyagesController::class);
Route::resource('location_types', Location_typesController::class);

//party
Route::get('/party', [PartyController::class, 'index']);
Route::get('/party/add', [PartyController::class, 'add']);
Route::post('/party/add', [PartyController::class, 'store']);
Route::get('/party/edit/{party}', [PartyController::class, 'edit']);
Route::post('/party/edit/{party}', [PartyController::class, 'update']);
Route::post('/party/delete/{id}', [PartyController::class, 'delete']);

//partylocations
Route::get('/party_location', [PartyLocationsController::class, 'index']);
Route::get('/party_location/add', [PartyLocationsController::class, 'add']);
Route::post('/party_location/add', [PartyLocationsController::class, 'store']);
Route::get('/party_location/edit/{party_location}', [PartyLocationsController::class, 'edit']);
Route::post('/party_location/edit/{party_location}', [PartyLocationsController::class, 'update']);
Route::post('/party_location/delete/{id}', [PartyLocationsController::class, 'delete']);

// SE Manifest
Route::get('/se_manifests', [SEManifestController::class, 'index']);
Route::get('/se_manifest/add', [SEManifestController::class, 'add']);

//CRO
Route::get('/cro', [CroController::class, 'index']);
Route::get('/cro/add', [CroController::class, 'add']);
Route::get('/cro/add/{job_master}', [CroController::class, 'add']);
Route::post('/cro/add/{job_master}', [CroController::class, 'store']);
Route::get('/cro/edit/{cro_master}', [CroController::class, 'edit']);
Route::post('/cro/edit/{cro_master}', [CroController::class, 'update']);

//SE Job
Route::get('/job', [JobController::class, 'index']);
Route::get('/se_job', [SEJobController::class, 'index']);
Route::get('/se_job/add', [SEJobController::class, 'add']);
Route::post('/se_job/add', [SEJobController::class, 'store']);
Route::get('/se_job/edit/{job_master}', [SEJobController::class, 'edit']);
Route::post('/se_job/edit/{job_master}', [SEJobController::class, 'update']);
Route::post('/se_job/updateStatus/{job_master}', [SEJobController::class, 'updateStatus']);
Route::post('/se_job/unapproveJob/{job_master}', [SEJobController::class, 'unapproveJob']);
Route::post('/se_job/updateStatusCharges/{job_master}', [SEJobController::class, 'updateStatusCharges']);
Route::post('/se_job/unapproveCharges/{job_master}', [SEJobController::class, 'unapproveCharges']);
Route::post('/se_job/deletePayable/{id}', [SEJobController::class, 'deletePayable']);
Route::post('/se_job/deleteReceivable/{id}', [SEJobController::class, 'deleteReceivable']);
// Route::get('/se_job/pdf', [SEJobController::class, 'jobpdf']);
// Route::get('/se_job/print', [SEJobController::class, 'print']);
Route::get('/job_print/{job_master}', [SEJobController::class, 'print']);


//SE B/L
Route::get('/se_bl', [SEBlController::class, 'index']);
Route::get('/se_bl/add/', [SEBlController::class, 'add']);
Route::get('/se_bl/add/{job_master}', [SEBlController::class, 'add']);
Route::post('/se_bl/add/{job_master}', [SEBlController::class, 'store']);
Route::get('/se_bl/edit/{bl_master}', [SEBlController::class, 'edit']);
Route::post('/se_bl/edit/{bl_master}', [SEBlController::class, 'update']);
Route::get('/bl_print/{bl_master}', [SEBlController::class, 'print']);


//SE Switch B/L
Route::get('/se_switch_bl', [SESwitchBlController::class, 'index']);
Route::get('/se_switch_bl/add', [SESwitchBlController::class, 'add']);

//Stuffing Plan
Route::get('/stuffing_plan', [StuffingPlanController::class, 'index']);
Route::get('/stuffing_plan/add', [StuffingPlanController::class, 'add']);

//SE Milestone
Route::get('/se_milestone', [SEMilestoneController::class, 'index']);
Route::get('/se_milestone/add', [SEMilestoneController::class, 'add']);

//SE Invoice
Route::get('/se_invoice', [SEInvoiceController::class, 'index']);
Route::get('/se_invoice/add', [SEInvoiceController::class, 'add']);
Route::post('/se_invoice/add', [SEInvoiceController::class, 'store']);
Route::get('/se_invoice/edit/{invoice}', [SEInvoiceController::class, 'edit']);
Route::post('/se_invoice/edit/{invoice}', [SEInvoiceController::class, 'update']);
Route::get('/se_invoice/add/{job_master}', [SEInvoiceController::class, 'addFromJob']);
Route::get('/se_invoice/manual/add/{job_master}', [SEInvoiceController::class, 'manualInvoice']);
Route::post('/se_invoice/auto/add/{job_master}', [SEInvoiceController::class, 'autoInvoice']);
Route::post('/se_invoice/add/{job_master}', [SEInvoiceController::class, 'storeFromJob']);
Route::get('/se_invoice/edit/{job_master}', [SEInvoiceController::class, 'editFromJob']);
Route::post('/se_invoice/edit/{job_master}', [SEInvoiceController::class, 'updateFromJob']);
Route::get('/se_invoice_print/{invoice}', [SEInvoiceController::class, 'print']);
Route::get('/get-invoices/{client_id}', [SEInvoiceController::class, 'getInvoicesByClient']);



//SE Receipt
Route::get('/se_receipt', [SEReceiptController::class, 'index']);
Route::get('/se_receipt/add', [SEReceiptController::class, 'add']);
Route::post('/se_receipt/add', [SEReceiptController::class, 'store']);
Route::get('/se_receipt/edit/{receipt_payment}', [SEReceiptController::class, 'edit']);
Route::post('/se_receipt/edit/{receipt_payment}', [SEReceiptController::class, 'update']);
Route::post('/se_receipt/delete/{id}', [SEReceiptController::class, 'destroy']);
Route::get('/se_receiptstatus/{transaction_master}/{status}', [SEReceiptController::class, 'updateStatus']);
Route::get('/receipt_print/{receipt_payment}', [SEReceiptController::class, 'print']);

// Receipt
Route::get('/receipt', [SEReceiptController::class, 'index']);
Route::get('/receipt/add', [SEReceiptController::class, 'add']);
Route::post('/receipt/add', [SEReceiptController::class, 'store']);
Route::get('/receipt/edit/{receipt_payment}', [SEReceiptController::class, 'edit']);
Route::post('/receipt/edit/{receipt_payment}', [SEReceiptController::class, 'update']);
Route::get('/receiptstatus/{transaction_master}/{status}', [SEReceiptController::class, 'updateStatus']);

// Route::get('/receipt/status/{transaction_master}/{status}', [SEReceiptController::class, 'updateStatus']);



//SE Bill
Route::get('/se_bill', [SEBillController::class, 'index']);
// Route::get('/se_bill/add', [SEBillController::class, 'add']);
Route::get('/se_bill/add/{job_master}', [SEBillController::class, 'add']);
Route::post('/se_bill/auto/add/{job_master}', [SEBillController::class, 'autoBill']);
Route::get('/se_bill/manual/add/{job_master}', [SEBillController::class, 'manualBill']);
Route::post('/se_bill/add/{job_master}', [SEBillController::class, 'store']);
Route::get('/se_bill/edit/{job_master}', [SEBillController::class, 'edit']);
Route::post('/se_bill/edit/{job_master}', [SEBillController::class, 'update']);
Route::get('/bill_print/{bill}', [SEBillController::class, 'print']);
Route::get('/get-bills/{vendor_id}', [SEBillController::class, 'getBillsByVendor']);



//SE Payment
Route::get('/se_payment', [SEPaymentController::class, 'index']);
Route::get('/se_payment/add', [SEPaymentController::class, 'add']);

//SE Agent Invoice
Route::get('/se_agent_invoice', [SEAgentInvoiceController::class, 'index']);
Route::get('/se_agent_invoice/add', [SEAgentInvoiceController::class, 'add']);
Route::post('/se_agent_invoice/add', [SEAgentInvoiceController::class, 'store']);
Route::get('/se_agent_invoice/edit/{invoice}', [SEAgentInvoiceController::class, 'edit']);
Route::post('/se_agent_invoice/edit/{invoice}', [SEAgentInvoiceController::class, 'update']);
Route::get('/se_agent_invoice/add/{job_master}', [SEAgentInvoiceController::class, 'addFromJob']);
Route::post('/se_agent_invoice/add/{job_master}', [SEAgentInvoiceController::class, 'storeFromJob']);
Route::get('/se_agent_invoice/edit/fromjob/{job_master}', [SEAgentInvoiceController::class, 'editFromJob']);
Route::post('/se_agent_invoice/edit/fromjob/{job_master}', [SEAgentInvoiceController::class, 'updateFromJob']);
Route::get('/se_agent_invoice/manual/add/{job_master}', [SEAgentInvoiceController::class, 'manualInvoice']);
Route::post('/se_agent_invoice/auto/add/{job_master}', [SEAgentInvoiceController::class, 'autoInvoice']);
Route::get('/agent_invoice_print/{invoice}', [SEAgentInvoiceController::class, 'print']);
Route::post('/se_agent_invoice/check_cc/{job_master}', [SEAgentInvoiceController::class, 'checkCC']);


//SE Agent Receipt/Payment
Route::get('/se_agent_receipt', [SEAgentReceiptController::class, 'index']);
Route::get('/se_agent_receipt/add', [SEAgentReceiptController::class, 'add']);

//SE Query
Route::get('/se_query', [SEQueryController::class, 'index']);
Route::get('/se_query/add', [SEQueryController::class, 'add']);

//SE Letter Template
Route::get('/se_letter_template', [SELetterTemplateController::class, 'index']);
Route::get('/se_letter_template/add', [SELetterTemplateController::class, 'add']);

//SE Letter Process
Route::get('/se_letter_process', [SELetterProcessController::class, 'index']);
Route::get('/se_letter_process/add', [SELetterProcessController::class, 'add']);

//SE Letters
Route::get('/se_letters', [SELettersController::class, 'index']);
Route::get('/se_letters/add', [SELettersController::class, 'add']);

//SE Letter List
Route::get('/se_letter_list', [SELetterListController::class, 'index']);
Route::get('/se_letter_list/add', [SELetterListController::class, 'add']);

//SE Quotation
Route::get('/se_quotation', [SEQuotationController::class, 'index']);
Route::get('/se_quotation/add', [SEQuotationController::class, 'add']);

//SE Query(Customer Service)
Route::get('/se_query_customer_service', [SEQueryCustomerServiceController::class, 'index']);
Route::get('/se_query_customer_service/add', [SEQueryCustomerServiceController::class, 'add']);

//Shipping Instruction
Route::get('/shipping_instruction', [ShippingInstructionController::class, 'index']);
Route::get('/shipping_instruction/add', [ShippingInstructionController::class, 'add']);

//Export Booking Request
Route::get('/export_booking_request', [ExportBookingRequestController::class, 'index']);
Route::get('/export_booking_request/add', [ExportBookingRequestController::class, 'add']);

//SE Payment Requisition
Route::get('/se_payment_requisition', [SEPaymentRequisitionController::class, 'index']);
Route::get('/se_payment_requisition/add', [SEPaymentRequisitionController::class, 'add']);

//Agent Payment Requisition
Route::get('/agent_payment_requisition', [AgentPaymentRequisitionController::class, 'index']);
Route::get('/agent_payment_requisition/add', [AgentPaymentRequisitionController::class, 'add']);

//SE Console Release Instruction
Route::get('/se_console_release_instruction', [SEConsoleReleaseInstructionController::class, 'index']);
Route::get('/se_console_release_instruction/add', [SEConsoleReleaseInstructionController::class, 'add']);

//SE NOC
Route::get('/se_noc', [SENocController::class, 'index']);
Route::get('/se_noc/add', [SENocController::class, 'add']);

//Fixed SalesTax
Route::get('/fixed_salestax', [FixedSalesTaxController::class, 'index']);
Route::get('/fixed_salestax/add', [FixedSalesTaxController::class, 'add']);

//Se Loading Updation
Route::get('/se_loading_updation', [SELoadingUpdationController::class, 'index']);
Route::get('/se_loading_updation/add', [SELoadingUpdationController::class, 'add']);


// SI Manifest
Route::get('/si_manifests', [SEManifestController::class, 'index']);
Route::get('/si_manifest/add', [SEManifestController::class, 'add']);


//SI Job
Route::get('/si_job', [SEJobController::class, 'index']);
Route::get('/si_job/add', [SEJobController::class, 'add']);
Route::get('/si_job/edit/{job_master}', [SEJobController::class, 'edit']);

//SI B/L
Route::get('/si_bl', [SEBlController::class, 'index']);
Route::get('/si_bl/add', [SEBlController::class, 'add']);
Route::get('/si_bl/edit/{bl_master}', [SEBlController::class, 'edit']);
Route::get('/si_bl/add/{job_master}', [SEBlController::class, 'add']);


//SI Switch B/L
Route::get('/si_switch_bl', [SESwitchBlController::class, 'index']);
Route::get('/si_switch_bl/add', [SESwitchBlController::class, 'add']);

//SI Milestone
Route::get('/si_milestone', [SEMilestoneController::class, 'index']);
Route::get('/si_milestone/add', [SEMilestoneController::class, 'add']);


//SI Invoice
Route::get('/si_invoice', [SEInvoiceController::class, 'index']);
Route::get('/si_invoice/add', [SEInvoiceController::class, 'add']);
Route::get('/si_invoice/edit/{invoice}', [SEInvoiceController::class, 'edit']);
Route::get('/si_invoice/manual/add/{job_master}', [SEInvoiceController::class, 'manualInvoice']);

//SI Agent Invoice
Route::get('/si_agent_invoice', [SEAgentInvoiceController::class, 'index']);
Route::get('/si_agent_invoice/add', [SEAgentInvoiceController::class, 'add']);
Route::get('/si_agent_invoice/edit/{invoice}', [SEAgentInvoiceController::class, 'edit']);
Route::get('/si_agent_invoice/add/{job_master}', [SEAgentInvoiceController::class, 'addFromJob']);
Route::get('/si_agent_invoice/edit/fromjob/{job_master}', [SEAgentInvoiceController::class, 'editFromJob']);
Route::get('/si_agent_invoice/manual/add/{job_master}', [SEAgentInvoiceController::class, 'manualInvoice']);

//SI Receipt
Route::get('/si_receipt', [SEReceiptController::class, 'index']);
Route::get('/si_receipt/add', [SEReceiptController::class, 'add']);
Route::get('/si_receipt/edit/{receipt_payment}', [SEReceiptController::class, 'edit']);


//SI Bill
Route::get('/si_bill', [SEBillController::class, 'index']);
Route::get('/si_bill/add', [SEBillController::class, 'add']);
Route::get('/si_bill/edit/{job_master}', [SEBillController::class, 'edit']);


// AE Job
Route::get('/ae_job', [SEJobController::class, 'index']);
Route::get('/ae_job/add', [SEJobController::class, 'add']);
Route::get('/ae_job/edit/{job_master}', [SEJobController::class, 'edit']);

// AE B/L
Route::get('/ae_bl', [SEBlController::class, 'index']);
Route::get('/ae_bl/add', [SEBlController::class, 'add']);
Route::get('/ae_bl/edit/{bl_master}', [SEBlController::class, 'edit']);
Route::get('/ae_bl/add/{job_master}', [SEBlController::class, 'add']);

//AE Milestone
Route::get('/ae_milestone', [SEMilestoneController::class, 'index']);
Route::get('/ae_milestone/add', [SEMilestoneController::class, 'add']);

//AE Invoice
Route::get('/ae_invoice', [SEInvoiceController::class, 'index']);
Route::get('/ae_invoice/add', [SEInvoiceController::class, 'add']);
Route::get('/ae_invoice/edit/{invoice}', [SEInvoiceController::class, 'edit']);
Route::get('/ae_invoice/manual/add/{job_master}', [SEInvoiceController::class, 'manualInvoice']);

//AE Agent Invoice
Route::get('/ae_agent_invoice', [SEAgentInvoiceController::class, 'index']);
Route::get('/ae_agent_invoice/add', [SEAgentInvoiceController::class, 'add']);
Route::get('/ae_agent_invoice/edit/{invoice}', [SEAgentInvoiceController::class, 'edit']);
Route::get('/ae_agent_invoice/add/{job_master}', [SEAgentInvoiceController::class, 'addFromJob']);
Route::get('/ae_agent_invoice/edit/fromjob/{job_master}', [SEAgentInvoiceController::class, 'editFromJob']);
Route::get('/ae_agent_invoice/manual/add/{job_master}', [SEAgentInvoiceController::class, 'manualInvoice']);

//AE Receipt
Route::get('/ae_receipt', [SEReceiptController::class, 'index']);
Route::get('/ae_receipt/add', [SEReceiptController::class, 'add']);
Route::get('/ae_receipt/edit/{receipt_payment}', [SEReceiptController::class, 'edit']);

//AE Bill
Route::get('/ae_bill', [SEBillController::class, 'index']);
Route::get('/ae_bill/add', [SEBillController::class, 'add']);
Route::get('/ae_bill/edit/{job_master}', [SEBillController::class, 'edit']);


// AI Manifest
Route::get('/ai_manifests', [SEManifestController::class, 'index']);
Route::get('/ai_manifest/add', [SEManifestController::class, 'add']);

//AI Job
Route::get('/ai_job', [SEJobController::class, 'index']);
Route::get('/ai_job/add', [SEJobController::class, 'add']);
Route::get('/ai_job/edit/{job_master}', [SEJobController::class, 'edit']);

// AI B/L
Route::get('/ai_bl', [SEBlController::class, 'index']);
Route::get('/ai_bl/add', [SEBlController::class, 'add']);
Route::get('/ai_bl/edit/{bl_master}', [SEBlController::class, 'edit']);
Route::get('/ai_bl/add/{job_master}', [SEBlController::class, 'add']);


//AI Switch B/L
Route::get('/ai_switch_bl', [SESwitchBlController::class, 'index']);
Route::get('/ai_switch_bl/add', [SESwitchBlController::class, 'add']);

//AI Milestone
Route::get('/ai_milestone', [SEMilestoneController::class, 'index']);
Route::get('/ai_milestone/add', [SEMilestoneController::class, 'add']);

//AI Invoice
Route::get('/ai_invoice', [SEInvoiceController::class, 'index']);
Route::get('/ai_invoice/add', [SEInvoiceController::class, 'add']);
Route::get('/ai_invoice/edit/{invoice}', [SEInvoiceController::class, 'edit']);
Route::get('/ai_invoice/manual/add/{job_master}', [SEInvoiceController::class, 'manualInvoice']);

//AI Agent Invoice
Route::get('/ai_agent_invoice', [SEAgentInvoiceController::class, 'index']);
Route::get('/ai_agent_invoice/add', [SEAgentInvoiceController::class, 'add']);
Route::get('/ai_agent_invoice/edit/{invoice}', [SEAgentInvoiceController::class, 'edit']);
Route::get('/ai_agent_invoice/add/{job_master}', [SEAgentInvoiceController::class, 'addFromJob']);
Route::get('/ai_agent_invoice/edit/fromjob/{job_master}', [SEAgentInvoiceController::class, 'editFromJob']);
Route::get('/ai_agent_invoice/manual/add/{job_master}', [SEAgentInvoiceController::class, 'manualInvoice']);

//AI Receipt
Route::get('/ai_receipt', [SEReceiptController::class, 'index']);
Route::get('/ai_receipt/add', [SEReceiptController::class, 'add']);
Route::get('/ai_receipt/edit/{receipt_payment}', [SEReceiptController::class, 'edit']);

//AI Bill
Route::get('/ai_bill', [SEBillController::class, 'index']);
Route::get('/ai_bill/add', [SEBillController::class, 'add']);
Route::get('/ai_bill/edit/{job_master}', [SEBillController::class, 'edit']);



// Accounts

// Chart of Account
Route::get('/accounts/chart_of_account', [ChartOfAccountController::class, 'index']);
Route::get('/accounts/chart_of_account/add', [ChartOfAccountController::class, 'add']);
Route::post('/accounts/chart_of_account/add/', [ChartOfAccountController::class, 'store'])->name('chart-of-account.store');
Route::get('/accounts/chart_of_account/edit/{account}', [ChartOfAccountController::class, 'edit']);
Route::post('/accounts/chart_of_account/edit/{account}', [ChartOfAccountController::class, 'update']);
Route::post('/accounts/chart_of_account/delete/{account}', [ChartOfAccountController::class, 'delete']);

// Cost Center
Route::get('/accounts/cost_center', [CostCenterController::class, 'index']);
Route::get('/accounts/cost_center/add', [CostCenterController::class, 'add']);
Route::post('/accounts/cost_center/add/', [CostCenterController::class, 'store']);
Route::get('/accounts/cost_center/edit/{cost_center}', [CostCenterController::class, 'edit']);
Route::post('/accounts/cost_center/edit/{cost_center}', [CostCenterController::class, 'update']);

// Department Master
Route::get('/accounts/department_master', [DepartmentController::class, 'index']);
Route::get('/accounts/department_master/add', [DepartmentController::class, 'add']);
Route::post('/accounts/department_master/add/', [DepartmentController::class, 'store']);
Route::get('/accounts/department_master/edit/{department_master}', [DepartmentController::class, 'edit']);
Route::post('/accounts/department_master/edit/{department_master}', [DepartmentController::class, 'update']);

// Location
Route::get('/accounts/location_master', [LocationController::class, 'index']);
Route::get('/accounts/location_master/add', [LocationController::class, 'add']);
Route::post('/accounts/location_master/add/', [LocationController::class, 'store']);
Route::get('/accounts/location_master/edit/{location_master}', [LocationController::class, 'edit']);
Route::post('/accounts/location_master/edit/{location_master}', [LocationController::class, 'update']);

// Voucher
Route::get('/accounts/voucher', [VoucherController::class, 'index']);
Route::get('/accounts/voucher/add', [VoucherController::class, 'add']);
Route::post('/accounts/voucher/add/', [VoucherController::class, 'store']);
Route::get('/accounts/voucher/edit/{transaction_master}', [VoucherController::class, 'edit']);
Route::post('/accounts/voucher/edit/{transaction_master}', [VoucherController::class, 'update']);

// Bills
Route::get('/accounts/bills', [BillsController::class, 'index']);
Route::get('/accounts/bills/add', [BillsController::class, 'add']);
Route::post('/accounts/bills/add/', [BillsController::class, 'store']);
Route::get('/accounts/bills/edit/{transaction_master}', [BillsController::class, 'edit']);
Route::post('/accounts/bills/edit/{transaction_master}', [BillsController::class, 'update']);

// Invoice
Route::get('/accounts/invoice', [InvoiceController::class, 'index']);
Route::get('/accounts/invoice/add', [InvoiceController::class, 'add']);
Route::post('/accounts/invoice/add/', [InvoiceController::class, 'store']);
Route::get('/accounts/invoice/edit/{transaction_master}', [InvoiceController::class, 'edit']);
Route::post('/accounts/invoice/edit/{transaction_master}', [InvoiceController::class, 'update']);

// Receipt
Route::get('/accounts/receipt', [ReceiptController::class, 'index']);
Route::get('/accounts/receipt/add', [ReceiptController::class, 'add']);
Route::post('/accounts/receipt/add/', [ReceiptController::class, 'store']);
Route::get('/accounts/receipt/edit/{transaction_master}', [ReceiptController::class, 'edit']);
Route::post('/accounts/receipt/edit/{transaction_master}', [ReceiptController::class, 'update']);

// Payment
Route::get('/accounts/payment', [PaymentController::class, 'index']);
Route::get('/accounts/payment/add', [PaymentController::class, 'add']);
Route::post('/accounts/payment/add/', [PaymentController::class, 'store']);
Route::get('/accounts/payment/edit/{transaction_master}', [PaymentController::class, 'edit']);
Route::post('/accounts/payment/edit/{transaction_master}', [PaymentController::class, 'update']);

Route::get('/accounts/general-voucher', [GeneralVoucherController::class, 'index']);
Route::get('/accounts/general-voucher/add', [GeneralVoucherController::class, 'add']);
Route::post('/accounts/general-voucher/add/', [GeneralVoucherController::class, 'store']);
Route::get('/accounts/general-voucher/edit/{transaction_master}', [GeneralVoucherController::class, 'edit']);
Route::post('/accounts/general-voucher/edit/{transaction_master}', [GeneralVoucherController::class, 'update']);
Route::post('/accounts/general-voucher/delete/{id}', [GeneralVoucherController::class, 'destroy']);
Route::get('/accounts/general-voucher/status/{transaction_master}/{status}', [GeneralVoucherController::class, 'updateStatus']);
Route::get('/accounts/general-voucher/print/{transaction_master}', [GeneralVoucherController::class, 'print']);

// Cheque Book
Route::get('/accounts/cheque_book', [ChequeBookController::class, 'index']);
Route::get('/accounts/cheque_book/add', [ChequeBookController::class, 'add']);
Route::post('/accounts/cheque_book/add/', [ChequeBookController::class, 'store']);
Route::get('/accounts/cheque_book/edit/{cheque_book_master}', [ChequeBookController::class, 'edit']);
Route::post('/accounts/cheque_book/edit/{cheque_book_master}', [ChequeBookController::class, 'update']);

// Opening Balances
Route::get('/accounts/opening_balance', [OpeningBalancesController::class, 'index']);
Route::get('/accounts/opening_balance/totals', [OpeningBalancesController::class, 'totals']);        // NEW
Route::get('/accounts/opening_balance/data', [OpeningBalancesController::class, 'data']);        // NEW
Route::post('/accounts/opening_balance/save-row', [OpeningBalancesController::class, 'saveRow']); // NEW

Route::get('/accounts/opening_balance/add', [OpeningBalancesController::class, 'add']);
Route::post('/accounts/opening_balance/add/', [OpeningBalancesController::class, 'store']);
Route::get('/accounts/opening_balance/edit/{account}', [OpeningBalancesController::class, 'edit']);
Route::post('/accounts/opening_balance/edit/{account}', [OpeningBalancesController::class, 'update']);


// Accounts Report [Account Ledger]
Route::get('/accounts/account-ledger', [AccountsReportController::class, 'indexAccountsLedger']);
Route::post('/accounts/account-ledger', [AccountsReportController::class, 'reportAccountsLedger']);
Route::get('/account-ledger/export/{format}', [AccountsReportController::class, 'exportAccountsLedger'])->name('account.ledger.export');


// Accounts Report [Account Activity]
Route::get('/accounts/account-activity', [AccountsReportController::class, 'indexAccountsActivity']);
Route::post('/accounts/account-activity', [AccountsReportController::class, 'reportAccountsActivity']);
// Accounts Report [Account Activity cost center wise]
Route::get('/accounts/account-activity-costcenter-wise', [AccountsReportController::class, 'indexAccountsActivityCostCenterWise']);
Route::post('/accounts/account-activity-costcenter-wise', [AccountsReportController::class, 'reportAccountsActivitycostcenterwise']);
// Accounts Report [debitor list]
Route::get('/accounts/debitor-list', [AccountsReportController::class, 'indexDebitorList']);
Route::post('/accounts/debitor-list', [AccountsReportController::class, 'reportdebitor_list']);
// Accounts Report [creaditor list]
Route::get('/accounts/creditor-list', [AccountsReportController::class, 'indexcreditorList']);
Route::post('/accounts/creditor-list', [AccountsReportController::class, 'reportCreditor_list']);
// Accounts Report [pdcm]
Route::get('/accounts/pdcm', [AccountsReportController::class, 'indexpdcm']);
Route::post('/accounts/pdcm', [AccountsReportController::class, 'reportPDCM']);
// Accounts Report [cash flow]
Route::get('/accounts/cash-flow', [AccountsReportController::class, 'indexcashflow']);
Route::post('/accounts/cash-flow', [AccountsReportController::class, 'reportcashflow']);
// Accounts Report [chart of account list]
Route::get('/accounts/chart-of-account-list', [AccountsReportController::class, 'indexchartofaccountlist']);
Route::post('/accounts/chart-of-account-list', [AccountsReportController::class, 'reportchartofaccountlist']);

// Accounts Report [Trial Balance]
Route::get('/accounts/trial-balance', [AccountsReportController::class, 'indexTrialBalance']);
Route::post('/accounts/trial-balance', [AccountsReportController::class, 'reportTrialBalance']);

// Accounts Report [Income Statement]
Route::get('/accounts/income-statement', [AccountsReportController::class, 'indexIncomeStatement']);
Route::post('/accounts/income-statement', [AccountsReportController::class, 'reportIncomeStatement']);

// Accounts Report [Balance Sheet]
Route::get('/accounts/balance-sheet', [AccountsReportController::class, 'indexBalanceSheet']);
Route::post('/accounts/balance-sheet', [AccountsReportController::class, 'reportBalanceSheet']);
// Accounts Report [cash book]
Route::get('/accounts/cash-book', [AccountsReportController::class, 'indexcashbook']);
Route::post('/accounts/cash-book', [AccountsReportController::class, 'reportCashbook']);
// Accounts Report [budget variance report]
Route::get('/accounts/buget-variance-report', [AccountsReportController::class, 'indexbugetvariance']);
Route::post('/accounts/buget-variance-report', [AccountsReportController::class, 'reportBudgetVariance']);
// Accounts Report [ageing report]
Route::get('/accounts/ageing-report', [AccountsReportController::class, 'indexageingreport']);
Route::post('/accounts/ageing-report', [AccountsReportController::class, 'reportAgeingDetail']);
// Accounts Report [cheque printing]
Route::get('/accounts/cheque-printing', [AccountsReportController::class, 'indexchequeprinting']);
Route::post('/accounts/cheque-printing', [AccountsReportController::class, 'reportChequePrinting']);
// Accounts Report [invoice settelment]
Route::get('/accounts/invoice-settelment', [AccountsReportController::class, 'indexinvoicesettelment']);
Route::post('/accounts/invoice-settelment', [AccountsReportController::class, 'reportInvoiceSettelment']);
// Accounts Report [clear unclear]
Route::get('/accounts/clear-unclear-report', [AccountsReportController::class, 'indexclearunclear']);
Route::post('/accounts/clear-unclear-report', [AccountsReportController::class, 'reportclearunclear']);

// Account Movement
Route::get('/accounts/move-entries', [AccountMovementController::class, 'showMoveEntriesForm'])->name('accounts.showMoveEntriesForm');
Route::post('/accounts/move-entries', [AccountMovementController::class, 'moveAccountEntries'])->name('accounts.moveEntries');

//Reports
Route::get('/report/job_balancing', [ReportsController::class, 'jobBalanceSheet']);
Route::get('/report/show_job_balancing', [ReportsController::class, 'showJobBalanceSheet'])->name('job-balancing-report');
Route::get('/report/charges_wise', [ReportsController::class, 'chargesWiseSheet']);
Route::get('/report/show_charges_wise', [ReportsController::class, 'showChargesWiseSheet']);
Route::get('/report/container_wise', [ReportsController::class, 'containerWiseSheet']);
Route::get('/report/show_container_wise', [ReportsController::class, 'showContainerWiseSheet']);
Route::get('/report/job_list', [ReportsController::class, 'jobListSheet']);
Route::get('/report/show_job_list', [ReportsController::class, 'showJobListSheet']);
Route::get('/report/party_soa', [ReportsController::class, 'partySOASheet']);
Route::get('/report/show_party_soa', [ReportsController::class, 'showPartySOASheet']);
Route::get('/report/new_party_soa', [ReportsController::class, 'newPartySOASheet']);
Route::get('/report/new_show_party_soa', [ReportsController::class, 'newShowPartySOASheet']);
Route::get('/report/profit_and_loss', [ReportsController::class, 'profitAndLossSheet']);
Route::get('/report/show_profit_and_loss', [ReportsController::class, 'showProfitAndLossSheet']);
Route::get('/report/party_audit', [ReportsController::class, 'partyAudit']);
Route::get('/report/show_party_audit', [ReportsController::class, 'showPartyAudit']);
Route::get('/report/client_exposure', [ReportsController::class, 'clientExposure']);
Route::get('/report/show_client_exposure', [ReportsController::class, 'showClientExposure']);
Route::get('/report/loading_list', [ReportsController::class, 'loadingList']);
Route::get('/report/show_loading_list', [ReportsController::class, 'showLoadingList']);
Route::get('/report/cargo_movements', [ReportsController::class, 'cargoMovements']);
Route::get('/report/show_cargo_movements', [ReportsController::class, 'showCargoMovements']);
Route::get('/report/agent_invoice', [ReportsController::class, 'agentInvoice']);
Route::get('/report/show_agent_invoice', [ReportsController::class, 'showAgentInvoice']);
Route::get('/report/bl_release_status', [ReportsController::class, 'blReleaseStatus']);
Route::get('/report/show_bl_release_status', [ReportsController::class, 'showBlReleaseStatus']);

Route::get('/getRecCharges/{jobId}/{customerId}', [SEJobController::class, 'getRecCharges']);
Route::get('/getRecChargeDetail/{jobId}/{customerId}/{chargeId}', [SEJobController::class, 'getRecChargeDetail']);
Route::get('/getRecCCCharges/{jobId}/{customerId}', [SEJobController::class, 'getRecCCCharges']);
Route::get('/getRecCCChargeDetail/{jobId}/{customerId}/{chargeId}', [SEJobController::class, 'getRecCCChargeDetail']);
Route::get('/getPayCharges/{jobId}/{vendorId}', [SEJobController::class, 'getPayCharges']);
Route::get('/getPayChargeDetail/{jobId}/{vendorId}/{chargeId}', [SEJobController::class, 'getPayChargeDetail']);



// Parties Import
Route::get('parties-import', [ImportController::class, 'parties']);
Route::post('parties-import', [ImportController::class, 'partiesImport']);
